#!/usr/bin/env python

from ABINIT_variables import variables
from ABINIT_groups import groups
from ABINIT_sections import sections

TMPSUFFIX='_new'

def create_dictio(listofvariables):
    # Create the dictionary of variables
    dictio={}
    for i in listofvariables:
        if not i[0] in dictio.keys():
            dictio[i[0]]=[]
        dictio[i[0]].append(i)
    return dictio

def tableofcontents(wf,sec):
    """
    Creates the table of contents for a given section 'sec'
    and write the table inside the file descriptor 'wf'
    """
    # The variables in the section
    secvars=[]
    for i in variables.keys():
        if variables[i]['section']==sec:
            secvars.append(i)

    dictio=create_dictio(secvars)
    
    wf.write('<h3><b> Content of the file : alphabetical list of variables.</b></h3>\n')
    wf.write('<dl>\n')
    for i in sorted(dictio.keys()):
        wf.write(" <br><dt>"+i.upper()+'.<dt>\n')
        for j in sorted(dictio[i]):
            wf.write('  <a href="'+sec+TMPSUFFIX+'.html#'+j+'">'+j+'</a>&nbsp;&nbsp;\n')
    wf.write('</dl>\n')
    wf.write("<br><br><br><br><hr>\n")

    return secvars

def fill_variable_info(wf,sec,secvars):

    for i in sorted(secvars):

        # Identify if the variable belongs to a group
        # and in that case if it is the first one
        FromGroup=False
        First=False
        Line=[]
        for j in groups:
            if i in j:
                FromGroup=True
                if i==j[0]:
                    First=True
                    Line=j

        if not FromGroup or First:
            wf.write('<!-- -------------------- -->\n')
            wf.write('<!-- '+i.upper()+(20-len(i))*' '+' -->\n')
        if FromGroup and First:
            for k in Line[1:]:
                wf.write('<!-- '+k.upper()+(20-len(k))*' '+' -->\n')
        if not FromGroup or First:
            wf.write('<!-- -------------------- -->\n')
            wf.write('<br><font id="title"><a name="'+i+'">'+i+'</a></font>\n')
            wf.write('<br><font id="definition">  Mnemonics: '+variables[i]['definition']+'</font>\n')
        if FromGroup and First:
            for k in Line[1:]:
                wf.write('<br><font id="title"><a name="'+k+'">'+k+'</a></font>\n')
                wf.write('<br><font id="definition"> Mnemonics: '+variables[k]['definition']+'</font>\n')
        if not FromGroup or First:
            wf.write('<br><font id="category"> Characteristic: '+variables[i]['category']+'</font>\n')
            wf.write('<br><font id="vartype"> Variable type: '+variables[i]['vartype']+'</font>\n')
            wf.write('<br><font id="default"> Default is '+variables[i]['default']+'</font>\n')
            wf.write('<br><font id="text">'+variables[i]['text']+'</font>\n')
            wf.write('<br><br><a href="#top">Go to the top</a>\n')
            wf.write('<B> | </B><a href="keyhr.html#list">Complete list of input variables</a><hr>\n\n')
        FromGroup=False
        First=False
        Line=[]

def preamble(wf,sec):
    preamble="""
<!-- -------------------------------------------- -->
<!-- PLEASE DO NOT EDIT THIS FILE                 -->
<!-- The contents are generated from the files    -->
<!-- ABINIT_variables.py                          -->
<!-- ABINIT_sections.py                           -->
<!-- ABINIT_groups.py                             -->
<!-- Any changes to this file will be lost        -->
<!-- -------------------------------------------- -->
<html>
<head><title>"""+sections[sec]['title']+"""</title>
<link rel=stylesheet type="text/css" href="formabinit.css">
</head>
<body bgcolor="#ffffff">

<hr>
<a name="top"></a>

<h1>"""+sections[sec]['header']+"""</h1>
<h2>List and description.</h2>

<hr>

<p>"""+sections[sec]['text']+"""

<p>The new user is advised to read first the
  <a href="../users/new_user_guide.html">new user's guide</a>,
  before reading the present file. It will be easier to discover the
  present file with the help of the <a href="../tutorial/welcome.html">tutorial</a>.

<p>When the user is sufficiently familiarized with ABINIT, the reading of the
  ~ABINIT/Infos/tuning file might be useful. For response-function calculations using
  abinit, the complementary file ~ABINIT/Infos/respfn_help is needed.

<h5>Copyright (C) 1998-2012 ABINIT group (DCA, XG, RC)
<br> This file is distributed under the terms of the GNU General Public License, see
~ABINIT/COPYING or <a href="http://www.gnu.org/copyleft/gpl.txt">
http://www.gnu.org/copyleft/gpl.txt </a>.
<br> For the initials of contributors, see ~ABINIT/Infos/contributors .
</h5>

<script type="text/javascript" src="list_internal_links.js"> </script>
<script type="text/javascript" src="list_htmlfiles_input_variables.js"> </script>
"""
    wf.write(preamble)

def keyhr_preamble(wf):
    preamble="""
<!-- -------------------------------------------- -->
<!-- PLEASE DO NOT EDIT THIS FILE                 -->
<!-- The contents are generated from the files    -->
<!-- ABINIT_variables.py                          -->
<!-- ABINIT_sections.py                           -->
<!-- ABINIT_groups.py                             -->
<!-- Any changes to this file will be lost        -->
<!-- -------------------------------------------- -->
<html>
<head><title>Input variables</title>
<link rel=stylesheet type="text/css" href="formabinit.css">
</head>
<body bgcolor="#ffffff">

<hr>

<h1>Main ABINIT code, input variables:</h1>
<h2>Complete list.</h2>

<hr>

<p>This document lists the names (keywords) of all input
variables to be used in the main input file of the abinit code.

<p>The new user is advised to read first the
  <a href="../users/new_user_guide.html">new user's guide</a>,
  before reading the present file. It will be easier to discover the
  present file with the help of the <a href="../tutorial/welcome.html">tutorial</a>.

<p>When the user is sufficiently familiarized with ABINIT, the reading of the
  ~abinit/doc/users/tuning file might be useful. For response-function calculations using
  abinit, please read <a href="../users/respfn_help.html">the response function help file</a>

<h5>Copyright (C) 1998-2012 ABINIT group (DCA,XG,RC)
<br> This file is distributed under the terms of the GNU General Public License, see
~abinit/COPYING or <a href="http://www.gnu.org/copyleft/gpl.txt">
http://www.gnu.org/copyleft/gpl.txt </a>.
<br> For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
</h5>

<script type="text/javascript" src="list_internal_links.js"> </script>

<script type="text/javascript" src="list_htmlfiles_input_variables.js"> </script>

<a name="list"></a>
<h3><b> Alphabetical list of all input variables and some internal variables.</b></h3>
(Keywords with a % sign are internal variables contained in the dtset array -
 whose description is useful for the user,
 but to which no direct access is provided in the input files)
"""
    wf.write(preamble)
    
def keyhr_tableofcontents(wf):
    dictio=create_dictio(variables.keys())

    wf.write('<dl>\n')
    for i in sorted(dictio.keys()):
        wf.write(" <br><dt>"+i.upper()+'.<dt>\n')
        for j in sorted(dictio[i]):
            if variables[j]['section'] != 'varint':
                wf.write('  <a href="'+variables[j]['section']+TMPSUFFIX+'.html#'+j+'">'+j+'</a>&nbsp;&nbsp;\n')
            else:
                wf.write(' %<a href="'+variables[j]['section']+TMPSUFFIX+'.html#'+j+'">'+j+'</a>&nbsp;&nbsp;\n')                
    wf.write('</dl>\n')
    wf.write("<br><br><br><br><hr>\n")
    
def html_close(wf):
    wf.write('<script type="text/javascript" src="list_internal_links.js"> </script>\n')
    wf.write("</body>\n</html>")
    wf.close()

def main():
    for sec in sections.keys():
        wf=open(sec+TMPSUFFIX+'.html','w')

        # Write the preamble
        preamble(wf,sec)

        # Create the table of contents
        secvars=tableofcontents(wf,sec)

        # With the list of variables fill the webpage
        fill_variable_info(wf,sec,secvars)

        # Close the file
        html_close(wf)

    # Create the Main Page keyhr.html
    wf=open('keyhr'+TMPSUFFIX+'.html','w')
    keyhr_preamble(wf)
    keyhr_tableofcontents(wf)
    html_close(wf)

if __name__=='__main__':
    main()
