#
# Makefile for the build system guide of ABINIT 6
#

# Name of the document
document = build-system-guide

# Includes
doc_includes = \
  adding-extlibs.tex \
  before-starting.tex \
  configure-options.tex \
  contributors.tex \
  conventions.tex \
  extending-the-build-system.tex \
  overview.tex \
  preprocessing-macros.tex

# Graphics
doc_graphics = \
  connectors.pdf

# --------------------------------------------------------------------------- #

#
# Rules to build the document
#

GRAPHVIZ_DOT = dot
GVDFLAGS =

LATEX    = pdflatex
TEXFLAGS =

.SUFFIXES:
.SUFFIXES: .pdf .tex .gv

.gv.pdf:
	if test -e "/usr/bin/epstopdf"; then \
	    $(GRAPHVIZ_DOT) $(GVDFLAGS) -Tps2 $< | epstopdf --filter > $@; \
	else \
	    $(GRAPHVIZ_DOT) $(GVDFLAGS) -Tpdf -o $@ $<; \
	fi;

.tex.pdf:
	$(LATEX) $(TEXFLAGS) $<
	$(LATEX) $(TEXFLAGS) $<

# --------------------------------------------------------------------------- #

#
# Targets
#

all_targets all: $(document).pdf

$(document).pdf: $(doc_includes) $(doc_graphics)

mostlyclean:
	rm -f $(document).dvi

clean: mostlyclean
	rm -f *.tmp *.blg *.ilg *.log *.aux *.nav *.out *.snm *.toc *.vrb

distclean: clean
	rm -f connectors.pdf $(document).pdf
