# -*- Autoconf -*-
#
# Copyright (C) 2005-2011 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-env on 2013/01/19 13:19:22 +0000

#
# Environment variables relevant to ABINIT
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-env
# script. Any change will systematically be overwritten.
#



# ABI_ENV_AC_UPDATE(LANG)
# -----------------------
#
# Updates Autoconf build environment.
#
AC_DEFUN([ABI_ENV_AC_UPDATE],[
  dnl Please note that the existing environment will always be overwritten.
  dnl Thus you should save sensistive data before calling this macro.

  dnl Check arguments
  m4_if([$1], [tmp_lang="$1"], [tmp_lang="Fortran"])dnl

  dnl Update linker flags
  case "$1" in
    C)
      LDFLAGS="${CC_LDFLAGS}"
      ;;
    C++)
      LDFLAGS="${CXX_LDFLAGS}"
      ;;
    Fortran)
      LDFLAGS="${FC_LDFLAGS}"
      ;;
  esac

  dnl Update linker additional libs
  LIBS="${CC_LIBS}"
  CXXLIBS="${CXX_LIBS}"
  FCLIBS="${FC_LIBS}"

  unset tmp_lang
]) # ABI_ENV_AC_UPDATE



# ABI_ENV_INIT()
# --------------
#
# Declares ABINIT environment variables and initializes the internal
# variables.
#
AC_DEFUN([ABI_ENV_INIT],[

  dnl CPPFLAGS holder to permit C/Fortran mixing
  ABI_CPPFLAGS=''
  AC_SUBST(ABI_CPPFLAGS)

  dnl Library archiver

  dnl Library archiver flags

  dnl Library archiver flags for 64-bit objects
  ARFLAGS_64BITS=''
  AC_SUBST(ARFLAGS_64BITS)

  dnl Library archiver commands
  ARFLAGS_CMD='rc'
  AC_SUBST(ARFLAGS_CMD)

  dnl Library archiver flags for debugging
  AC_ARG_VAR([ARFLAGS_DEBUG],
    [Library archiver flags for debugging])
  AC_SUBST(ARFLAGS_DEBUG)

  dnl Additional library archiver flags
  AC_ARG_VAR([ARFLAGS_EXTRA],
    [Additional library archiver flags])
  AC_SUBST(ARFLAGS_EXTRA)

  dnl Tricky library archiver flags
  ARFLAGS_HINTS=''
  AC_SUBST(ARFLAGS_HINTS)

  dnl Library archiver flags for optimization
  AC_ARG_VAR([ARFLAGS_OPTIM],
    [Library archiver flags for optimization])
  AC_SUBST(ARFLAGS_OPTIM)

  dnl C compiler

  dnl C linker flags
  AC_ARG_VAR([CC_LDFLAGS],
    [C linker flags])
  AC_SUBST(CC_LDFLAGS)

  dnl C linker flags for 64-bit objects
  CC_LDFLAGS_64BITS=''
  AC_SUBST(CC_LDFLAGS_64BITS)

  dnl C linker flags for debugging
  AC_ARG_VAR([CC_LDFLAGS_DEBUG],
    [C linker flags for debugging])
  AC_SUBST(CC_LDFLAGS_DEBUG)

  dnl Additional C linker flags
  AC_SUBST(CC_LDFLAGS_EXTRA)

  dnl C linker flags for GPU
  CC_LDFLAGS_GPU=''
  AC_SUBST(CC_LDFLAGS_GPU)

  dnl Tricky C linker flags
  CC_LDFLAGS_HINTS=''
  AC_SUBST(CC_LDFLAGS_HINTS)

  dnl C linker flags for optimization
  AC_ARG_VAR([CC_LDFLAGS_OPTIM],
    [C linker flags for optimization])
  AC_SUBST(CC_LDFLAGS_OPTIM)

  dnl C linker libraries
  AC_ARG_VAR([CC_LIBS],
    [C linker libraries])
  AC_SUBST(CC_LIBS)

  dnl C linker additional libraries for 64-bit objects
  CC_LIBS_64BITS=''
  AC_SUBST(CC_LIBS_64BITS)

  dnl C linker additional libraries for debugging
  AC_ARG_VAR([CC_LIBS_DEBUG],
    [C linker additional libraries for debugging])
  AC_SUBST(CC_LIBS_DEBUG)

  dnl C linker additional libraries
  AC_SUBST(CC_LIBS_EXTRA)

  dnl C linker additional libraries for GPU
  CC_LIBS_GPU=''
  AC_SUBST(CC_LIBS_GPU)

  dnl Tricky C linker additional libraries
  CC_LIBS_HINTS=''
  AC_SUBST(CC_LIBS_HINTS)

  dnl C linker additional libraries for optimization
  AC_ARG_VAR([CC_LIBS_OPTIM],
    [C linker additional libraries for optimization])
  AC_SUBST(CC_LIBS_OPTIM)

  dnl C compiler flags

  dnl C flags for 64-bit objects
  CFLAGS_64BITS=''
  AC_SUBST(CFLAGS_64BITS)

  dnl C compiler flags for debugging
  AC_ARG_VAR([CFLAGS_DEBUG],
    [C compiler flags for debugging])
  AC_SUBST(CFLAGS_DEBUG)

  dnl Additional C compiler flags
  AC_ARG_VAR([CFLAGS_EXTRA],
    [Additional C compiler flags])
  AC_SUBST(CFLAGS_EXTRA)

  dnl C flags for GPU
  CFLAGS_GPU=''
  AC_SUBST(CFLAGS_GPU)

  dnl Tricky C compiler flags
  CFLAGS_HINTS=''
  AC_SUBST(CFLAGS_HINTS)

  dnl C compiler flags for optimization
  AC_ARG_VAR([CFLAGS_OPTIM],
    [C compiler flags for optimization])
  AC_SUBST(CFLAGS_OPTIM)

  dnl C preprocessor

  dnl C preprocessor flags

  dnl C preprocessor flags for 64-bit objects
  CPPFLAGS_64BITS=''
  AC_SUBST(CPPFLAGS_64BITS)

  dnl C preprocessor flags for debugging
  AC_ARG_VAR([CPPFLAGS_DEBUG],
    [C preprocessor flags for debugging])
  AC_SUBST(CPPFLAGS_DEBUG)

  dnl Additional C preprocessor flags
  AC_ARG_VAR([CPPFLAGS_EXTRA],
    [Additional C preprocessor flags])
  AC_SUBST(CPPFLAGS_EXTRA)

  dnl C preprocessor flags for GPU
  CPPFLAGS_GPU=''
  AC_SUBST(CPPFLAGS_GPU)

  dnl Tricky C preprocessor flags
  CPPFLAGS_HINTS=''
  AC_SUBST(CPPFLAGS_HINTS)

  dnl C preprocessor flags for optimization
  AC_ARG_VAR([CPPFLAGS_OPTIM],
    [C preprocessor flags for optimization])
  AC_SUBST(CPPFLAGS_OPTIM)

  dnl C++ compiler

  dnl C++ compiler flags

  dnl C++ flags for 64-bit objects
  CXXFLAGS_64BITS=''
  AC_SUBST(CXXFLAGS_64BITS)

  dnl C++ compiler flags for debugging
  AC_ARG_VAR([CXXFLAGS_DEBUG],
    [C++ compiler flags for debugging])
  AC_SUBST(CXXFLAGS_DEBUG)

  dnl Additional C++ compiler flags
  AC_ARG_VAR([CXXFLAGS_EXTRA],
    [Additional C++ compiler flags])
  AC_SUBST(CXXFLAGS_EXTRA)

  dnl C++ flags for GPU
  CXXFLAGS_GPU=''
  AC_SUBST(CXXFLAGS_GPU)

  dnl Tricky C++ compiler flags
  CXXFLAGS_HINTS=''
  AC_SUBST(CXXFLAGS_HINTS)

  dnl C++ compiler flags for optimization
  AC_ARG_VAR([CXXFLAGS_OPTIM],
    [C++ compiler flags for optimization])
  AC_SUBST(CXXFLAGS_OPTIM)

  dnl C++ linker flags
  AC_ARG_VAR([CXX_LDFLAGS],
    [C++ linker flags])

  dnl C++ linker flags for 64-bit objects
  CXX_LDFLAGS_64BITS=''
  AC_SUBST(CXX_LDFLAGS_64BITS)

  dnl C++ linker flags for debugging
  AC_ARG_VAR([CXX_LDFLAGS_DEBUG],
    [C++ linker flags for debugging])
  AC_SUBST(CXX_LDFLAGS_DEBUG)

  dnl Additional C++ linker flags
  AC_ARG_VAR([CXX_LDFLAGS_EXTRA],
    [Additional C++ linker flags])
  AC_SUBST(CXX_LDFLAGS_EXTRA)

  dnl C++ linker flags for GPU
  CXX_LDFLAGS_GPU=''
  AC_SUBST(CXX_LDFLAGS_GPU)

  dnl Tricky C++ linker flags
  CXX_LDFLAGS_HINTS=''
  AC_SUBST(CXX_LDFLAGS_HINTS)

  dnl C++ linker flags for optimization
  AC_ARG_VAR([CXX_LDFLAGS_OPTIM],
    [C++ linker flags for optimization])
  AC_SUBST(CXX_LDFLAGS_OPTIM)

  dnl C++ linker additional libraries
  AC_ARG_VAR([CXX_LIBS],
    [C++ linker additional libraries])
  AC_SUBST(CXX_LIBS)

  dnl C++ linker additional libraries for 64-bit objects
  CXX_LIBS_64BITS=''
  AC_SUBST(CXX_LIBS_64BITS)

  dnl C++ linker additional libraries for debugging
  AC_ARG_VAR([CXX_LIBS_DEBUG],
    [C++ linker additional libraries for debugging])
  AC_SUBST(CXX_LIBS_DEBUG)

  dnl C++ linker additional libraries
  AC_SUBST(CXX_LIBS_EXTRA)

  dnl C++ linker additional libraries for GPU
  CXX_LIBS_GPU=''
  AC_SUBST(CXX_LIBS_GPU)

  dnl Tricky C++ linker additional libraries
  CXX_LIBS_HINTS=''
  AC_SUBST(CXX_LIBS_HINTS)

  dnl C++ linker additional libraries for optimization
  AC_ARG_VAR([CXX_LIBS_OPTIM],
    [C++ linker additional libraries for optimization])
  AC_SUBST(CXX_LIBS_OPTIM)

  dnl C preprocessor definitions

  dnl Fortran 77 compiler

  dnl Fortran compiler

  dnl Fortran compiler flags
  AC_SUBST(FCFLAGS)

  dnl Fortran flags for 64-bit objects
  FCFLAGS_64BITS=''
  AC_SUBST(FCFLAGS_64BITS)

  dnl Fortran compiler flags for debugging
  AC_ARG_VAR([FCFLAGS_DEBUG],
    [Fortran compiler flags for debugging])
  AC_SUBST(FCFLAGS_DEBUG)

  dnl Additional Fortran compiler flags
  AC_ARG_VAR([FCFLAGS_EXTRA],
    [Additional Fortran compiler flags])
  AC_SUBST(FCFLAGS_EXTRA)

  dnl Fortran flags for fixed-form source files
  FCFLAGS_FIXEDFORM=''
  AC_SUBST(FCFLAGS_FIXEDFORM)

  dnl Fortran flags for free-form source files
  FCFLAGS_FREEFORM=''
  AC_SUBST(FCFLAGS_FREEFORM)

  dnl Tricky Fortran compiler flags
  FCFLAGS_HINTS=''
  AC_SUBST(FCFLAGS_HINTS)

  dnl Fortran compiler flags to use a module directory
  FCFLAGS_MODDIR=''
  AC_SUBST(FCFLAGS_MODDIR)

  dnl Fortran compiler flags to enable openmp
  AC_ARG_VAR([FCFLAGS_OPENMP],
    [Fortran compiler flags to enable openmp])
  AC_SUBST(FCFLAGS_OPENMP)

  dnl Fortran compiler flags for optimization
  AC_ARG_VAR([FCFLAGS_OPTIM],
    [Fortran compiler flags for optimization])
  AC_SUBST(FCFLAGS_OPTIM)

  dnl Fortran linker flags
  AC_ARG_VAR([FC_LDFLAGS],
    [Fortran linker flags])

  dnl Fortran linker flags for 64-bit objects
  FC_LDFLAGS_64BITS=''
  AC_SUBST(FC_LDFLAGS_64BITS)

  dnl Fortran linker flags for debugging
  AC_ARG_VAR([FC_LDFLAGS_DEBUG],
    [Fortran linker flags for debugging])
  AC_SUBST(FC_LDFLAGS_DEBUG)

  dnl Additional Fortran linker flags
  AC_ARG_VAR([FC_LDFLAGS_EXTRA],
    [Additional Fortran linker flags])
  AC_SUBST(FC_LDFLAGS_EXTRA)

  dnl Tricky Fortran linker flags
  FC_LDFLAGS_HINTS=''
  AC_SUBST(FC_LDFLAGS_HINTS)

  dnl Fortran linker flags for optimization
  AC_ARG_VAR([FC_LDFLAGS_OPTIM],
    [Fortran linker flags for optimization])
  AC_SUBST(FC_LDFLAGS_OPTIM)

  dnl Fortran linker additional libraries
  AC_ARG_VAR([FC_LIBS],
    [Fortran linker additional libraries])
  AC_SUBST(FC_LIBS)

  dnl Fortran linker additional libraries for 64-bit objects
  FC_LIBS_64BITS=''
  AC_SUBST(FC_LIBS_64BITS)

  dnl Fortran linker additional libraries for debugging
  AC_ARG_VAR([FC_LIBS_DEBUG],
    [Fortran linker additional libraries for debugging])
  AC_SUBST(FC_LIBS_DEBUG)

  dnl Fortran linker additional libraries
  AC_SUBST(FC_LIBS_EXTRA)

  dnl Tricky Fortran linker additional libraries
  FC_LIBS_HINTS=''
  AC_SUBST(FC_LIBS_HINTS)

  dnl Fortran linker additional libraries for optimization
  AC_ARG_VAR([FC_LIBS_OPTIM],
    [Fortran linker additional libraries for optimization])
  AC_SUBST(FC_LIBS_OPTIM)

  dnl Fortran preprocessor
  AC_ARG_VAR([FPP],
    [Fortran preprocessor])
  AC_SUBST(FPP)

  dnl Fortran preprocessor flags
  AC_ARG_VAR([FPPFLAGS],
    [Fortran preprocessor flags])
  AC_SUBST(FPPFLAGS)

  dnl Fortran preprocessor flags for debugging
  AC_ARG_VAR([FPPFLAGS_DEBUG],
    [Fortran preprocessor flags for debugging])
  AC_SUBST(FPPFLAGS_DEBUG)

  dnl Additional Fortran preprocessor flags
  AC_ARG_VAR([FPPFLAGS_EXTRA],
    [Additional Fortran preprocessor flags])
  AC_SUBST(FPPFLAGS_EXTRA)

  dnl Tricky Fortran preprocessor flags
  FPPFLAGS_HINTS=''
  AC_SUBST(FPPFLAGS_HINTS)

  dnl Fortran preprocessor flags for optimization
  AC_ARG_VAR([FPPFLAGS_OPTIM],
    [Fortran preprocessor flags for optimization])
  AC_SUBST(FPPFLAGS_OPTIM)

  dnl Linker

  dnl LaTeX flags
  AC_SUBST(LTXFLAGS)

  dnl Markdown text-to-HTML processor flags
  AC_SUBST(MDFLAGS)

  dnl MPI runner command
  AC_ARG_VAR([MPI_RUNNER],
    [MPI runner command])
  AC_SUBST(MPI_RUNNER)

  dnl List symbols from object files

  dnl nVidia CUDA C compiler
  AC_SUBST(NVCC)

  dnl nVidia CUDA C compiler flags
  AC_SUBST(NVCC_CFLAGS)

  dnl nVidia CUDA preprocessing options
  AC_SUBST(NVCC_CPPFLAGS)

  dnl nVidia CUDA C linker flags
  AC_SUBST(NVCC_LDFLAGS)

  dnl nVidia CUDA C linker additional libraries
  AC_SUBST(NVCC_LIBS)

  dnl DVI->PDF converter flags
  AC_SUBST(PDFFLAGS)

  dnl Generate index to archive

  dnl Serial runner command
  AC_ARG_VAR([SERIAL_RUNNER],
    [Serial runner command])
  AC_SUBST(SERIAL_RUNNER)

  dnl C++ preprocessor
  AC_ARG_VAR([XPP],
    [C++ preprocessor])
  AC_SUBST(XPP)

  dnl C++ preprocessor flags
  AC_ARG_VAR([XPPFLAGS],
    [C++ preprocessor flags])
  AC_SUBST(XPPFLAGS)

  dnl C++ preprocessor flags for debugging
  AC_ARG_VAR([XPPFLAGS_DEBUG],
    [C++ preprocessor flags for debugging])
  AC_SUBST(XPPFLAGS_DEBUG)

  dnl Additional C++ preprocessor flags
  AC_ARG_VAR([XPPFLAGS_EXTRA],
    [Additional C++ preprocessor flags])
  AC_SUBST(XPPFLAGS_EXTRA)

  dnl C++ preprocessor flags for optimization
  AC_ARG_VAR([XPPFLAGS_OPTIM],
    [C++ preprocessor flags for optimization])
  AC_SUBST(XPPFLAGS_OPTIM)

]) # ABI_ENV_INIT



# ABI_ENV_BACKUP()
# ----------------
#
# Saves all ABINIT environment variables.
#
AC_DEFUN([ABI_ENV_BACKUP],[
  dnl All variables will be saved, yet please note that they may be
  dnl conditionally restored (see ABI_ENV_RECALL for details).

  dnl Save CPPFLAGS holder to permit C/Fortran mixing
  abi_env_ABI_CPPFLAGS="${ABI_CPPFLAGS}"

  dnl Save Library archiver
  abi_env_AR="${AR}"

  dnl Save Library archiver flags
  abi_env_ARFLAGS="${ARFLAGS}"

  dnl Save Library archiver flags for 64-bit objects
  abi_env_ARFLAGS_64BITS="${ARFLAGS_64BITS}"

  dnl Save Library archiver commands
  abi_env_ARFLAGS_CMD="${ARFLAGS_CMD}"

  dnl Save Library archiver flags for debugging
  abi_env_ARFLAGS_DEBUG="${ARFLAGS_DEBUG}"

  dnl Save Additional library archiver flags
  abi_env_ARFLAGS_EXTRA="${ARFLAGS_EXTRA}"

  dnl Save Tricky library archiver flags
  abi_env_ARFLAGS_HINTS="${ARFLAGS_HINTS}"

  dnl Save Library archiver flags for optimization
  abi_env_ARFLAGS_OPTIM="${ARFLAGS_OPTIM}"

  dnl Save C compiler
  abi_env_CC="${CC}"

  dnl Save C linker flags
  abi_env_CC_LDFLAGS="${CC_LDFLAGS}"

  dnl Save C linker flags for 64-bit objects
  abi_env_CC_LDFLAGS_64BITS="${CC_LDFLAGS_64BITS}"

  dnl Save C linker flags for debugging
  abi_env_CC_LDFLAGS_DEBUG="${CC_LDFLAGS_DEBUG}"

  dnl Save Additional C linker flags
  abi_env_CC_LDFLAGS_EXTRA="${CC_LDFLAGS_EXTRA}"

  dnl Save C linker flags for GPU
  abi_env_CC_LDFLAGS_GPU="${CC_LDFLAGS_GPU}"

  dnl Save Tricky C linker flags
  abi_env_CC_LDFLAGS_HINTS="${CC_LDFLAGS_HINTS}"

  dnl Save C linker flags for optimization
  abi_env_CC_LDFLAGS_OPTIM="${CC_LDFLAGS_OPTIM}"

  dnl Save C linker libraries
  abi_env_CC_LIBS="${CC_LIBS}"

  dnl Save C linker additional libraries for 64-bit objects
  abi_env_CC_LIBS_64BITS="${CC_LIBS_64BITS}"

  dnl Save C linker additional libraries for debugging
  abi_env_CC_LIBS_DEBUG="${CC_LIBS_DEBUG}"

  dnl Save C linker additional libraries
  abi_env_CC_LIBS_EXTRA="${CC_LIBS_EXTRA}"

  dnl Save C linker additional libraries for GPU
  abi_env_CC_LIBS_GPU="${CC_LIBS_GPU}"

  dnl Save Tricky C linker additional libraries
  abi_env_CC_LIBS_HINTS="${CC_LIBS_HINTS}"

  dnl Save C linker additional libraries for optimization
  abi_env_CC_LIBS_OPTIM="${CC_LIBS_OPTIM}"

  dnl Save C compiler flags
  abi_env_CFLAGS="${CFLAGS}"

  dnl Save C flags for 64-bit objects
  abi_env_CFLAGS_64BITS="${CFLAGS_64BITS}"

  dnl Save C compiler flags for debugging
  abi_env_CFLAGS_DEBUG="${CFLAGS_DEBUG}"

  dnl Save Additional C compiler flags
  abi_env_CFLAGS_EXTRA="${CFLAGS_EXTRA}"

  dnl Save C flags for GPU
  abi_env_CFLAGS_GPU="${CFLAGS_GPU}"

  dnl Save Tricky C compiler flags
  abi_env_CFLAGS_HINTS="${CFLAGS_HINTS}"

  dnl Save C compiler flags for optimization
  abi_env_CFLAGS_OPTIM="${CFLAGS_OPTIM}"

  dnl Save C preprocessor
  abi_env_CPP="${CPP}"

  dnl Save C preprocessor flags
  abi_env_CPPFLAGS="${CPPFLAGS}"

  dnl Save C preprocessor flags for 64-bit objects
  abi_env_CPPFLAGS_64BITS="${CPPFLAGS_64BITS}"

  dnl Save C preprocessor flags for debugging
  abi_env_CPPFLAGS_DEBUG="${CPPFLAGS_DEBUG}"

  dnl Save Additional C preprocessor flags
  abi_env_CPPFLAGS_EXTRA="${CPPFLAGS_EXTRA}"

  dnl Save C preprocessor flags for GPU
  abi_env_CPPFLAGS_GPU="${CPPFLAGS_GPU}"

  dnl Save Tricky C preprocessor flags
  abi_env_CPPFLAGS_HINTS="${CPPFLAGS_HINTS}"

  dnl Save C preprocessor flags for optimization
  abi_env_CPPFLAGS_OPTIM="${CPPFLAGS_OPTIM}"

  dnl Save C++ compiler
  abi_env_CXX="${CXX}"

  dnl Save C++ compiler flags
  abi_env_CXXFLAGS="${CXXFLAGS}"

  dnl Save C++ flags for 64-bit objects
  abi_env_CXXFLAGS_64BITS="${CXXFLAGS_64BITS}"

  dnl Save C++ compiler flags for debugging
  abi_env_CXXFLAGS_DEBUG="${CXXFLAGS_DEBUG}"

  dnl Save Additional C++ compiler flags
  abi_env_CXXFLAGS_EXTRA="${CXXFLAGS_EXTRA}"

  dnl Save C++ flags for GPU
  abi_env_CXXFLAGS_GPU="${CXXFLAGS_GPU}"

  dnl Save Tricky C++ compiler flags
  abi_env_CXXFLAGS_HINTS="${CXXFLAGS_HINTS}"

  dnl Save C++ compiler flags for optimization
  abi_env_CXXFLAGS_OPTIM="${CXXFLAGS_OPTIM}"

  dnl Save C++ linker flags
  abi_env_CXX_LDFLAGS="${CXX_LDFLAGS}"

  dnl Save C++ linker flags for 64-bit objects
  abi_env_CXX_LDFLAGS_64BITS="${CXX_LDFLAGS_64BITS}"

  dnl Save C++ linker flags for debugging
  abi_env_CXX_LDFLAGS_DEBUG="${CXX_LDFLAGS_DEBUG}"

  dnl Save Additional C++ linker flags
  abi_env_CXX_LDFLAGS_EXTRA="${CXX_LDFLAGS_EXTRA}"

  dnl Save C++ linker flags for GPU
  abi_env_CXX_LDFLAGS_GPU="${CXX_LDFLAGS_GPU}"

  dnl Save Tricky C++ linker flags
  abi_env_CXX_LDFLAGS_HINTS="${CXX_LDFLAGS_HINTS}"

  dnl Save C++ linker flags for optimization
  abi_env_CXX_LDFLAGS_OPTIM="${CXX_LDFLAGS_OPTIM}"

  dnl Save C++ linker additional libraries
  abi_env_CXX_LIBS="${CXX_LIBS}"

  dnl Save C++ linker additional libraries for 64-bit objects
  abi_env_CXX_LIBS_64BITS="${CXX_LIBS_64BITS}"

  dnl Save C++ linker additional libraries for debugging
  abi_env_CXX_LIBS_DEBUG="${CXX_LIBS_DEBUG}"

  dnl Save C++ linker additional libraries
  abi_env_CXX_LIBS_EXTRA="${CXX_LIBS_EXTRA}"

  dnl Save C++ linker additional libraries for GPU
  abi_env_CXX_LIBS_GPU="${CXX_LIBS_GPU}"

  dnl Save Tricky C++ linker additional libraries
  abi_env_CXX_LIBS_HINTS="${CXX_LIBS_HINTS}"

  dnl Save C++ linker additional libraries for optimization
  abi_env_CXX_LIBS_OPTIM="${CXX_LIBS_OPTIM}"

  dnl Save C preprocessor definitions
  abi_env_DEFS="${DEFS}"

  dnl Save Fortran 77 compiler
  abi_env_F77="${F77}"

  dnl Save Fortran compiler
  abi_env_FC="${FC}"

  dnl Save Fortran compiler flags
  abi_env_FCFLAGS="${FCFLAGS}"

  dnl Save Fortran flags for 64-bit objects
  abi_env_FCFLAGS_64BITS="${FCFLAGS_64BITS}"

  dnl Save Fortran compiler flags for debugging
  abi_env_FCFLAGS_DEBUG="${FCFLAGS_DEBUG}"

  dnl Save Additional Fortran compiler flags
  abi_env_FCFLAGS_EXTRA="${FCFLAGS_EXTRA}"

  dnl Save Fortran flags for fixed-form source files
  abi_env_FCFLAGS_FIXEDFORM="${FCFLAGS_FIXEDFORM}"

  dnl Save Fortran flags for free-form source files
  abi_env_FCFLAGS_FREEFORM="${FCFLAGS_FREEFORM}"

  dnl Save Tricky Fortran compiler flags
  abi_env_FCFLAGS_HINTS="${FCFLAGS_HINTS}"

  dnl Save Fortran compiler flags to use a module directory
  abi_env_FCFLAGS_MODDIR="${FCFLAGS_MODDIR}"

  dnl Save Fortran compiler flags to enable openmp
  abi_env_FCFLAGS_OPENMP="${FCFLAGS_OPENMP}"

  dnl Save Fortran compiler flags for optimization
  abi_env_FCFLAGS_OPTIM="${FCFLAGS_OPTIM}"

  dnl Save Fortran linker flags
  abi_env_FC_LDFLAGS="${FC_LDFLAGS}"

  dnl Save Fortran linker flags for 64-bit objects
  abi_env_FC_LDFLAGS_64BITS="${FC_LDFLAGS_64BITS}"

  dnl Save Fortran linker flags for debugging
  abi_env_FC_LDFLAGS_DEBUG="${FC_LDFLAGS_DEBUG}"

  dnl Save Additional Fortran linker flags
  abi_env_FC_LDFLAGS_EXTRA="${FC_LDFLAGS_EXTRA}"

  dnl Save Tricky Fortran linker flags
  abi_env_FC_LDFLAGS_HINTS="${FC_LDFLAGS_HINTS}"

  dnl Save Fortran linker flags for optimization
  abi_env_FC_LDFLAGS_OPTIM="${FC_LDFLAGS_OPTIM}"

  dnl Save Fortran linker additional libraries
  abi_env_FC_LIBS="${FC_LIBS}"

  dnl Save Fortran linker additional libraries for 64-bit objects
  abi_env_FC_LIBS_64BITS="${FC_LIBS_64BITS}"

  dnl Save Fortran linker additional libraries for debugging
  abi_env_FC_LIBS_DEBUG="${FC_LIBS_DEBUG}"

  dnl Save Fortran linker additional libraries
  abi_env_FC_LIBS_EXTRA="${FC_LIBS_EXTRA}"

  dnl Save Tricky Fortran linker additional libraries
  abi_env_FC_LIBS_HINTS="${FC_LIBS_HINTS}"

  dnl Save Fortran linker additional libraries for optimization
  abi_env_FC_LIBS_OPTIM="${FC_LIBS_OPTIM}"

  dnl Save Fortran preprocessor
  abi_env_FPP="${FPP}"

  dnl Save Fortran preprocessor flags
  abi_env_FPPFLAGS="${FPPFLAGS}"

  dnl Save Fortran preprocessor flags for debugging
  abi_env_FPPFLAGS_DEBUG="${FPPFLAGS_DEBUG}"

  dnl Save Additional Fortran preprocessor flags
  abi_env_FPPFLAGS_EXTRA="${FPPFLAGS_EXTRA}"

  dnl Save Tricky Fortran preprocessor flags
  abi_env_FPPFLAGS_HINTS="${FPPFLAGS_HINTS}"

  dnl Save Fortran preprocessor flags for optimization
  abi_env_FPPFLAGS_OPTIM="${FPPFLAGS_OPTIM}"

  dnl Save Linker
  abi_env_LD="${LD}"

  dnl Save LaTeX flags
  abi_env_LTXFLAGS="${LTXFLAGS}"

  dnl Save Markdown text-to-HTML processor flags
  abi_env_MDFLAGS="${MDFLAGS}"

  dnl Save MPI runner command
  abi_env_MPI_RUNNER="${MPI_RUNNER}"

  dnl Save List symbols from object files
  abi_env_NM="${NM}"

  dnl Save nVidia CUDA C compiler
  abi_env_NVCC="${NVCC}"

  dnl Save nVidia CUDA C compiler flags
  abi_env_NVCC_CFLAGS="${NVCC_CFLAGS}"

  dnl Save nVidia CUDA preprocessing options
  abi_env_NVCC_CPPFLAGS="${NVCC_CPPFLAGS}"

  dnl Save nVidia CUDA C linker flags
  abi_env_NVCC_LDFLAGS="${NVCC_LDFLAGS}"

  dnl Save nVidia CUDA C linker additional libraries
  abi_env_NVCC_LIBS="${NVCC_LIBS}"

  dnl Save DVI->PDF converter flags
  abi_env_PDFFLAGS="${PDFFLAGS}"

  dnl Save Generate index to archive
  abi_env_RANLIB="${RANLIB}"

  dnl Save Serial runner command
  abi_env_SERIAL_RUNNER="${SERIAL_RUNNER}"

  dnl Save C++ preprocessor
  abi_env_XPP="${XPP}"

  dnl Save C++ preprocessor flags
  abi_env_XPPFLAGS="${XPPFLAGS}"

  dnl Save C++ preprocessor flags for debugging
  abi_env_XPPFLAGS_DEBUG="${XPPFLAGS_DEBUG}"

  dnl Save Additional C++ preprocessor flags
  abi_env_XPPFLAGS_EXTRA="${XPPFLAGS_EXTRA}"

  dnl Save C++ preprocessor flags for optimization
  abi_env_XPPFLAGS_OPTIM="${XPPFLAGS_OPTIM}"

]) # ABI_ENV_BACKUP



# ABI_ENV_RECALL()
# ----------------
#
# Restores all previously-saved non-empty ABINIT environment variables.
#
AC_DEFUN([ABI_ENV_RECALL],[
  dnl The following ensures that non-empty environment variables always override
  dnl what is read from the config files.

  dnl Recall CPPFLAGS holder to permit C/Fortran mixing
  if test "${abi_env_ABI_CPPFLAGS}" != ""; then
    test "${ABI_CPPFLAGS}" != "${abi_env_ABI_CPPFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of ABI_CPPFLAGS from environment])
    ABI_CPPFLAGS="${abi_env_ABI_CPPFLAGS}"
  fi

  dnl Recall Library archiver
  if test "${abi_env_AR}" != ""; then
    test "${AR}" != "${abi_env_AR}" && \
      AC_MSG_NOTICE([overriding configuration of AR from environment])
    AR="${abi_env_AR}"
  fi

  dnl Recall Library archiver flags
  if test "${abi_env_ARFLAGS}" != ""; then
    test "${ARFLAGS}" != "${abi_env_ARFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS from environment])
    ARFLAGS="${abi_env_ARFLAGS}"
  fi

  dnl Recall Library archiver flags for 64-bit objects
  if test "${abi_env_ARFLAGS_64BITS}" != ""; then
    test "${ARFLAGS_64BITS}" != "${abi_env_ARFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS_64BITS from environment])
    ARFLAGS_64BITS="${abi_env_ARFLAGS_64BITS}"
  fi

  dnl Recall Library archiver commands
  if test "${abi_env_ARFLAGS_CMD}" != ""; then
    test "${ARFLAGS_CMD}" != "${abi_env_ARFLAGS_CMD}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS_CMD from environment])
    ARFLAGS_CMD="${abi_env_ARFLAGS_CMD}"
  fi

  dnl Recall Library archiver flags for debugging
  if test "${abi_env_ARFLAGS_DEBUG}" != ""; then
    test "${ARFLAGS_DEBUG}" != "${abi_env_ARFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS_DEBUG from environment])
    ARFLAGS_DEBUG="${abi_env_ARFLAGS_DEBUG}"
  fi

  dnl Recall Additional library archiver flags
  if test "${abi_env_ARFLAGS_EXTRA}" != ""; then
    test "${ARFLAGS_EXTRA}" != "${abi_env_ARFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS_EXTRA from environment])
    ARFLAGS_EXTRA="${abi_env_ARFLAGS_EXTRA}"
  fi

  dnl Recall Tricky library archiver flags
  if test "${abi_env_ARFLAGS_HINTS}" != ""; then
    test "${ARFLAGS_HINTS}" != "${abi_env_ARFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS_HINTS from environment])
    ARFLAGS_HINTS="${abi_env_ARFLAGS_HINTS}"
  fi

  dnl Recall Library archiver flags for optimization
  if test "${abi_env_ARFLAGS_OPTIM}" != ""; then
    test "${ARFLAGS_OPTIM}" != "${abi_env_ARFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of ARFLAGS_OPTIM from environment])
    ARFLAGS_OPTIM="${abi_env_ARFLAGS_OPTIM}"
  fi

  dnl Recall C compiler
  if test "${abi_env_CC}" != ""; then
    test "${CC}" != "${abi_env_CC}" && \
      AC_MSG_NOTICE([overriding configuration of CC from environment])
    CC="${abi_env_CC}"
  fi

  dnl Recall C linker flags
  if test "${abi_env_CC_LDFLAGS}" != ""; then
    test "${CC_LDFLAGS}" != "${abi_env_CC_LDFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS from environment])
    CC_LDFLAGS="${abi_env_CC_LDFLAGS}"
  fi

  dnl Recall C linker flags for 64-bit objects
  if test "${abi_env_CC_LDFLAGS_64BITS}" != ""; then
    test "${CC_LDFLAGS_64BITS}" != "${abi_env_CC_LDFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS_64BITS from environment])
    CC_LDFLAGS_64BITS="${abi_env_CC_LDFLAGS_64BITS}"
  fi

  dnl Recall C linker flags for debugging
  if test "${abi_env_CC_LDFLAGS_DEBUG}" != ""; then
    test "${CC_LDFLAGS_DEBUG}" != "${abi_env_CC_LDFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS_DEBUG from environment])
    CC_LDFLAGS_DEBUG="${abi_env_CC_LDFLAGS_DEBUG}"
  fi

  dnl Recall Additional C linker flags
  if test "${abi_env_CC_LDFLAGS_EXTRA}" != ""; then
    test "${CC_LDFLAGS_EXTRA}" != "${abi_env_CC_LDFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS_EXTRA from environment])
    CC_LDFLAGS_EXTRA="${abi_env_CC_LDFLAGS_EXTRA}"
  fi

  dnl Recall C linker flags for GPU
  if test "${abi_env_CC_LDFLAGS_GPU}" != ""; then
    test "${CC_LDFLAGS_GPU}" != "${abi_env_CC_LDFLAGS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS_GPU from environment])
    CC_LDFLAGS_GPU="${abi_env_CC_LDFLAGS_GPU}"
  fi

  dnl Recall Tricky C linker flags
  if test "${abi_env_CC_LDFLAGS_HINTS}" != ""; then
    test "${CC_LDFLAGS_HINTS}" != "${abi_env_CC_LDFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS_HINTS from environment])
    CC_LDFLAGS_HINTS="${abi_env_CC_LDFLAGS_HINTS}"
  fi

  dnl Recall C linker flags for optimization
  if test "${abi_env_CC_LDFLAGS_OPTIM}" != ""; then
    test "${CC_LDFLAGS_OPTIM}" != "${abi_env_CC_LDFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LDFLAGS_OPTIM from environment])
    CC_LDFLAGS_OPTIM="${abi_env_CC_LDFLAGS_OPTIM}"
  fi

  dnl Recall C linker libraries
  if test "${abi_env_CC_LIBS}" != ""; then
    test "${CC_LIBS}" != "${abi_env_CC_LIBS}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS from environment])
    CC_LIBS="${abi_env_CC_LIBS}"
  fi

  dnl Recall C linker additional libraries for 64-bit objects
  if test "${abi_env_CC_LIBS_64BITS}" != ""; then
    test "${CC_LIBS_64BITS}" != "${abi_env_CC_LIBS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS_64BITS from environment])
    CC_LIBS_64BITS="${abi_env_CC_LIBS_64BITS}"
  fi

  dnl Recall C linker additional libraries for debugging
  if test "${abi_env_CC_LIBS_DEBUG}" != ""; then
    test "${CC_LIBS_DEBUG}" != "${abi_env_CC_LIBS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS_DEBUG from environment])
    CC_LIBS_DEBUG="${abi_env_CC_LIBS_DEBUG}"
  fi

  dnl Recall C linker additional libraries
  if test "${abi_env_CC_LIBS_EXTRA}" != ""; then
    test "${CC_LIBS_EXTRA}" != "${abi_env_CC_LIBS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS_EXTRA from environment])
    CC_LIBS_EXTRA="${abi_env_CC_LIBS_EXTRA}"
  fi

  dnl Recall C linker additional libraries for GPU
  if test "${abi_env_CC_LIBS_GPU}" != ""; then
    test "${CC_LIBS_GPU}" != "${abi_env_CC_LIBS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS_GPU from environment])
    CC_LIBS_GPU="${abi_env_CC_LIBS_GPU}"
  fi

  dnl Recall Tricky C linker additional libraries
  if test "${abi_env_CC_LIBS_HINTS}" != ""; then
    test "${CC_LIBS_HINTS}" != "${abi_env_CC_LIBS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS_HINTS from environment])
    CC_LIBS_HINTS="${abi_env_CC_LIBS_HINTS}"
  fi

  dnl Recall C linker additional libraries for optimization
  if test "${abi_env_CC_LIBS_OPTIM}" != ""; then
    test "${CC_LIBS_OPTIM}" != "${abi_env_CC_LIBS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CC_LIBS_OPTIM from environment])
    CC_LIBS_OPTIM="${abi_env_CC_LIBS_OPTIM}"
  fi

  dnl Recall C compiler flags
  if test "${abi_env_CFLAGS}" != ""; then
    test "${CFLAGS}" != "${abi_env_CFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS from environment])
    CFLAGS="${abi_env_CFLAGS}"
  fi

  dnl Recall C flags for 64-bit objects
  if test "${abi_env_CFLAGS_64BITS}" != ""; then
    test "${CFLAGS_64BITS}" != "${abi_env_CFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS_64BITS from environment])
    CFLAGS_64BITS="${abi_env_CFLAGS_64BITS}"
  fi

  dnl Recall C compiler flags for debugging
  if test "${abi_env_CFLAGS_DEBUG}" != ""; then
    test "${CFLAGS_DEBUG}" != "${abi_env_CFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS_DEBUG from environment])
    CFLAGS_DEBUG="${abi_env_CFLAGS_DEBUG}"
  fi

  dnl Recall Additional C compiler flags
  if test "${abi_env_CFLAGS_EXTRA}" != ""; then
    test "${CFLAGS_EXTRA}" != "${abi_env_CFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS_EXTRA from environment])
    CFLAGS_EXTRA="${abi_env_CFLAGS_EXTRA}"
  fi

  dnl Recall C flags for GPU
  if test "${abi_env_CFLAGS_GPU}" != ""; then
    test "${CFLAGS_GPU}" != "${abi_env_CFLAGS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS_GPU from environment])
    CFLAGS_GPU="${abi_env_CFLAGS_GPU}"
  fi

  dnl Recall Tricky C compiler flags
  if test "${abi_env_CFLAGS_HINTS}" != ""; then
    test "${CFLAGS_HINTS}" != "${abi_env_CFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS_HINTS from environment])
    CFLAGS_HINTS="${abi_env_CFLAGS_HINTS}"
  fi

  dnl Recall C compiler flags for optimization
  if test "${abi_env_CFLAGS_OPTIM}" != ""; then
    test "${CFLAGS_OPTIM}" != "${abi_env_CFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CFLAGS_OPTIM from environment])
    CFLAGS_OPTIM="${abi_env_CFLAGS_OPTIM}"
  fi

  dnl Recall C preprocessor
  if test "${abi_env_CPP}" != ""; then
    test "${CPP}" != "${abi_env_CPP}" && \
      AC_MSG_NOTICE([overriding configuration of CPP from environment])
    CPP="${abi_env_CPP}"
  fi

  dnl Recall C preprocessor flags
  if test "${abi_env_CPPFLAGS}" != ""; then
    test "${CPPFLAGS}" != "${abi_env_CPPFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS from environment])
    CPPFLAGS="${abi_env_CPPFLAGS}"
  fi

  dnl Recall C preprocessor flags for 64-bit objects
  if test "${abi_env_CPPFLAGS_64BITS}" != ""; then
    test "${CPPFLAGS_64BITS}" != "${abi_env_CPPFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS_64BITS from environment])
    CPPFLAGS_64BITS="${abi_env_CPPFLAGS_64BITS}"
  fi

  dnl Recall C preprocessor flags for debugging
  if test "${abi_env_CPPFLAGS_DEBUG}" != ""; then
    test "${CPPFLAGS_DEBUG}" != "${abi_env_CPPFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS_DEBUG from environment])
    CPPFLAGS_DEBUG="${abi_env_CPPFLAGS_DEBUG}"
  fi

  dnl Recall Additional C preprocessor flags
  if test "${abi_env_CPPFLAGS_EXTRA}" != ""; then
    test "${CPPFLAGS_EXTRA}" != "${abi_env_CPPFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS_EXTRA from environment])
    CPPFLAGS_EXTRA="${abi_env_CPPFLAGS_EXTRA}"
  fi

  dnl Recall C preprocessor flags for GPU
  if test "${abi_env_CPPFLAGS_GPU}" != ""; then
    test "${CPPFLAGS_GPU}" != "${abi_env_CPPFLAGS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS_GPU from environment])
    CPPFLAGS_GPU="${abi_env_CPPFLAGS_GPU}"
  fi

  dnl Recall Tricky C preprocessor flags
  if test "${abi_env_CPPFLAGS_HINTS}" != ""; then
    test "${CPPFLAGS_HINTS}" != "${abi_env_CPPFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS_HINTS from environment])
    CPPFLAGS_HINTS="${abi_env_CPPFLAGS_HINTS}"
  fi

  dnl Recall C preprocessor flags for optimization
  if test "${abi_env_CPPFLAGS_OPTIM}" != ""; then
    test "${CPPFLAGS_OPTIM}" != "${abi_env_CPPFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CPPFLAGS_OPTIM from environment])
    CPPFLAGS_OPTIM="${abi_env_CPPFLAGS_OPTIM}"
  fi

  dnl Recall C++ compiler
  if test "${abi_env_CXX}" != ""; then
    test "${CXX}" != "${abi_env_CXX}" && \
      AC_MSG_NOTICE([overriding configuration of CXX from environment])
    CXX="${abi_env_CXX}"
  fi

  dnl Recall C++ compiler flags
  if test "${abi_env_CXXFLAGS}" != ""; then
    test "${CXXFLAGS}" != "${abi_env_CXXFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS from environment])
    CXXFLAGS="${abi_env_CXXFLAGS}"
  fi

  dnl Recall C++ flags for 64-bit objects
  if test "${abi_env_CXXFLAGS_64BITS}" != ""; then
    test "${CXXFLAGS_64BITS}" != "${abi_env_CXXFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS_64BITS from environment])
    CXXFLAGS_64BITS="${abi_env_CXXFLAGS_64BITS}"
  fi

  dnl Recall C++ compiler flags for debugging
  if test "${abi_env_CXXFLAGS_DEBUG}" != ""; then
    test "${CXXFLAGS_DEBUG}" != "${abi_env_CXXFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS_DEBUG from environment])
    CXXFLAGS_DEBUG="${abi_env_CXXFLAGS_DEBUG}"
  fi

  dnl Recall Additional C++ compiler flags
  if test "${abi_env_CXXFLAGS_EXTRA}" != ""; then
    test "${CXXFLAGS_EXTRA}" != "${abi_env_CXXFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS_EXTRA from environment])
    CXXFLAGS_EXTRA="${abi_env_CXXFLAGS_EXTRA}"
  fi

  dnl Recall C++ flags for GPU
  if test "${abi_env_CXXFLAGS_GPU}" != ""; then
    test "${CXXFLAGS_GPU}" != "${abi_env_CXXFLAGS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS_GPU from environment])
    CXXFLAGS_GPU="${abi_env_CXXFLAGS_GPU}"
  fi

  dnl Recall Tricky C++ compiler flags
  if test "${abi_env_CXXFLAGS_HINTS}" != ""; then
    test "${CXXFLAGS_HINTS}" != "${abi_env_CXXFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS_HINTS from environment])
    CXXFLAGS_HINTS="${abi_env_CXXFLAGS_HINTS}"
  fi

  dnl Recall C++ compiler flags for optimization
  if test "${abi_env_CXXFLAGS_OPTIM}" != ""; then
    test "${CXXFLAGS_OPTIM}" != "${abi_env_CXXFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CXXFLAGS_OPTIM from environment])
    CXXFLAGS_OPTIM="${abi_env_CXXFLAGS_OPTIM}"
  fi

  dnl Recall C++ linker flags
  if test "${abi_env_CXX_LDFLAGS}" != ""; then
    test "${CXX_LDFLAGS}" != "${abi_env_CXX_LDFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS from environment])
    CXX_LDFLAGS="${abi_env_CXX_LDFLAGS}"
  fi

  dnl Recall C++ linker flags for 64-bit objects
  if test "${abi_env_CXX_LDFLAGS_64BITS}" != ""; then
    test "${CXX_LDFLAGS_64BITS}" != "${abi_env_CXX_LDFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS_64BITS from environment])
    CXX_LDFLAGS_64BITS="${abi_env_CXX_LDFLAGS_64BITS}"
  fi

  dnl Recall C++ linker flags for debugging
  if test "${abi_env_CXX_LDFLAGS_DEBUG}" != ""; then
    test "${CXX_LDFLAGS_DEBUG}" != "${abi_env_CXX_LDFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS_DEBUG from environment])
    CXX_LDFLAGS_DEBUG="${abi_env_CXX_LDFLAGS_DEBUG}"
  fi

  dnl Recall Additional C++ linker flags
  if test "${abi_env_CXX_LDFLAGS_EXTRA}" != ""; then
    test "${CXX_LDFLAGS_EXTRA}" != "${abi_env_CXX_LDFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS_EXTRA from environment])
    CXX_LDFLAGS_EXTRA="${abi_env_CXX_LDFLAGS_EXTRA}"
  fi

  dnl Recall C++ linker flags for GPU
  if test "${abi_env_CXX_LDFLAGS_GPU}" != ""; then
    test "${CXX_LDFLAGS_GPU}" != "${abi_env_CXX_LDFLAGS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS_GPU from environment])
    CXX_LDFLAGS_GPU="${abi_env_CXX_LDFLAGS_GPU}"
  fi

  dnl Recall Tricky C++ linker flags
  if test "${abi_env_CXX_LDFLAGS_HINTS}" != ""; then
    test "${CXX_LDFLAGS_HINTS}" != "${abi_env_CXX_LDFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS_HINTS from environment])
    CXX_LDFLAGS_HINTS="${abi_env_CXX_LDFLAGS_HINTS}"
  fi

  dnl Recall C++ linker flags for optimization
  if test "${abi_env_CXX_LDFLAGS_OPTIM}" != ""; then
    test "${CXX_LDFLAGS_OPTIM}" != "${abi_env_CXX_LDFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LDFLAGS_OPTIM from environment])
    CXX_LDFLAGS_OPTIM="${abi_env_CXX_LDFLAGS_OPTIM}"
  fi

  dnl Recall C++ linker additional libraries
  if test "${abi_env_CXX_LIBS}" != ""; then
    test "${CXX_LIBS}" != "${abi_env_CXX_LIBS}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS from environment])
    CXX_LIBS="${abi_env_CXX_LIBS}"
  fi

  dnl Recall C++ linker additional libraries for 64-bit objects
  if test "${abi_env_CXX_LIBS_64BITS}" != ""; then
    test "${CXX_LIBS_64BITS}" != "${abi_env_CXX_LIBS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS_64BITS from environment])
    CXX_LIBS_64BITS="${abi_env_CXX_LIBS_64BITS}"
  fi

  dnl Recall C++ linker additional libraries for debugging
  if test "${abi_env_CXX_LIBS_DEBUG}" != ""; then
    test "${CXX_LIBS_DEBUG}" != "${abi_env_CXX_LIBS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS_DEBUG from environment])
    CXX_LIBS_DEBUG="${abi_env_CXX_LIBS_DEBUG}"
  fi

  dnl Recall C++ linker additional libraries
  if test "${abi_env_CXX_LIBS_EXTRA}" != ""; then
    test "${CXX_LIBS_EXTRA}" != "${abi_env_CXX_LIBS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS_EXTRA from environment])
    CXX_LIBS_EXTRA="${abi_env_CXX_LIBS_EXTRA}"
  fi

  dnl Recall C++ linker additional libraries for GPU
  if test "${abi_env_CXX_LIBS_GPU}" != ""; then
    test "${CXX_LIBS_GPU}" != "${abi_env_CXX_LIBS_GPU}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS_GPU from environment])
    CXX_LIBS_GPU="${abi_env_CXX_LIBS_GPU}"
  fi

  dnl Recall Tricky C++ linker additional libraries
  if test "${abi_env_CXX_LIBS_HINTS}" != ""; then
    test "${CXX_LIBS_HINTS}" != "${abi_env_CXX_LIBS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS_HINTS from environment])
    CXX_LIBS_HINTS="${abi_env_CXX_LIBS_HINTS}"
  fi

  dnl Recall C++ linker additional libraries for optimization
  if test "${abi_env_CXX_LIBS_OPTIM}" != ""; then
    test "${CXX_LIBS_OPTIM}" != "${abi_env_CXX_LIBS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of CXX_LIBS_OPTIM from environment])
    CXX_LIBS_OPTIM="${abi_env_CXX_LIBS_OPTIM}"
  fi

  dnl Recall C preprocessor definitions
  if test "${abi_env_DEFS}" != ""; then
    test "${DEFS}" != "${abi_env_DEFS}" && \
      AC_MSG_NOTICE([overriding configuration of DEFS from environment])
    DEFS="${abi_env_DEFS}"
  fi

  dnl Recall Fortran 77 compiler
  if test "${abi_env_F77}" != ""; then
    test "${F77}" != "${abi_env_F77}" && \
      AC_MSG_NOTICE([overriding configuration of F77 from environment])
    F77="${abi_env_F77}"
  fi

  dnl Recall Fortran compiler
  if test "${abi_env_FC}" != ""; then
    test "${FC}" != "${abi_env_FC}" && \
      AC_MSG_NOTICE([overriding configuration of FC from environment])
    FC="${abi_env_FC}"
  fi

  dnl Recall Fortran compiler flags
  if test "${abi_env_FCFLAGS}" != ""; then
    test "${FCFLAGS}" != "${abi_env_FCFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS from environment])
    FCFLAGS="${abi_env_FCFLAGS}"
  fi

  dnl Recall Fortran flags for 64-bit objects
  if test "${abi_env_FCFLAGS_64BITS}" != ""; then
    test "${FCFLAGS_64BITS}" != "${abi_env_FCFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_64BITS from environment])
    FCFLAGS_64BITS="${abi_env_FCFLAGS_64BITS}"
  fi

  dnl Recall Fortran compiler flags for debugging
  if test "${abi_env_FCFLAGS_DEBUG}" != ""; then
    test "${FCFLAGS_DEBUG}" != "${abi_env_FCFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_DEBUG from environment])
    FCFLAGS_DEBUG="${abi_env_FCFLAGS_DEBUG}"
  fi

  dnl Recall Additional Fortran compiler flags
  if test "${abi_env_FCFLAGS_EXTRA}" != ""; then
    test "${FCFLAGS_EXTRA}" != "${abi_env_FCFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_EXTRA from environment])
    FCFLAGS_EXTRA="${abi_env_FCFLAGS_EXTRA}"
  fi

  dnl Recall Fortran flags for fixed-form source files
  if test "${abi_env_FCFLAGS_FIXEDFORM}" != ""; then
    test "${FCFLAGS_FIXEDFORM}" != "${abi_env_FCFLAGS_FIXEDFORM}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_FIXEDFORM from environment])
    FCFLAGS_FIXEDFORM="${abi_env_FCFLAGS_FIXEDFORM}"
  fi

  dnl Recall Fortran flags for free-form source files
  if test "${abi_env_FCFLAGS_FREEFORM}" != ""; then
    test "${FCFLAGS_FREEFORM}" != "${abi_env_FCFLAGS_FREEFORM}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_FREEFORM from environment])
    FCFLAGS_FREEFORM="${abi_env_FCFLAGS_FREEFORM}"
  fi

  dnl Recall Tricky Fortran compiler flags
  if test "${abi_env_FCFLAGS_HINTS}" != ""; then
    test "${FCFLAGS_HINTS}" != "${abi_env_FCFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_HINTS from environment])
    FCFLAGS_HINTS="${abi_env_FCFLAGS_HINTS}"
  fi

  dnl Recall Fortran compiler flags to use a module directory
  if test "${abi_env_FCFLAGS_MODDIR}" != ""; then
    test "${FCFLAGS_MODDIR}" != "${abi_env_FCFLAGS_MODDIR}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_MODDIR from environment])
    FCFLAGS_MODDIR="${abi_env_FCFLAGS_MODDIR}"
  fi

  dnl Recall Fortran compiler flags to enable openmp
  if test "${abi_env_FCFLAGS_OPENMP}" != ""; then
    test "${FCFLAGS_OPENMP}" != "${abi_env_FCFLAGS_OPENMP}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_OPENMP from environment])
    FCFLAGS_OPENMP="${abi_env_FCFLAGS_OPENMP}"
  fi

  dnl Recall Fortran compiler flags for optimization
  if test "${abi_env_FCFLAGS_OPTIM}" != ""; then
    test "${FCFLAGS_OPTIM}" != "${abi_env_FCFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of FCFLAGS_OPTIM from environment])
    FCFLAGS_OPTIM="${abi_env_FCFLAGS_OPTIM}"
  fi

  dnl Recall Fortran linker flags
  if test "${abi_env_FC_LDFLAGS}" != ""; then
    test "${FC_LDFLAGS}" != "${abi_env_FC_LDFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LDFLAGS from environment])
    FC_LDFLAGS="${abi_env_FC_LDFLAGS}"
  fi

  dnl Recall Fortran linker flags for 64-bit objects
  if test "${abi_env_FC_LDFLAGS_64BITS}" != ""; then
    test "${FC_LDFLAGS_64BITS}" != "${abi_env_FC_LDFLAGS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LDFLAGS_64BITS from environment])
    FC_LDFLAGS_64BITS="${abi_env_FC_LDFLAGS_64BITS}"
  fi

  dnl Recall Fortran linker flags for debugging
  if test "${abi_env_FC_LDFLAGS_DEBUG}" != ""; then
    test "${FC_LDFLAGS_DEBUG}" != "${abi_env_FC_LDFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LDFLAGS_DEBUG from environment])
    FC_LDFLAGS_DEBUG="${abi_env_FC_LDFLAGS_DEBUG}"
  fi

  dnl Recall Additional Fortran linker flags
  if test "${abi_env_FC_LDFLAGS_EXTRA}" != ""; then
    test "${FC_LDFLAGS_EXTRA}" != "${abi_env_FC_LDFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LDFLAGS_EXTRA from environment])
    FC_LDFLAGS_EXTRA="${abi_env_FC_LDFLAGS_EXTRA}"
  fi

  dnl Recall Tricky Fortran linker flags
  if test "${abi_env_FC_LDFLAGS_HINTS}" != ""; then
    test "${FC_LDFLAGS_HINTS}" != "${abi_env_FC_LDFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LDFLAGS_HINTS from environment])
    FC_LDFLAGS_HINTS="${abi_env_FC_LDFLAGS_HINTS}"
  fi

  dnl Recall Fortran linker flags for optimization
  if test "${abi_env_FC_LDFLAGS_OPTIM}" != ""; then
    test "${FC_LDFLAGS_OPTIM}" != "${abi_env_FC_LDFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LDFLAGS_OPTIM from environment])
    FC_LDFLAGS_OPTIM="${abi_env_FC_LDFLAGS_OPTIM}"
  fi

  dnl Recall Fortran linker additional libraries
  if test "${abi_env_FC_LIBS}" != ""; then
    test "${FC_LIBS}" != "${abi_env_FC_LIBS}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LIBS from environment])
    FC_LIBS="${abi_env_FC_LIBS}"
  fi

  dnl Recall Fortran linker additional libraries for 64-bit objects
  if test "${abi_env_FC_LIBS_64BITS}" != ""; then
    test "${FC_LIBS_64BITS}" != "${abi_env_FC_LIBS_64BITS}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LIBS_64BITS from environment])
    FC_LIBS_64BITS="${abi_env_FC_LIBS_64BITS}"
  fi

  dnl Recall Fortran linker additional libraries for debugging
  if test "${abi_env_FC_LIBS_DEBUG}" != ""; then
    test "${FC_LIBS_DEBUG}" != "${abi_env_FC_LIBS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LIBS_DEBUG from environment])
    FC_LIBS_DEBUG="${abi_env_FC_LIBS_DEBUG}"
  fi

  dnl Recall Fortran linker additional libraries
  if test "${abi_env_FC_LIBS_EXTRA}" != ""; then
    test "${FC_LIBS_EXTRA}" != "${abi_env_FC_LIBS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LIBS_EXTRA from environment])
    FC_LIBS_EXTRA="${abi_env_FC_LIBS_EXTRA}"
  fi

  dnl Recall Tricky Fortran linker additional libraries
  if test "${abi_env_FC_LIBS_HINTS}" != ""; then
    test "${FC_LIBS_HINTS}" != "${abi_env_FC_LIBS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LIBS_HINTS from environment])
    FC_LIBS_HINTS="${abi_env_FC_LIBS_HINTS}"
  fi

  dnl Recall Fortran linker additional libraries for optimization
  if test "${abi_env_FC_LIBS_OPTIM}" != ""; then
    test "${FC_LIBS_OPTIM}" != "${abi_env_FC_LIBS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of FC_LIBS_OPTIM from environment])
    FC_LIBS_OPTIM="${abi_env_FC_LIBS_OPTIM}"
  fi

  dnl Recall Fortran preprocessor
  if test "${abi_env_FPP}" != ""; then
    test "${FPP}" != "${abi_env_FPP}" && \
      AC_MSG_NOTICE([overriding configuration of FPP from environment])
    FPP="${abi_env_FPP}"
  fi

  dnl Recall Fortran preprocessor flags
  if test "${abi_env_FPPFLAGS}" != ""; then
    test "${FPPFLAGS}" != "${abi_env_FPPFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of FPPFLAGS from environment])
    FPPFLAGS="${abi_env_FPPFLAGS}"
  fi

  dnl Recall Fortran preprocessor flags for debugging
  if test "${abi_env_FPPFLAGS_DEBUG}" != ""; then
    test "${FPPFLAGS_DEBUG}" != "${abi_env_FPPFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of FPPFLAGS_DEBUG from environment])
    FPPFLAGS_DEBUG="${abi_env_FPPFLAGS_DEBUG}"
  fi

  dnl Recall Additional Fortran preprocessor flags
  if test "${abi_env_FPPFLAGS_EXTRA}" != ""; then
    test "${FPPFLAGS_EXTRA}" != "${abi_env_FPPFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of FPPFLAGS_EXTRA from environment])
    FPPFLAGS_EXTRA="${abi_env_FPPFLAGS_EXTRA}"
  fi

  dnl Recall Tricky Fortran preprocessor flags
  if test "${abi_env_FPPFLAGS_HINTS}" != ""; then
    test "${FPPFLAGS_HINTS}" != "${abi_env_FPPFLAGS_HINTS}" && \
      AC_MSG_NOTICE([overriding configuration of FPPFLAGS_HINTS from environment])
    FPPFLAGS_HINTS="${abi_env_FPPFLAGS_HINTS}"
  fi

  dnl Recall Fortran preprocessor flags for optimization
  if test "${abi_env_FPPFLAGS_OPTIM}" != ""; then
    test "${FPPFLAGS_OPTIM}" != "${abi_env_FPPFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of FPPFLAGS_OPTIM from environment])
    FPPFLAGS_OPTIM="${abi_env_FPPFLAGS_OPTIM}"
  fi

  dnl Recall Linker
  if test "${abi_env_LD}" != ""; then
    test "${LD}" != "${abi_env_LD}" && \
      AC_MSG_NOTICE([overriding configuration of LD from environment])
    LD="${abi_env_LD}"
  fi

  dnl Recall LaTeX flags
  if test "${abi_env_LTXFLAGS}" != ""; then
    test "${LTXFLAGS}" != "${abi_env_LTXFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of LTXFLAGS from environment])
    LTXFLAGS="${abi_env_LTXFLAGS}"
  fi

  dnl Recall Markdown text-to-HTML processor flags
  if test "${abi_env_MDFLAGS}" != ""; then
    test "${MDFLAGS}" != "${abi_env_MDFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of MDFLAGS from environment])
    MDFLAGS="${abi_env_MDFLAGS}"
  fi

  dnl Recall MPI runner command
  if test "${abi_env_MPI_RUNNER}" != ""; then
    test "${MPI_RUNNER}" != "${abi_env_MPI_RUNNER}" && \
      AC_MSG_NOTICE([overriding configuration of MPI_RUNNER from environment])
    MPI_RUNNER="${abi_env_MPI_RUNNER}"
  fi

  dnl Recall List symbols from object files
  if test "${abi_env_NM}" != ""; then
    test "${NM}" != "${abi_env_NM}" && \
      AC_MSG_NOTICE([overriding configuration of NM from environment])
    NM="${abi_env_NM}"
  fi

  dnl Recall nVidia CUDA C compiler
  if test "${abi_env_NVCC}" != ""; then
    test "${NVCC}" != "${abi_env_NVCC}" && \
      AC_MSG_NOTICE([overriding configuration of NVCC from environment])
    NVCC="${abi_env_NVCC}"
  fi

  dnl Recall nVidia CUDA C compiler flags
  if test "${abi_env_NVCC_CFLAGS}" != ""; then
    test "${NVCC_CFLAGS}" != "${abi_env_NVCC_CFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of NVCC_CFLAGS from environment])
    NVCC_CFLAGS="${abi_env_NVCC_CFLAGS}"
  fi

  dnl Recall nVidia CUDA preprocessing options
  if test "${abi_env_NVCC_CPPFLAGS}" != ""; then
    test "${NVCC_CPPFLAGS}" != "${abi_env_NVCC_CPPFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of NVCC_CPPFLAGS from environment])
    NVCC_CPPFLAGS="${abi_env_NVCC_CPPFLAGS}"
  fi

  dnl Recall nVidia CUDA C linker flags
  if test "${abi_env_NVCC_LDFLAGS}" != ""; then
    test "${NVCC_LDFLAGS}" != "${abi_env_NVCC_LDFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of NVCC_LDFLAGS from environment])
    NVCC_LDFLAGS="${abi_env_NVCC_LDFLAGS}"
  fi

  dnl Recall nVidia CUDA C linker additional libraries
  if test "${abi_env_NVCC_LIBS}" != ""; then
    test "${NVCC_LIBS}" != "${abi_env_NVCC_LIBS}" && \
      AC_MSG_NOTICE([overriding configuration of NVCC_LIBS from environment])
    NVCC_LIBS="${abi_env_NVCC_LIBS}"
  fi

  dnl Recall DVI->PDF converter flags
  if test "${abi_env_PDFFLAGS}" != ""; then
    test "${PDFFLAGS}" != "${abi_env_PDFFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of PDFFLAGS from environment])
    PDFFLAGS="${abi_env_PDFFLAGS}"
  fi

  dnl Recall Generate index to archive
  if test "${abi_env_RANLIB}" != ""; then
    test "${RANLIB}" != "${abi_env_RANLIB}" && \
      AC_MSG_NOTICE([overriding configuration of RANLIB from environment])
    RANLIB="${abi_env_RANLIB}"
  fi

  dnl Recall Serial runner command
  if test "${abi_env_SERIAL_RUNNER}" != ""; then
    test "${SERIAL_RUNNER}" != "${abi_env_SERIAL_RUNNER}" && \
      AC_MSG_NOTICE([overriding configuration of SERIAL_RUNNER from environment])
    SERIAL_RUNNER="${abi_env_SERIAL_RUNNER}"
  fi

  dnl Recall C++ preprocessor
  if test "${abi_env_XPP}" != ""; then
    test "${XPP}" != "${abi_env_XPP}" && \
      AC_MSG_NOTICE([overriding configuration of XPP from environment])
    XPP="${abi_env_XPP}"
  fi

  dnl Recall C++ preprocessor flags
  if test "${abi_env_XPPFLAGS}" != ""; then
    test "${XPPFLAGS}" != "${abi_env_XPPFLAGS}" && \
      AC_MSG_NOTICE([overriding configuration of XPPFLAGS from environment])
    XPPFLAGS="${abi_env_XPPFLAGS}"
  fi

  dnl Recall C++ preprocessor flags for debugging
  if test "${abi_env_XPPFLAGS_DEBUG}" != ""; then
    test "${XPPFLAGS_DEBUG}" != "${abi_env_XPPFLAGS_DEBUG}" && \
      AC_MSG_NOTICE([overriding configuration of XPPFLAGS_DEBUG from environment])
    XPPFLAGS_DEBUG="${abi_env_XPPFLAGS_DEBUG}"
  fi

  dnl Recall Additional C++ preprocessor flags
  if test "${abi_env_XPPFLAGS_EXTRA}" != ""; then
    test "${XPPFLAGS_EXTRA}" != "${abi_env_XPPFLAGS_EXTRA}" && \
      AC_MSG_NOTICE([overriding configuration of XPPFLAGS_EXTRA from environment])
    XPPFLAGS_EXTRA="${abi_env_XPPFLAGS_EXTRA}"
  fi

  dnl Recall C++ preprocessor flags for optimization
  if test "${abi_env_XPPFLAGS_OPTIM}" != ""; then
    test "${XPPFLAGS_OPTIM}" != "${abi_env_XPPFLAGS_OPTIM}" && \
      AC_MSG_NOTICE([overriding configuration of XPPFLAGS_OPTIM from environment])
    XPPFLAGS_OPTIM="${abi_env_XPPFLAGS_OPTIM}"
  fi

]) # ABI_ENV_RECALL



# ABI_ENV_RESTORE()
# -----------------
#
# Restores all previously-saved ABINIT environment variables.
#
AC_DEFUN([ABI_ENV_RESTORE],[

  dnl Restore CPPFLAGS holder to permit C/Fortran mixing
  ABI_CPPFLAGS="${abi_env_ABI_CPPFLAGS}"

  dnl Restore Library archiver
  AR="${abi_env_AR}"

  dnl Restore Library archiver flags
  ARFLAGS="${abi_env_ARFLAGS}"

  dnl Restore Library archiver flags for 64-bit objects
  ARFLAGS_64BITS="${abi_env_ARFLAGS_64BITS}"

  dnl Restore Library archiver commands
  ARFLAGS_CMD="${abi_env_ARFLAGS_CMD}"

  dnl Restore Library archiver flags for debugging
  ARFLAGS_DEBUG="${abi_env_ARFLAGS_DEBUG}"

  dnl Restore Additional library archiver flags
  ARFLAGS_EXTRA="${abi_env_ARFLAGS_EXTRA}"

  dnl Restore Tricky library archiver flags
  ARFLAGS_HINTS="${abi_env_ARFLAGS_HINTS}"

  dnl Restore Library archiver flags for optimization
  ARFLAGS_OPTIM="${abi_env_ARFLAGS_OPTIM}"

  dnl Restore C compiler
  CC="${abi_env_CC}"

  dnl Restore C linker flags
  CC_LDFLAGS="${abi_env_CC_LDFLAGS}"

  dnl Restore C linker flags for 64-bit objects
  CC_LDFLAGS_64BITS="${abi_env_CC_LDFLAGS_64BITS}"

  dnl Restore C linker flags for debugging
  CC_LDFLAGS_DEBUG="${abi_env_CC_LDFLAGS_DEBUG}"

  dnl Restore Additional C linker flags
  CC_LDFLAGS_EXTRA="${abi_env_CC_LDFLAGS_EXTRA}"

  dnl Restore C linker flags for GPU
  CC_LDFLAGS_GPU="${abi_env_CC_LDFLAGS_GPU}"

  dnl Restore Tricky C linker flags
  CC_LDFLAGS_HINTS="${abi_env_CC_LDFLAGS_HINTS}"

  dnl Restore C linker flags for optimization
  CC_LDFLAGS_OPTIM="${abi_env_CC_LDFLAGS_OPTIM}"

  dnl Restore C linker libraries
  CC_LIBS="${abi_env_CC_LIBS}"

  dnl Restore C linker additional libraries for 64-bit objects
  CC_LIBS_64BITS="${abi_env_CC_LIBS_64BITS}"

  dnl Restore C linker additional libraries for debugging
  CC_LIBS_DEBUG="${abi_env_CC_LIBS_DEBUG}"

  dnl Restore C linker additional libraries
  CC_LIBS_EXTRA="${abi_env_CC_LIBS_EXTRA}"

  dnl Restore C linker additional libraries for GPU
  CC_LIBS_GPU="${abi_env_CC_LIBS_GPU}"

  dnl Restore Tricky C linker additional libraries
  CC_LIBS_HINTS="${abi_env_CC_LIBS_HINTS}"

  dnl Restore C linker additional libraries for optimization
  CC_LIBS_OPTIM="${abi_env_CC_LIBS_OPTIM}"

  dnl Restore C compiler flags
  CFLAGS="${abi_env_CFLAGS}"

  dnl Restore C flags for 64-bit objects
  CFLAGS_64BITS="${abi_env_CFLAGS_64BITS}"

  dnl Restore C compiler flags for debugging
  CFLAGS_DEBUG="${abi_env_CFLAGS_DEBUG}"

  dnl Restore Additional C compiler flags
  CFLAGS_EXTRA="${abi_env_CFLAGS_EXTRA}"

  dnl Restore C flags for GPU
  CFLAGS_GPU="${abi_env_CFLAGS_GPU}"

  dnl Restore Tricky C compiler flags
  CFLAGS_HINTS="${abi_env_CFLAGS_HINTS}"

  dnl Restore C compiler flags for optimization
  CFLAGS_OPTIM="${abi_env_CFLAGS_OPTIM}"

  dnl Restore C preprocessor
  CPP="${abi_env_CPP}"

  dnl Restore C preprocessor flags
  CPPFLAGS="${abi_env_CPPFLAGS}"

  dnl Restore C preprocessor flags for 64-bit objects
  CPPFLAGS_64BITS="${abi_env_CPPFLAGS_64BITS}"

  dnl Restore C preprocessor flags for debugging
  CPPFLAGS_DEBUG="${abi_env_CPPFLAGS_DEBUG}"

  dnl Restore Additional C preprocessor flags
  CPPFLAGS_EXTRA="${abi_env_CPPFLAGS_EXTRA}"

  dnl Restore C preprocessor flags for GPU
  CPPFLAGS_GPU="${abi_env_CPPFLAGS_GPU}"

  dnl Restore Tricky C preprocessor flags
  CPPFLAGS_HINTS="${abi_env_CPPFLAGS_HINTS}"

  dnl Restore C preprocessor flags for optimization
  CPPFLAGS_OPTIM="${abi_env_CPPFLAGS_OPTIM}"

  dnl Restore C++ compiler
  CXX="${abi_env_CXX}"

  dnl Restore C++ compiler flags
  CXXFLAGS="${abi_env_CXXFLAGS}"

  dnl Restore C++ flags for 64-bit objects
  CXXFLAGS_64BITS="${abi_env_CXXFLAGS_64BITS}"

  dnl Restore C++ compiler flags for debugging
  CXXFLAGS_DEBUG="${abi_env_CXXFLAGS_DEBUG}"

  dnl Restore Additional C++ compiler flags
  CXXFLAGS_EXTRA="${abi_env_CXXFLAGS_EXTRA}"

  dnl Restore C++ flags for GPU
  CXXFLAGS_GPU="${abi_env_CXXFLAGS_GPU}"

  dnl Restore Tricky C++ compiler flags
  CXXFLAGS_HINTS="${abi_env_CXXFLAGS_HINTS}"

  dnl Restore C++ compiler flags for optimization
  CXXFLAGS_OPTIM="${abi_env_CXXFLAGS_OPTIM}"

  dnl Restore C++ linker flags
  CXX_LDFLAGS="${abi_env_CXX_LDFLAGS}"

  dnl Restore C++ linker flags for 64-bit objects
  CXX_LDFLAGS_64BITS="${abi_env_CXX_LDFLAGS_64BITS}"

  dnl Restore C++ linker flags for debugging
  CXX_LDFLAGS_DEBUG="${abi_env_CXX_LDFLAGS_DEBUG}"

  dnl Restore Additional C++ linker flags
  CXX_LDFLAGS_EXTRA="${abi_env_CXX_LDFLAGS_EXTRA}"

  dnl Restore C++ linker flags for GPU
  CXX_LDFLAGS_GPU="${abi_env_CXX_LDFLAGS_GPU}"

  dnl Restore Tricky C++ linker flags
  CXX_LDFLAGS_HINTS="${abi_env_CXX_LDFLAGS_HINTS}"

  dnl Restore C++ linker flags for optimization
  CXX_LDFLAGS_OPTIM="${abi_env_CXX_LDFLAGS_OPTIM}"

  dnl Restore C++ linker additional libraries
  CXX_LIBS="${abi_env_CXX_LIBS}"

  dnl Restore C++ linker additional libraries for 64-bit objects
  CXX_LIBS_64BITS="${abi_env_CXX_LIBS_64BITS}"

  dnl Restore C++ linker additional libraries for debugging
  CXX_LIBS_DEBUG="${abi_env_CXX_LIBS_DEBUG}"

  dnl Restore C++ linker additional libraries
  CXX_LIBS_EXTRA="${abi_env_CXX_LIBS_EXTRA}"

  dnl Restore C++ linker additional libraries for GPU
  CXX_LIBS_GPU="${abi_env_CXX_LIBS_GPU}"

  dnl Restore Tricky C++ linker additional libraries
  CXX_LIBS_HINTS="${abi_env_CXX_LIBS_HINTS}"

  dnl Restore C++ linker additional libraries for optimization
  CXX_LIBS_OPTIM="${abi_env_CXX_LIBS_OPTIM}"

  dnl Restore C preprocessor definitions
  DEFS="${abi_env_DEFS}"

  dnl Restore Fortran 77 compiler
  F77="${abi_env_F77}"

  dnl Restore Fortran compiler
  FC="${abi_env_FC}"

  dnl Restore Fortran compiler flags
  FCFLAGS="${abi_env_FCFLAGS}"

  dnl Restore Fortran flags for 64-bit objects
  FCFLAGS_64BITS="${abi_env_FCFLAGS_64BITS}"

  dnl Restore Fortran compiler flags for debugging
  FCFLAGS_DEBUG="${abi_env_FCFLAGS_DEBUG}"

  dnl Restore Additional Fortran compiler flags
  FCFLAGS_EXTRA="${abi_env_FCFLAGS_EXTRA}"

  dnl Restore Fortran flags for fixed-form source files
  FCFLAGS_FIXEDFORM="${abi_env_FCFLAGS_FIXEDFORM}"

  dnl Restore Fortran flags for free-form source files
  FCFLAGS_FREEFORM="${abi_env_FCFLAGS_FREEFORM}"

  dnl Restore Tricky Fortran compiler flags
  FCFLAGS_HINTS="${abi_env_FCFLAGS_HINTS}"

  dnl Restore Fortran compiler flags to use a module directory
  FCFLAGS_MODDIR="${abi_env_FCFLAGS_MODDIR}"

  dnl Restore Fortran compiler flags to enable openmp
  FCFLAGS_OPENMP="${abi_env_FCFLAGS_OPENMP}"

  dnl Restore Fortran compiler flags for optimization
  FCFLAGS_OPTIM="${abi_env_FCFLAGS_OPTIM}"

  dnl Restore Fortran linker flags
  FC_LDFLAGS="${abi_env_FC_LDFLAGS}"

  dnl Restore Fortran linker flags for 64-bit objects
  FC_LDFLAGS_64BITS="${abi_env_FC_LDFLAGS_64BITS}"

  dnl Restore Fortran linker flags for debugging
  FC_LDFLAGS_DEBUG="${abi_env_FC_LDFLAGS_DEBUG}"

  dnl Restore Additional Fortran linker flags
  FC_LDFLAGS_EXTRA="${abi_env_FC_LDFLAGS_EXTRA}"

  dnl Restore Tricky Fortran linker flags
  FC_LDFLAGS_HINTS="${abi_env_FC_LDFLAGS_HINTS}"

  dnl Restore Fortran linker flags for optimization
  FC_LDFLAGS_OPTIM="${abi_env_FC_LDFLAGS_OPTIM}"

  dnl Restore Fortran linker additional libraries
  FC_LIBS="${abi_env_FC_LIBS}"

  dnl Restore Fortran linker additional libraries for 64-bit objects
  FC_LIBS_64BITS="${abi_env_FC_LIBS_64BITS}"

  dnl Restore Fortran linker additional libraries for debugging
  FC_LIBS_DEBUG="${abi_env_FC_LIBS_DEBUG}"

  dnl Restore Fortran linker additional libraries
  FC_LIBS_EXTRA="${abi_env_FC_LIBS_EXTRA}"

  dnl Restore Tricky Fortran linker additional libraries
  FC_LIBS_HINTS="${abi_env_FC_LIBS_HINTS}"

  dnl Restore Fortran linker additional libraries for optimization
  FC_LIBS_OPTIM="${abi_env_FC_LIBS_OPTIM}"

  dnl Restore Fortran preprocessor
  FPP="${abi_env_FPP}"

  dnl Restore Fortran preprocessor flags
  FPPFLAGS="${abi_env_FPPFLAGS}"

  dnl Restore Fortran preprocessor flags for debugging
  FPPFLAGS_DEBUG="${abi_env_FPPFLAGS_DEBUG}"

  dnl Restore Additional Fortran preprocessor flags
  FPPFLAGS_EXTRA="${abi_env_FPPFLAGS_EXTRA}"

  dnl Restore Tricky Fortran preprocessor flags
  FPPFLAGS_HINTS="${abi_env_FPPFLAGS_HINTS}"

  dnl Restore Fortran preprocessor flags for optimization
  FPPFLAGS_OPTIM="${abi_env_FPPFLAGS_OPTIM}"

  dnl Restore Linker
  LD="${abi_env_LD}"

  dnl Restore LaTeX flags
  LTXFLAGS="${abi_env_LTXFLAGS}"

  dnl Restore Markdown text-to-HTML processor flags
  MDFLAGS="${abi_env_MDFLAGS}"

  dnl Restore MPI runner command
  MPI_RUNNER="${abi_env_MPI_RUNNER}"

  dnl Restore List symbols from object files
  NM="${abi_env_NM}"

  dnl Restore nVidia CUDA C compiler
  NVCC="${abi_env_NVCC}"

  dnl Restore nVidia CUDA C compiler flags
  NVCC_CFLAGS="${abi_env_NVCC_CFLAGS}"

  dnl Restore nVidia CUDA preprocessing options
  NVCC_CPPFLAGS="${abi_env_NVCC_CPPFLAGS}"

  dnl Restore nVidia CUDA C linker flags
  NVCC_LDFLAGS="${abi_env_NVCC_LDFLAGS}"

  dnl Restore nVidia CUDA C linker additional libraries
  NVCC_LIBS="${abi_env_NVCC_LIBS}"

  dnl Restore DVI->PDF converter flags
  PDFFLAGS="${abi_env_PDFFLAGS}"

  dnl Restore Generate index to archive
  RANLIB="${abi_env_RANLIB}"

  dnl Restore Serial runner command
  SERIAL_RUNNER="${abi_env_SERIAL_RUNNER}"

  dnl Restore C++ preprocessor
  XPP="${abi_env_XPP}"

  dnl Restore C++ preprocessor flags
  XPPFLAGS="${abi_env_XPPFLAGS}"

  dnl Restore C++ preprocessor flags for debugging
  XPPFLAGS_DEBUG="${abi_env_XPPFLAGS_DEBUG}"

  dnl Restore Additional C++ preprocessor flags
  XPPFLAGS_EXTRA="${abi_env_XPPFLAGS_EXTRA}"

  dnl Restore C++ preprocessor flags for optimization
  XPPFLAGS_OPTIM="${abi_env_XPPFLAGS_OPTIM}"

]) # ABI_ENV_RESTORE
