/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.transform;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.JDOMFactory;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.jdom.transform.XSLTransformException;
import org.xml.sax.EntityResolver;

public class XSLTransformer {
    private static final String CVS_ID = "@(#) $RCSfile: XSLTransformer.java,v $ $Revision: 1.5 $ $Date: 2007/11/14 04:36:54 $ $Name: jdom_1_1_1 $";
    private Templates templates;
    private JDOMFactory factory = null;

    private XSLTransformer(Source source) throws XSLTransformException {
        try {
            this.templates = TransformerFactory.newInstance().newTemplates(source);
        }
        catch (TransformerException transformerException) {
            throw new XSLTransformException("Could not construct XSLTransformer", transformerException);
        }
    }

    public XSLTransformer(String string) throws XSLTransformException {
        this(new StreamSource(string));
    }

    public XSLTransformer(InputStream inputStream) throws XSLTransformException {
        this(new StreamSource(inputStream));
    }

    public XSLTransformer(Reader reader) throws XSLTransformException {
        this(new StreamSource(reader));
    }

    public XSLTransformer(File file) throws XSLTransformException {
        this(new StreamSource(file));
    }

    public XSLTransformer(Document document) throws XSLTransformException {
        this(new JDOMSource(document));
    }

    public List transform(List list) throws XSLTransformException {
        JDOMSource jDOMSource = new JDOMSource(list);
        JDOMResult jDOMResult = new JDOMResult();
        jDOMResult.setFactory(this.factory);
        try {
            this.templates.newTransformer().transform(jDOMSource, jDOMResult);
            return jDOMResult.getResult();
        }
        catch (TransformerException transformerException) {
            throw new XSLTransformException("Could not perform transformation", transformerException);
        }
    }

    public Document transform(Document document) throws XSLTransformException {
        return this.transform(document, null);
    }

    public Document transform(Document document, EntityResolver entityResolver) throws XSLTransformException {
        JDOMSource jDOMSource = new JDOMSource(document, entityResolver);
        JDOMResult jDOMResult = new JDOMResult();
        jDOMResult.setFactory(this.factory);
        try {
            this.templates.newTransformer().transform(jDOMSource, jDOMResult);
            return jDOMResult.getDocument();
        }
        catch (TransformerException transformerException) {
            throw new XSLTransformException("Could not perform transformation", transformerException);
        }
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }
}

