/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.JDOMLocator;
import org.jdom.output.NamespaceStack;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXOutputter {
    private static final String CVS_ID = "@(#) $RCSfile: SAXOutputter.java,v $ $Revision: 1.40 $ $Date: 2007/11/10 05:29:01 $ $Name: jdom_1_1_1 $";
    private static final String NAMESPACES_SAX_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NS_PREFIXES_SAX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_SAX_FEATURE = "http://xml.org/sax/features/validation";
    private static final String LEXICAL_HANDLER_SAX_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECL_HANDLER_SAX_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    private static final String LEXICAL_HANDLER_ALT_PROPERTY = "http://xml.org/sax/handlers/LexicalHandler";
    private static final String DECL_HANDLER_ALT_PROPERTY = "http://xml.org/sax/handlers/DeclHandler";
    private static final String[] attrTypeToNameMap = new String[]{"CDATA", "CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", "NOTATION", "NMTOKEN"};
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private LexicalHandler lexicalHandler;
    private DeclHandler declHandler;
    private boolean declareNamespaces = false;
    private boolean reportDtdEvents = true;
    private JDOMLocator locator = null;

    public SAXOutputter() {
    }

    public SAXOutputter(ContentHandler contentHandler) {
        this(contentHandler, null, null, null, null);
    }

    public SAXOutputter(ContentHandler contentHandler, ErrorHandler errorHandler, DTDHandler dTDHandler, EntityResolver entityResolver) {
        this(contentHandler, errorHandler, dTDHandler, entityResolver, null);
    }

    public SAXOutputter(ContentHandler contentHandler, ErrorHandler errorHandler, DTDHandler dTDHandler, EntityResolver entityResolver, LexicalHandler lexicalHandler) {
        this.contentHandler = contentHandler;
        this.errorHandler = errorHandler;
        this.dtdHandler = dTDHandler;
        this.entityResolver = entityResolver;
        this.lexicalHandler = lexicalHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public boolean getReportNamespaceDeclarations() {
        return this.declareNamespaces;
    }

    public void setReportNamespaceDeclarations(boolean bl) {
        this.declareNamespaces = bl;
    }

    public boolean getReportDTDEvents() {
        return this.reportDtdEvents;
    }

    public void setReportDTDEvents(boolean bl) {
        this.reportDtdEvents = bl;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NS_PREFIXES_SAX_FEATURE.equals(string)) {
            this.setReportNamespaceDeclarations(bl);
        } else if (NAMESPACES_SAX_FEATURE.equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (VALIDATION_SAX_FEATURE.equals(string)) {
            this.setReportDTDEvents(bl);
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NS_PREFIXES_SAX_FEATURE.equals(string)) {
            return this.declareNamespaces;
        }
        if (NAMESPACES_SAX_FEATURE.equals(string)) {
            return true;
        }
        if (VALIDATION_SAX_FEATURE.equals(string)) {
            return this.reportDtdEvents;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_SAX_PROPERTY.equals(string) || LEXICAL_HANDLER_ALT_PROPERTY.equals(string)) {
            this.setLexicalHandler((LexicalHandler)object);
        } else if (DECL_HANDLER_SAX_PROPERTY.equals(string) || DECL_HANDLER_ALT_PROPERTY.equals(string)) {
            this.setDeclHandler((DeclHandler)object);
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_SAX_PROPERTY.equals(string) || LEXICAL_HANDLER_ALT_PROPERTY.equals(string)) {
            return this.getLexicalHandler();
        }
        if (DECL_HANDLER_SAX_PROPERTY.equals(string) || DECL_HANDLER_ALT_PROPERTY.equals(string)) {
            return this.getDeclHandler();
        }
        throw new SAXNotRecognizedException(string);
    }

    public void output(Document document) throws JDOMException {
        if (document == null) {
            return;
        }
        this.documentLocator(document);
        this.startDocument();
        if (this.reportDtdEvents) {
            this.dtdEvents(document);
        }
        for (Object e : document.getContent()) {
            this.locator.setNode(e);
            if (e instanceof Element) {
                this.element(document.getRootElement(), new NamespaceStack());
                continue;
            }
            if (e instanceof ProcessingInstruction) {
                this.processingInstruction((ProcessingInstruction)e);
                continue;
            }
            if (!(e instanceof Comment)) continue;
            this.comment(((Comment)e).getText());
        }
        this.endDocument();
    }

    public void output(List list) throws JDOMException {
        if (list == null || list.size() == 0) {
            return;
        }
        this.documentLocator(null);
        this.startDocument();
        this.elementContent(list, new NamespaceStack());
        this.endDocument();
    }

    public void output(Element element) throws JDOMException {
        if (element == null) {
            return;
        }
        this.documentLocator(null);
        this.startDocument();
        this.elementContent(element, new NamespaceStack());
        this.endDocument();
    }

    public void outputFragment(List list) throws JDOMException {
        if (list == null || list.size() == 0) {
            return;
        }
        this.elementContent(list, new NamespaceStack());
    }

    public void outputFragment(Content content) throws JDOMException {
        if (content == null) {
            return;
        }
        this.elementContent(content, new NamespaceStack());
    }

    private void dtdEvents(Document document) throws JDOMException {
        DocType docType = document.getDocType();
        if (docType != null && (this.dtdHandler != null || this.declHandler != null)) {
            String string = new XMLOutputter().outputString(docType);
            try {
                this.createDTDParser().parse(new InputSource(new StringReader(string)));
            }
            catch (SAXParseException sAXParseException) {
            }
            catch (SAXException sAXException) {
                throw new JDOMException("DTD parsing error", sAXException);
            }
            catch (IOException iOException) {
                throw new JDOMException("DTD parsing error", iOException);
            }
        }
    }

    private void documentLocator(Document document) {
        DocType docType;
        this.locator = new JDOMLocator();
        String string = null;
        String string2 = null;
        if (document != null && (docType = document.getDocType()) != null) {
            string = docType.getPublicID();
            string2 = docType.getSystemID();
        }
        this.locator.setPublicId(string);
        this.locator.setSystemId(string2);
        this.locator.setLineNumber(-1);
        this.locator.setColumnNumber(-1);
        this.contentHandler.setDocumentLocator(this.locator);
    }

    private void startDocument() throws JDOMException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in startDocument", sAXException);
        }
    }

    private void endDocument() throws JDOMException {
        try {
            this.contentHandler.endDocument();
            this.locator = null;
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in endDocument", sAXException);
        }
    }

    private void processingInstruction(ProcessingInstruction processingInstruction) throws JDOMException {
        if (processingInstruction != null) {
            String string = processingInstruction.getTarget();
            String string2 = processingInstruction.getData();
            try {
                this.contentHandler.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in processingInstruction", sAXException);
            }
        }
    }

    private void element(Element element, NamespaceStack namespaceStack) throws JDOMException {
        int n = namespaceStack.size();
        Attributes attributes = this.startPrefixMapping(element, namespaceStack);
        this.startElement(element, attributes);
        this.elementContent(element.getContent(), namespaceStack);
        if (this.locator != null) {
            this.locator.setNode(element);
        }
        this.endElement(element);
        this.endPrefixMapping(namespaceStack, n);
    }

    private Attributes startPrefixMapping(Element element, NamespaceStack namespaceStack) throws JDOMException {
        Object object;
        Object object2;
        AttributesImpl attributesImpl = null;
        Namespace namespace = element.getNamespace();
        if (namespace != Namespace.XML_NAMESPACE) {
            object2 = namespace.getPrefix();
            object = namespaceStack.getURI((String)object2);
            if (!namespace.getURI().equals(object)) {
                namespaceStack.push(namespace);
                attributesImpl = this.addNsAttribute(attributesImpl, namespace);
                try {
                    this.contentHandler.startPrefixMapping((String)object2, namespace.getURI());
                }
                catch (SAXException sAXException) {
                    throw new JDOMException("Exception in startPrefixMapping", sAXException);
                }
            }
        }
        if ((object2 = element.getAdditionalNamespaces()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                namespace = (Namespace)object.next();
                String string = namespace.getPrefix();
                String string2 = namespaceStack.getURI(string);
                if (namespace.getURI().equals(string2)) continue;
                namespaceStack.push(namespace);
                attributesImpl = this.addNsAttribute(attributesImpl, namespace);
                try {
                    this.contentHandler.startPrefixMapping(string, namespace.getURI());
                }
                catch (SAXException sAXException) {
                    throw new JDOMException("Exception in startPrefixMapping", sAXException);
                }
            }
        }
        return attributesImpl;
    }

    private void endPrefixMapping(NamespaceStack namespaceStack, int n) throws JDOMException {
        while (namespaceStack.size() > n) {
            String string = namespaceStack.pop();
            try {
                this.contentHandler.endPrefixMapping(string);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in endPrefixMapping", sAXException);
            }
        }
    }

    private void startElement(Element element, Attributes attributes) throws JDOMException {
        String string = element.getNamespaceURI();
        String string2 = element.getName();
        String string3 = element.getQualifiedName();
        AttributesImpl attributesImpl = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        List list = element.getAttributes();
        for (Attribute attribute : list) {
            attributesImpl.addAttribute(attribute.getNamespaceURI(), attribute.getName(), attribute.getQualifiedName(), SAXOutputter.getAttributeTypeName(attribute.getAttributeType()), attribute.getValue());
        }
        try {
            this.contentHandler.startElement(string, string2, string3, attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in startElement", sAXException);
        }
    }

    private void endElement(Element element) throws JDOMException {
        String string = element.getNamespaceURI();
        String string2 = element.getName();
        String string3 = element.getQualifiedName();
        try {
            this.contentHandler.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in endElement", sAXException);
        }
    }

    private void elementContent(List list, NamespaceStack namespaceStack) throws JDOMException {
        for (Object e : list) {
            if (e instanceof Content) {
                this.elementContent((Content)e, namespaceStack);
                continue;
            }
            this.handleError(new JDOMException("Invalid element content: " + e));
        }
    }

    private void elementContent(Content content, NamespaceStack namespaceStack) throws JDOMException {
        if (this.locator != null) {
            this.locator.setNode(content);
        }
        if (content instanceof Element) {
            this.element((Element)content, namespaceStack);
        } else if (content instanceof CDATA) {
            this.cdata(((CDATA)content).getText());
        } else if (content instanceof Text) {
            this.characters(((Text)content).getText());
        } else if (content instanceof ProcessingInstruction) {
            this.processingInstruction((ProcessingInstruction)content);
        } else if (content instanceof Comment) {
            this.comment(((Comment)content).getText());
        } else if (content instanceof EntityRef) {
            this.entityRef((EntityRef)content);
        } else {
            this.handleError(new JDOMException("Invalid element content: " + content));
        }
    }

    private void cdata(String string) throws JDOMException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
                this.characters(string);
                this.lexicalHandler.endCDATA();
            } else {
                this.characters(string);
            }
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in CDATA", sAXException);
        }
    }

    private void characters(String string) throws JDOMException {
        char[] cArray = string.toCharArray();
        try {
            this.contentHandler.characters(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in characters", sAXException);
        }
    }

    private void comment(String string) throws JDOMException {
        if (this.lexicalHandler != null) {
            char[] cArray = string.toCharArray();
            try {
                this.lexicalHandler.comment(cArray, 0, cArray.length);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in comment", sAXException);
            }
        }
    }

    private void entityRef(EntityRef entityRef) throws JDOMException {
        if (entityRef != null) {
            try {
                this.contentHandler.skippedEntity(entityRef.getName());
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in entityRef", sAXException);
            }
        }
    }

    private AttributesImpl addNsAttribute(AttributesImpl attributesImpl, Namespace namespace) {
        if (this.declareNamespaces) {
            String string;
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            if ((string = namespace.getPrefix()).equals("")) {
                attributesImpl.addAttribute("", "", "xmlns", "CDATA", namespace.getURI());
            } else {
                attributesImpl.addAttribute("", "", "xmlns:" + namespace.getPrefix(), "CDATA", namespace.getURI());
            }
        }
        return attributesImpl;
    }

    private static String getAttributeTypeName(int n) {
        if (n < 0 || n >= attrTypeToNameMap.length) {
            n = 0;
        }
        return attrTypeToNameMap[n];
    }

    private void handleError(JDOMException jDOMException) throws JDOMException {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.error(new SAXParseException(jDOMException.getMessage(), null, jDOMException));
            }
            catch (SAXException sAXException) {
                if (sAXException.getException() instanceof JDOMException) {
                    throw (JDOMException)sAXException.getException();
                }
                throw new JDOMException(sAXException.getMessage(), sAXException);
            }
        } else {
            throw jDOMException;
        }
    }

    protected XMLReader createParser() throws Exception {
        XMLReader xMLReader = null;
        try {
            Class<?> clazz = Class.forName("javax.xml.parsers.SAXParserFactory");
            Method method = clazz.getMethod("newInstance", new Class[]{null});
            Object object = method.invoke(null, new Object[]{null});
            Method method2 = clazz.getMethod("newSAXParser", new Class[]{null});
            Object object2 = method2.invoke(object, new Object[]{null});
            Class<?> clazz2 = object2.getClass();
            Method method3 = clazz2.getMethod("getXMLReader", new Class[]{null});
            xMLReader = (XMLReader)method3.invoke(object2, new Object[]{null});
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        return xMLReader;
    }

    private XMLReader createDTDParser() throws JDOMException {
        XMLReader xMLReader = null;
        try {
            xMLReader = this.createParser();
        }
        catch (Exception exception) {
            throw new JDOMException("Error in SAX parser allocation", exception);
        }
        if (this.getDTDHandler() != null) {
            xMLReader.setDTDHandler(this.getDTDHandler());
        }
        if (this.getEntityResolver() != null) {
            xMLReader.setEntityResolver(this.getEntityResolver());
        }
        if (this.getLexicalHandler() != null) {
            try {
                xMLReader.setProperty(LEXICAL_HANDLER_SAX_PROPERTY, this.getLexicalHandler());
            }
            catch (SAXException sAXException) {
                try {
                    xMLReader.setProperty(LEXICAL_HANDLER_ALT_PROPERTY, this.getLexicalHandler());
                }
                catch (SAXException sAXException2) {
                    // empty catch block
                }
            }
        }
        if (this.getDeclHandler() != null) {
            try {
                xMLReader.setProperty(DECL_HANDLER_SAX_PROPERTY, this.getDeclHandler());
            }
            catch (SAXException sAXException) {
                try {
                    xMLReader.setProperty(DECL_HANDLER_ALT_PROPERTY, this.getDeclHandler());
                }
                catch (SAXException sAXException3) {
                    // empty catch block
                }
            }
        }
        xMLReader.setErrorHandler(new DefaultHandler());
        return xMLReader;
    }

    public JDOMLocator getLocator() {
        return this.locator != null ? new JDOMLocator(this.locator) : null;
    }
}

