/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter;

import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.filter.AbstractFilter;

public class ContentFilter
extends AbstractFilter {
    private static final String CVS_ID = "@(#) $RCSfile: ContentFilter.java,v $ $Revision: 1.15 $ $Date: 2007/11/10 05:29:00 $ $Name: jdom_1_1_1 $";
    public static final int ELEMENT = 1;
    public static final int CDATA = 2;
    public static final int TEXT = 4;
    public static final int COMMENT = 8;
    public static final int PI = 16;
    public static final int ENTITYREF = 32;
    public static final int DOCUMENT = 64;
    public static final int DOCTYPE = 128;
    private int filterMask;

    public ContentFilter() {
        this.setDefaultMask();
    }

    public ContentFilter(boolean bl) {
        if (bl) {
            this.setDefaultMask();
        } else {
            this.filterMask &= ~this.filterMask;
        }
    }

    public ContentFilter(int n) {
        this.setFilterMask(n);
    }

    public int getFilterMask() {
        return this.filterMask;
    }

    public void setFilterMask(int n) {
        this.setDefaultMask();
        this.filterMask &= n;
    }

    public void setDefaultMask() {
        this.filterMask = 255;
    }

    public void setDocumentContent() {
        this.filterMask = 153;
    }

    public void setElementContent() {
        this.filterMask = 63;
    }

    public void setElementVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 1) : (this.filterMask &= 0xFFFFFFFE);
    }

    public void setCDATAVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 2) : (this.filterMask &= 0xFFFFFFFD);
    }

    public void setTextVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 4) : (this.filterMask &= 0xFFFFFFFB);
    }

    public void setCommentVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 8) : (this.filterMask &= 0xFFFFFFF7);
    }

    public void setPIVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x10) : (this.filterMask &= 0xFFFFFFEF);
    }

    public void setEntityRefVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x20) : (this.filterMask &= 0xFFFFFFDF);
    }

    public void setDocTypeVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x80) : (this.filterMask &= 0xFFFFFF7F);
    }

    @Override
    public boolean matches(Object object) {
        if (object instanceof Element) {
            return (this.filterMask & 1) != 0;
        }
        if (object instanceof CDATA) {
            return (this.filterMask & 2) != 0;
        }
        if (object instanceof Text) {
            return (this.filterMask & 4) != 0;
        }
        if (object instanceof Comment) {
            return (this.filterMask & 8) != 0;
        }
        if (object instanceof ProcessingInstruction) {
            return (this.filterMask & 0x10) != 0;
        }
        if (object instanceof EntityRef) {
            return (this.filterMask & 0x20) != 0;
        }
        if (object instanceof Document) {
            return (this.filterMask & 0x40) != 0;
        }
        if (object instanceof DocType) {
            return (this.filterMask & 0x80) != 0;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentFilter)) {
            return false;
        }
        ContentFilter contentFilter = (ContentFilter)object;
        return this.filterMask == contentFilter.filterMask;
    }

    public int hashCode() {
        return this.filterMask;
    }
}

