/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.filter.Filter;

final class ContentList
extends AbstractList
implements Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: ContentList.java,v $ $Revision: 1.42 $ $Date: 2007/11/10 05:28:58 $ $Name: jdom_1_1_1 $";
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_ARRAY_SIZE = 5;
    private Content[] elementData;
    private int size;
    private Parent parent;

    ContentList(Parent parent) {
        this.parent = parent;
    }

    final void uncheckedAddContent(Content content) {
        content.parent = this.parent;
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = content;
        ++this.modCount;
    }

    @Override
    public void add(int n, Object object) {
        if (object == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (object instanceof String) {
            object = new Text(object.toString());
        }
        if (!(object instanceof Content)) {
            throw new IllegalAddException("Class " + object.getClass().getName() + " is of unrecognized type and cannot be added");
        }
        this.add(n, (Content)object);
    }

    private void documentCanContain(int n, Content content) throws IllegalAddException {
        if (content instanceof Element) {
            if (this.indexOfFirstElement() >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.indexOfDocType() > n) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (content instanceof DocType) {
            if (this.indexOfDocType() >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int n2 = this.indexOfFirstElement();
            if (n2 != -1 && n2 < n) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (content instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (content instanceof Text) {
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (content instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }

    private static void elementCanContain(int n, Content content) throws IllegalAddException {
        if (content instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }

    @Override
    void add(int n, Content content) {
        if (content == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.parent instanceof Document) {
            this.documentCanContain(n, content);
        } else {
            ContentList.elementCanContain(n, content);
        }
        if (content.getParent() != null) {
            Parent parent = content.getParent();
            if (parent instanceof Document) {
                throw new IllegalAddException((Element)content, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)parent).getQualifiedName() + "\"");
        }
        if (content == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && content instanceof Element && ((Element)content).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        content.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (n == this.size) {
            this.elementData[this.size++] = content;
        } else {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
            this.elementData[n] = content;
            ++this.size;
        }
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + collection.size());
        int n2 = 0;
        try {
            for (Object e : collection) {
                this.add(n + n2, e);
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            for (int i = 0; i < n2; ++i) {
                this.remove(n);
            }
            throw runtimeException;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Content content = this.elementData[i];
                ContentList.removeParent(content);
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    void clearAndSet(Collection collection) {
        Content[] contentArray = this.elementData;
        int n = this.size;
        this.elementData = null;
        this.size = 0;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.elementData = contentArray;
                this.size = n;
                throw runtimeException;
            }
        }
        if (contentArray != null) {
            for (int i = 0; i < n; ++i) {
                ContentList.removeParent(contentArray[i]);
            }
        }
        ++this.modCount;
    }

    void ensureCapacity(int n) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(n, 5)];
        } else {
            int n2 = this.elementData.length;
            if (n > n2) {
                Content[] contentArray = this.elementData;
                int n3 = n2 * 3 / 2 + 1;
                if (n3 < n) {
                    n3 = n;
                }
                this.elementData = new Content[n3];
                System.arraycopy(contentArray, 0, this.elementData, 0, this.size);
            }
        }
    }

    @Override
    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        return this.elementData[n];
    }

    List getView(Filter filter) {
        return new FilterList(filter);
    }

    int indexOfFirstElement() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof Element)) continue;
                return i;
            }
        }
        return -1;
    }

    int indexOfDocType() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof DocType)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Content content = this.elementData[n];
        ContentList.removeParent(content);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return content;
    }

    private static void removeParent(Content content) {
        content.setParent(null);
    }

    @Override
    public Object set(int n, Object object) {
        int n2;
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (object instanceof Element && this.parent instanceof Document && (n2 = this.indexOfFirstElement()) >= 0 && n2 != n) {
            throw new IllegalAddException("Cannot add a second root element, only one is allowed");
        }
        if (object instanceof DocType && this.parent instanceof Document && (n2 = this.indexOfDocType()) >= 0 && n2 != n) {
            throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
        }
        Object object2 = this.remove(n);
        try {
            this.add(n, object);
        }
        catch (RuntimeException runtimeException) {
            this.add(n, object2);
            throw runtimeException;
        }
        return object2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private int getModCount() {
        return this.modCount;
    }

    class FilterListIterator
    implements ListIterator {
        Filter filter;
        private boolean forward = false;
        private boolean canremove = false;
        private boolean canset = false;
        private int cursor = -1;
        private int tmpcursor = -1;
        private int index = -1;
        private int expected = -1;
        private int fsize = 0;

        FilterListIterator(Filter filter, int n) {
            this.filter = filter;
            this.expected = ContentList.this.getModCount();
            this.forward = false;
            if (n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n);
            }
            this.fsize = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                if (!filter.matches(ContentList.this.get(i))) continue;
                if (n == this.fsize) {
                    this.cursor = i;
                    this.index = this.fsize;
                }
                ++this.fsize;
            }
            if (n > this.fsize) {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.fsize);
            }
            if (this.cursor == -1) {
                this.cursor = ContentList.this.size();
                this.index = this.fsize;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.fsize;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() is beyond the end of the Iterator");
            }
            this.index = this.nextIndex();
            this.cursor = this.tmpcursor;
            this.forward = true;
            this.canremove = true;
            this.canset = true;
            return ContentList.this.get(this.cursor);
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("previous() is before the start of the Iterator");
            }
            this.index = this.previousIndex();
            this.cursor = this.tmpcursor;
            this.forward = false;
            this.canremove = true;
            this.canset = true;
            return ContentList.this.get(this.cursor);
        }

        @Override
        public int nextIndex() {
            this.checkConcurrentModification();
            if (this.forward) {
                for (int i = this.cursor + 1; i < ContentList.this.size(); ++i) {
                    if (!this.filter.matches(ContentList.this.get(i))) continue;
                    this.tmpcursor = i;
                    return this.index + 1;
                }
                this.tmpcursor = ContentList.this.size();
                return this.index + 1;
            }
            this.tmpcursor = this.cursor;
            return this.index;
        }

        @Override
        public int previousIndex() {
            this.checkConcurrentModification();
            if (!this.forward) {
                for (int i = this.cursor - 1; i >= 0; --i) {
                    if (!this.filter.matches(ContentList.this.get(i))) continue;
                    this.tmpcursor = i;
                    return this.index - 1;
                }
                this.tmpcursor = -1;
                return this.index - 1;
            }
            this.tmpcursor = this.cursor;
            return this.index;
        }

        public void add(Object object) {
            this.nextIndex();
            ContentList.this.add(this.tmpcursor, object);
            this.forward = true;
            this.expected = ContentList.this.getModCount();
            this.canset = false;
            this.canremove = false;
            this.index = this.nextIndex();
            this.cursor = this.tmpcursor;
            ++this.fsize;
        }

        @Override
        public void remove() {
            if (!this.canremove) {
                throw new IllegalStateException("Can not remove an element unless either next() or previous() has been called since the last remove()");
            }
            this.nextIndex();
            ContentList.this.remove(this.cursor);
            this.cursor = this.tmpcursor - 1;
            this.expected = ContentList.this.getModCount();
            this.forward = false;
            this.canremove = false;
            this.canset = false;
            --this.fsize;
        }

        public void set(Object object) {
            if (!this.canset) {
                throw new IllegalStateException("Can not set an element unless either next() or previous() has been called since the last remove() or set()");
            }
            this.checkConcurrentModification();
            if (!this.filter.matches(object)) {
                throw new IllegalAddException("Filter won't allow index " + this.index + " to be set to " + object.getClass().getName());
            }
            ContentList.this.set(this.cursor, object);
            this.expected = ContentList.this.getModCount();
        }

        private void checkConcurrentModification() {
            if (this.expected != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class FilterList
    extends AbstractList
    implements Serializable {
        Filter filter;
        int count = 0;
        int expected = -1;

        FilterList(Filter filter) {
            this.filter = filter;
        }

        @Override
        public void add(int n, Object object) {
            if (this.filter.matches(object)) {
                int n2 = this.getAdjustedIndex(n);
                ContentList.this.add(n2, object);
                ++this.expected;
                ++this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' to be added to the list");
            }
        }

        @Override
        public Object get(int n) {
            int n2 = this.getAdjustedIndex(n);
            return ContentList.this.get(n2);
        }

        @Override
        public Iterator iterator() {
            return new FilterListIterator(this.filter, 0);
        }

        @Override
        public ListIterator listIterator() {
            return new FilterListIterator(this.filter, 0);
        }

        @Override
        public ListIterator listIterator(int n) {
            return new FilterListIterator(this.filter, n);
        }

        @Override
        public Object remove(int n) {
            int n2 = this.getAdjustedIndex(n);
            Object object = ContentList.this.get(n2);
            if (this.filter.matches(object)) {
                object = ContentList.this.remove(n2);
                ++this.expected;
                --this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' (index " + n + ") to be removed");
            }
            return object;
        }

        @Override
        public Object set(int n, Object object) {
            Object object2 = null;
            if (this.filter.matches(object)) {
                int n2 = this.getAdjustedIndex(n);
                object2 = ContentList.this.get(n2);
                if (!this.filter.matches(object2)) {
                    throw new IllegalAddException("Filter won't allow the " + object2.getClass().getName() + " '" + object2 + "' (index " + n + ") to be removed");
                }
                object2 = ContentList.this.set(n2, object);
                this.expected += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + n + " to be set to " + object.getClass().getName());
            }
            return object2;
        }

        @Override
        public int size() {
            if (this.expected == ContentList.this.getModCount()) {
                return this.count;
            }
            this.count = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                Content content = ContentList.this.elementData[i];
                if (!this.filter.matches(content)) continue;
                ++this.count;
            }
            this.expected = ContentList.this.getModCount();
            return this.count;
        }

        private final int getAdjustedIndex(int n) {
            int n2 = 0;
            for (int i = 0; i < ContentList.this.size; ++i) {
                Content content = ContentList.this.elementData[i];
                if (!this.filter.matches(content)) continue;
                if (n == n2) {
                    return i;
                }
                ++n2;
            }
            if (n == n2) {
                return ContentList.this.size;
            }
            return ContentList.this.size + 1;
        }
    }
}

