/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.jdesktop.layout.LayoutStyle;

class SwingLayoutStyle
extends LayoutStyle {
    private static final Method SWING_GET_LAYOUT_STYLE_METHOD;
    private static final Method SWING_GET_PREFERRED_GAP_METHOD;
    private static final Method SWING_GET_CONTAINER_GAP_METHOD;
    private static final Object RELATED_TYPE;
    private static final Object UNRELATED_TYPE;
    private static final Object INDENT_TYPE;

    SwingLayoutStyle() {
    }

    private static Object layoutStyleTypeToComponentPlacement(int n) {
        if (n == 0) {
            return RELATED_TYPE;
        }
        if (n == 1) {
            return UNRELATED_TYPE;
        }
        assert (n == 3);
        return INDENT_TYPE;
    }

    private static Object getSwingLayoutStyle() {
        try {
            return SWING_GET_LAYOUT_STYLE_METHOD.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getPreferredGap(JComponent jComponent, JComponent jComponent2, int n, int n2, Container container) {
        super.getPreferredGap(jComponent, jComponent2, n, n2, container);
        Object object = SwingLayoutStyle.layoutStyleTypeToComponentPlacement(n);
        Object object2 = SwingLayoutStyle.getSwingLayoutStyle();
        try {
            return (Integer)SWING_GET_PREFERRED_GAP_METHOD.invoke(object2, jComponent, jComponent2, object, new Integer(n2), container);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int getContainerGap(JComponent jComponent, int n, Container container) {
        super.getContainerGap(jComponent, n, container);
        Object object = SwingLayoutStyle.getSwingLayoutStyle();
        try {
            return (Integer)SWING_GET_CONTAINER_GAP_METHOD.invoke(object, jComponent, new Integer(n), container);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return 0;
    }

    static {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            Class<?> clazz = Class.forName("javax.swing.LayoutStyle");
            Class<?> clazz2 = Class.forName("javax.swing.LayoutStyle$ComponentPlacement");
            clazz = Class.forName("javax.swing.LayoutStyle");
            method = clazz.getMethod("getInstance", null);
            method2 = clazz.getMethod("getPreferredGap", JComponent.class, JComponent.class, clazz2, Integer.TYPE, Container.class);
            method3 = clazz.getMethod("getContainerGap", JComponent.class, Integer.TYPE, Container.class);
            object = clazz2.getField("RELATED").get(null);
            object2 = clazz2.getField("UNRELATED").get(null);
            object3 = clazz2.getField("INDENT").get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SWING_GET_LAYOUT_STYLE_METHOD = method;
        SWING_GET_PREFERRED_GAP_METHOD = method2;
        SWING_GET_CONTAINER_GAP_METHOD = method3;
        RELATED_TYPE = object;
        UNRELATED_TYPE = object2;
        INDENT_TYPE = object3;
    }
}

