/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenRSA;
import com.jcraft.jsch.Util;

public class KeyPairRSA
extends KeyPair {
    private byte[] prv_array;
    private byte[] pub_array;
    private byte[] n_array;
    private byte[] p_array;
    private byte[] q_array;
    private byte[] ep_array;
    private byte[] eq_array;
    private byte[] c_array;
    private int key_size = 1024;
    private static final byte[] begin = "-----BEGIN RSA PRIVATE KEY-----".getBytes();
    private static final byte[] end = "-----END RSA PRIVATE KEY-----".getBytes();
    private static final byte[] sshrsa = "ssh-rsa".getBytes();

    public KeyPairRSA(JSch jSch) {
        super(jSch);
    }

    @Override
    void generate(int n) throws JSchException {
        this.key_size = n;
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("keypairgen.rsa"));
            KeyPairGenRSA keyPairGenRSA = (KeyPairGenRSA)clazz.newInstance();
            keyPairGenRSA.init(n);
            this.pub_array = keyPairGenRSA.getE();
            this.prv_array = keyPairGenRSA.getD();
            this.n_array = keyPairGenRSA.getN();
            this.p_array = keyPairGenRSA.getP();
            this.q_array = keyPairGenRSA.getQ();
            this.ep_array = keyPairGenRSA.getEP();
            this.eq_array = keyPairGenRSA.getEQ();
            this.c_array = keyPairGenRSA.getC();
            keyPairGenRSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        int n = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.n_array.length) + this.n_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length + 1 + this.countLength(this.p_array.length) + this.p_array.length + 1 + this.countLength(this.q_array.length) + this.q_array.length + 1 + this.countLength(this.ep_array.length) + this.ep_array.length + 1 + this.countLength(this.eq_array.length) + this.eq_array.length + 1 + this.countLength(this.c_array.length) + this.c_array.length;
        int n2 = 1 + this.countLength(n) + n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = this.writeSEQUENCE(byArray, n3, n);
        n3 = this.writeINTEGER(byArray, n3, new byte[1]);
        n3 = this.writeINTEGER(byArray, n3, this.n_array);
        n3 = this.writeINTEGER(byArray, n3, this.pub_array);
        n3 = this.writeINTEGER(byArray, n3, this.prv_array);
        n3 = this.writeINTEGER(byArray, n3, this.p_array);
        n3 = this.writeINTEGER(byArray, n3, this.q_array);
        n3 = this.writeINTEGER(byArray, n3, this.ep_array);
        n3 = this.writeINTEGER(byArray, n3, this.eq_array);
        n3 = this.writeINTEGER(byArray, n3, this.c_array);
        return byArray;
    }

    @Override
    boolean parse(byte[] byArray) {
        try {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (this.vendor == 1) {
                if (byArray[n2] != 48) {
                    Buffer buffer = new Buffer(byArray);
                    this.pub_array = buffer.getMPIntBits();
                    this.prv_array = buffer.getMPIntBits();
                    this.n_array = buffer.getMPIntBits();
                    byte[] byArray2 = buffer.getMPIntBits();
                    this.p_array = buffer.getMPIntBits();
                    this.q_array = buffer.getMPIntBits();
                    return true;
                }
                return false;
            }
            int n4 = ++n2;
            ++n2;
            n3 = byArray[n4] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            if (byArray[n2] != 2) {
                return false;
            }
            int n5 = ++n2;
            ++n2;
            n3 = byArray[n5] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            n2 += n3;
            int n6 = ++n2;
            ++n2;
            n3 = byArray[n6] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.n_array = new byte[n3];
            System.arraycopy(byArray, n2, this.n_array, 0, n3);
            n2 += n3;
            int n7 = ++n2;
            ++n2;
            n3 = byArray[n7] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.pub_array = new byte[n3];
            System.arraycopy(byArray, n2, this.pub_array, 0, n3);
            n2 += n3;
            int n8 = ++n2;
            ++n2;
            n3 = byArray[n8] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.prv_array = new byte[n3];
            System.arraycopy(byArray, n2, this.prv_array, 0, n3);
            n2 += n3;
            int n9 = ++n2;
            ++n2;
            n3 = byArray[n9] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.p_array = new byte[n3];
            System.arraycopy(byArray, n2, this.p_array, 0, n3);
            n2 += n3;
            int n10 = ++n2;
            ++n2;
            n3 = byArray[n10] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.q_array = new byte[n3];
            System.arraycopy(byArray, n2, this.q_array, 0, n3);
            n2 += n3;
            int n11 = ++n2;
            ++n2;
            n3 = byArray[n11] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.ep_array = new byte[n3];
            System.arraycopy(byArray, n2, this.ep_array, 0, n3);
            n2 += n3;
            int n12 = ++n2;
            ++n2;
            n3 = byArray[n12] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.eq_array = new byte[n3];
            System.arraycopy(byArray, n2, this.eq_array, 0, n3);
            n2 += n3;
            int n13 = ++n2;
            ++n2;
            n3 = byArray[n13] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.c_array = new byte[n3];
            System.arraycopy(byArray, n2, this.c_array, 0, n3);
            n2 += n3;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.pub_array == null) {
            return null;
        }
        Buffer buffer = new Buffer(sshrsa.length + 4 + this.pub_array.length + 4 + this.n_array.length + 4);
        buffer.putString(sshrsa);
        buffer.putString(this.pub_array);
        buffer.putString(this.n_array);
        return buffer.buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return sshrsa;
    }

    @Override
    public int getKeyType() {
        return 2;
    }

    @Override
    public int getKeySize() {
        return this.key_size;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

