/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenDSA;
import com.jcraft.jsch.Util;

public class KeyPairDSA
extends KeyPair {
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private int key_size = 1024;
    private static final byte[] begin = "-----BEGIN DSA PRIVATE KEY-----".getBytes();
    private static final byte[] end = "-----END DSA PRIVATE KEY-----".getBytes();
    private static final byte[] sshdss = "ssh-dss".getBytes();

    public KeyPairDSA(JSch jSch) {
        super(jSch);
    }

    @Override
    void generate(int n) throws JSchException {
        this.key_size = n;
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("keypairgen.dsa"));
            KeyPairGenDSA keyPairGenDSA = (KeyPairGenDSA)clazz.newInstance();
            keyPairGenDSA.init(n);
            this.P_array = keyPairGenDSA.getP();
            this.Q_array = keyPairGenDSA.getQ();
            this.G_array = keyPairGenDSA.getG();
            this.pub_array = keyPairGenDSA.getY();
            this.prv_array = keyPairGenDSA.getX();
            keyPairGenDSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        int n = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.P_array.length) + this.P_array.length + 1 + this.countLength(this.Q_array.length) + this.Q_array.length + 1 + this.countLength(this.G_array.length) + this.G_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length;
        int n2 = 1 + this.countLength(n) + n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = this.writeSEQUENCE(byArray, n3, n);
        n3 = this.writeINTEGER(byArray, n3, new byte[1]);
        n3 = this.writeINTEGER(byArray, n3, this.P_array);
        n3 = this.writeINTEGER(byArray, n3, this.Q_array);
        n3 = this.writeINTEGER(byArray, n3, this.G_array);
        n3 = this.writeINTEGER(byArray, n3, this.pub_array);
        n3 = this.writeINTEGER(byArray, n3, this.prv_array);
        return byArray;
    }

    @Override
    boolean parse(byte[] byArray) {
        try {
            int n;
            if (this.vendor == 1) {
                if (byArray[0] != 48) {
                    Buffer buffer = new Buffer(byArray);
                    buffer.getInt();
                    this.P_array = buffer.getMPIntBits();
                    this.G_array = buffer.getMPIntBits();
                    this.Q_array = buffer.getMPIntBits();
                    this.pub_array = buffer.getMPIntBits();
                    this.prv_array = buffer.getMPIntBits();
                    return true;
                }
                return false;
            }
            int n2 = 0;
            int n3 = 0;
            if (byArray[n2] != 48) {
                return false;
            }
            int n4 = ++n2;
            ++n2;
            n3 = byArray[n4] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            if (byArray[n2] != 2) {
                return false;
            }
            int n5 = ++n2;
            ++n2;
            n3 = byArray[n5] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            n2 += n3;
            int n6 = ++n2;
            ++n2;
            n3 = byArray[n6] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.P_array = new byte[n3];
            System.arraycopy(byArray, n2, this.P_array, 0, n3);
            n2 += n3;
            int n7 = ++n2;
            ++n2;
            n3 = byArray[n7] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.Q_array = new byte[n3];
            System.arraycopy(byArray, n2, this.Q_array, 0, n3);
            n2 += n3;
            int n8 = ++n2;
            ++n2;
            n3 = byArray[n8] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.G_array = new byte[n3];
            System.arraycopy(byArray, n2, this.G_array, 0, n3);
            n2 += n3;
            int n9 = ++n2;
            ++n2;
            n3 = byArray[n9] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.pub_array = new byte[n3];
            System.arraycopy(byArray, n2, this.pub_array, 0, n3);
            n2 += n3;
            int n10 = ++n2;
            ++n2;
            n3 = byArray[n10] & 0xFF;
            if ((n3 & 0x80) != 0) {
                n = n3 & 0x7F;
                n3 = 0;
                while (n-- > 0) {
                    n3 = (n3 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.prv_array = new byte[n3];
            System.arraycopy(byArray, n2, this.prv_array, 0, n3);
            n2 += n3;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.P_array == null) {
            return null;
        }
        Buffer buffer = new Buffer(sshdss.length + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buffer.putString(sshdss);
        buffer.putString(this.P_array);
        buffer.putString(this.Q_array);
        buffer.putString(this.G_array);
        buffer.putString(this.pub_array);
        return buffer.buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return sshdss;
    }

    @Override
    public int getKeyType() {
        return 1;
    }

    @Override
    public int getKeySize() {
        return this.key_size;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

