/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.util.Vector;

class ChannelAgentForwarding
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    private final int SSH2_AGENTC_REQUEST_IDENTITIES = 11;
    private final int SSH2_AGENT_IDENTITIES_ANSWER = 12;
    private final int SSH2_AGENTC_SIGN_REQUEST = 13;
    private final int SSH2_AGENT_SIGN_RESPONSE = 14;
    private final int SSH2_AGENTC_ADD_IDENTITY = 17;
    private final int SSH2_AGENTC_REMOVE_IDENTITY = 18;
    private final int SSH2_AGENTC_REMOVE_ALL_IDENTITIES = 19;
    private final int SSH2_AGENT_FAILURE = 30;
    boolean init = true;
    private Buffer rbuf = null;
    private Buffer wbuf = null;
    private Packet packet = null;
    private Buffer mbuf = null;

    ChannelAgentForwarding() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.type = "auth-agent@openssh.com".getBytes();
        this.rbuf = new Buffer();
        this.rbuf.reset();
        this.mbuf = new Buffer();
        this.connected = true;
    }

    @Override
    public void run() {
        try {
            this.sendOpenConfirmation();
        }
        catch (Exception exception) {
            this.close = true;
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.packet == null) {
            this.wbuf = new Buffer(this.rmpsize);
            this.packet = new Packet(this.wbuf);
        }
        this.rbuf.shift();
        if (this.rbuf.buffer.length < this.rbuf.index + n2) {
            byte[] byArray2 = new byte[this.rbuf.s + n2];
            System.arraycopy(this.rbuf.buffer, 0, byArray2, 0, this.rbuf.buffer.length);
            this.rbuf.buffer = byArray2;
        }
        this.rbuf.putByte(byArray, n, n2);
        int n3 = this.rbuf.getInt();
        if (n3 > this.rbuf.getLength()) {
            this.rbuf.s -= 4;
            return;
        }
        int n4 = this.rbuf.getByte();
        Session session = null;
        try {
            session = this.getSession();
        }
        catch (JSchException jSchException) {
            throw new IOException(jSchException.toString());
        }
        Vector vector = session.jsch.identities;
        UserInfo userInfo = session.getUserInfo();
        if (n4 == 11) {
            this.mbuf.reset();
            this.mbuf.putByte((byte)12);
            Object object = vector;
            synchronized (object) {
                Identity identity;
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < vector.size(); ++n5) {
                    identity = (Identity)vector.elementAt(n5);
                    if (identity.getPublicKeyBlob() == null) continue;
                    ++n6;
                }
                this.mbuf.putInt(n6);
                for (n5 = 0; n5 < vector.size(); ++n5) {
                    identity = (Identity)vector.elementAt(n5);
                    byte[] byArray3 = identity.getPublicKeyBlob();
                    if (byArray3 == null) continue;
                    this.mbuf.putString(byArray3);
                    this.mbuf.putString("".getBytes());
                }
            }
            object = new byte[this.mbuf.getLength()];
            this.mbuf.getByte((byte[])object);
            this.send((byte[])object);
        } else if (n4 == 13) {
            byte[] byArray4 = this.rbuf.getString();
            byte[] byArray5 = this.rbuf.getString();
            int n7 = this.rbuf.getInt();
            Identity identity = null;
            Object object = vector;
            synchronized (object) {
                for (int i = 0; i < vector.size(); ++i) {
                    Identity identity2 = (Identity)vector.elementAt(i);
                    if (identity2.getPublicKeyBlob() == null || !Util.array_equals(byArray4, identity2.getPublicKeyBlob())) continue;
                    if (identity2.isEncrypted()) {
                        String string;
                        if (userInfo == null) continue;
                        while (identity2.isEncrypted() && userInfo.promptPassphrase("Passphrase for " + identity2.getName()) && (string = userInfo.getPassphrase()) != null) {
                            byte[] byArray6 = Util.str2byte(string);
                            try {
                                if (!identity2.setPassphrase(byArray6)) continue;
                            }
                            catch (JSchException jSchException) {}
                            break;
                        }
                    }
                    if (identity2.isEncrypted()) continue;
                    identity = identity2;
                    break;
                }
            }
            object = null;
            if (identity != null) {
                object = identity.getSignature(byArray5);
            }
            this.mbuf.reset();
            if (object == null) {
                this.mbuf.putByte((byte)30);
            } else {
                this.mbuf.putByte((byte)14);
                this.mbuf.putString((byte[])object);
            }
            byte[] byArray7 = new byte[this.mbuf.getLength()];
            this.mbuf.getByte(byArray7);
            this.send(byArray7);
        }
    }

    private void send(byte[] byArray) {
        this.packet.reset();
        this.wbuf.putByte((byte)94);
        this.wbuf.putInt(this.recipient);
        this.wbuf.putInt(4 + byArray.length);
        this.wbuf.putString(byArray);
        try {
            this.getSession().write(this.packet, this, 4 + byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

