/*
 * Decompiled with CFR 0.152.
 */
package abinitgui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Utils {
    private static DecimalFormat df = new DecimalFormat("#0.00");
    private static final Pattern DOS = Pattern.compile("\\r\\n", 8);
    private static final Pattern UNIX = Pattern.compile("([^\\r])(\\n)", 8);

    public static boolean mkdir(String string) {
        File file = new File(string);
        return file.mkdir();
    }

    public static boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static String osArch() {
        return System.getProperty("os.arch");
    }

    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String javaVersion() {
        return System.getProperty("java.version");
    }

    public static String inByteFormat(double d) {
        double d2 = d / 1024.0;
        if (d2 < 1.0) {
            return df.format(d2 * 1024.0) + " B";
        }
        if ((d2 /= 1024.0) < 1.0) {
            return df.format(d2 * 1024.0) + " kB";
        }
        if ((d2 /= 1024.0) < 1.0) {
            return df.format(d2 * 1024.0) + " MB";
        }
        if ((d2 /= 1024.0) < 1.0) {
            return df.format(d2 * 1024.0) + " GB";
        }
        return df.format(d2) + " TB";
    }

    public static String formatDouble(double d) {
        return df.format(d);
    }

    public static String formatTime(double d) {
        return df.format(d) + " s";
    }

    public static String getLastToken(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        String string4 = null;
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (n2 == n - 1) {
                string3 = string4;
            }
            ++n2;
        }
        return string3;
    }

    public static String dos2unix(String string) {
        return DOS.matcher(string).replaceAll("\n");
    }

    public static String unix2dos(String string) {
        return UNIX.matcher(string).replaceAll("$1\r\n");
    }

    public static void dos2unix(File file) {
        try {
            Scanner scanner = new Scanner(file).useDelimiter("\\Z");
            String string = scanner.next();
            scanner.close();
            String string2 = DOS.matcher(string).replaceAll("\n");
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void unix2dos(File file) {
        try {
            Scanner scanner = new Scanner(file).useDelimiter("\\Z");
            String string = scanner.next();
            scanner.close();
            String string2 = UNIX.matcher(string).replaceAll("$1\r\n");
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }
}

