/*
 * Decompiled with CFR 0.152.
 */
package abinitgui;

import abinitgui.DisplayerJDialog;
import abinitgui.MyLogger;
import abinitgui.MyUserInfo;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JTextArea;

public class SSH {
    private InputStream in;
    private OutputStream out;
    public Channel channel;
    public Session session;
    private String userAndHost = null;
    private String password = null;
    private JTextArea outputTA;
    private OutputHandler sshOH;
    private Vector cmds = new Vector();
    private String retMSG = "";
    private SSHExecOutput sshEO;
    boolean console = false;
    private int sshPort = 22;
    private static boolean DEBUG = false;
    private DisplayerJDialog dialog;
    private boolean graphical = false;

    public void setDialog(DisplayerJDialog displayerJDialog) {
        this.graphical = true;
        this.dialog = displayerJDialog;
    }

    void printOUT(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendOUT(string);
            } else {
                this.dialog.appendOUT(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.out.print(string);
        } else {
            System.out.println(string);
        }
    }

    void printERR(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendERR(string);
            } else {
                this.dialog.appendERR(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.err.print(string);
        } else {
            System.err.println(string);
        }
    }

    void printDEB(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendDEB(string);
            } else {
                this.dialog.appendDEB(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.out.print(string);
        } else {
            System.out.println(string);
        }
    }

    public SSH(JTextArea jTextArea) {
        this(jTextArea, false);
    }

    public SSH(JTextArea jTextArea, boolean bl) {
        this.outputTA = jTextArea;
        this.console = bl;
    }

    public void setUserAndHost(String string) {
        this.userAndHost = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.sshPort = n;
    }

    public void sendCommand(String string) {
        if (this.console) {
            try {
                string = string + '\n';
                this.out.write(string.getBytes(), 0, string.length());
                this.out.flush();
            }
            catch (Exception exception) {
                this.printERR(exception.getMessage());
            }
        } else {
            if (string.startsWith("ls")) {
                string = string + " --color=never";
            }
            if (string.startsWith("exec") || string.startsWith("EXEC")) {
                this.outputTA.append("Command [" + string + "] not supported by ABINIT GUI !\n");
                return;
            }
            if (string.equals("vi") || string.equals("VI")) {
                this.outputTA.append("Command [" + string + "] not supported by ABINIT GUI !\n");
                return;
            }
            if (string.equals("vim") || string.equals("VIM")) {
                this.outputTA.append("Command [" + string + "] not supported by ABINIT GUI !\n");
                return;
            }
            if (!this.cmds.add(string)) {
                this.printERR("Could not register the command: " + string);
            }
        }
    }

    public boolean start() {
        try {
            if (DEBUG) {
                JSch.setLogger(new MyLogger());
            }
            JSch jSch = new JSch();
            String string = this.userAndHost.substring(0, this.userAndHost.indexOf(64));
            String string2 = this.userAndHost.substring(this.userAndHost.indexOf(64) + 1);
            this.session = jSch.getSession(string, string2, this.sshPort);
            MyUserInfo myUserInfo = new MyUserInfo();
            myUserInfo.setPassword(this.password);
            this.session.setUserInfo(myUserInfo);
            this.session.connect();
            this.channel = this.session.openChannel("shell");
            this.out = this.channel.getOutputStream();
            this.in = this.channel.getInputStream();
            if (this.console) {
                this.sshEO = new SSHExecOutput(this.in);
            } else {
                this.sshOH = new OutputHandler();
                this.sshOH.start();
            }
            this.channel.connect();
            return this.session.isConnected() && this.channel.isConnected();
        }
        catch (JSchException jSchException) {
            String string = jSchException.getMessage();
            if (jSchException.getCause() != null) {
                String string3 = string.substring(0, string.indexOf(58));
                String string4 = jSchException.getCause().getMessage();
                if (string3.equals("java.net.UnknownHostException")) {
                    this.printERR("Unknown hostname: " + string4);
                } else {
                    this.printERR("Exception: " + string3);
                }
            } else if (string.equals("Auth fail")) {
                this.printERR("Username or password is wrong !!");
            } else {
                this.printERR("JSchException => MSG: " + string);
            }
            return false;
        }
        catch (Exception exception) {
            this.printERR(exception.getMessage());
            return false;
        }
    }

    public void stop() {
        if (this.console) {
            if (this.channel != null && this.session != null) {
                this.sendCommand("exit");
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
            if (this.sshEO != null) {
                this.sshEO.stop();
            }
        } else {
            new ClosureWatcher().start();
        }
    }

    public boolean isConnected() {
        if (this.channel.isConnected()) {
            return this.session.isConnected();
        }
        return false;
    }

    public class SSHExecOutput
    extends Thread {
        private InputStream input;

        public SSHExecOutput(InputStream inputStream) {
            this.input = inputStream;
            this.start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                while ((n = this.input.read(byArray, 0, 1024)) > 0) {
                    byte[] byArray2 = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        byArray2[i] = byArray[i];
                    }
                    String string = new String(byArray2);
                    SSH.this.outputTA.append(string.replace("\u001b[0;0m", "").replace("\u001b[1;39m", "").replace("\u001b[00m", "").replace("\u001b[01;31m", "").replace("\u001b[01;32m", "").replace("\u001b[01;33m", "").replace("\u001b[01;34m", "").replace("\u001b[m", "").replace("\u001b[0m", "").replace("\u001b[K", ""));
                    SSH.this.outputTA.setCaretPosition(SSH.this.outputTA.getDocument().getLength());
                }
            }
            catch (Exception exception) {
                SSH.this.printERR(exception.getMessage());
            }
        }
    }

    public class ClosureWatcher
    extends Thread {
        @Override
        public void run() {
            SSH.this.sendCommand("exit");
            try {
                SSH.this.sshOH.join();
            }
            catch (Exception exception) {
                SSH.this.printERR("SSH stop(): " + exception);
            }
            if (SSH.this.channel != null) {
                SSH.this.channel.disconnect();
            }
            if (SSH.this.session != null) {
                SSH.this.session.disconnect();
            }
            if (SSH.this.sshOH != null) {
                SSH.this.sshOH.stop();
            }
        }
    }

    public class OutputHandler
    extends Thread {
        @Override
        public void run() {
            String string = null;
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                block2: while (true) {
                    string = "";
                    do {
                        int n2;
                        if ((n2 = SSH.this.in.read()) != -1) {
                            if (n2 == 0) {
                                SSH.this.outputTA.append("[" + n2 + "] SUCCES\n");
                            } else if (n2 == 1) {
                                SSH.this.outputTA.append("[" + n2 + "] ERROR\n");
                            } else if (n2 == 2) {
                                SSH.this.outputTA.append("[" + n2 + "] FATAL ERROR\n");
                            }
                        }
                        if ((n = SSH.this.in.read(byArray, 0, 1024)) <= 0) continue block2;
                        byte[] byArray2 = new byte[n];
                        for (int i = 0; i < n; ++i) {
                            byArray2[i] = byArray[i];
                        }
                        string = (char)n2 + new String(byArray2);
                        SSH.this.outputTA.append(string);
                        SSH.this.outputTA.setCaretPosition(SSH.this.outputTA.getDocument().getLength());
                        if (string.contains("@") && (string.endsWith("> ") || string.endsWith(">") || string.endsWith("# ") || string.endsWith("#") || string.endsWith("$ ") || string.endsWith("$"))) {
                            String string2 = this.execNextCMD();
                            if (!string2.startsWith("exit") && !string2.startsWith("EXIT")) continue;
                            throw new Exception("OutputHandler thread is shuting down !!");
                        }
                        if (string.contains("Password:") || string.contains("password:")) {
                            SSH.this.printOUT("msg.contains(\"Password:\") || msg.contains(\"password:\")");
                            this.execNextCMD();
                            continue;
                        }
                        if (!string.endsWith("ETA")) continue block2;
                        SSH.this.outputTA.append("\n");
                        SSH.this.outputTA.setCaretPosition(SSH.this.outputTA.getDocument().getLength());
                    } while (SSH.this.in.available() > 0);
                }
            }
            catch (Exception exception) {
                SSH.this.printERR(exception.getMessage());
                return;
            }
        }

        private String execNextCMD() {
            String string = null;
            while (true) {
                if (!SSH.this.cmds.isEmpty()) break;
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            string = (String)SSH.this.cmds.firstElement();
            SSH.this.cmds.remove(string);
            try {
                string = string + '\n';
                SSH.this.out.write(string.getBytes(), 0, string.length());
                SSH.this.out.flush();
            }
            catch (Exception exception) {
                SSH.this.printERR(exception.getMessage());
            }
            return string;
        }
    }
}

