/*
 * Decompiled with CFR 0.152.
 */
package abinitgui;

import abinitgui.DisplayerJDialog;
import abinitgui.MyLogger;
import abinitgui.MyUserInfo;
import abinitgui.Utils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public class SFTP {
    private JProgressBar pb;
    private JLabel lab_file;
    private JLabel lab_rate;
    private JTextArea outputTA;
    private String userAndHost = null;
    private String password = null;
    private ChannelSftp c;
    private Session session;
    private boolean isGraphic;
    private int sftpPort = 22;
    private static boolean DEBUG = false;
    private DisplayerJDialog dialog;
    private boolean graphical = false;
    private static String help = "      Available commands:\n      * means unimplemented command.\ncd path                       Change remote directory to 'path'\nlcd path                      Change local directory to 'path'\nchgrp grp path                Change group of file 'path' to 'grp'\nchmod mode path               Change permissions of file 'path' to 'mode'\nchown own path                Change owner of file 'path' to 'own'\nhelp                          Display this help text\nget remote-path [local-path]  Download file\nget-resume remote-path [local-path]  Resume to download file.\nget-append remote-path [local-path]  Append remote file to local file\nlls [ls-options [path]]       Display local directory listing\nln oldpath newpath            Symlink remote file\n*lmkdir path                  Create local directory\nlpwd                          Print local working directory\nls [path]                     Display remote directory listing\n*lumask umask                 Set local umask to 'umask'\nmkdir path                    Create remote directory\nput local-path [remote-path]  Upload file\nput-resume local-path [remote-path]  Resume to upload file\nput-append local-path [remote-path]  Append local file to remote file.\npwd                           Display remote working directory\nstat path                     Display info about path\nexit                          Quit sftp\nquit                          Quit sftp\nrename oldpath newpath        Rename remote file\nrmdir path                    Remove remote directory\nrm path                       Delete remote file\nsymlink oldpath newpath       Symlink remote file\nreadlink path                 Check the target of a symbolic link\nrealpath path                 Canonicalize the path\nrekey                         Key re-exchanging\ncompression level             Packet compression will be enabled\nversion                       Show SFTP version\n?                             Synonym for help";

    public void setDialog(DisplayerJDialog displayerJDialog) {
        this.graphical = true;
        this.dialog = displayerJDialog;
    }

    void printOUT(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendOUT(string);
            } else {
                this.dialog.appendOUT(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.out.print(string);
        } else {
            System.out.println(string);
        }
    }

    void printERR(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendERR(string);
            } else {
                this.dialog.appendERR(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.err.print(string);
        } else {
            System.err.println(string);
        }
    }

    void printDEB(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendDEB(string);
            } else {
                this.dialog.appendDEB(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.out.print(string);
        } else {
            System.out.println(string);
        }
    }

    void printOUT2(String string) {
        if (this.graphical) {
            this.dialog.appendOUT(string);
        } else {
            System.out.print(string);
        }
    }

    public SFTP(JProgressBar jProgressBar, JLabel jLabel, JLabel jLabel2, JTextArea jTextArea) {
        this.pb = jProgressBar;
        this.lab_file = jLabel;
        this.lab_rate = jLabel2;
        this.outputTA = jTextArea;
        this.isGraphic = true;
    }

    public void setUserAndHost(String string) {
        this.userAndHost = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isConnected() {
        if (this.c.isConnected()) {
            return this.session.isConnected();
        }
        return false;
    }

    public void sendCommand(String string) {
        if (!string.equals("")) {
            this.printText(string + '\n');
        }
        Vector<String> vector = new Vector<String>();
        vector.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = 0;
        if (vector.size() == 0) {
            return;
        }
        String string2 = (String)vector.elementAt(0);
        if (string2.equals("quit")) {
            this.c.quit();
            return;
        }
        if (string2.equals("exit")) {
            this.c.exit();
            return;
        }
        if (string2.equals("rekey")) {
            try {
                this.session.rekey();
            }
            catch (Exception exception) {
                this.printERR(exception.getMessage());
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("compression")) {
            if (vector.size() < 2) {
                this.printText("compression level: " + n + '\n');
                this.printPrompt();
                return;
            }
            try {
                n = Integer.parseInt((String)vector.elementAt(1));
                if (n == 0) {
                    this.session.setConfig("compression.s2c", "none");
                    this.session.setConfig("compression.c2s", "none");
                } else {
                    this.session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                    this.session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                }
                this.session.rekey();
            }
            catch (Exception exception) {
                this.printERR(exception.getMessage());
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("cd") || string2.equals("lcd")) {
            if (vector.size() < 2) {
                this.printPrompt();
                return;
            }
            String string3 = (String)vector.elementAt(1);
            if (string2.equals("cd")) {
                try {
                    this.c.cd(string3);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else {
                try {
                    this.c.lcd(string3);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("rm") || string2.equals("rmdir") || string2.equals("mkdir")) {
            if (vector.size() < 2) {
                this.printPrompt();
                return;
            }
            String string4 = (String)vector.elementAt(1);
            if (string2.equals("rm")) {
                try {
                    this.c.rm(string4);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else if (string2.equals("rmdir")) {
                try {
                    this.c.rmdir(string4);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else {
                try {
                    this.c.mkdir(string4);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("chgrp") || string2.equals("chown") || string2.equals("chmod")) {
            if (vector.size() != 3) {
                this.printPrompt();
                return;
            }
            String string5 = (String)vector.elementAt(2);
            int n2 = 0;
            if (string2.equals("chmod")) {
                byte[] byArray = ((String)vector.elementAt(1)).getBytes();
                for (int i = 0; i < byArray.length; ++i) {
                    byte by = byArray[i];
                    if (by < 48 || by > 55) {
                        n2 = -1;
                        break;
                    }
                    n2 <<= 3;
                    n2 |= by - 48;
                }
                if (n2 == -1) {
                    this.printPrompt();
                    return;
                }
            } else {
                try {
                    n2 = Integer.parseInt((String)vector.elementAt(1));
                }
                catch (Exception exception) {
                    this.printPrompt();
                    return;
                }
            }
            if (string2.equals("chgrp")) {
                try {
                    this.c.chgrp(n2, string5);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else if (string2.equals("chown")) {
                try {
                    this.c.chown(n2, string5);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else if (string2.equals("chmod")) {
                try {
                    this.c.chmod(n2, string5);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("pwd") || string2.equals("lpwd")) {
            String string6 = string2.equals("pwd") ? "Remote" : "Local";
            string6 = string6 + " working directory: ";
            if (string2.equals("pwd")) {
                try {
                    string6 = string6 + this.c.pwd();
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else {
                try {
                    string6 = string6 + this.c.lpwd();
                }
                catch (Exception exception) {
                    this.printERR(exception.getMessage());
                }
            }
            this.printText(string6 + '\n');
            this.printPrompt();
            return;
        }
        if (string2.equals("ls") || string2.equals("dir")) {
            String string7 = ".";
            if (vector.size() == 2) {
                string7 = (String)vector.elementAt(1);
            }
            try {
                Vector vector2 = this.c.ls(string7);
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        Object e = vector2.elementAt(i);
                        if (!(e instanceof ChannelSftp.LsEntry)) continue;
                        this.printText(((ChannelSftp.LsEntry)e).getLongname() + '\n');
                    }
                }
            }
            catch (SftpException sftpException) {
                this.printERR(sftpException.getMessage());
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("lls") || string2.equals("ldir")) {
            String string8 = ".";
            if (vector.size() == 2) {
                string8 = (String)vector.elementAt(1);
            }
            try {
                File file = new File(string8);
                if (!file.exists()) {
                    this.printText(string8 + ": No such file or directory" + '\n');
                    this.printPrompt();
                    return;
                }
                if (file.isDirectory()) {
                    String[] stringArray = file.list();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.printText(stringArray[i] + '\n');
                    }
                    this.printPrompt();
                    return;
                }
                this.printText(string8 + '\n');
            }
            catch (Exception exception) {
                this.printERR(exception.getMessage());
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("get") || string2.equals("get-resume") || string2.equals("get-append") || string2.equals("put") || string2.equals("put-resume") || string2.equals("put-append")) {
            if (vector.size() != 2 && vector.size() != 3) {
                this.printERR("Too much parameters for " + (String)vector.elementAt(0) + " command");
                this.printPrompt();
                return;
            }
            String string9 = (String)vector.elementAt(1);
            String string10 = ".";
            if (vector.size() == 3) {
                string10 = (String)vector.elementAt(2);
            }
            MyProgressMonitor myProgressMonitor = new MyProgressMonitor(this.pb, this.lab_file, this.lab_rate);
            if (string2.startsWith("get")) {
                int n3 = 0;
                if (string2.equals("get-resume")) {
                    n3 = 1;
                } else if (string2.equals("get-append")) {
                    n3 = 2;
                }
                Get get = new Get(string9, string10, myProgressMonitor, n3);
                try {
                    get.join();
                }
                catch (InterruptedException interruptedException) {
                    this.printERR(interruptedException.getMessage());
                }
            } else {
                int n4 = 0;
                if (string2.equals("put-resume")) {
                    n4 = 1;
                } else if (string2.equals("put-append")) {
                    n4 = 2;
                }
                Put put = new Put(string9, string10, myProgressMonitor, n4);
                try {
                    put.join();
                }
                catch (InterruptedException interruptedException) {
                    this.printERR(interruptedException.getMessage());
                }
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("ln") || string2.equals("symlink") || string2.equals("rename")) {
            if (vector.size() != 3) {
                this.printPrompt();
                return;
            }
            String string11 = (String)vector.elementAt(1);
            String string12 = (String)vector.elementAt(2);
            if (string2.equals("rename")) {
                try {
                    this.c.rename(string11, string12);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else {
                try {
                    this.c.symlink(string11, string12);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("stat") || string2.equals("lstat")) {
            if (vector.size() != 2) {
                this.printPrompt();
                return;
            }
            String string13 = (String)vector.elementAt(1);
            SftpATTRS sftpATTRS = null;
            if (string2.equals("stat")) {
                try {
                    sftpATTRS = this.c.stat(string13);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            } else {
                try {
                    sftpATTRS = this.c.lstat(string13);
                }
                catch (SftpException sftpException) {
                    this.printERR(sftpException.getMessage());
                }
            }
            if (sftpATTRS != null) {
                this.printText(sftpATTRS.toString() + '\n');
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("readlink")) {
            if (vector.size() != 2) {
                this.printPrompt();
                return;
            }
            String string14 = (String)vector.elementAt(1);
            String string15 = null;
            try {
                string15 = this.c.readlink(string14);
                this.printText(string15 + '\n');
            }
            catch (SftpException sftpException) {
                this.printERR(sftpException.getMessage());
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("realpath")) {
            if (vector.size() != 2) {
                this.printPrompt();
                return;
            }
            String string16 = (String)vector.elementAt(1);
            String string17 = null;
            try {
                string17 = this.c.realpath(string16);
                this.printText(string17 + '\n');
            }
            catch (SftpException sftpException) {
                this.printERR(sftpException.getMessage());
            }
            this.printPrompt();
            return;
        }
        if (string2.equals("version")) {
            this.printText("SFTP protocol version " + this.c.version() + '\n');
            this.printPrompt();
            return;
        }
        if (string2.equals("help") || string2.equals("?")) {
            this.printText(help + '\n');
            this.printPrompt();
            return;
        }
        this.printText("unimplemented command: " + string2 + '\n');
        this.printPrompt();
    }

    private void printPrompt() {
        if (this.isGraphic) {
            this.outputTA.append("sftp> ");
            this.outputTA.setCaretPosition(this.outputTA.getDocument().getLength());
        } else {
            this.printOUT2("sftp> ");
        }
    }

    private void printText(String string) {
        if (this.isGraphic) {
            this.outputTA.append(string);
        } else {
            this.printOUT2(string);
        }
    }

    public ChannelSftp getChannel() {
        return this.c;
    }

    public void setPort(int n) {
        this.sftpPort = n;
    }

    public boolean start() {
        try {
            if (DEBUG) {
                JSch.setLogger(new MyLogger());
            }
            JSch jSch = new JSch();
            String string = this.userAndHost.substring(0, this.userAndHost.indexOf(64));
            String string2 = this.userAndHost.substring(this.userAndHost.indexOf(64) + 1);
            this.session = jSch.getSession(string, string2, this.sftpPort);
            MyUserInfo myUserInfo = new MyUserInfo();
            myUserInfo.setPassword(this.password);
            this.session.setUserInfo(myUserInfo);
            this.session.connect();
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.c = (ChannelSftp)channel;
            this.printText("sftp> ");
            return this.session.isConnected() && this.c.isConnected();
        }
        catch (JSchException jSchException) {
            String string = jSchException.getMessage();
            if (jSchException.getCause() != null) {
                String string3 = string.substring(0, string.indexOf(58));
                String string4 = jSchException.getCause().getMessage();
                if (string3.equals("java.net.UnknownHostException")) {
                    this.printERR("Unknown hostname: " + string4);
                } else {
                    this.printERR("Exception: " + string3);
                }
            } else if (string.equals("Auth fail")) {
                this.printERR("Username or password is wrong !!");
            } else {
                this.printERR("JSchException => MSG: " + string);
            }
            return false;
        }
        catch (Exception exception) {
            this.printERR(exception.getMessage());
            return false;
        }
    }

    public void stop() {
        try {
            if (this.c != null) {
                this.c.exit();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
        catch (Exception exception) {
            this.printERR("SFTP stop (" + exception + ")");
        }
    }

    public class Put
    extends Thread {
        String p1;
        String p2;
        SftpProgressMonitor monitor;
        int mode;

        public Put(String string, String string2, SftpProgressMonitor sftpProgressMonitor, int n) {
            this.p1 = string;
            this.p2 = string2;
            this.monitor = sftpProgressMonitor;
            this.mode = n;
            this.start();
        }

        @Override
        public void run() {
            try {
                SFTP.this.c.put(this.p1, this.p2, this.monitor, this.mode);
            }
            catch (SftpException sftpException) {
                String string = sftpException.getMessage();
                SFTP.this.printERR(sftpException.getMessage());
            }
        }
    }

    public class Get
    extends Thread {
        String p1;
        String p2;
        SftpProgressMonitor monitor;
        int mode;

        public Get(String string, String string2, SftpProgressMonitor sftpProgressMonitor, int n) {
            this.p1 = string;
            this.p2 = string2;
            this.monitor = sftpProgressMonitor;
            this.mode = n;
            this.start();
        }

        @Override
        public void run() {
            try {
                SFTP.this.c.get(this.p1, this.p2, this.monitor, this.mode);
            }
            catch (SftpException sftpException) {
                String string = sftpException.getMessage();
                SFTP.this.printERR(sftpException.getMessage());
            }
        }
    }

    public class MyProgressMonitor
    implements SftpProgressMonitor {
        long count = 0L;
        long max = 0L;
        final long begtime = System.nanoTime();
        long curtime = 0L;
        JProgressBar pb_;
        JLabel lab_file_;
        JLabel lab_rate_;
        private long percent = -1L;

        public MyProgressMonitor(JProgressBar jProgressBar, JLabel jLabel, JLabel jLabel2) {
            this.pb_ = jProgressBar;
            this.lab_file_ = jLabel;
            this.lab_rate_ = jLabel2;
        }

        @Override
        public void init(int n, String string, String string2, long l) {
            this.max = l;
            this.lab_file_.setText((n == 0 ? "PUT" : "GET") + ": " + string + " (" + Utils.inByteFormat(l) + ")");
            this.count = 0L;
            this.percent = -1L;
            this.pb_.setMaximum((int)l);
            this.pb_.setValue((int)this.count);
        }

        @Override
        public boolean count(long l) {
            this.count += l;
            if (this.percent >= this.count * 100L / this.max) {
                return true;
            }
            this.percent = this.count * 100L / this.max;
            this.curtime = System.nanoTime();
            double d = (double)(this.curtime - this.begtime) / 1.0E9;
            double d2 = (double)this.count / d;
            String string = d < 1.0 ? Math.ceil(d * 1000.0) + " ms" : Utils.formatDouble(d) + " s";
            this.lab_rate_.setText("Elapsed time " + string + " | Speed " + Utils.inByteFormat(d2) + "/s (" + this.percent + "%)");
            this.pb_.setValue((int)this.count);
            return true;
        }

        @Override
        public void end() {
            this.lab_rate_.setText("<HTML>" + this.lab_rate_.getText() + " <b>(Transfert completed)<b></HTML>");
        }
    }
}

