/*
 * Decompiled with CFR 0.152.
 */
package abinitgui;

import abinitgui.DisplayerJDialog;
import abinitgui.MyLogger;
import abinitgui.MyUserInfo;
import abinitgui.RetMSG;
import abinitgui.Utils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class RemoteExec {
    private Session session;
    private InputStream in;
    private InputStream err;
    private String ruser;
    private String rhost;
    private int rport;
    private String succesMSG = null;
    private String errorMSG = null;
    MyUserInfo ui;
    private static boolean DEBUG = false;
    private DisplayerJDialog dialog;
    private boolean graphical = false;

    public void setDialog(DisplayerJDialog displayerJDialog) {
        this.graphical = true;
        this.dialog = displayerJDialog;
    }

    void printOUT(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendOUT(string);
            } else {
                this.dialog.appendOUT(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.out.print(string);
        } else {
            System.out.println(string);
        }
    }

    void printERR(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendERR(string);
            } else {
                this.dialog.appendERR(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.err.print(string);
        } else {
            System.err.println(string);
        }
    }

    void printDEB(String string) {
        if (this.graphical) {
            if (string.endsWith("\n")) {
                this.dialog.appendDEB(string);
            } else {
                this.dialog.appendDEB(string + "\n");
            }
        } else if (string.endsWith("\n")) {
            System.out.print(string);
        } else {
            System.out.println(string);
        }
    }

    public RemoteExec(String string, String string2, int n) {
        this.ruser = string;
        this.rhost = string2;
        this.rport = n;
        this.ui = new MyUserInfo();
    }

    public void setPassword(String string) {
        if (this.ui != null) {
            this.ui.setPassword(string);
        } else {
            this.printERR("Error in setPassword (ui = null)");
        }
    }

    public boolean start() {
        try {
            if (DEBUG) {
                JSch.setLogger(new MyLogger());
            }
            JSch jSch = new JSch();
            this.session = jSch.getSession(this.ruser, this.rhost, this.rport);
            this.session.setUserInfo(this.ui);
            this.session.connect();
            return this.session.isConnected();
        }
        catch (JSchException jSchException) {
            this.printERR(jSchException.getMessage());
            return false;
        }
    }

    public void stop() {
        try {
            this.session.disconnect();
        }
        catch (Exception exception) {
            this.printERR(exception.getMessage());
        }
    }

    public synchronized RetMSG sendCommand(String string) {
        Channel channel;
        if (string.equals("")) {
            return new RetMSG(-2, "Empty command !", string);
        }
        Vector<String> vector = new Vector<String>();
        vector.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String string2 = (String)vector.elementAt(0);
        if (string2.equals("put") || string2.equals("PUT")) {
            if (vector.size() == 2) {
                String string3 = (String)vector.elementAt(1);
                String string4 = ".";
                return this.scpL2R(string3, string4);
            }
            if (vector.size() == 3) {
                String string5 = (String)vector.elementAt(1);
                String string6 = (String)vector.elementAt(2);
                return this.scpL2R(string5, string6);
            }
            return new RetMSG(-2, "Bad number of parameters !", string);
        }
        if (string2.equals("get") || string2.equals("GET")) {
            if (vector.size() == 2) {
                String string7 = (String)vector.elementAt(1);
                String string8 = ".";
                return this.scpR2L(string7, string8);
            }
            if (vector.size() == 3) {
                String string9 = (String)vector.elementAt(1);
                String string10 = (String)vector.elementAt(2);
                return this.scpR2L(string9, string10);
            }
            return new RetMSG(-2, "Bad number of parameters !", string);
        }
        try {
            channel = this.session.openChannel("exec");
        }
        catch (JSchException jSchException) {
            return new RetMSG(-1, jSchException.toString(), string);
        }
        ((ChannelExec)channel).setCommand(string);
        channel.setInputStream(null);
        try {
            this.err = ((ChannelExec)channel).getErrStream();
            this.in = channel.getInputStream();
        }
        catch (IOException iOException) {
            return new RetMSG(-1, iOException.toString(), string);
        }
        try {
            channel.connect();
        }
        catch (JSchException jSchException) {
            return new RetMSG(-1, jSchException.toString(), string);
        }
        byte[] byArray = new byte[1024];
        try {
            int n;
            this.succesMSG = "";
            while (true) {
                if ((n = this.in.read(byArray, 0, byArray.length)) > 0) {
                    this.succesMSG = this.succesMSG + new String(byArray, 0, n);
                    continue;
                }
                if (channel.isClosed()) break;
            }
            n = channel.getExitStatus();
            if (n != 0) {
                int n2 = this.err.read(byArray, 0, 1024);
                if (n2 < 0) {
                    return new RetMSG(-2, "Error in reading the input error stream", string);
                }
                return new RetMSG(n, new String(byArray, 0, n2), string);
            }
            return new RetMSG(n, this.succesMSG, string);
        }
        catch (IOException iOException) {
            return new RetMSG(-1, iOException.toString(), string);
        }
    }

    public RetMSG scpL2R(String string, String string2) {
        FileInputStream fileInputStream = null;
        try {
            int n;
            int n2 = 0;
            String string3 = "scp -p -t " + string2;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(string3);
            OutputStream outputStream = channel.getOutputStream();
            this.in = channel.getInputStream();
            channel.connect();
            long l = System.nanoTime();
            n2 = this.checkAck(this.in);
            if (n2 != 0) {
                return new RetMSG(n2, this.errorMSG, "scp " + string + " " + string2);
            }
            long l2 = new File(string).length();
            string3 = "C0644 " + l2 + " ";
            string3 = string.lastIndexOf(47) > 0 ? string3 + string.substring(string.lastIndexOf(47) + 1) : string3 + string;
            string3 = string3 + "\n";
            outputStream.write(string3.getBytes());
            outputStream.flush();
            n2 = this.checkAck(this.in);
            if (n2 != 0) {
                return new RetMSG(n2, this.errorMSG, "scp " + string + " " + string2);
            }
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileInputStream = null;
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            n2 = this.checkAck(this.in);
            if (n2 != 0) {
                return new RetMSG(n2, this.errorMSG, "scp " + string + " " + string2);
            }
            outputStream.close();
            long l3 = System.nanoTime();
            this.printDEB("File " + string + " was uploaded in " + Utils.formatTime((double)(l3 - l) / 1.0E9));
            channel.disconnect();
            return new RetMSG(0, "", "scp " + string + " " + string2);
        }
        catch (Exception exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception2) {
                this.printERR(exception.getMessage());
            }
            return new RetMSG(-1, exception.toString(), "scp " + string + " " + string2);
        }
    }

    public RetMSG scpR2L(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            int n2 = 0;
            String string3 = "scp -f " + string;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(string3);
            String string4 = null;
            if (new File(string2).isDirectory()) {
                string4 = string2 + File.separator;
            }
            OutputStream outputStream = channel.getOutputStream();
            this.in = channel.getInputStream();
            channel.connect();
            long l = System.nanoTime();
            byte[] byArray = new byte[1024];
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            int n3 = 0;
            while ((n = this.checkAck(this.in)) == 67) {
                ++n3;
                this.in.read(byArray, 0, 5);
                long l2 = 0L;
                while (true) {
                    if (this.in.read(byArray, 0, 1) < 0) {
                        return new RetMSG(-2, "Reading filesize", "scp " + string + " " + string2);
                    }
                    if (byArray[0] == 32) break;
                    l2 = l2 * 10L + (long)(byArray[0] - 48);
                }
                String string5 = null;
                int n4 = 0;
                while (true) {
                    this.in.read(byArray, n4, 1);
                    if (byArray[n4] == 10) break;
                    ++n4;
                }
                string5 = new String(byArray, 0, n4);
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                fileOutputStream = new FileOutputStream(string4 == null ? string2 : string4 + string5);
                do {
                    n4 = (long)byArray.length < l2 ? byArray.length : (int)l2;
                    if ((n4 = this.in.read(byArray, 0, n4)) < 0) {
                        return new RetMSG(-2, "Error: reading incomming stream", "scp " + string + " " + string2);
                    }
                    fileOutputStream.write(byArray, 0, n4);
                } while ((l2 -= (long)n4) != 0L);
                fileOutputStream.close();
                fileOutputStream = null;
                n2 = this.checkAck(this.in);
                if (n2 != 0) {
                    return new RetMSG(n2, this.errorMSG, "scp " + string + " " + string2);
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
            }
            if (n3 != 0) {
                long l3 = System.nanoTime();
                this.printDEB("File " + string2 + " was downloaded in " + Utils.formatTime((double)(l3 - l) / 1.0E9));
                channel.disconnect();
                return new RetMSG(0, "", "scp " + string + " " + string2);
            }
            return new RetMSG(-2, "File " + string + " doesn't exist", "scp " + string + " " + string2);
        }
        catch (Exception exception) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception2) {
                this.printERR(exception.getMessage());
            }
            return new RetMSG(-1, exception.toString(), "scp " + string + " " + string2);
        }
    }

    int checkAck(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                n2 = inputStream.read();
                stringBuffer.append((char)n2);
            } while (n2 != 10);
            if (n == 1) {
                this.errorMSG = stringBuffer.toString();
            }
            if (n == 2) {
                this.errorMSG = stringBuffer.toString();
            }
        }
        return n;
    }
}

