/*
 * Decompiled with CFR 0.152.
 */
package abinitgui;

import abinitgui.Atom;
import abinitgui.AtomEditor;
import abinitgui.DisplayerJDialog;
import abinitgui.MainFrame;
import abinitgui.MyTableModel;
import abinitgui.znuclAtomRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class Geometry
extends JPanel {
    private String previous = "xred";
    private MyTableModel xyzModel = null;
    private MyTableModel rprimModel = null;
    private MyTableModel znuclModel = null;
    private MyTableModel symrelModel = null;
    private MyTableModel tnonsModel = null;
    private final double bohr2angst = 0.5291772108;
    private DisplayerJDialog outDialog;
    private JCheckBox acellCheckBox;
    private JTextField acellTextField1;
    private JTextField acellTextField2;
    private JTextField acellTextField3;
    private JLabel acellUnitsLabel;
    private JCheckBox angdegCheckBox;
    private JCheckBox natomCheckBox;
    private JTextField natomTextField;
    private JCheckBox nsymCheckBox;
    private JTextField nsymTextField;
    private JCheckBox ntypatCheckBox;
    private JTextField ntypatTextField;
    private JCheckBox rprimCheckBox;
    private JTable rprimTable;
    private JScrollPane rprimTableScrollPane;
    private JCheckBox rprimdCheckBox;
    private JScrollPane shiftkTableScrollPane1;
    private JScrollPane shiftkTableScrollPane2;
    private JCheckBox symrelCheckBox;
    private JTable symrelTable;
    private JCheckBox tnonsCheckBox;
    private JTable tnonsTable;
    private JCheckBox typatCheckBox;
    private JRadioButton xangstRadioButton;
    private JRadioButton xcartRadioButton;
    private JRadioButton xredRadioButton;
    private JTable xyzTable;
    private JScrollPane xyzTableScrollPane;
    private ButtonGroup xyzbuttonGroup;
    private JCheckBox znuclCheckBox;
    private JTable znuclTable;
    private JScrollPane znuclTableScrollPane;

    public Geometry(DisplayerJDialog displayerJDialog, MainFrame mainFrame) {
        this.outDialog = displayerJDialog;
        this.initComponents();
        this.xyzModel = new MyTableModel(this.xyzTable);
        this.xyzTable.setModel(this.xyzModel);
        this.initTableHeader(this.xyzTable, new String[]{"xred", "yred", "zred"}, new Integer[]{null, null, null});
        this.rprimModel = new MyTableModel(this.rprimTable);
        this.rprimModel.setNotEditableCol("0");
        this.rprimTable.setModel(this.rprimModel);
        this.initTableHeader(this.rprimTable, new String[]{"", "x (red.)", "y (red.)", "z (red.)"}, new Integer[]{18, null, null, null});
        this.rprimTable.setVisible(false);
        this.znuclModel = new MyTableModel(this.znuclTable);
        this.znuclModel.setNotEditableCol("1-2");
        this.znuclTable.setModel(this.znuclModel);
        this.initTableHeader(this.znuclTable, new String[]{"Atom", "znucl", "typat", "#"}, new Integer[]{null, null, null, null});
        this.znuclTable.setDefaultRenderer(Atom.class, new znuclAtomRenderer());
        this.znuclTable.setDefaultEditor(Atom.class, new AtomEditor(mainFrame));
        this.symrelModel = new MyTableModel(this.symrelTable);
        this.symrelTable.setModel(this.symrelModel);
        this.initTableHeader(this.symrelTable, new String[]{"S11", "S12", "S13", "S21", "S22", "S23", "S31", "S32", "S33"}, new Integer[]{null, null, null, null, null, null, null, null, null});
        this.symrelTable.setVisible(false);
        this.tnonsModel = new MyTableModel(this.tnonsTable);
        this.tnonsTable.setModel(this.tnonsModel);
        this.initTableHeader(this.tnonsTable, new String[]{"a", "b", "c"}, new Integer[]{null, null, null});
        this.tnonsTable.setVisible(false);
        this.rprimdCheckBox.setVisible(false);
    }

    private void initTableHeader(JTable jTable, String[] stringArray, Integer[] integerArray) {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setHeaderValue(stringArray[i]);
            tableColumn.setResizable(false);
            if (integerArray[i] != null) {
                tableColumn.setMinWidth(integerArray[i]);
                tableColumn.setPreferredWidth(integerArray[i]);
                tableColumn.setMaxWidth(integerArray[i]);
            }
            defaultTableColumnModel.addColumn(tableColumn);
        }
        jTable.setColumnModel(defaultTableColumnModel);
    }

    public void printERR(String string) {
        if (string.endsWith("\n")) {
            this.outDialog.appendERR(string);
        } else {
            this.outDialog.appendERR(string + "\n");
        }
    }

    public void printOUT(String string) {
        if (string.endsWith("\n")) {
            this.outDialog.appendOUT(string);
        } else {
            this.outDialog.appendOUT(string + "\n");
        }
    }

    String removeEndl(String string) {
        if (string.endsWith("\n")) {
            return (String)string.subSequence(0, string.lastIndexOf(10));
        }
        return string;
    }

    private void printDEB(String string) {
        if (string.endsWith("\n")) {
            this.outDialog.appendDEB("DEBUG: " + string);
        } else {
            this.outDialog.appendDEB("DEBUG: " + string + "\n");
        }
    }

    private void initComponents() {
        this.xyzbuttonGroup = new ButtonGroup();
        this.znuclTableScrollPane = new JScrollPane();
        this.znuclTable = new JTable();
        this.znuclCheckBox = new JCheckBox();
        this.rprimTableScrollPane = new JScrollPane();
        this.rprimTable = new JTable();
        this.angdegCheckBox = new JCheckBox();
        this.rprimCheckBox = new JCheckBox();
        this.acellTextField1 = new JTextField();
        this.acellTextField2 = new JTextField();
        this.acellUnitsLabel = new JLabel();
        this.ntypatTextField = new JTextField();
        this.typatCheckBox = new JCheckBox();
        this.xangstRadioButton = new JRadioButton();
        this.xredRadioButton = new JRadioButton();
        this.xyzTableScrollPane = new JScrollPane();
        this.xyzTable = new JTable();
        this.natomTextField = new JTextField();
        this.xcartRadioButton = new JRadioButton();
        this.ntypatCheckBox = new JCheckBox();
        this.natomCheckBox = new JCheckBox();
        this.acellCheckBox = new JCheckBox();
        this.rprimdCheckBox = new JCheckBox();
        this.acellTextField3 = new JTextField();
        this.shiftkTableScrollPane2 = new JScrollPane();
        this.tnonsTable = new JTable();
        this.symrelCheckBox = new JCheckBox();
        this.tnonsCheckBox = new JCheckBox();
        this.nsymCheckBox = new JCheckBox();
        this.nsymTextField = new JTextField();
        this.shiftkTableScrollPane1 = new JScrollPane();
        this.symrelTable = new JTable();
        this.setAutoscrolls(true);
        this.znuclTableScrollPane.setMaximumSize(new Dimension(325, 110));
        this.znuclTableScrollPane.setMinimumSize(new Dimension(325, 110));
        this.znuclTableScrollPane.setPreferredSize(new Dimension(325, 110));
        this.znuclTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.znuclTable.setEnabled(false);
        this.znuclTable.setMaximumSize(null);
        this.znuclTable.setMinimumSize(null);
        this.znuclTable.setPreferredSize(null);
        this.znuclTable.setRowSelectionAllowed(false);
        this.znuclTable.getTableHeader().setReorderingAllowed(false);
        this.znuclTableScrollPane.setViewportView(this.znuclTable);
        this.znuclCheckBox.setForeground(Color.blue);
        this.znuclCheckBox.setText("znucl");
        this.znuclCheckBox.setEnabled(false);
        this.znuclCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.znuclCheckBoxActionPerformed(actionEvent);
            }
        });
        this.rprimTableScrollPane.setMaximumSize(new Dimension(325, 70));
        this.rprimTableScrollPane.setMinimumSize(new Dimension(325, 70));
        this.rprimTableScrollPane.setPreferredSize(new Dimension(325, 70));
        this.rprimTable.setEnabled(false);
        this.rprimTable.setMaximumSize(null);
        this.rprimTable.setMinimumSize(null);
        this.rprimTable.setPreferredSize(null);
        this.rprimTable.setRowSelectionAllowed(false);
        this.rprimTable.getTableHeader().setReorderingAllowed(false);
        this.rprimTableScrollPane.setViewportView(this.rprimTable);
        this.angdegCheckBox.setForeground(Color.blue);
        this.angdegCheckBox.setText("angdeg");
        this.angdegCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.angdegCheckBoxActionPerformed(actionEvent);
            }
        });
        this.rprimCheckBox.setForeground(Color.blue);
        this.rprimCheckBox.setText("rprim");
        this.rprimCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.rprimCheckBoxActionPerformed(actionEvent);
            }
        });
        this.acellTextField1.setEnabled(false);
        this.acellTextField2.setEnabled(false);
        this.acellUnitsLabel.setText("[Bohr]");
        this.acellUnitsLabel.setEnabled(false);
        this.ntypatTextField.setEnabled(false);
        this.ntypatTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Geometry.this.ntypatTextFieldKeyReleased(keyEvent);
            }
        });
        this.typatCheckBox.setForeground(Color.blue);
        this.typatCheckBox.setText("typat");
        this.typatCheckBox.setEnabled(false);
        this.typatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.typatCheckBoxActionPerformed(actionEvent);
            }
        });
        this.xyzbuttonGroup.add(this.xangstRadioButton);
        this.xangstRadioButton.setText("xangst");
        this.xangstRadioButton.setEnabled(false);
        this.xangstRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.xangstRadioButtonActionPerformed(actionEvent);
            }
        });
        this.xyzbuttonGroup.add(this.xredRadioButton);
        this.xredRadioButton.setForeground(Color.red);
        this.xredRadioButton.setSelected(true);
        this.xredRadioButton.setText("xred");
        this.xredRadioButton.setEnabled(false);
        this.xredRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.xredRadioButtonActionPerformed(actionEvent);
            }
        });
        this.xyzTableScrollPane.setMaximumSize(new Dimension(325, 110));
        this.xyzTableScrollPane.setMinimumSize(new Dimension(325, 110));
        this.xyzTableScrollPane.setPreferredSize(new Dimension(325, 110));
        this.xyzTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.xyzTable.setEnabled(false);
        this.xyzTable.setMaximumSize(null);
        this.xyzTable.setMinimumSize(null);
        this.xyzTable.setPreferredSize(null);
        this.xyzTable.setRowSelectionAllowed(false);
        this.xyzTable.getTableHeader().setReorderingAllowed(false);
        this.xyzTableScrollPane.setViewportView(this.xyzTable);
        this.natomTextField.setEnabled(false);
        this.natomTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Geometry.this.natomTextFieldKeyReleased(keyEvent);
            }
        });
        this.xyzbuttonGroup.add(this.xcartRadioButton);
        this.xcartRadioButton.setText("xcart");
        this.xcartRadioButton.setEnabled(false);
        this.xcartRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.xcartRadioButtonActionPerformed(actionEvent);
            }
        });
        this.ntypatCheckBox.setForeground(Color.blue);
        this.ntypatCheckBox.setText("ntypat");
        this.ntypatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.ntypatCheckBoxActionPerformed(actionEvent);
            }
        });
        this.natomCheckBox.setForeground(Color.blue);
        this.natomCheckBox.setText("natom");
        this.natomCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.natomCheckBoxActionPerformed(actionEvent);
            }
        });
        this.acellCheckBox.setForeground(Color.blue);
        this.acellCheckBox.setText("acell");
        this.acellCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.acellCheckBoxActionPerformed(actionEvent);
            }
        });
        this.rprimdCheckBox.setForeground(Color.blue);
        this.rprimdCheckBox.setText("rprimd");
        this.rprimdCheckBox.setEnabled(false);
        this.rprimdCheckBox.setFocusPainted(false);
        this.rprimdCheckBox.setFocusable(false);
        this.rprimdCheckBox.setRequestFocusEnabled(false);
        this.rprimdCheckBox.setRolloverEnabled(false);
        this.rprimdCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.rprimdCheckBoxActionPerformed(actionEvent);
            }
        });
        this.acellTextField3.setEnabled(false);
        this.shiftkTableScrollPane2.setMaximumSize(new Dimension(325, 110));
        this.shiftkTableScrollPane2.setMinimumSize(new Dimension(325, 110));
        this.shiftkTableScrollPane2.setPreferredSize(new Dimension(325, 110));
        this.tnonsTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tnonsTable.setEnabled(false);
        this.tnonsTable.setRowSelectionAllowed(false);
        this.tnonsTable.getTableHeader().setReorderingAllowed(false);
        this.shiftkTableScrollPane2.setViewportView(this.tnonsTable);
        this.symrelCheckBox.setForeground(Color.blue);
        this.symrelCheckBox.setText("symrel");
        this.symrelCheckBox.setEnabled(false);
        this.symrelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.symrelCheckBoxActionPerformed(actionEvent);
            }
        });
        this.tnonsCheckBox.setForeground(Color.blue);
        this.tnonsCheckBox.setText("tnons");
        this.tnonsCheckBox.setEnabled(false);
        this.tnonsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.tnonsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.nsymCheckBox.setForeground(Color.blue);
        this.nsymCheckBox.setText("nsym");
        this.nsymCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Geometry.this.nsymCheckBoxActionPerformed(actionEvent);
            }
        });
        this.nsymTextField.setEnabled(false);
        this.nsymTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Geometry.this.nsymTextFieldKeyReleased(keyEvent);
            }
        });
        this.shiftkTableScrollPane1.setMaximumSize(new Dimension(325, 110));
        this.shiftkTableScrollPane1.setMinimumSize(new Dimension(325, 110));
        this.shiftkTableScrollPane1.setPreferredSize(new Dimension(325, 110));
        this.symrelTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.symrelTable.setEnabled(false);
        this.symrelTable.setRowSelectionAllowed(false);
        this.symrelTable.getTableHeader().setReorderingAllowed(false);
        this.shiftkTableScrollPane1.setViewportView(this.symrelTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.rprimCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.angdegCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rprimdCheckBox)).addGroup(groupLayout.createSequentialGroup().addComponent(this.acellCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acellTextField1, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acellTextField2, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acellTextField3, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acellUnitsLabel)).addGroup(groupLayout.createSequentialGroup().addComponent(this.natomCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.natomTextField, -2, 41, -2).addGap(18, 18, 18).addComponent(this.xredRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xcartRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xangstRadioButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.ntypatCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ntypatTextField, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.znuclCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.typatCheckBox)).addComponent(this.rprimTableScrollPane, -1, 337, Short.MAX_VALUE).addComponent(this.xyzTableScrollPane, -1, -1, Short.MAX_VALUE).addComponent(this.znuclTableScrollPane, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.nsymCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nsymTextField, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.symrelCheckBox)).addComponent(this.tnonsCheckBox).addComponent(this.shiftkTableScrollPane1, -1, -1, Short.MAX_VALUE).addComponent(this.shiftkTableScrollPane2, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.acellTextField1, this.acellTextField2, this.acellTextField3);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nsymCheckBox).addComponent(this.nsymTextField, -2, -1, -2).addComponent(this.symrelCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shiftkTableScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tnonsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shiftkTableScrollPane2, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.acellCheckBox).addComponent(this.acellTextField3, -2, -1, -2).addComponent(this.acellTextField2, -2, -1, -2).addComponent(this.acellTextField1, -2, -1, -2).addComponent(this.acellUnitsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rprimCheckBox).addComponent(this.angdegCheckBox).addComponent(this.rprimdCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rprimTableScrollPane, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.natomCheckBox).addComponent(this.natomTextField, -2, -1, -2).addComponent(this.xangstRadioButton).addComponent(this.xcartRadioButton).addComponent(this.xredRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xyzTableScrollPane, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ntypatCheckBox).addComponent(this.ntypatTextField, -2, -1, -2).addComponent(this.znuclCheckBox).addComponent(this.typatCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.znuclTableScrollPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void znuclCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.znuclCheckBox.setSelected(true);
    }

    private void angdegCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.angdegCheckBox.isSelected()) {
            Double d;
            Double d2;
            Double d3;
            if (this.rprimCheckBox.isSelected()) {
                this.rprimCheckBox.setSelected(false);
                this.rprimCheckBoxActionPerformed(actionEvent);
                int n = this.rprimTable.getColumnCount();
                int n2 = this.rprimTable.getRowCount();
                Double[][] doubleArray = new Double[n2][n - 1];
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 1; j < n; ++j) {
                            try {
                                doubleArray[i][j - 1] = (Double)this.rprimTable.getValueAt(i, j);
                                continue;
                            }
                            catch (Exception exception) {
                                d3 = 90.0;
                                d2 = 90.0;
                                d = 90.0;
                                this.printERR("Error in reading rprimTable (angdegCheckBoxActionPerformed) !");
                            }
                        }
                    }
                    Double d4 = doubleArray[0][0];
                    Double d5 = doubleArray[0][1];
                    Double d6 = doubleArray[0][2];
                    Double d7 = doubleArray[1][0];
                    Double d8 = doubleArray[1][1];
                    Double d9 = doubleArray[1][2];
                    Double d10 = doubleArray[2][0];
                    Double d11 = doubleArray[2][1];
                    Double d12 = doubleArray[2][2];
                    d3 = new Double(Math.acos((d10 * d7 + d11 * d8 + d12 * d9) / (Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12) * Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9))) * 180.0 / Math.PI);
                    d2 = new Double(Math.acos((d4 * d10 + d5 * d11 + d6 * d12) / (Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6) * Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12))) * 180.0 / Math.PI);
                    d = new Double(Math.acos((d4 * d7 + d5 * d8 + d6 * d9) / (Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6) * Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9))) * 180.0 / Math.PI);
                } else {
                    d3 = 90.0;
                    d2 = 90.0;
                    d = 90.0;
                }
            } else if (this.rprimdCheckBox.isSelected()) {
                Double d13;
                Double d14;
                Double d15;
                this.rprimdCheckBox.setSelected(false);
                this.rprimdCheckBoxActionPerformed(actionEvent);
                try {
                    d15 = Double.parseDouble(this.acellTextField1.getText());
                    d14 = Double.parseDouble(this.acellTextField2.getText());
                    d13 = Double.parseDouble(this.acellTextField3.getText());
                }
                catch (Exception exception) {
                    d15 = 1.0;
                    d14 = 1.0;
                    d13 = 1.0;
                    this.printERR("Please setup acell (to avoid calculation errors acell became (1, 1, 1)) !");
                }
                int n = this.rprimTable.getColumnCount();
                int n3 = this.rprimTable.getRowCount();
                Double[][] doubleArray = new Double[n3][n - 1];
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 1; j < n; ++j) {
                            try {
                                doubleArray[i][j - 1] = (Double)this.rprimTable.getValueAt(i, j);
                                continue;
                            }
                            catch (Exception exception) {
                                this.printERR("Error in reading rprimTable (angdegCheckBoxActionPerformed) !");
                                d3 = 90.0;
                                d2 = 90.0;
                                d = 90.0;
                            }
                        }
                    }
                    Double d16 = doubleArray[0][0] / d15;
                    Double d17 = doubleArray[0][1] / d15;
                    Double d18 = doubleArray[0][2] / d15;
                    Double d19 = doubleArray[1][0] / d14;
                    Double d20 = doubleArray[1][1] / d14;
                    Double d21 = doubleArray[1][2] / d14;
                    Double d22 = doubleArray[2][0] / d13;
                    Double d23 = doubleArray[2][1] / d13;
                    Double d24 = doubleArray[2][2] / d13;
                    d3 = new Double(Math.acos((d22 * d19 + d23 * d20 + d24 * d21) / (Math.sqrt(d22 * d22 + d23 * d23 + d24 * d24) * Math.sqrt(d19 * d19 + d20 * d20 + d21 * d21))) * 180.0 / Math.PI);
                    d2 = new Double(Math.acos((d16 * d22 + d17 * d23 + d18 * d24) / (Math.sqrt(d16 * d16 + d17 * d17 + d18 * d18) * Math.sqrt(d22 * d22 + d23 * d23 + d24 * d24))) * 180.0 / Math.PI);
                    d = new Double(Math.acos((d16 * d19 + d17 * d20 + d18 * d21) / (Math.sqrt(d16 * d16 + d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20 + d21 * d21))) * 180.0 / Math.PI);
                } else {
                    d3 = 90.0;
                    d2 = 90.0;
                    d = 90.0;
                }
            } else {
                d3 = 90.0;
                d2 = 90.0;
                d = 90.0;
            }
            this.angdegCheckBox.setForeground(Color.red);
            this.initTableHeader(this.rprimTable, new String[]{"", "angle [deg.]"}, new Integer[]{160, null});
            this.rprimModel.setData(new Object[][]{{new String("angle between b and c"), new Double(d3)}, {new String("angle between a and c"), new Double(d2)}, {new String("angle between a and b"), new Double(d)}});
            this.rprimTable.setEnabled(true);
            this.rprimTable.setVisible(true);
        } else {
            this.angdegCheckBox.setForeground(Color.blue);
            this.rprimTable.setEnabled(false);
            this.rprimTable.setVisible(false);
        }
    }

    private void rprimCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.rprimCheckBox.isSelected()) {
            Object[][] objectArray;
            if (this.angdegCheckBox.isSelected()) {
                Double d;
                Double d2;
                Double d3;
                this.angdegCheckBox.setSelected(false);
                this.angdegCheckBoxActionPerformed(actionEvent);
                try {
                    d3 = Double.parseDouble(this.acellTextField1.getText());
                    d2 = Double.parseDouble(this.acellTextField2.getText());
                    d = Double.parseDouble(this.acellTextField3.getText());
                }
                catch (Exception exception) {
                    d3 = 1.0;
                    d2 = 1.0;
                    d = 1.0;
                    this.printERR("Please setup acell (to avoid calculation errors acell became (1, 1, 1)) !");
                }
                int n = this.rprimTable.getColumnCount();
                int n2 = this.rprimTable.getRowCount();
                Object[][] objectArray2 = new Object[n2][n];
                if (n2 > 0) {
                    Double d4;
                    Double d5;
                    Double d6;
                    Double d7;
                    Double d8;
                    Double d9;
                    Double d10;
                    Double d11;
                    Double d12;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 1; j < n; ++j) {
                            try {
                                objectArray2[i][j] = new Double((Double)this.rprimTable.getValueAt(i, j));
                                continue;
                            }
                            catch (Exception exception) {
                                this.printERR("Error in reading rprimTable (angdegCheckBoxActionPerformed) !");
                            }
                        }
                    }
                    Double d13 = (Double)objectArray2[0][1];
                    Double d14 = (Double)objectArray2[1][1];
                    Double d15 = (Double)objectArray2[2][1];
                    objectArray = new Object[3][4];
                    objectArray[0][0] = "a";
                    objectArray[1][0] = "b";
                    objectArray[2][0] = "c";
                    if (d13.equals(d14) && d13.equals(d15) && !d13.equals(90.0)) {
                        Double d16 = Math.cos(Math.PI * d13 / 180.0);
                        Double d17 = 0.6666666666666666 * (1.0 - d16);
                        Double d18 = Math.sqrt(d17);
                        Double d19 = Math.sqrt(1.0 - d17);
                        d12 = d18;
                        d11 = 0.0;
                        d10 = d19;
                        d9 = -0.5 * d18;
                        d8 = Math.sqrt(3.0) * 0.5 * d18;
                        d7 = d19;
                        d6 = -0.5 * d18;
                        d5 = -Math.sqrt(3.0) * 0.5 * d18;
                        d4 = d19;
                    } else {
                        d12 = new Double(1.0);
                        d9 = new Double(Math.cos(Math.PI * d15 / 180.0));
                        d6 = new Double(Math.cos(Math.PI * d14 / 180.0));
                        d11 = new Double(0.0);
                        d8 = new Double(Math.sin(Math.PI * d15 / 180.0));
                        d5 = new Double((Math.cos(Math.PI * d13 / 180.0) - d9 * d6) / d8);
                        d10 = new Double(0.0);
                        d7 = new Double(0.0);
                        d4 = new Double(Math.sqrt(1.0 - Math.pow(d6, 2.0) - Math.pow(d5, 2.0)));
                    }
                    objectArray[0][1] = new Double(d12);
                    objectArray[1][1] = new Double(d9);
                    objectArray[2][1] = new Double(d6);
                    objectArray[0][2] = new Double(d11);
                    objectArray[1][2] = new Double(d8);
                    objectArray[2][2] = new Double(d5);
                    objectArray[0][3] = new Double(d10);
                    objectArray[1][3] = new Double(d7);
                    objectArray[2][3] = new Double(d4);
                } else {
                    objectArray = new Object[][]{{new String("a"), new Double(1.0), new Double(0.0), new Double(0.0)}, {new String("b"), new Double(0.0), new Double(1.0), new Double(0.0)}, {new String("c"), new Double(0.0), new Double(0.0), new Double(1.0)}};
                }
            } else if (this.rprimdCheckBox.isSelected()) {
                Double d;
                Double d20;
                Double d21;
                this.rprimdCheckBox.setSelected(false);
                this.rprimdCheckBoxActionPerformed(actionEvent);
                try {
                    d21 = Double.parseDouble(this.acellTextField1.getText());
                    d20 = Double.parseDouble(this.acellTextField2.getText());
                    d = Double.parseDouble(this.acellTextField3.getText());
                }
                catch (Exception exception) {
                    d21 = 1.0;
                    d20 = 1.0;
                    d = 1.0;
                    this.printERR("Please setup acell (to avoid calculation errors acell became (1, 1, 1)) !");
                }
                int n = this.rprimTable.getColumnCount();
                int n3 = this.rprimTable.getRowCount();
                Object[][] objectArray3 = new Object[n3][n];
                Double[] doubleArray = new Double[]{d21, d20, d};
                objectArray3[0][0] = "a";
                objectArray3[1][0] = "b";
                objectArray3[2][0] = "c";
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 1; j < n; ++j) {
                            try {
                                objectArray3[i][j] = new Double((Double)this.rprimTable.getValueAt(i, j) / doubleArray[i]);
                                continue;
                            }
                            catch (Exception exception) {
                                this.printERR("Error in reading rprimTable (angdegCheckBoxActionPerformed) !");
                            }
                        }
                    }
                    objectArray = objectArray3;
                } else {
                    objectArray = new Object[][]{{new String("a"), new Double(1.0), new Double(0.0), new Double(0.0)}, {new String("b"), new Double(0.0), new Double(1.0), new Double(0.0)}, {new String("c"), new Double(0.0), new Double(0.0), new Double(1.0)}};
                }
            } else {
                objectArray = new Object[][]{{new String("a"), new Double(1.0), new Double(0.0), new Double(0.0)}, {new String("b"), new Double(0.0), new Double(1.0), new Double(0.0)}, {new String("c"), new Double(0.0), new Double(0.0), new Double(1.0)}};
            }
            this.rprimCheckBox.setForeground(Color.red);
            this.initTableHeader(this.rprimTable, new String[]{"", "x (red.)", "y (red.)", "z (red.)"}, new Integer[]{18, null, null, null});
            this.rprimModel.setData(objectArray);
            this.rprimTable.setEnabled(true);
            this.rprimTable.setVisible(true);
        } else {
            this.rprimCheckBox.setForeground(Color.blue);
            this.rprimTable.setEnabled(false);
            this.rprimTable.setVisible(false);
        }
    }

    private void ntypatTextFieldKeyReleased(KeyEvent keyEvent) {
        try {
            int n = Integer.parseInt(this.ntypatTextField.getText());
            if (n > 1000) {
                n = 1000;
                Object[][] objectArray = new Object[n][4];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Object[]{new Atom(), new Integer(0), new Integer(i + 1), new Integer(1)};
                }
                this.znuclModel.setData(objectArray);
            } else {
                Object[][] objectArray = new Object[n][4];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Object[]{new Atom(), new Integer(0), new Integer(i + 1), new Integer(1)};
                }
                this.znuclModel.setData(objectArray);
            }
        }
        catch (Exception exception) {
            this.znuclModel.setData(null);
        }
    }

    private void typatCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.typatCheckBox.setSelected(true);
    }

    private void xangstRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.radioButtonHandler(null, false);
    }

    private void xredRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.radioButtonHandler(null, false);
    }

    private void natomTextFieldKeyReleased(KeyEvent keyEvent) {
        try {
            int n = Integer.parseInt(this.natomTextField.getText());
            if (n > 1000) {
                n = 1000;
                Object[][] objectArray = new Object[n][3];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                }
                this.radioButtonHandler(objectArray, false);
            } else {
                Object[][] objectArray = new Object[n][3];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                }
                this.radioButtonHandler(objectArray, false);
            }
        }
        catch (Exception exception) {
            this.radioButtonHandler(null, true);
        }
    }

    private void xcartRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.radioButtonHandler(null, false);
    }

    private void ntypatCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.ntypatCheckBox.isSelected()) {
            this.ntypatCheckBox.setForeground(Color.red);
            this.znuclCheckBox.setForeground(Color.red);
            this.znuclCheckBox.setEnabled(true);
            this.znuclCheckBox.setSelected(true);
            this.typatCheckBox.setForeground(Color.red);
            this.typatCheckBox.setEnabled(true);
            this.typatCheckBox.setSelected(true);
            this.ntypatTextField.setEnabled(true);
            this.znuclTable.setEnabled(true);
            this.znuclTable.setVisible(true);
        } else {
            this.ntypatCheckBox.setForeground(Color.blue);
            this.znuclCheckBox.setEnabled(false);
            this.znuclCheckBox.setSelected(false);
            this.typatCheckBox.setEnabled(false);
            this.typatCheckBox.setSelected(false);
            this.ntypatTextField.setEnabled(false);
            this.znuclTable.setEnabled(false);
            this.znuclTable.setVisible(false);
        }
    }

    private void natomCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.natomCheckBox.isSelected()) {
            this.natomCheckBox.setForeground(Color.red);
            this.natomTextField.setEnabled(true);
            this.xredRadioButton.setEnabled(true);
            this.xcartRadioButton.setEnabled(true);
            this.xangstRadioButton.setEnabled(true);
            this.xyzTable.setEnabled(true);
            this.xyzTable.setVisible(true);
        } else {
            this.natomCheckBox.setForeground(Color.blue);
            this.natomTextField.setEnabled(false);
            this.xredRadioButton.setEnabled(false);
            this.xcartRadioButton.setEnabled(false);
            this.xangstRadioButton.setEnabled(false);
            this.xyzTable.setEnabled(false);
            this.xyzTable.setVisible(false);
        }
    }

    private void acellCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.acellCheckBox.isSelected()) {
            this.acellCheckBox.setForeground(Color.red);
            this.acellTextField1.setEnabled(true);
            this.acellTextField2.setEnabled(true);
            this.acellTextField3.setEnabled(true);
            this.acellUnitsLabel.setEnabled(true);
        } else {
            this.acellCheckBox.setForeground(Color.blue);
            this.acellTextField1.setEnabled(false);
            this.acellTextField2.setEnabled(false);
            this.acellTextField3.setEnabled(false);
            this.acellUnitsLabel.setEnabled(false);
        }
    }

    private void rprimdCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.rprimdCheckBox.isSelected()) {
            Object[][] objectArray;
            Double d;
            Double d2;
            Double d3;
            try {
                d3 = Double.parseDouble(this.acellTextField1.getText());
                d2 = Double.parseDouble(this.acellTextField2.getText());
                d = Double.parseDouble(this.acellTextField3.getText());
            }
            catch (Exception exception) {
                d3 = 1.0;
                d2 = 1.0;
                d = 1.0;
                this.printERR("Please setup acell (to avoid calculation errors acell became (1, 1, 1)) !");
            }
            if (this.angdegCheckBox.isSelected()) {
                this.angdegCheckBox.setSelected(false);
                this.angdegCheckBoxActionPerformed(actionEvent);
                try {
                    d3 = Double.parseDouble(this.acellTextField1.getText());
                    d2 = Double.parseDouble(this.acellTextField2.getText());
                    d = Double.parseDouble(this.acellTextField3.getText());
                }
                catch (Exception exception) {
                    d3 = 1.0;
                    d2 = 1.0;
                    d = 1.0;
                    this.printERR("Please setup acell (to avoid calculation errors acell became (1, 1, 1)) !");
                }
                int n = this.rprimTable.getColumnCount();
                int n2 = this.rprimTable.getRowCount();
                Object[][] objectArray2 = new Object[n2][n];
                if (n2 > 0) {
                    Double d4;
                    Double d5;
                    Double d6;
                    Double d7;
                    Double d8;
                    Double d9;
                    Double d10;
                    Double d11;
                    Double d12;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 1; j < n; ++j) {
                            try {
                                objectArray2[i][j] = new Double((Double)this.rprimTable.getValueAt(i, j));
                                continue;
                            }
                            catch (Exception exception) {
                                this.printERR("Error in reading rprimTable (angdegCheckBoxActionPerformed) !");
                            }
                        }
                    }
                    Double d13 = (Double)objectArray2[0][1];
                    Double d14 = (Double)objectArray2[1][1];
                    Double d15 = (Double)objectArray2[2][1];
                    objectArray = new Object[3][4];
                    objectArray[0][0] = "a";
                    objectArray[1][0] = "b";
                    objectArray[2][0] = "c";
                    if (d13.equals(d14) && d13.equals(d15) && !d13.equals(90.0)) {
                        Double d16 = Math.cos(Math.PI * d13 / 180.0);
                        Double d17 = 0.6666666666666666 * (1.0 - d16);
                        Double d18 = Math.sqrt(d17);
                        Double d19 = Math.sqrt(1.0 - d17);
                        d12 = d18;
                        d11 = 0.0;
                        d10 = d19;
                        d9 = -0.5 * d18;
                        d8 = Math.sqrt(3.0) * 0.5 * d18;
                        d7 = d19;
                        d6 = -0.5 * d18;
                        d5 = -Math.sqrt(3.0) * 0.5 * d18;
                        d4 = d19;
                    } else {
                        d12 = new Double(1.0);
                        d9 = new Double(Math.cos(Math.PI * d15 / 180.0));
                        d6 = new Double(Math.cos(Math.PI * d14 / 180.0));
                        d11 = new Double(0.0);
                        d8 = new Double(Math.sin(Math.PI * d15 / 180.0));
                        d5 = new Double((Math.cos(Math.PI * d13 / 180.0) - d9 * d6) / d8);
                        d10 = new Double(0.0);
                        d7 = new Double(0.0);
                        d4 = new Double(Math.sqrt(1.0 - Math.pow(d6, 2.0) - Math.pow(d5, 2.0)));
                    }
                    objectArray[0][1] = new Double(d12 * d3);
                    objectArray[1][1] = new Double(d9 * d2);
                    objectArray[2][1] = new Double(d6 * d);
                    objectArray[0][2] = new Double(d11 * d3);
                    objectArray[1][2] = new Double(d8 * d2);
                    objectArray[2][2] = new Double(d5 * d);
                    objectArray[0][3] = new Double(d10 * d3);
                    objectArray[1][3] = new Double(d7 * d2);
                    objectArray[2][3] = new Double(d4 * d);
                } else {
                    objectArray = new Object[][]{{new String("a"), new Double(1.0 * d3), new Double(0.0), new Double(0.0)}, {new String("b"), new Double(0.0), new Double(1.0 * d2), new Double(0.0)}, {new String("c"), new Double(0.0), new Double(0.0), new Double(1.0 * d)}};
                }
            } else if (this.rprimCheckBox.isSelected()) {
                this.rprimCheckBox.setSelected(false);
                this.rprimCheckBoxActionPerformed(actionEvent);
                int n = this.rprimTable.getColumnCount();
                int n3 = this.rprimTable.getRowCount();
                Object[][] objectArray3 = new Object[n3][n];
                Double[] doubleArray = new Double[]{d3, d2, d};
                objectArray3[0][0] = "a";
                objectArray3[1][0] = "b";
                objectArray3[2][0] = "c";
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 1; j < n; ++j) {
                            try {
                                objectArray3[i][j] = new Double((Double)this.rprimTable.getValueAt(i, j) * doubleArray[i]);
                                continue;
                            }
                            catch (Exception exception) {
                                this.printERR("Error in reading rprimTable (angdegCheckBoxActionPerformed) !");
                            }
                        }
                    }
                    objectArray = objectArray3;
                } else {
                    objectArray = new Object[][]{{new String("a"), new Double(1.0), new Double(0.0), new Double(0.0)}, {new String("b"), new Double(0.0), new Double(1.0), new Double(0.0)}, {new String("c"), new Double(0.0), new Double(0.0), new Double(1.0)}};
                }
            } else {
                objectArray = new Object[][]{{new String("a"), new Double(1.0 * d3), new Double(0.0), new Double(0.0)}, {new String("b"), new Double(0.0), new Double(1.0 * d2), new Double(0.0)}, {new String("c"), new Double(0.0), new Double(0.0), new Double(1.0 * d)}};
            }
            this.rprimdCheckBox.setForeground(Color.red);
            this.initTableHeader(this.rprimTable, new String[]{"", "x", "y", "z"}, new Integer[]{15, null, null, null});
            this.rprimModel.setData(objectArray);
            this.rprimTable.setEnabled(true);
            this.rprimTable.setVisible(true);
        } else {
            this.rprimdCheckBox.setForeground(Color.blue);
            this.rprimTable.setEnabled(false);
            this.rprimTable.setVisible(false);
        }
    }

    private void symrelCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.symrelCheckBox.setForeground(Color.red);
        this.symrelCheckBox.setEnabled(true);
        this.symrelCheckBox.setSelected(true);
    }

    private void tnonsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.tnonsCheckBox.setForeground(Color.red);
        this.tnonsCheckBox.setEnabled(true);
        this.tnonsCheckBox.setSelected(true);
    }

    private void nsymCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.nsymTextField.getText().equals("0")) {
            if (this.nsymCheckBox.isSelected()) {
                this.nsymCheckBox.setForeground(Color.red);
                this.nsymTextField.setEnabled(true);
                this.symrelCheckBox.setEnabled(false);
                this.symrelCheckBox.setSelected(false);
                this.tnonsCheckBox.setEnabled(false);
                this.tnonsCheckBox.setSelected(false);
                this.symrelTable.setEnabled(false);
                this.symrelTable.setVisible(false);
                this.tnonsTable.setEnabled(false);
                this.tnonsTable.setVisible(false);
            } else {
                this.nsymCheckBox.setForeground(Color.blue);
                this.nsymTextField.setEnabled(false);
                this.symrelCheckBox.setEnabled(false);
                this.symrelCheckBox.setSelected(false);
                this.tnonsCheckBox.setEnabled(false);
                this.tnonsCheckBox.setSelected(false);
                this.symrelTable.setEnabled(false);
                this.symrelTable.setVisible(false);
                this.tnonsTable.setEnabled(false);
                this.tnonsTable.setVisible(false);
            }
        } else if (this.nsymCheckBox.isSelected()) {
            this.nsymCheckBox.setForeground(Color.red);
            this.nsymTextField.setEnabled(true);
            if (this.nsymTextField.getText().equals("")) {
                this.symrelCheckBox.setEnabled(false);
                this.symrelCheckBox.setSelected(false);
                this.tnonsCheckBox.setEnabled(false);
                this.tnonsCheckBox.setSelected(false);
                this.symrelTable.setEnabled(false);
                this.symrelTable.setVisible(false);
                this.tnonsTable.setEnabled(false);
                this.tnonsTable.setVisible(false);
            } else {
                this.symrelCheckBox.setEnabled(true);
                this.symrelCheckBox.setSelected(true);
                this.tnonsCheckBox.setEnabled(true);
                this.tnonsCheckBox.setSelected(true);
                this.symrelTable.setEnabled(true);
                this.symrelTable.setVisible(true);
                this.tnonsTable.setEnabled(true);
                this.tnonsTable.setVisible(true);
            }
        } else {
            this.nsymCheckBox.setForeground(Color.blue);
            this.nsymTextField.setEnabled(false);
            this.symrelCheckBox.setEnabled(false);
            this.symrelCheckBox.setSelected(false);
            this.tnonsCheckBox.setEnabled(false);
            this.tnonsCheckBox.setSelected(false);
            this.symrelTable.setEnabled(false);
            this.symrelTable.setVisible(false);
            this.tnonsTable.setEnabled(false);
            this.tnonsTable.setVisible(false);
        }
    }

    private void nsymTextFieldKeyReleased(KeyEvent keyEvent) {
        block16: {
            if (!this.nsymTextField.getText().equals("0")) {
                try {
                    int n;
                    Object[][] objectArray;
                    int n2 = Integer.parseInt(this.nsymTextField.getText());
                    if (n2 > 400) {
                        n2 = 400;
                        objectArray = new Object[n2][3];
                        for (n = 0; n < n2; ++n) {
                            objectArray[n] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0)};
                        }
                        this.symrelModel.setData(objectArray);
                    } else {
                        objectArray = new Object[n2][3];
                        for (n = 0; n < n2; ++n) {
                            objectArray[n] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0), new Double(0.0)};
                        }
                        this.symrelModel.setData(objectArray);
                    }
                    if (n2 > 400) {
                        n2 = 400;
                        objectArray = new Object[n2][3];
                        for (n = 0; n < n2; ++n) {
                            objectArray[n] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                        }
                        this.tnonsModel.setData(objectArray);
                    } else {
                        objectArray = new Object[n2][3];
                        for (n = 0; n < n2; ++n) {
                            objectArray[n] = new Object[]{new Double(0.0), new Double(0.0), new Double(0.0)};
                        }
                        this.tnonsModel.setData(objectArray);
                    }
                    if (this.nsymCheckBox.isSelected()) {
                        this.nsymCheckBox.setForeground(Color.red);
                        this.nsymTextField.setEnabled(true);
                        this.symrelCheckBox.setForeground(Color.red);
                        this.symrelCheckBox.setEnabled(true);
                        this.symrelCheckBox.setSelected(true);
                        this.tnonsCheckBox.setForeground(Color.red);
                        this.tnonsCheckBox.setEnabled(true);
                        this.tnonsCheckBox.setSelected(true);
                        this.symrelTable.setEnabled(true);
                        this.symrelTable.setVisible(true);
                        this.tnonsTable.setEnabled(true);
                        this.tnonsTable.setVisible(true);
                        break block16;
                    }
                    this.nsymCheckBox.setForeground(Color.blue);
                    this.nsymTextField.setEnabled(false);
                    this.symrelCheckBox.setEnabled(false);
                    this.symrelCheckBox.setSelected(false);
                    this.tnonsCheckBox.setEnabled(false);
                    this.tnonsCheckBox.setSelected(false);
                    this.symrelTable.setEnabled(false);
                    this.symrelTable.setVisible(false);
                    this.tnonsTable.setEnabled(false);
                    this.tnonsTable.setVisible(false);
                }
                catch (Exception exception) {
                    if (this.nsymCheckBox.isSelected()) {
                        this.nsymCheckBox.setForeground(Color.red);
                        this.nsymTextField.setEnabled(true);
                        this.symrelCheckBox.setEnabled(false);
                        this.symrelCheckBox.setSelected(false);
                        this.tnonsCheckBox.setEnabled(false);
                        this.tnonsCheckBox.setSelected(false);
                        this.symrelTable.setEnabled(false);
                        this.symrelTable.setVisible(false);
                        this.tnonsTable.setEnabled(false);
                        this.tnonsTable.setVisible(false);
                        break block16;
                    }
                    this.nsymCheckBox.setForeground(Color.blue);
                    this.nsymTextField.setEnabled(false);
                    this.symrelCheckBox.setEnabled(false);
                    this.symrelCheckBox.setSelected(false);
                    this.tnonsCheckBox.setEnabled(false);
                    this.tnonsCheckBox.setSelected(false);
                    this.symrelTable.setEnabled(false);
                    this.symrelTable.setVisible(false);
                    this.tnonsTable.setEnabled(false);
                    this.tnonsTable.setVisible(false);
                }
            } else if (this.nsymCheckBox.isSelected()) {
                this.nsymCheckBox.setForeground(Color.red);
                this.nsymTextField.setEnabled(true);
                this.symrelCheckBox.setSelected(false);
                this.tnonsCheckBox.setSelected(false);
                this.symrelTable.setEnabled(false);
                this.symrelTable.setVisible(false);
                this.tnonsTable.setEnabled(false);
                this.tnonsTable.setVisible(false);
            } else {
                this.nsymCheckBox.setForeground(Color.blue);
                this.nsymTextField.setEnabled(false);
                this.symrelCheckBox.setEnabled(false);
                this.symrelCheckBox.setSelected(false);
                this.tnonsCheckBox.setEnabled(false);
                this.tnonsCheckBox.setSelected(false);
                this.symrelTable.setEnabled(false);
                this.symrelTable.setVisible(false);
                this.tnonsTable.setEnabled(false);
                this.tnonsTable.setVisible(false);
            }
        }
    }

    private void radioButtonHandler(Object[][] objectArray, boolean bl) {
        Enumeration<AbstractButton> enumeration = this.xyzbuttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.isSelected()) {
                Object[][] objectArray2 = null;
                objectArray2 = objectArray != null ? objectArray : (bl ? (Object[][])null : this.getTableData(this.xyzTable));
                jRadioButton.setForeground(new Color(255, 0, 0));
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                try {
                    d = Double.parseDouble(this.acellTextField1.getText());
                    d2 = Double.parseDouble(this.acellTextField2.getText());
                    d3 = Double.parseDouble(this.acellTextField3.getText());
                }
                catch (Exception exception) {
                    this.printERR("Fill acell vector please !");
                }
                if (jRadioButton.getText().equals("xred")) {
                    if (this.previous.equals("xred")) {
                        this.xyzModel.setHeader(new String[]{"xred", "yred", "zred"});
                        this.xyzModel.setData(objectArray2);
                        this.xyzTable.setModel(this.xyzModel);
                    } else if (this.previous.equals("xcart")) {
                        objectArray2 = this.xcart2xred(objectArray2);
                        this.xyzModel.setHeader(new String[]{"xred", "yred", "zred"});
                        this.xyzModel.setData(objectArray2);
                        this.xyzTable.setModel(this.xyzModel);
                    } else if (this.previous.equals("xangst")) {
                        objectArray2 = this.xangst2xred(objectArray2);
                        this.xyzModel.setHeader(new String[]{"xred", "yred", "zred"});
                        this.xyzModel.setData(objectArray2);
                        this.xyzTable.setModel(this.xyzModel);
                    }
                    this.previous = "xred";
                    continue;
                }
                if (jRadioButton.getText().equals("xcart")) {
                    if (this.previous.equals("xred")) {
                        objectArray2 = this.xred2xcart(objectArray2);
                        this.xyzModel.setHeader(new String[]{"xcart", "ycart", "zcart"});
                        this.xyzModel.setData(objectArray2);
                        this.xyzTable.setModel(this.xyzModel);
                    } else if (this.previous.equals("xcart")) {
                        this.xyzModel.setHeader(new String[]{"xcart", "ycart", "zcart"});
                        this.xyzModel.setData(objectArray2);
                        this.xyzTable.setModel(this.xyzModel);
                    } else if (this.previous.equals("xangst")) {
                        objectArray2 = this.xangst2xcart(objectArray2);
                        this.xyzModel.setHeader(new String[]{"xcart", "ycart", "zcart"});
                        this.xyzModel.setData(objectArray2);
                        this.xyzTable.setModel(this.xyzModel);
                    }
                    this.previous = "xcart";
                    continue;
                }
                if (!jRadioButton.getText().equals("xangst")) continue;
                if (this.previous.equals("xred")) {
                    objectArray2 = this.xred2xangst(objectArray2);
                    this.xyzModel.setHeader(new String[]{"xangst", "yangst", "zangst"});
                    this.xyzModel.setData(objectArray2);
                    this.xyzTable.setModel(this.xyzModel);
                } else if (this.previous.equals("xcart")) {
                    objectArray2 = this.xcart2xangst(objectArray2);
                    this.xyzModel.setHeader(new String[]{"xangst", "yangst", "zangst"});
                    this.xyzModel.setData(objectArray2);
                    this.xyzTable.setModel(this.xyzModel);
                } else if (this.previous.equals("xangst")) {
                    this.xyzModel.setHeader(new String[]{"xangst", "yangst", "zangst"});
                    this.xyzModel.setData(objectArray2);
                    this.xyzTable.setModel(this.xyzModel);
                }
                this.previous = "xangst";
                continue;
            }
            jRadioButton.setForeground(new Color(0, 0, 0));
        }
    }

    private Object[][] getTableData(JTable jTable) {
        int n = jTable.getColumnCount();
        int n2 = jTable.getRowCount();
        if (n2 > 0) {
            Object[][] objectArray = new Object[n2][n];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    try {
                        objectArray[i][j] = jTable.getValueAt(i, j);
                        continue;
                    }
                    catch (Exception exception) {
                        this.printERR(exception.getMessage());
                    }
                }
            }
            return objectArray;
        }
        return null;
    }

    private Object[][] xred2xcart(Object[][] objectArray) {
        if (objectArray != null) {
            Double d;
            Double d2;
            Double d3;
            Object[][] objectArray2;
            Double[][] doubleArrayArray;
            Double[] doubleArray;
            Double[] doubleArray2;
            Double[] doubleArray3;
            Double d4;
            Double d5;
            Double d6;
            try {
                d6 = Double.parseDouble(this.acellTextField1.getText());
                d5 = Double.parseDouble(this.acellTextField2.getText());
                d4 = Double.parseDouble(this.acellTextField3.getText());
            }
            catch (Exception exception) {
                this.printERR("Please setup acell !");
                return objectArray;
            }
            int n = this.rprimTable.getColumnCount();
            int n2 = this.rprimTable.getRowCount();
            Double[][] doubleArray4 = new Double[n2][n - 1];
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 1; j < n; ++j) {
                        try {
                            doubleArray4[i][j - 1] = (Double)this.rprimTable.getValueAt(i, j);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please setup rprim or angdeg (problem with getValue from rprimTable) !");
                            return objectArray;
                        }
                    }
                }
            } else {
                this.printERR("Please setup rprim or angdeg !");
                return objectArray;
            }
            if (this.rprimCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0], doubleArray4[0][1], doubleArray4[0][2]};
                doubleArray2 = new Double[]{doubleArray4[1][0], doubleArray4[1][1], doubleArray4[1][2]};
                doubleArray = new Double[]{doubleArray4[2][0], doubleArray4[2][1], doubleArray4[2][2]};
            } else if (this.rprimdCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0] / d6, doubleArray4[0][1] / d6, doubleArray4[0][2] / d6};
                doubleArray2 = new Double[]{doubleArray4[1][0] / d5, doubleArray4[1][1] / d5, doubleArray4[1][2] / d5};
                doubleArray = new Double[]{doubleArray4[2][0] / d4, doubleArray4[2][1] / d4, doubleArray4[2][2] / d4};
            } else {
                Double d7;
                Double d8;
                Double d9;
                Double d10;
                Double d11;
                Double d12;
                this.printDEB("ang1 = " + doubleArray4[0][0] + " ang2 = " + doubleArray4[1][0] + " ang3 = " + doubleArray4[2][0]);
                doubleArrayArray = doubleArray4[0][0];
                objectArray2 = doubleArray4[1][0];
                Double d13 = doubleArray4[2][0];
                if (doubleArrayArray.equals(objectArray2) && doubleArrayArray.equals(d13) && !doubleArrayArray.equals(90.0)) {
                    Double d14 = Math.cos(Math.PI * doubleArrayArray.doubleValue() / 180.0);
                    Double d15 = 0.6666666666666666 * (1.0 - d14);
                    Double d16 = Math.sqrt(d15);
                    Double d17 = Math.sqrt(1.0 - d15);
                    d3 = d16;
                    d12 = 0.0;
                    d11 = d17;
                    d2 = -0.5 * d16;
                    d10 = Math.sqrt(3.0) * 0.5 * d16;
                    d9 = d17;
                    d = -0.5 * d16;
                    d8 = -Math.sqrt(3.0) * 0.5 * d16;
                    d7 = d17;
                } else {
                    d3 = new Double(1.0);
                    d2 = new Double(Math.cos(Math.PI * d13 / 180.0));
                    d = new Double(Math.cos(Math.PI * objectArray2.doubleValue() / 180.0));
                    d12 = new Double(0.0);
                    d10 = new Double(Math.sin(Math.PI * d13 / 180.0));
                    d8 = new Double((Math.cos(Math.PI * doubleArrayArray.doubleValue() / 180.0) - d2 * d) / d10);
                    d11 = new Double(0.0);
                    d9 = new Double(0.0);
                    d7 = new Double(Math.sqrt(1.0 - Math.pow(d, 2.0) - Math.pow(d8, 2.0)));
                }
                doubleArray3 = new Double[]{d3, d12, d11};
                doubleArray2 = new Double[]{d2, d10, d9};
                doubleArray = new Double[]{d, d8, d7};
            }
            doubleArrayArray = new Double[][]{{doubleArray3[0] * d6, doubleArray3[1] * d6, doubleArray3[2] * d6}, {doubleArray2[0] * d5, doubleArray2[1] * d5, doubleArray2[2] * d5}, {doubleArray[0] * d4, doubleArray[1] * d4, doubleArray[2] * d4}};
            objectArray2 = new Object[objectArray.length][3];
            for (int i = 0; i < objectArray.length; ++i) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                for (int j = 0; j < 3; ++j) {
                    d3 = d3 + doubleArrayArray[0][j] * (Double)objectArray[i][j];
                    d2 = d2 + doubleArrayArray[1][j] * (Double)objectArray[i][j];
                    d = d + doubleArrayArray[2][j] * (Double)objectArray[i][j];
                }
                objectArray2[i] = new Double[]{new Double(d3), new Double(d2), new Double(d)};
            }
            return objectArray2;
        }
        return null;
    }

    private Object[][] xred2xangst(Object[][] objectArray) {
        if (objectArray != null) {
            Double d;
            Double d2;
            Double d3;
            Object[][] objectArray2;
            Double[][] doubleArrayArray;
            Double[] doubleArray;
            Double[] doubleArray2;
            Double[] doubleArray3;
            Double d4;
            Double d5;
            Double d6;
            try {
                d6 = Double.parseDouble(this.acellTextField1.getText());
                d5 = Double.parseDouble(this.acellTextField2.getText());
                d4 = Double.parseDouble(this.acellTextField3.getText());
            }
            catch (Exception exception) {
                this.printERR("Please setup acell !");
                return objectArray;
            }
            int n = this.rprimTable.getColumnCount();
            int n2 = this.rprimTable.getRowCount();
            Double[][] doubleArray4 = new Double[n2][n - 1];
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 1; j < n; ++j) {
                        try {
                            doubleArray4[i][j - 1] = (Double)this.rprimTable.getValueAt(i, j);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please setup rprim or angdeg (problem with getValue from rprimTable) !");
                            return objectArray;
                        }
                    }
                }
            } else {
                this.printERR("Please setup rprim or angdeg !");
                return objectArray;
            }
            if (this.rprimCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0], doubleArray4[0][1], doubleArray4[0][2]};
                doubleArray2 = new Double[]{doubleArray4[1][0], doubleArray4[1][1], doubleArray4[1][2]};
                doubleArray = new Double[]{doubleArray4[2][0], doubleArray4[2][1], doubleArray4[2][2]};
            } else if (this.rprimdCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0] / d6, doubleArray4[0][1] / d5, doubleArray4[0][2] / d4};
                doubleArray2 = new Double[]{doubleArray4[1][0] / d6, doubleArray4[1][1] / d5, doubleArray4[1][2] / d4};
                doubleArray = new Double[]{doubleArray4[2][0] / d6, doubleArray4[2][1] / d5, doubleArray4[2][2] / d4};
            } else {
                Double d7;
                Double d8;
                Double d9;
                Double d10;
                Double d11;
                Double d12;
                this.printDEB("ang1 = " + doubleArray4[0][0] + " ang2 = " + doubleArray4[1][0] + " ang3 = " + doubleArray4[2][0]);
                doubleArrayArray = doubleArray4[0][0];
                objectArray2 = doubleArray4[1][0];
                Double d13 = doubleArray4[2][0];
                if (doubleArrayArray.equals(objectArray2) && doubleArrayArray.equals(d13) && !doubleArrayArray.equals(90.0)) {
                    Double d14 = Math.cos(Math.PI * doubleArrayArray.doubleValue() / 180.0);
                    Double d15 = 0.6666666666666666 * (1.0 - d14);
                    Double d16 = Math.sqrt(d15);
                    Double d17 = Math.sqrt(1.0 - d15);
                    d3 = d16;
                    d12 = 0.0;
                    d11 = d17;
                    d2 = -0.5 * d16;
                    d10 = Math.sqrt(3.0) * 0.5 * d16;
                    d9 = d17;
                    d = -0.5 * d16;
                    d8 = -Math.sqrt(3.0) * 0.5 * d16;
                    d7 = d17;
                } else {
                    d3 = new Double(1.0);
                    d2 = new Double(Math.cos(Math.PI * d13 / 180.0));
                    d = new Double(Math.cos(Math.PI * objectArray2.doubleValue() / 180.0));
                    d12 = new Double(0.0);
                    d10 = new Double(Math.sin(Math.PI * d13 / 180.0));
                    d8 = new Double((Math.cos(Math.PI * doubleArrayArray.doubleValue() / 180.0) - d2 * d) / d10);
                    d11 = new Double(0.0);
                    d9 = new Double(0.0);
                    d7 = new Double(Math.sqrt(1.0 - Math.pow(d, 2.0) - Math.pow(d8, 2.0)));
                }
                doubleArray3 = new Double[]{d3, d12, d11};
                doubleArray2 = new Double[]{d2, d10, d9};
                doubleArray = new Double[]{d, d8, d7};
            }
            doubleArrayArray = new Double[][]{{doubleArray3[0] * d6, doubleArray3[1] * d6, doubleArray3[2] * d6}, {doubleArray2[0] * d5, doubleArray2[1] * d5, doubleArray2[2] * d5}, {doubleArray[0] * d4, doubleArray[1] * d4, doubleArray[2] * d4}};
            objectArray2 = new Object[objectArray.length][3];
            for (int i = 0; i < objectArray.length; ++i) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                for (int j = 0; j < 3; ++j) {
                    d3 = d3 + doubleArrayArray[0][j] * (Double)objectArray[i][j];
                    d2 = d2 + doubleArrayArray[1][j] * (Double)objectArray[i][j];
                    d = d + doubleArrayArray[2][j] * (Double)objectArray[i][j];
                }
                objectArray2[i] = new Double[]{new Double(d3 * 0.5291772108), new Double(d2 * 0.5291772108), new Double(d * 0.5291772108)};
            }
            return objectArray2;
        }
        return null;
    }

    private Object[][] xcart2xred(Object[][] objectArray) {
        if (objectArray != null) {
            Double d;
            Double d2;
            Object[][] objectArray2;
            Double d3;
            Double d4;
            Double[][] doubleArrayArray;
            Double d5;
            Double d6;
            Double d7;
            Double d8;
            Double d9;
            Double d10;
            Double d11;
            Double d12;
            Double[] doubleArray;
            Double[] doubleArray2;
            Double[] doubleArray3;
            Double d13;
            Double d14;
            Double d15;
            try {
                d15 = Double.parseDouble(this.acellTextField1.getText());
                d14 = Double.parseDouble(this.acellTextField2.getText());
                d13 = Double.parseDouble(this.acellTextField3.getText());
            }
            catch (Exception exception) {
                this.printERR("Please setup acell !");
                return objectArray;
            }
            int n = this.rprimTable.getColumnCount();
            int n2 = this.rprimTable.getRowCount();
            Double[][] doubleArray4 = new Double[n2][n - 1];
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 1; j < n; ++j) {
                        try {
                            doubleArray4[i][j - 1] = (Double)this.rprimTable.getValueAt(i, j);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please setup rprim or angdeg (wrong values) !");
                            return objectArray;
                        }
                    }
                }
            } else {
                this.printERR("Please setup rprim or angdeg !");
                return objectArray;
            }
            if (this.rprimCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0], doubleArray4[0][1], doubleArray4[0][2]};
                doubleArray2 = new Double[]{doubleArray4[1][0], doubleArray4[1][1], doubleArray4[1][2]};
                doubleArray = new Double[]{doubleArray4[2][0], doubleArray4[2][1], doubleArray4[2][2]};
            } else if (this.rprimdCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0] / d15, doubleArray4[0][1] / d14, doubleArray4[0][2] / d13};
                doubleArray2 = new Double[]{doubleArray4[1][0] / d15, doubleArray4[1][1] / d14, doubleArray4[1][2] / d13};
                doubleArray = new Double[]{doubleArray4[2][0] / d15, doubleArray4[2][1] / d14, doubleArray4[2][2] / d13};
            } else {
                Double[][] doubleArrayArray2;
                this.printDEB("ang1 = " + doubleArray4[0][0] + " ang2 = " + doubleArray4[1][0] + " ang3 = " + doubleArray4[2][0]);
                d12 = doubleArray4[0][0];
                d11 = doubleArray4[1][0];
                d10 = doubleArray4[2][0];
                if (d12.equals(d11) && d12.equals(d10) && !d12.equals(90.0)) {
                    d9 = Math.cos(Math.PI * d12 / 180.0);
                    d8 = 0.6666666666666666 * (1.0 - d9);
                    d7 = Math.sqrt(d8);
                    Double[][] doubleArrayArray3 = Double.valueOf(Math.sqrt(1.0 - d8));
                    d6 = d7;
                    d5 = 0.0;
                    doubleArrayArray = doubleArrayArray3;
                    d4 = -0.5 * d7;
                    d3 = Math.sqrt(3.0) * 0.5 * d7;
                    objectArray2 = doubleArrayArray3;
                    d2 = -0.5 * d7;
                    d = -Math.sqrt(3.0) * 0.5 * d7;
                    doubleArrayArray2 = doubleArrayArray3;
                } else {
                    d6 = new Double(1.0);
                    d4 = new Double(Math.cos(Math.PI * d10 / 180.0));
                    d2 = new Double(Math.cos(Math.PI * d11 / 180.0));
                    d5 = new Double(0.0);
                    d3 = new Double(Math.sin(Math.PI * d10 / 180.0));
                    d = new Double((Math.cos(Math.PI * d12 / 180.0) - d4 * d2) / d3);
                    doubleArrayArray = new Double(0.0);
                    objectArray2 = new Double(0.0);
                    doubleArrayArray2 = new Double(Math.sqrt(1.0 - Math.pow(d2, 2.0) - Math.pow(d, 2.0)));
                }
                doubleArray3 = new Double[]{d6, d5, doubleArrayArray};
                doubleArray2 = new Double[]{d4, d3, objectArray2};
                doubleArray = new Double[]{d2, d, doubleArrayArray2};
            }
            d12 = (doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray2[2] * d14 * doubleArray[1] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d11 = -(doubleArray3[1] * d15 * doubleArray[2] * d13 - doubleArray3[2] * d15 * doubleArray[1] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d10 = (doubleArray3[1] * d15 * doubleArray2[2] * d14 - doubleArray3[2] * d15 * doubleArray2[1] * d14) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d6 = -(doubleArray2[0] * d14 * doubleArray[2] * d13 - doubleArray2[2] * d14 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d4 = (doubleArray3[0] * d15 * doubleArray[2] * d13 - doubleArray3[2] * d15 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d2 = -(doubleArray3[0] * d15 * doubleArray2[2] * d14 - doubleArray3[2] * d15 * doubleArray2[0] * d14) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d5 = (doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray2[1] * d14 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d3 = -(doubleArray3[0] * d15 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d = (doubleArray3[0] * d15 * doubleArray2[1] * d14 - doubleArray3[1] * d15 * doubleArray2[0] * d14) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            doubleArrayArray = new Double[][]{{d12, d11, d10}, {d6, d4, d2}, {d5, d3, d}};
            objectArray2 = new Object[objectArray.length][3];
            for (int i = 0; i < objectArray.length; ++i) {
                d9 = 0.0;
                d8 = 0.0;
                d7 = 0.0;
                for (int j = 0; j < 3; ++j) {
                    d9 = d9 + doubleArrayArray[0][j] * (Double)objectArray[i][j];
                    d8 = d8 + doubleArrayArray[1][j] * (Double)objectArray[i][j];
                    d7 = d7 + doubleArrayArray[2][j] * (Double)objectArray[i][j];
                }
                objectArray2[i] = new Double[]{new Double(d9), new Double(d8), new Double(d7)};
            }
            return objectArray2;
        }
        return null;
    }

    private Object[][] xangst2xred(Object[][] objectArray) {
        if (objectArray != null) {
            Double d;
            Double d2;
            Object[][] objectArray2;
            Double d3;
            Double d4;
            Double[][] doubleArrayArray;
            Double d5;
            Double d6;
            Double d7;
            Double d8;
            Double d9;
            Double d10;
            Double d11;
            Double d12;
            Double[] doubleArray;
            Double[] doubleArray2;
            Double[] doubleArray3;
            Double d13;
            Double d14;
            Double d15;
            try {
                d15 = Double.parseDouble(this.acellTextField1.getText());
                d14 = Double.parseDouble(this.acellTextField2.getText());
                d13 = Double.parseDouble(this.acellTextField3.getText());
            }
            catch (Exception exception) {
                this.printERR("Please setup acell !");
                return objectArray;
            }
            int n = this.rprimTable.getColumnCount();
            int n2 = this.rprimTable.getRowCount();
            Double[][] doubleArray4 = new Double[n2][n - 1];
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 1; j < n; ++j) {
                        try {
                            doubleArray4[i][j - 1] = (Double)this.rprimTable.getValueAt(i, j);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please setup rprim or angdeg (wrong values) !");
                            return objectArray;
                        }
                    }
                }
            } else {
                this.printERR("Please setup rprim or angdeg !");
                return objectArray;
            }
            if (this.rprimCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0], doubleArray4[0][1], doubleArray4[0][2]};
                doubleArray2 = new Double[]{doubleArray4[1][0], doubleArray4[1][1], doubleArray4[1][2]};
                doubleArray = new Double[]{doubleArray4[2][0], doubleArray4[2][1], doubleArray4[2][2]};
            } else if (this.rprimdCheckBox.isSelected()) {
                doubleArray3 = new Double[]{doubleArray4[0][0] / d15, doubleArray4[0][1] / d14, doubleArray4[0][2] / d13};
                doubleArray2 = new Double[]{doubleArray4[1][0] / d15, doubleArray4[1][1] / d14, doubleArray4[1][2] / d13};
                doubleArray = new Double[]{doubleArray4[2][0] / d15, doubleArray4[2][1] / d14, doubleArray4[2][2] / d13};
            } else {
                Double[][] doubleArrayArray2;
                this.printDEB("ang1 = " + doubleArray4[0][0] + " ang2 = " + doubleArray4[1][0] + " ang3 = " + doubleArray4[2][0]);
                d12 = doubleArray4[0][0];
                d11 = doubleArray4[1][0];
                d10 = doubleArray4[2][0];
                if (d12.equals(d11) && d12.equals(d10) && !d12.equals(90.0)) {
                    d9 = Math.cos(Math.PI * d12 / 180.0);
                    d8 = 0.6666666666666666 * (1.0 - d9);
                    d7 = Math.sqrt(d8);
                    Double[][] doubleArrayArray3 = Double.valueOf(Math.sqrt(1.0 - d8));
                    d6 = d7;
                    d5 = 0.0;
                    doubleArrayArray = doubleArrayArray3;
                    d4 = -0.5 * d7;
                    d3 = Math.sqrt(3.0) * 0.5 * d7;
                    objectArray2 = doubleArrayArray3;
                    d2 = -0.5 * d7;
                    d = -Math.sqrt(3.0) * 0.5 * d7;
                    doubleArrayArray2 = doubleArrayArray3;
                } else {
                    d6 = new Double(1.0);
                    d4 = new Double(Math.cos(Math.PI * d10 / 180.0));
                    d2 = new Double(Math.cos(Math.PI * d11 / 180.0));
                    d5 = new Double(0.0);
                    d3 = new Double(Math.sin(Math.PI * d10 / 180.0));
                    d = new Double((Math.cos(Math.PI * d12 / 180.0) - d4 * d2) / d3);
                    doubleArrayArray = new Double(0.0);
                    objectArray2 = new Double(0.0);
                    doubleArrayArray2 = new Double(Math.sqrt(1.0 - Math.pow(d2, 2.0) - Math.pow(d, 2.0)));
                }
                doubleArray3 = new Double[]{d6, d5, doubleArrayArray};
                doubleArray2 = new Double[]{d4, d3, objectArray2};
                doubleArray = new Double[]{d2, d, doubleArrayArray2};
            }
            d12 = (doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray2[2] * d14 * doubleArray[1] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d11 = -(doubleArray3[1] * d15 * doubleArray[2] * d13 - doubleArray3[2] * d15 * doubleArray[1] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d10 = (doubleArray3[1] * d15 * doubleArray2[2] * d14 - doubleArray3[2] * d15 * doubleArray2[1] * d14) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d6 = -(doubleArray2[0] * d14 * doubleArray[2] * d13 - doubleArray2[2] * d14 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d4 = (doubleArray3[0] * d15 * doubleArray[2] * d13 - doubleArray3[2] * d15 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d2 = -(doubleArray3[0] * d15 * doubleArray2[2] * d14 - doubleArray3[2] * d15 * doubleArray2[0] * d14) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d5 = (doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray2[1] * d14 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d3 = -(doubleArray3[0] * d15 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray[0] * d13) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            d = (doubleArray3[0] * d15 * doubleArray2[1] * d14 - doubleArray3[1] * d15 * doubleArray2[0] * d14) / (doubleArray3[0] * d15 * doubleArray2[1] * d14 * doubleArray[2] * d13 - doubleArray3[0] * d15 * doubleArray2[2] * d14 * doubleArray[1] * d13 - doubleArray3[1] * d15 * doubleArray2[0] * d14 * doubleArray[2] * d13 + doubleArray3[1] * d15 * doubleArray2[2] * d14 * doubleArray[0] * d13 + doubleArray3[2] * d15 * doubleArray2[0] * d14 * doubleArray[1] * d13 - doubleArray3[2] * d15 * doubleArray2[1] * d14 * doubleArray[0] * d13);
            doubleArrayArray = new Double[][]{{d12, d11, d10}, {d6, d4, d2}, {d5, d3, d}};
            objectArray2 = new Object[objectArray.length][3];
            for (int i = 0; i < objectArray.length; ++i) {
                d9 = 0.0;
                d8 = 0.0;
                d7 = 0.0;
                for (int j = 0; j < 3; ++j) {
                    d9 = d9 + doubleArrayArray[0][j] * (Double)objectArray[i][j];
                    d8 = d8 + doubleArrayArray[1][j] * (Double)objectArray[i][j];
                    d7 = d7 + doubleArrayArray[2][j] * (Double)objectArray[i][j];
                }
                objectArray2[i] = new Double[]{new Double(d9 / 0.5291772108), new Double(d8 / 0.5291772108), new Double(d7 / 0.5291772108)};
            }
            return objectArray2;
        }
        return null;
    }

    private Object[][] xcart2xangst(Object[][] objectArray) {
        if (objectArray != null) {
            Object[][] objectArray2 = new Object[objectArray.length][3];
            for (int i = 0; i < objectArray.length; ++i) {
                Double d = (Double)objectArray[i][0];
                Double d2 = (Double)objectArray[i][1];
                Double d3 = (Double)objectArray[i][2];
                objectArray2[i] = new Double[]{new Double(d * 0.5291772108), new Double(d2 * 0.5291772108), new Double(d3 * 0.5291772108)};
            }
            return objectArray2;
        }
        return null;
    }

    private Object[][] xangst2xcart(Object[][] objectArray) {
        if (objectArray != null) {
            Object[][] objectArray2 = new Object[objectArray.length][3];
            for (int i = 0; i < objectArray.length; ++i) {
                Double d = (Double)objectArray[i][0];
                Double d2 = (Double)objectArray[i][1];
                Double d3 = (Double)objectArray[i][2];
                objectArray2[i] = new Double[]{new Double(d / 0.5291772108), new Double(d2 / 0.5291772108), new Double(d3 / 0.5291772108)};
            }
            return objectArray2;
        }
        return null;
    }

    public String getData() {
        int n;
        int n2;
        String string = new String();
        if (this.acellCheckBox.isSelected()) {
            try {
                double d = Double.parseDouble(this.acellTextField1.getText());
                double d2 = Double.parseDouble(this.acellTextField2.getText());
                double d3 = Double.parseDouble(this.acellTextField3.getText());
                string = d == d2 && d2 == d3 ? string + this.acellCheckBox.getText() + " 3*" + d + "\n\n" : string + this.acellCheckBox.getText() + " " + d + " " + d2 + " " + d3 + "\n\n";
            }
            catch (Exception exception) {
                this.printERR("Please set up ACELL !");
            }
        }
        if (this.natomCheckBox.isSelected()) {
            try {
                int n3 = Integer.parseInt(this.natomTextField.getText());
                string = string + this.natomCheckBox.getText() + " " + n3 + "\n\n";
            }
            catch (Exception exception) {
                this.printERR("Please set up NATOM !");
            }
        }
        if (this.natomCheckBox.isSelected()) {
            Enumeration<AbstractButton> enumeration = this.xyzbuttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                if (!jRadioButton.isSelected()) continue;
                int n4 = this.xyzTable.getColumnCount();
                n2 = this.xyzTable.getRowCount();
                if (n2 <= 0) continue;
                int n5 = jRadioButton.getText().length();
                string = string + jRadioButton.getText();
                for (int i = 0; i < n2; ++i) {
                    for (n = 0; n < n4; ++n) {
                        try {
                            string = string + " " + this.xyzTable.getValueAt(i, n);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please set up XYZ !");
                        }
                    }
                    string = string + "\n";
                    for (n = 0; n < n5; ++n) {
                        string = string + " ";
                    }
                }
                string = string + "\n";
            }
        }
        if (this.rprimCheckBox.isSelected()) {
            int n6 = this.rprimTable.getColumnCount();
            int n7 = this.rprimTable.getRowCount();
            if (n7 > 0) {
                string = string + this.rprimCheckBox.getText() + " ";
                for (int i = 0; i < n7; ++i) {
                    for (n2 = 1; n2 < n6; ++n2) {
                        try {
                            string = string + this.rprimTable.getValueAt(i, n2) + " ";
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please set up RPRIM !");
                        }
                    }
                    string = string + "\n      ";
                }
                string = string + "\n";
            }
        }
        if (this.rprimdCheckBox.isSelected()) {
            int n8 = this.rprimTable.getColumnCount();
            int n9 = this.rprimTable.getRowCount();
            if (n9 > 0) {
                string = string + this.rprimdCheckBox.getText() + " ";
                for (int i = 0; i < n9; ++i) {
                    for (n2 = 1; n2 < n8; ++n2) {
                        try {
                            string = string + this.rprimTable.getValueAt(i, n2) + " ";
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please set up RPRIMD !");
                        }
                    }
                    string = string + "\n       ";
                }
                string = string + "\n";
            }
        }
        if (this.angdegCheckBox.isSelected()) {
            int n10 = this.rprimTable.getColumnCount();
            int n11 = this.rprimTable.getRowCount();
            if (n11 > 0) {
                string = string + this.angdegCheckBox.getText() + " ";
                for (int i = 0; i < n11; ++i) {
                    for (n2 = 1; n2 < n10; ++n2) {
                        try {
                            string = string + this.rprimTable.getValueAt(i, n2) + " ";
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please set up ANGDEG !");
                        }
                    }
                }
                string = string + "\n\n";
            }
        }
        if (this.ntypatCheckBox.isSelected()) {
            try {
                int n12 = Integer.parseInt(this.ntypatTextField.getText());
                string = string + this.ntypatCheckBox.getText() + " " + n12 + "\n\n";
            }
            catch (Exception exception) {
                this.printERR("Please set up NTYPAT !");
            }
        }
        if (this.znuclCheckBox.isSelected()) {
            int n13 = this.znuclTable.getColumnCount();
            int n14 = this.znuclTable.getRowCount();
            String string2 = "";
            String string3 = "";
            if (n14 > 0) {
                string2 = string2 + this.znuclCheckBox.getText();
                string3 = string3 + this.typatCheckBox.getText();
                for (int i = 0; i < n14; ++i) {
                    try {
                        Atom atom = (Atom)this.znuclTable.getValueAt(i, 0);
                        n = (Integer)this.znuclTable.getValueAt(i, 3);
                        int n15 = (Integer)this.znuclTable.getValueAt(i, 2);
                        string2 = string2 + " " + atom.getZnucl();
                        this.printDEB(atom.getPSPPath() + "/" + atom.getPSPFileName());
                        for (int j = 0; j < n; ++j) {
                            string3 = string3 + " " + n15;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        this.printERR("Please set up ZNUCL/TYPAT !");
                    }
                }
                string = string + string3 + "\n\n";
                string = string + string2 + "\n\n";
            }
        }
        if (this.nsymCheckBox.isSelected()) {
            try {
                int n16 = Integer.parseInt(this.nsymTextField.getText());
                string = string + this.nsymCheckBox.getText() + " " + n16 + "\n\n";
            }
            catch (Exception exception) {
                this.printERR("Please set up NSYM !");
            }
        }
        if (this.symrelCheckBox.isSelected()) {
            int n17 = this.symrelTable.getColumnCount();
            int n18 = this.symrelTable.getRowCount();
            if (n18 > 0) {
                int n19 = this.symrelCheckBox.getText().length();
                string = string + this.symrelCheckBox.getText();
                for (int i = 0; i < n18; ++i) {
                    int n20;
                    for (n20 = 0; n20 < n17; ++n20) {
                        try {
                            string = string + " " + this.symrelTable.getValueAt(i, n20);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please set up SYMREL !");
                        }
                    }
                    string = string + "\n";
                    for (n20 = 0; n20 < n19; ++n20) {
                        string = string + " ";
                    }
                }
                string = string + "\n";
            }
        }
        if (this.tnonsCheckBox.isSelected()) {
            int n21 = this.tnonsTable.getColumnCount();
            int n22 = this.tnonsTable.getRowCount();
            if (n22 > 0) {
                int n23 = this.tnonsCheckBox.getText().length();
                string = string + this.tnonsCheckBox.getText();
                for (int i = 0; i < n22; ++i) {
                    int n24;
                    for (n24 = 0; n24 < n21; ++n24) {
                        try {
                            string = string + " " + this.tnonsTable.getValueAt(i, n24);
                            continue;
                        }
                        catch (Exception exception) {
                            this.printERR("Please set up TNONS !");
                        }
                    }
                    string = string + "\n";
                    for (n24 = 0; n24 < n23; ++n24) {
                        string = string + " ";
                    }
                }
                string = string + "\n";
            }
        }
        return string;
    }

    public JTable getZnuclTable() {
        return this.znuclTable;
    }

    public String getNtypat() {
        if (this.ntypatCheckBox.isSelected()) {
            return this.ntypatTextField.getText();
        }
        return "0";
    }
}

