/*
 * Decompiled with CFR 0.152.
 */
package abinitgui;

import abinitgui.Atom;
import abinitgui.Geometry;
import abinitgui.MainFrame;
import abinitgui.MendTabDialog;
import abinitgui.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class AtomEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    Atom currentAtom;
    JButton but = new JButton();
    MendTabDialog dialog;
    MainFrame mainFrame;
    Geometry geomFrame;
    protected static final String CMD = "setAtom";

    public AtomEditor(MainFrame mainFrame) {
        this.but.setActionCommand(CMD);
        this.but.addActionListener(this);
        this.but.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.but.setBackground(Color.darkGray);
        this.dialog = new MendTabDialog(mainFrame, true, this);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (CMD.equals(string)) {
            String string2 = this.mainFrame.pspPathTextField.getText();
            String string3 = this.dialog.getPSPSelected();
            Object[][] objectArray = Atom.getAtomsBD();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.setAtomButton((String)objectArray[i][0], string3, string2);
            }
            this.dialog.setLocationRelativeTo(this.mainFrame);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else if (!string.equals("OK") && !string.equals("cancel")) {
            if (string.equals("GGA_FHI") || string.equals("GGA_HGH") || string.equals("LDA_Core") || string.equals("LDA_FHI") || string.equals("LDA_GTH") || string.equals("LDA_HGH") || string.equals("LDA_TM") || string.equals("LDA_Teter")) {
                String string4 = this.mainFrame.pspPathTextField.getText();
                Object[][] objectArray = Atom.getAtomsBD();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.setAtomButton((String)objectArray[i][0], string, string4);
                }
            } else if (string.equals("UserPSP")) {
                this.dialog.setVisible(false);
                JFileChooser jFileChooser = new JFileChooser(".");
                File file = new File(".");
                String string5 = file.getAbsolutePath();
                String string6 = string5.replace("\\", "/").replace(".", "");
                this.mainFrame.printDEB(string6);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showOpenDialog(this.mainFrame);
                if (n == 0) {
                    File file2 = jFileChooser.getSelectedFile();
                    String string7 = file2.getAbsolutePath().replace("\\", "/").replace(string6, "./");
                    this.mainFrame.printDEB(string7);
                    int n2 = this.pspReader(string7);
                    if (n2 > 0) {
                        this.currentAtom.setByZNucl(n2);
                        this.currentAtom.setPSPType("UserPSP");
                        String string8 = string7.replace('\\', '/');
                        String string9 = Utils.getLastToken(string8, "/");
                        String string10 = string8.replaceAll("/" + string9, "");
                        this.currentAtom.setPSPPath(string10);
                        this.currentAtom.setPSPFileName(string9);
                    } else {
                        this.mainFrame.printERR("Problem in reading the pseudopotential file !");
                    }
                } else {
                    this.mainFrame.printERR("You canceled the pseudo-potential file chooser !");
                }
            } else {
                this.dialog.setVisible(false);
                String string11 = this.dialog.getPSPSelected();
                String string12 = this.mainFrame.pspPathTextField.getText();
                if (!string12.equals("")) {
                    this.setAtomParse(this.currentAtom, string, string11, string12);
                } else {
                    this.mainFrame.printERR("Please setup the path to the pseudopotentials at the config. tab !");
                    this.currentAtom.setPSPPath("");
                    this.currentAtom.setPSPFileName("");
                    this.currentAtom.setName("");
                    this.currentAtom.setSymbol("");
                    this.currentAtom.setPSPType("");
                    this.currentAtom.setTypat(0);
                    this.currentAtom.setZnucl(0);
                }
            }
        }
    }

    public static void setAtom(Atom atom, String string, String string2, String string3, String string4) {
        atom.setBySymbol(string);
        atom.setPSPType(string2);
        atom.setPSPPath(string3);
        atom.setPSPFileName(string4);
        String string5 = string3 + "/" + string4;
        if (Utils.exists(string5)) {
            System.out.println("The file " + string5 + " exists!");
        } else {
            System.err.println("The file " + string5 + " doesn't exist!");
        }
    }

    private void setAtomParse(Atom atom, String string, String string2, String string3) {
        atom.setBySymbol(string);
        atom.setPSPType(string2);
        if (string2.equals("GGA_FHI")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            String string4 = "";
            if (n < 10) {
                string4 = string4 + "0";
            }
            string4 = string4 + n + "-" + string + ".GGA.fhi";
            atom.setPSPFileName(string4);
            String string5 = string3 + "/" + string2 + "/" + string4;
            if (Utils.exists(string5)) {
                System.out.println("The file " + string5 + " exists!");
            } else {
                this.mainFrame.printERR("The file " + string5 + " doesn't exist!");
            }
        } else if (string2.equals("GGA_HGH")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            String string6 = "";
            if (n < 10) {
                string6 = string6 + "0";
            }
            string6 = string6 + n + string.toLowerCase() + ".pbe_hgh";
            atom.setPSPFileName(string6);
            String string7 = string3 + "/" + string2 + "/" + string6;
            if (Utils.exists(string7)) {
                System.out.println("The file " + string7 + " exists!");
            } else {
                this.mainFrame.printERR("The file " + string7 + " doesn't exist!");
            }
        } else if (string2.equals("LDA_Core")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            String string8 = n + string.toLowerCase() + ".1s_psp.mod";
            atom.setPSPFileName(string8);
            String string9 = string3 + "/" + string2 + "/" + string8;
            if (Utils.exists(string9)) {
                System.out.println("The file " + string9 + " exists!");
            } else {
                this.mainFrame.printERR("The file " + string9 + " doesn't exist!");
            }
        } else if (string2.equals("LDA_FHI")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            String string10 = "";
            if (n < 10) {
                string10 = string10 + "0";
            }
            string10 = string10 + n + "-" + string + ".LDA.fhi";
            atom.setPSPFileName(string10);
            String string11 = string3 + "/" + string2 + "/" + string10;
            if (Utils.exists(string11)) {
                System.out.println("The file " + string11 + " exists!");
            } else {
                this.mainFrame.printERR("The file " + string11 + " doesn't exist!");
            }
        } else if (string2.equals("LDA_GTH")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            String string12 = "";
            if (n < 10) {
                string12 = string12 + "0";
            }
            string12 = string12 + n + string.toLowerCase() + ".pspgth";
            atom.setPSPFileName(string12);
            String string13 = string3 + "/" + string2 + "/" + string12;
            if (Utils.exists(string13)) {
                System.out.println("The file " + string13 + " exists!");
            } else {
                this.mainFrame.printERR("The file " + string13 + " doesn't exist!");
            }
        } else if (string2.equals("LDA_HGH")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            int n2 = 1;
            String string14 = n + string.toLowerCase() + "." + n2 + ".hgh";
            atom.setPSPFileName(string14);
        } else if (string2.equals("LDA_TM")) {
            int n = atom.getZnucl();
            String string15 = "";
            if (n < 10) {
                string15 = string15 + "0";
            }
            string15 = string15 + n;
            string = string.replaceAll("Rf", "Unq");
            string = string.replaceAll("Db", "Unp");
            string = string.replaceAll("Sg", "Unh");
            string = string.replaceAll("Bh", "Uns");
            string = string.replaceAll("Hs", "Uno");
            string = string.replaceAll("Mt", "Une");
            string = string.replaceAll("Ds", "Uun");
            string = string.replaceAll("Rg", "Uuu");
            string = string.replaceAll("Cn", "Uub");
            String string16 = n + string.toLowerCase() + ".pspnc";
            atom.setPSPFileName(string16);
            atom.setPSPPath(string3 + "/" + string2 + ".psps/" + string15);
            String string17 = string3 + "/" + string2 + ".psps/" + string15 + "/" + string16;
            if (Utils.exists(string17)) {
                System.out.println("The file " + string17 + " exists!");
            } else {
                this.mainFrame.printERR("The file " + string17 + " doesn't exist!");
            }
        } else if (string2.equals("LDA_Teter")) {
            atom.setPSPPath(string3 + "/" + string2);
            int n = atom.getZnucl();
            String string18 = "";
            String string19 = n + string.toLowerCase() + "." + string18 + ".mod";
            atom.setPSPFileName(string19);
        } else {
            this.mainFrame.printERR("No pseudopotential type defined !");
            atom.setPSPPath("");
            atom.setPSPFileName("");
            atom.setName("");
            atom.setSymbol("");
            atom.setPSPType("");
            atom.setTypat(0);
            atom.setZnucl(0);
        }
    }

    private void setAtomButton(String string, String string2, String string3) {
        JButton jButton = this.dialog.getMendButton(string);
        if (jButton == null) {
            return;
        }
        if (string2.equals("GGA_FHI")) {
            int n = Atom.getZnuclBySymbol(string);
            String string4 = "";
            if (n < 10) {
                string4 = string4 + "0";
            }
            string4 = string4 + n + "-" + string + ".GGA.fhi";
            String string5 = string3 + "/" + string2 + "/" + string4;
            if (Utils.exists(string5)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("GGA_HGH")) {
            int n = Atom.getZnuclBySymbol(string);
            String string6 = "";
            if (n < 10) {
                string6 = string6 + "0";
            }
            string6 = string6 + n + string.toLowerCase() + ".pbe_hgh";
            String string7 = string3 + "/" + string2 + "/" + string6;
            if (Utils.exists(string7)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("LDA_Core")) {
            int n = Atom.getZnuclBySymbol(string);
            String string8 = n + string.toLowerCase() + ".1s_psp.mod";
            String string9 = string3 + "/" + string2 + "/" + string8;
            if (Utils.exists(string9)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("LDA_FHI")) {
            int n = Atom.getZnuclBySymbol(string);
            String string10 = "";
            if (n < 10) {
                string10 = string10 + "0";
            }
            string10 = string10 + n + "-" + string + ".LDA.fhi";
            String string11 = string3 + "/" + string2 + "/" + string10;
            if (Utils.exists(string11)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("LDA_GTH")) {
            int n = Atom.getZnuclBySymbol(string);
            String string12 = "";
            if (n < 10) {
                string12 = string12 + "0";
            }
            string12 = string12 + n + string.toLowerCase() + ".pspgth";
            String string13 = string3 + "/" + string2 + "/" + string12;
            if (Utils.exists(string13)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("LDA_HGH")) {
            int n = Atom.getZnuclBySymbol(string);
            int n2 = 1;
            String string14 = n + string.toLowerCase() + "." + n2 + ".hgh";
            if (Utils.exists(string14)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("LDA_TM")) {
            int n = Atom.getZnuclBySymbol(string);
            String string15 = "";
            if (n < 10) {
                string15 = string15 + "0";
            }
            string15 = string15 + n;
            string = string.replaceAll("Rf", "Unq");
            string = string.replaceAll("Db", "Unp");
            string = string.replaceAll("Sg", "Unh");
            string = string.replaceAll("Bh", "Uns");
            string = string.replaceAll("Hs", "Uno");
            string = string.replaceAll("Mt", "Une");
            string = string.replaceAll("Ds", "Uun");
            string = string.replaceAll("Rg", "Uuu");
            string = string.replaceAll("Cn", "Uub");
            String string16 = n + string.toLowerCase() + ".pspnc";
            String string17 = string3 + "/" + string2 + ".psps/" + string15 + "/" + string16;
            if (Utils.exists(string17)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else if (string2.equals("LDA_Teter")) {
            int n = Atom.getZnuclBySymbol(string);
            String string18 = "";
            String string19 = n + string.toLowerCase() + "." + string18 + ".mod";
            if (Utils.exists(string19)) {
                jButton.setBackground(Color.GREEN);
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        } else {
            System.err.println("No pseudopotential type defined !");
        }
    }

    private int pspReader(String string) {
        Object object;
        double d = 0.0;
        String string2 = "";
        String string3 = "";
        try {
            object = new FileReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader((Reader)object);
            string2 = lineNumberReader.readLine();
            string3 = lineNumberReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File " + string + " doesn't exist!");
            return 0;
        }
        catch (IOException iOException) {
            System.err.println("Problem in reading the first two lines of file " + string + "!");
            return 0;
        }
        System.out.println("----------- Line 1 -----------");
        System.out.println(string2);
        object = new StringTokenizer(string3, " ,:\t", false);
        if (((StringTokenizer)object).countTokens() != 6) {
            System.err.println("Problem in line 2");
            return 0;
        }
        d = Double.parseDouble(((StringTokenizer)object).nextToken());
        double d2 = Double.parseDouble(((StringTokenizer)object).nextToken());
        String string4 = ((StringTokenizer)object).nextToken();
        System.out.println("----------- Line 2 -----------");
        System.out.println("zatom = " + d + "\n" + "zion = " + d2 + "\n" + "pspdat = " + string4);
        return (int)d;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentAtom;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentAtom = (Atom)object;
        return this.but;
    }
}

