!{\src2tex{textfont=tt}}
!!****f* ABINIT/outphdos
!! NAME
!! outdos
!! structured variables.
!!
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!  only write
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine outphdos(deltaene,dos_phon,enemin,enemax,filnam,g2fsmear,mband,nene,nqpt,ntetra,telphint,unit_phdos)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mband,nene,nqpt,ntetra,telphint,unit_phdos
 character(len=fnlen),intent(in) :: filnam
 real(dp) :: deltaene,enemin,enemax,g2fsmear
!arrays
 real(dp) :: dos_phon(nene)

!Local variables-------------------------------
!scalars
 integer :: iband,ikpt,iomega,iost
 real(dp) :: omega
 character(len=fnlen) :: outfile
 character(len=500) :: message
!arrays

! *************************************************************************

 outfile = trim(filnam) // '_PDS'
 open (unit=unit_phdos,file=outfile,status='replace',iostat=iost)
 if (iost /= 0) then
  write (message,'(3a)')' thmeig : ERROR- opening file ',trim(outfile),' as new'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

 write (*,*) 'phonon DOS'
 write (unit_phdos,'(a)') '#'
 write (unit_phdos,'(a)') '# ABINIT package : phonon DOS file'
 write (unit_phdos,'(a)') '#'
 write (unit_phdos,'(a,I10)') '#     number of Qpoints integrated over : ', nqpt
 write (unit_phdos,'(a,I10)') '#     number of energy points : ', nene
 write (unit_phdos,'(a,E16.6,a,E16.6,a)') '#       between omega_min = ', enemin, &
& ' Ha and omega_max = ', enemax, ' Ha'
 if(telphint==1)then
  write (unit_phdos,'(a,E16.6)') '#   and the smearing width for gaussians is ', g2fsmear
  write (unit_phdos,'(a)') '#'
 end if
 if(telphint==0)then
  write (unit_phdos,'(a,I10)') '#   number of tetrahedrons', ntetra
  write (unit_phdos,'(a)') '#'
 end if

 omega = enemin
 do iomega=1,nene
  write (*,*) omega, dos_phon(iomega)
  write (unit_phdos,*) omega*Ha_eV*1000, dos_phon(iomega)
  omega=omega+deltaene
 end do
 
 close (unit=unit_phdos)

end subroutine outphdos
!!***
