!{\src2tex{textfont=tt}}
!!****f* ABINIT/symdij
!! NAME
!! symdij
!!
!! FUNCTION
!! Symmetrize dij quantities (psp strengths)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  gprimd(3,3)=dimensional primitive translations for reciprocal space(bohr^-1).
!!  indlmn(6,lmnmax,ntypat)=array giving l,m,n,lm,ln,spin for i=lmn (for each atom type)
!!  indsym(4,nsym,natom)=indirect indexing array for atom labels
!!  lmnmax=maximum number of PAW radial wavefunctions
!!  natom=number of atoms in cell
!!  nsym=number of symmetry elements in space group
!!  ntypat=number of types of atoms in unit cell.
!!  option_dij=choose which part of Dij has to be symetrized (which paw_ij(:)%dijxxx):
!!             0: total dij (dij)
!!             1: dij due to compensation charge (dijhat)
!!             2: dij due to +U (dijU)
!!             3: dij XC (dijxc)
!!             4: dij XC valence only (dijxc_val)
!!             5: dij spin-orbit (dijso)
!!  paw_ij(natom)%lmn_size=number of (l,m,n) elements for the paw basis
!!  paw_ij(natom)%nspden=number of spin-density components
!!  paw_ij(natom)%dij(lmn2_size,nspden)=non-symetrized paw dij quantities
!!  pawang <type(pawang_type)>=angular mesh discretization and related data
!!  pawprtvol=control print volume and debugging output for PAW
!!  rprimd(3,3)=real space primitive translations.
!!  symafm(nsym)=(anti)ferromagnetic part of symmetry operations
!!  symrec(3,3,nsym)=symmetries of group in terms of operations on
!!                   reciprocal space primitive translations
!!  typat(natom)=type for each atom
!!
!! SIDE EFFECTS
!!    paw_ij(natom)%dij(cplex_dij*lmn2_size,nspden)=symetrized dij quantities as output
!!
!! PARENTS
!!      respfn,scfcv,sigma
!!
!! CHILDREN
!!      leave_new,print_ij,symredcart,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine symdij(gprimd,indlmn,indsym,lmnmax,natom,nsym,ntypat,option_dij,&
&                 paw_ij,pawang,pawprtvol,rprimd,symafm,symrec,typat)

 use defs_basis
 use defs_datatypes
 use m_io_tools, only : flush_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_12geometry
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: lmnmax,natom,nsym,ntypat,option_dij,pawprtvol
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat),indsym(4,nsym,natom)
 integer,intent(in) :: symafm(nsym),symrec(3,3,nsym),typat(natom)
 real(dp),intent(in) :: gprimd(3,3),rprimd(3,3)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)

!Local variables ---------------------------------------
!scalars
 integer :: at_indx,cplex_dij,iafm,iatom,il,il0,ilmn,iln,iln0,ilpm,indexi,indexii,indexj
 integer :: indexjj,indexjj0,indexk,indexkc,iplex,irot,irotaf,ispden,itypat,j0lmn,jj,jl,jl0
 integer :: jlmn,jln,jln0,jlpm,jspden,klmn,klmnc,kspden,lmn_size,mi,mj,mu,natinc,ndij0,ndij1,nu
 logical,parameter :: afm_noncoll=.true.  ! TRUE if antiferro symmetries are used with non-collinear magnetism
 real(dp) :: factafm,zarot2
 logical :: antiferro,noncoll,use_afm
 character(len=500) :: message
!arrays
 integer :: nsym_used(2)
 integer,allocatable :: idum(:)
 real(dp) :: sumdij(2,2)
 real(dp),allocatable :: dijnew(:,:),dijtmp(:,:),rotmag(:,:),summag(:,:),symrec_cart(:,:,:),work(:,:)
 character(len=7),parameter :: dspin(6)=(/"up     ","down   ","up-up  ","dwn-dwn","up-dwn ","dwn-up "/)
!no_abirules
  type dij_at
   real(dp),pointer :: dij(:,:)
  end type
  type(dij_at),allocatable :: tmp(:)

! *********************************************************************

#if defined DEBUG_MODE
 write(message,'(a)')' symdij : enter '
 call wrtout(std_out,message,'COLL') 
 call flush_unit(std_out)
#endif

!Test of compatibility:
 if ((option_dij==1.and.paw_ij(1)%has_dijhat==0).or.&
& (option_dij==2.and.paw_ij(1)%has_dijU==0).or.&
& (option_dij==3.and.paw_ij(1)%has_dijxc==0).or.&
& (option_dij==4.and.paw_ij(1)%has_dijxc_val==0).or.&
& (option_dij==5.and.paw_ij(1)%has_dijso==0)) then
  write(message,'(a,a,a)') ' symdij : BUG -',ch10,&
&  ' Incompatibilty between option_dij and allocation of Dij !'
  call wrtout(6,message,'PERS')
  call leave_new('PERS')
 end if

!Symetrization occurs only when nsym>1 and nsploop/=4
 if (nsym>1) then

  cplex_dij=paw_ij(1)%cplex_dij
! Antiferro case ?
  antiferro=(paw_ij(1)%nspden==2.and.paw_ij(1)%nsppol==1.and.paw_ij(1)%ndij/=4)
! Non-collinear case
  noncoll=(paw_ij(1)%ndij==4)
  if (noncoll.and.paw_ij(1)%cplex_dij/=2) stop "BUG in symdij; cplex_dij must be 2 with ndij=4 !"
  if (noncoll) then
   allocate(summag(cplex_dij,3),rotmag(cplex_dij,3),work(cplex_dij,3))
   allocate(symrec_cart(3,3,nsym))
   do irot=1,nsym
    call symredcart(gprimd,rprimd,symrec_cart(:,:,irot),symrec(:,:,irot))
   end do
  end if
! Do we use antiferro symmetries ?
  use_afm=((antiferro).or.(noncoll.and.afm_noncoll))

! Have to make a temporary copy of dij
  allocate(tmp(natom))
  do iatom=1,natom
   allocate(tmp(iatom)%dij(paw_ij(iatom)%cplex_dij*paw_ij(iatom)%lmn2_size,paw_ij(iatom)%ndij))
   allocate(dijtmp(paw_ij(iatom)%cplex_dij*paw_ij(iatom)%lmn2_size,paw_ij(iatom)%ndij))
   if (option_dij==0) then
    dijtmp(:,:)=paw_ij(iatom)%dij(:,:)
!   If spin-orbit, substract spin-orbit contribution
    if (paw_ij(iatom)%has_dijso==2) dijtmp(:,:)=dijtmp(:,:)-paw_ij(iatom)%dijso(:,:)
   else if (option_dij==1) then
    dijtmp(:,:)=paw_ij(iatom)%dijhat(:,:)
   else if (option_dij==2) then
    dijtmp(:,:)=paw_ij(iatom)%dijU(:,:)
   else if (option_dij==3) then
    dijtmp(:,:)=paw_ij(iatom)%dijxc(:,:)
   else if (option_dij==4) then
    dijtmp(:,:)=paw_ij(iatom)%dijxc_val(:,:)
   else if (option_dij==5) then
    dijtmp(:,:)=paw_ij(iatom)%dijso(:,:)
   end if
   if (noncoll) then  ! Has to translate Dij^{alpha,beta} into (Dij, Dij magnetization) format
    tmp(iatom)%dij(:,1)=dijtmp(:,1)+dijtmp(:,2)
    tmp(iatom)%dij(:,2)=dijtmp(:,3)+dijtmp(:,4)
    tmp(iatom)%dij(:,4)=dijtmp(:,1)-dijtmp(:,2)
    do klmn=1,paw_ij(iatom)%lmn2_size
     tmp(iatom)%dij(2*klmn-1,3)=-dijtmp(2*klmn  ,3)+dijtmp(2*klmn  ,4)
     tmp(iatom)%dij(2*klmn  ,3)= dijtmp(2*klmn-1,3)-dijtmp(2*klmn-1,4)
    end do
   else
    tmp(iatom)%dij(:,:)=dijtmp(:,:)
   end if
   deallocate(dijtmp)
  end do

  ndij1=1
  if (antiferro) ndij1=2
  if (noncoll)   ndij1=4
  ndij0=ndij1-1
  allocate(dijnew(cplex_dij,ndij1))

! Loops over atoms and spin components
  do iatom=1,natom
   itypat=typat(iatom)
   lmn_size=paw_ij(iatom)%lmn_size
   cplex_dij=paw_ij(iatom)%cplex_dij

   do ispden=1,paw_ij(iatom)%nsppol
    jspden=min(3-ispden,paw_ij(iatom)%nsppol)

!   Loops over (il,im) and (jl,jm)
    jl0=-1;jln0=-1;indexj=1
    do jlmn=1,lmn_size
     jl=indlmn(1,jlmn,itypat)
     jlpm=1+jl+indlmn(2,jlmn,itypat)
     jln=indlmn(5,jlmn,itypat)
     if (jln/=jln0) indexj=indexj+2*jl0+1
     j0lmn=jlmn*(jlmn-1)/2
     il0=-1;iln0=-1;indexi=1
     do ilmn=1,jlmn
      il=indlmn(1,ilmn,itypat)
      ilpm=1+il+indlmn(2,ilmn,itypat)
      iln=indlmn(5,ilmn,itypat)
      if (iln/=iln0) indexi=indexi+2*il0+1
      klmn=j0lmn+ilmn;klmnc=cplex_dij*(klmn-1)

      nsym_used(:)=0
      sumdij(:,:)=zero
      if (noncoll) rotmag(:,:)=zero

!     Loop over symmetries
      do irot=1,nsym

       if ((symafm(irot)/=1).and.(.not.use_afm)) cycle
       kspden=ispden;if (symafm(irot)==-1) kspden=jspden
       iafm=1;if ((antiferro).and.(symafm(irot)==-1)) iafm=2
       factafm=dble(symafm(irot))

       nsym_used(iafm)=nsym_used(iafm)+1
       at_indx=indsym(4,irot,iatom)
       if (noncoll) summag(:,:)=zero

!      Accumulate values over (mi,mj) and symmetries
       do mj=1,2*jl+1
        indexjj=indexj+mj;indexjj0=indexjj*(indexjj-1)/2
        do mi=1,2*il+1
         indexii=indexi+mi
         if (indexii<=indexjj) then
          indexk=indexjj0+indexii
         else
          indexk=indexii*(indexii-1)/2+indexjj
         end if
         indexkc=cplex_dij*(indexk-1)
!        Be careful: use here R_rel^-1 in term of spherical harmonics
!        which is tR_rec in term of spherical harmonics
!        so, use transpose[zarot]
         zarot2=pawang%zarot(mi,ilpm,il+1,irot)*pawang%zarot(mj,jlpm,jl+1,irot)
!        zarot2=pawang%zarot(ilpm,mi,il+1,irot)*pawang%zarot(jlpm,mj,jl+1,irot)

         do iplex=1,cplex_dij
          sumdij(iplex,iafm)=sumdij(iplex,iafm)+zarot2*tmp(at_indx)%dij(indexkc+iplex,kspden)
         end do

         if (noncoll) then
          do mu=1,3
           do iplex=1,cplex_dij
            summag(iplex,mu)=summag(iplex,mu)+factafm*zarot2*tmp(at_indx)%dij(indexkc+iplex,1+mu)
           end do
          end do
         end if

        end do
       end do

!      If non-collinear case, rotate Dij magnetization
       if (noncoll) then
!       Should use symrel^1 but use transpose[symrec] instead
        do nu=1,3
         do mu=1,3
          rotmag(1:cplex_dij,mu)=rotmag(1:cplex_dij,mu)+symrec_cart(nu,mu,irot)*summag(1:cplex_dij,nu)
         end do
        end do
       end if

      end do ! End loop over symmetries

!     Store new value of dij
      do iplex=1,cplex_dij
       dijnew(iplex,1)=sumdij(iplex,1)/nsym_used(1)
       if (abs(dijnew(iplex,1))<=tol10) dijnew(iplex,1)=zero
      end do

!     Antiferromagnetic case: has to fill up "down" component of dij
      if (antiferro.and.nsym_used(2)>0) then
       do iplex=1,cplex_dij
        dijnew(iplex,2)=sumdij(iplex,2)/nsym_used(2)
        if (abs(dijnew(iplex,2))<=tol10) dijnew(iplex,2)=zero
       end do
      end if

!     Non-collinear case: store new values of Dij magnetization
      if (noncoll) then
!      Select on-zero elements
       do mu=1,3
        do iplex=1,cplex_dij
         rotmag(iplex,mu)=rotmag(iplex,mu)/nsym_used(1)
         if (abs(rotmag(iplex,mu))<=tol10) rotmag(iplex,mu)=zero
        end do
       end do
!      Transfer back to Dij^{alpha,beta}
       dijnew(1,1)=half*(dijnew(1,1)+rotmag(1,3))
       dijnew(2,1)=half*(dijnew(2,1)+rotmag(2,3))
       dijnew(1,2)=      dijnew(1,1)-rotmag(1,3)
       dijnew(2,2)=      dijnew(2,1)-rotmag(2,3)
       dijnew(1,3)=half*(rotmag(1,1)+rotmag(2,2))
       dijnew(2,3)=half*(rotmag(2,1)-rotmag(1,2))
       dijnew(1,4)=half*(rotmag(1,1)-rotmag(2,2))
       dijnew(2,4)=half*(rotmag(2,1)+rotmag(1,2))
      end if

!     Transfer new value of Dij in suitable pointer
      if (option_dij==0) then
       paw_ij(iatom)%dij(klmnc+1:klmnc+cplex_dij,ispden:ispden+ndij0)=dijnew(1:cplex_dij,1:ndij1)
      else if (option_dij==1) then
       paw_ij(iatom)%dijhat(klmnc+1:klmnc+cplex_dij,ispden:ispden+ndij0)=dijnew(1:cplex_dij,1:ndij1)
      else if (option_dij==2) then
       paw_ij(iatom)%dijU(klmnc+1:klmnc+cplex_dij,ispden:ispden+ndij0)=dijnew(1:cplex_dij,1:ndij1)
      else if (option_dij==3) then
       paw_ij(iatom)%dijxc(klmnc+1:klmnc+cplex_dij,ispden:ispden+ndij0)=dijnew(1:cplex_dij,1:ndij1)
      else if (option_dij==4) then
       paw_ij(iatom)%dijxc_val(klmnc+1:klmnc+cplex_dij,ispden:ispden+ndij0)=dijnew(1:cplex_dij,1:ndij1)
      else if (option_dij==5) then
       paw_ij(iatom)%dijso(klmnc+1:klmnc+cplex_dij,ispden:ispden+ndij0)=dijnew(1:cplex_dij,1:ndij1)
      end if

      il0=il;iln0=iln  ! End loops over (il,im) and (jl,jm)
     end do
     jl0=jl;jln0=jln
    end do
   end do ! ispden
  end do ! iatom

  deallocate(dijnew)
  if (noncoll) deallocate(summag,rotmag,symrec_cart,work)
  do iatom=1,natom
   deallocate(tmp(iatom)%dij)
  end do
  deallocate(tmp)

! If spin-orbit, add again spin-orbit contribution
  if (option_dij==0.and.paw_ij(1)%has_dijso==2) then
   do iatom=1,natom
    paw_ij(iatom)%dij(:,:)=paw_ij(iatom)%dij(:,:)+paw_ij(iatom)%dijso(:,:)
   end do
  end if

 else  ! nsym>1

! *********************************************************************
! If nsym==1, only cut small components of dij

  if(paw_ij(1)%nspden==2.and.paw_ij(1)%nsppol==1) then
   write(message,'(a,a,a)') ' symdij : BUG -',ch10,&
&   ' In the antiferromagnetic case, nsym cannot be 1'
   call wrtout(6,message,'PERS')
   call leave_new('PERS')
  end if
  do iatom=1,natom
   do ispden=1,paw_ij(iatom)%ndij

    if (option_dij==0) then
     do klmn=1,paw_ij(iatom)%lmn2_size*paw_ij(iatom)%cplex_dij
      if (abs(paw_ij(iatom)%dij(klmn,ispden))<=tol10) paw_ij(iatom)%dij(klmn,ispden)=zero
     end do
    else if (option_dij==1) then
     do klmn=1,paw_ij(iatom)%lmn2_size*paw_ij(iatom)%cplex_dij
      if (abs(paw_ij(iatom)%dijhat(klmn,ispden))<=tol10) paw_ij(iatom)%dijhat(klmn,ispden)=zero
     end do
    else if (option_dij==2) then
     do klmn=1,paw_ij(iatom)%lmn2_size*paw_ij(iatom)%cplex_dij
      if (abs(paw_ij(iatom)%dijU(klmn,ispden))<=tol10) paw_ij(iatom)%dijU(klmn,ispden)=zero
     end do
    else if (option_dij==3) then
     do klmn=1,paw_ij(iatom)%lmn2_size*paw_ij(iatom)%cplex_dij
      if (abs(paw_ij(iatom)%dijxc(klmn,ispden))<=tol10) paw_ij(iatom)%dijxc(klmn,ispden)=zero
     end do
    else if (option_dij==4) then
     do klmn=1,paw_ij(iatom)%lmn2_size*paw_ij(iatom)%cplex_dij
      if (abs(paw_ij(iatom)%dijxc_val(klmn,ispden))<=tol10) paw_ij(iatom)%dijxc_val(klmn,ispden)=zero
     end do
    else if (option_dij==5) then
     do klmn=1,paw_ij(iatom)%lmn2_size*paw_ij(iatom)%cplex_dij
      if (abs(paw_ij(iatom)%dijso(klmn,ispden))<=tol10) paw_ij(iatom)%dijso(klmn,ispden)=zero
     end do
    end if

   end do
  end do

 end if  ! nsym>1

!*********************************************************************
!Printing of Dij

 if (abs(pawprtvol)>=1.and.option_dij==0) then
  natinc=1;if(natom>1.and.pawprtvol>=0) natinc=natom-1
  do iatom=1,natom,natinc
   write(message, '(4a,i3,a)') ch10," PAW TEST:",ch10,&
&   ' ====== Values of DIJ in symdij (iatom=',iatom,') (Hartree) ======'
   call wrtout(6,message,'COLL')
   do ispden=1,paw_ij(iatom)%ndij
    if (paw_ij(iatom)%ndij==1) then
     write(message, '(a,a,i3,a)') ch10,&
&     ' *********** Dij (atom ',iatom,') **********'
    else
     write(message, '(a,a,i3,3a)') ch10,&
&     ' *********** Dij (atom ',iatom,', Component ', &
&     trim(dspin(ispden+2*(paw_ij(iatom)%ndij/4))),') **********'
    end if
    call wrtout(6,message,'COLL')
    if (paw_ij(iatom)%ndij/=4.or.ispden<=2) then
     call print_ij(paw_ij(iatom)%dij(:,ispden),paw_ij(iatom)%lmn2_size,&
&     paw_ij(iatom)%cplex_dij,paw_ij(iatom)%lmn_size,1,-1,idum,0,pawprtvol,idum,50.d0*dble(3-2*ispden),1)
    else
     call print_ij(paw_ij(iatom)%dij(:,ispden),paw_ij(iatom)%lmn2_size,&
&     paw_ij(iatom)%cplex_dij,paw_ij(iatom)%lmn_size,1,-1,idum,0,pawprtvol,idum,50.d0*dble(3-2*ispden),1,&
&     asym_ij=paw_ij(iatom)%dij(:,7-ispden))
    end if
   end do
  end do
  message=''
  call wrtout(6,message,'COLL')
 end if

#if defined DEBUG_MODE
 write(message,'(a)')' symdij : exit '
 call wrtout(std_out,message,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine symdij
!!***
