!{\src2tex{textfont=tt}}
!!****f* ABINIT/optics_paw_core
!! NAME
!! optics_paw_core
!!
!! FUNCTION
!! Output routine for the outscfcv.F90 routine for optical conductivity
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (SM,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  atindx1(natom)=index table for atoms, inverse of atindx (see scfcv.f)
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions.
!!  cprj(natom,nspinor*mband*mkmem*nsppol)= <p_lmn|Cnk> coefficients for each WF |Cnk>
!!                                          and each |p_lmn> non-local projector
!!  dimcprj(natom)=array of dimensions of array cprj
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  ecut=cut-off energy for plane wave basis sphere (Ha)
!!  fildata= name of the output file
!!  gprimd(3,3)=dimensional reciprocal space primitive translations
!!  gsc(2,mpw*nspinor*mband*mkmem*nsppol)=<g|S|c> matrix elements (S=overlap)
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  indlmn(6,lmnmax,ntypat)= array giving l,m,n,lm,ln,s for i=lmn
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  lmnmax=max. number of (l,m,n) numbers over all types of atom
!!  mband=maximum number of bands
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  mpsang =1+maximum angular momentum for nonlocal pseudopotentials
!!  mpw=maximum dimensioned size of npw.
!!  natom=number of atoms in cell.
!!  nattyp(ntypat)= # atoms of each type.
!!  nkpt=number of k points.
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data:
!!     %mesh_size=Dimension of radial mesh
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data:
!!     %mesh_size=Dimension of radial mesh
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  wffnow=struct infos for wf disk file
!!
!! OUTPUT
!!  (only writing, printing)
!!
!! SIDE EFFECTS
!!
!!
!! NOTES
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      clsopn,cprj_alloc,cprj_diskinit,cprj_free,cprj_get,deducer0,hdr_skip
!!      int_ang,leave_new,leave_test,nderiv_gen,rdnpw,rwwf,simp_gen,timab
!!      wrtout,xcomm_init,xdefineoff,xsum_master
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine optics_paw_core(atindx1,cg,cprj,dimcprj,dtfil,dtset,ecut,fildata,gprimd,hdr,indlmn,kg,lmnmax,&
&               mband,mkmem,mpi_enreg,mpsang,mpw,natom,nattyp,nkpt,npwarr,nspinor,nsppol,&
&               pawrad,pawtab,wffnow)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13io_mpi
 use interfaces_14iowfdenpot
 use interfaces_15nonlocal
 use interfaces_15paw, except_this_one => optics_paw_core
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: lmnmax,mband,mkmem,mpsang,mpw,natom,nkpt,nspinor,nsppol
 real(dp),intent(in) :: ecut
 character(len=fnlen),intent(in) :: fildata
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(hdr_type),intent(inout) :: hdr
 type(wffile_type),intent(inout) :: wffnow
!arrays
 integer,intent(in) :: atindx1(natom),dimcprj(natom),indlmn(6,lmnmax,dtset%ntypat)
 integer,intent(in) :: kg(3,mpw*mkmem),nattyp(dtset%ntypat),npwarr(nkpt)
 real(dp),intent(in) :: gprimd(3,3)
 real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 type(cprj_type) :: cprj(natom,nspinor*mband*mkmem*nsppol)
 type(pawrad_type),intent(in) :: pawrad(dtset%ntypat)
 type(pawtab_type),intent(in) :: pawtab(dtset%ntypat)

!Local variables-------------------------------
!scalars
 integer :: basis_size,cplex,formeig,iatom,ib,ibg,ibsp
 integer :: icg,ierr,ii,ij_size,ikg,ikpt,il,ilm,ilmn,iln
 integer :: iorder_cprj,ipw,ispinor,isppol,istwf_k,itypat,iwavef
 integer :: jb,jbsp,jl,jlm,jlmn,jln,jwavef,lmn_size
 integer :: mcg_disk,me_kpt,mesh_size,nband_k,npw_k,nspinor0
 integer :: old_paral_level,spaceComm_band,spaceComm_bandfft,spaceComm_fft,spaceComm_k,tim_rwwf
 real(dp) :: cgnm1,cgnm2,cpnm1,cpnm2,intg
 character(len=500) :: message
!arrays
 integer,allocatable :: indlmn_(:,:),kg_dum(:,:),kg_k(:,:)
 real(dp) :: ang_phipphj(mpsang**2,mpsang**2,8),kpoint(3)
 real(dp) :: tsec(2)
 real(dp),allocatable :: cg_disk(:,:),dphi(:),dtphi(:),eig_dum(:),ff(:),int1(:,:),int2(:,:)
 real(dp),allocatable :: occ_dum(:),phidphj(:,:),phipphj(:,:,:),psinablapsi(:,:,:,:,:,:,:)
 real(dp),allocatable :: rad(:),tnm(:,:,:,:,:),tphidtphj(:,:)
 type(cprj_type),allocatable :: cprj_k(:,:)
!no_abirules
 type coeff_type    ! gives the phipphj
 real(dp), pointer :: phipphj(:,:,:)
 end type coeff_type
 type(coeff_type), allocatable :: typatom_fj(:)
!
character*8::dum
 integer ::npts,j,i,nphicor,iphicor,lmncmax
 integer,allocatable,dimension(:)::ncor,lcor
 real :: noccor
 real(dp),allocatable,dimension(:) ::energy_cor,r
 real,allocatable,dimension(:,:) :: phi_cor
 integer,allocatable,dimension(:,:) :: indlmn_core
! ************************************************************************

!DEBUG
!write(*,*)' optics_paw_core : enter'
!ENDDEBUG

!Compatibility tests
 if(dtset%paral_kgb==1.and.mkmem==0)then
  write(message, '(4a)' )ch10,&
&  ' optics_paw :  -',ch10,&
&  '  Not compatible with mkmem=0 and band-fft parallelism !'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

!------------------------------------------------------------------------------------------------
!0-reading core wavefunctions
!------------------------------------------------------------------------------------------------
 open(100,file='corewf.dat',form='formatted')
 do while (dum/='atompaw ') 
  read(100,'(a8)') dum  
 end do
 read(100,'(2i4)') npts,nphicor
 allocate(ncor(nphicor),lcor(nphicor),energy_cor(nphicor),phi_cor(nphicor,npts),r(npts))
 do i=1,nphicor
  read(100,'("# n=",i4," l=",i4," nocc=",f15.7," energy=",f15.7)')ncor(i),lcor(i),noccor,energy_cor(i)
  do j=1,npts
   read(100,*) r(j),phi_cor(i,j)
  end do
  read(100,*)
 end do

!set an array 'a la' indlmn
 lmncmax=0
 do ib=1,nphicor
  il=lcor(ib)
  lmncmax=lmncmax+2*il+1
 end do
 allocate(indlmn_core(6,lmncmax))
 ilmn=0;iln=0
 do ib=1,nphicor
  il=lcor(ib)
  iln=iln+1
  do ilm=1,2*il+1
   indlmn_core(1,ilmn+ilm)=il
   indlmn_core(2,ilmn+ilm)=ilm-(il+1)
   indlmn_core(3,ilmn+ilm)=1
   indlmn_core(4,ilmn+ilm)=il*il+ilm
   indlmn_core(5,ilmn+ilm)=iln
   indlmn_core(6,ilmn+ilm)=1
  end do
  ilmn=ilmn+2*il+1
 end do

!----------------------------------------------------------------------------------
!1-Computation of phipphj=<phi_i|nabla|phi_core>
!----------------------------------------------------------------------------------

!1-A Integration of the angular part : all angular integrals have been
!computed outside Abinit and tabulated for each (l,m) value
!----------------------------------------------------------------------------------

 call int_ang(ang_phipphj,mpsang)

 allocate(typatom_fj(dtset%ntypat))

!loop on atoms type
 do itypat=1,dtset%ntypat

  mesh_size=pawrad(itypat)%mesh_size
  lmn_size=pawtab(itypat)%lmn_size
  basis_size=pawtab(itypat)%basis_size
  ij_size=lmn_size*lmn_size

  allocate(indlmn_(6,lmnmax))
  allocate(ff(mesh_size),rad(mesh_size))
  allocate(int2(lmn_size,lmncmax),int1(lmn_size,lmncmax))
  allocate(dphi(mesh_size),dtphi(mesh_size),phidphj(mesh_size,ij_size),tphidtphj(mesh_size,ij_size))
  allocate(typatom_fj(itypat)%phipphj(3,lmn_size,lmncmax))

  indlmn_(:,:)=indlmn(:,:,itypat)
  rad(1:mesh_size)=pawrad(itypat)%rad(1:mesh_size)

! 1-B Computation of int1=\int phi phi_core /r dr 
! ----------------------------------------------------------------------------------
  do jln=1,nphicor
   do iln=1,basis_size
    ff(2:mesh_size)=(pawtab(itypat)%phi(2:mesh_size,iln)*pawtab(itypat)%phi(2:mesh_size,jln))/rad(2:mesh_size)
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intg,ff,pawrad(itypat))
    int1(iln,jln)=intg
   end do
  end do

! 1-C Computation of int2=\int phi/r d/dr(phi_core/r) r^2dr - \int phi/r d/dr(tphj/r)r^2 dr  MT: ????
! ----------------------------------------------------------------------------------
  do jln=1,nphicor
   ff(1:mesh_size)=phi_cor(jln,1:mesh_size)
   call nderiv_gen(dphi,ff,1,pawrad(itypat))
   ff(1:mesh_size)=pawtab(itypat)%tphi(1:mesh_size,jln)
   call nderiv_gen(dtphi,ff,1,pawrad(itypat))

   do iln=1,basis_size
    ff(2:mesh_size)=pawtab(itypat)%phi(2:mesh_size,iln)*dphi(2:mesh_size) &
&    -pawtab(itypat)%phi(2:mesh_size,iln)*phi_cor(jln,2:mesh_size)/ &
&    rad(2:mesh_size)
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intg,ff,pawrad(itypat))
    int2(iln,jln)=intg
   end do
  end do

! 1-D Integration of the radial part
! ----------------------------------------------------------------------------------
  do jlmn=1,lmncmax
   jlm=indlmn_core(4,jlmn)
   jl=indlmn_core(5,jlmn)
   do ilmn=1,lmn_size
    ilm=indlmn_(4,ilmn)
    il=indlmn_(5,ilmn)
    typatom_fj(itypat)%phipphj(1,ilmn,jlmn)= int2(il,jl)*ang_phipphj(ilm,jlm,1)&
&    + int1(il,jl)*(ang_phipphj(ilm,jlm,2)+ang_phipphj(ilm,jlm,3))
    typatom_fj(itypat)%phipphj(2,ilmn,jlmn)= int2(il,jl)*ang_phipphj(ilm,jlm,4)&
&    + int1(il,jl)*(ang_phipphj(ilm,jlm,5)+ang_phipphj(ilm,jlm,6))
    typatom_fj(itypat)%phipphj(3,ilmn,jlmn)= int2(il,jl)*ang_phipphj(ilm,jlm,7)&
&    + int1(il,jl)*ang_phipphj(ilm,jlm,8)
   end do
  end do

  deallocate(indlmn_,ff,rad)
  deallocate(int2,int1)
  deallocate(dphi,dtphi,phidphj,tphidtphj)

! end loop on atoms type
 end do

!----------------------------------------------------------------------------------
!2- Computation of <psi_n|-i.nabla|psi_m> for each k
!----------------------------------------------------------------------------------

!Init parallelism
 call xcomm_init(mpi_enreg,spaceComm_k)
 me_kpt=mpi_enreg%me
 if ((mpi_enreg%paral_compil_kpt==1) .and. &
& (mpi_enreg%paral_compil_fft==1)) then
  SpaceComm_k=mpi_enreg%comm_kpt
  me_kpt=mpi_enreg%me_kpt
 end if
 if (mpi_enreg%mode_para=='b') then
  spaceComm_fft=mpi_enreg%comm_fft
  spaceComm_band=mpi_enreg%comm_band
  spaceComm_bandfft=mpi_enreg%commcart
 else
  spaceComm_band=0;spaceComm_fft=0;spaceComm_bandfft=0
 end if

!Prepare temporary files if mkmem==0
!WF file
 if (mkmem==0) then
  formeig=0;mcg_disk=mpw*nspinor*mband
  call clsopn(wffnow)
  call hdr_skip(wffnow,ierr)
  call xdefineOff(formeig,wffnow,mpi_enreg,dtset%nband,npwarr,nspinor,nsppol,nkpt)
  allocate(cg_disk(2,mcg_disk))
 end if
!PAW file
 iorder_cprj=0
 call cprj_diskinit(atindx1,natom,iorder_cprj,mkmem,natom,dimcprj,nspinor,dtfil%unpaw)

!Initialize main variables
 allocate(psinablapsi(2,3,mband,nphicor,nkpt,nsppol,natom))
 psinablapsi=zero

!LOOP OVER SPINS
 ibg=0;icg=0
 do isppol=1,nsppol

! LOOP OVER k POINTS
  ikg=0
  if (dtset%mkmem==0) rewind dtfil%unkg
  do ikpt=1,nkpt
   nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)

   if(mpi_enreg%paral_compil_kpt==1)then
    if(minval(abs(mpi_enreg%proc_distrb(ikpt,1:nband_k,isppol)-me_kpt))/=0) cycle
   end if

!  Old FFT parallelism: define FFT communicator for this k-point
   if (mpi_enreg%paral_compil_fft==1.and.mpi_enreg%mode_para/='b') then
    mpi_enreg%num_group_fft=ikpt+(isppol-1)*nkpt
    old_paral_level=mpi_enreg%paral_level;mpi_enreg%paral_level=3
    call xcomm_init(mpi_enreg,spaceComm_fft)
    mpi_enreg%paral_level=old_paral_level
   end if

!  Allocations depending on k-point
   kpoint(:)=dtset%kptns(:,ikpt)
   istwf_k=dtset%istwfk(ikpt)
   npw_k=npwarr(ikpt)
   cplex=2;if (istwf_k>1) cplex=1
   allocate(kg_k(3,npw_k))
   allocate(cprj_k(natom,nspinor*nband_k))
   call cprj_alloc(cprj_k,0,dimcprj)

!  Extract cprj for this k-point according to mkmem
   call cprj_get(atindx1,cprj_k,cprj,natom,1,ibg,ikpt,iorder_cprj,isppol,&
&   mband,mkmem,mpi_enreg,natom,nband_k,nband_k,nspinor,nsppol,dtfil%unpaw)

!  Extract G-vectors for this k-point according to mkmem
   if (mkmem==0) then
    call rdnpw(ikpt,isppol,nband_k,npw_k,nspinor0,0,dtfil%unkg)
    read (dtfil%unkg) kg_k(1:3,1:npw_k)
   else
    kg_k(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)
    ikg=ikg+npw_k
   end if

!  Read the wavefunction block if mkmem=0
   if (mkmem==0) then
    tim_rwwf=1;allocate(eig_dum(dtset%mband),kg_dum(3,0),occ_dum(dtset%mband))
    call rwwf(cg_disk,eig_dum,0,0,0,ikpt,isppol,kg_dum,dtset%mband,mcg_disk,mpi_enreg,&
&    nband_k,nband_k,npw_k,nspinor,occ_dum,-2,0,tim_rwwf,wffnow)
    deallocate(eig_dum,kg_dum,occ_dum)
   end if

!  2-A Computation of <psi_n|p_i>(<phi_i|-i.nabla|phi_j>)
!  ----------------------------------------------------------------------------------

   allocate(tnm(2,3,nband_k,nphicor,natom));tnm=zero

!  Loops on bands
   do jb=1,nband_k

    if (mpi_enreg%mode_para=='b') then
     if (mod(jb-1,mpi_enreg%nproc_band)/=mpi_enreg%me_band) cycle
    elseif (mpi_enreg%paral_compil_kpt==1) then
     if (abs(mpi_enreg%proc_distrb(ikpt,jb,isppol)-me_kpt)/=0) cycle
    end if
    jbsp=(jb-1)*nspinor

    if (cplex==1) then
     do ispinor=1,nspinor
      jbsp=jbsp+1
      do iatom=1,natom
       itypat=dtset%typat(iatom)
       lmn_size=pawtab(itypat)%lmn_size
       do jlmn=1,lmn_size
        do ilmn=1,lmncmax
         ib=indlmn_core(5,ilmn)
         cpnm1=cprj_k(iatom,jbsp)%cp(1,jlmn)
         tnm(2,:,jb,ib,iatom)=tnm(2,:,jb,ib,iatom)+cpnm1*typatom_fj(itypat)%phipphj(:,jlmn,ilmn)
        end do !ilmn
       end do !jlmn
      end do !iatom
     end do !ispinor
    else
     do ispinor=1,nspinor
      jbsp=jbsp+1
      do iatom=1,natom
       itypat=dtset%typat(iatom)
       lmn_size=pawtab(itypat)%lmn_size
       do jlmn=1,lmn_size
        do ilmn=1,lmncmax	
         ib=indlmn_core(5,ilmn)
         cpnm1=cprj_k(iatom,jbsp)%cp(1,jlmn)
         cpnm2=cprj_k(iatom,jbsp)%cp(2,jlmn)
         tnm(1,:,jb,ib,iatom)=tnm(1,:,jb,ib,iatom)+cpnm1*typatom_fj(itypat)%phipphj(:,jlmn,ilmn)
         tnm(2,:,jb,ib,iatom)=tnm(2,:,jb,ib,iatom)+cpnm2*typatom_fj(itypat)%phipphj(:,jlmn,ilmn)
        end do !ilmn
       end do !jlmn
      end do !iatom
     end do !ispinor
    end if

!   End loops on bands
   end do ! jb

!  Reduction in case of parallelism
   if (mpi_enreg%mode_para=='b') then
    call timab(48,1,tsec)
    call xsum_master(tnm,0,spaceComm_band,ierr)
    call timab(48,2,tsec)
   end if

   psinablapsi(:,:,:,:,ikpt,isppol,:)=psinablapsi(:,:,:,:,ikpt,isppol,:)+tnm(:,:,:,:,:)
   deallocate(tnm)

   if (mkmem/=0) then
    ibg = ibg + nspinor*nband_k
    icg = icg + npw_k*nspinor*nband_k
   end if

!  End loop on spin,kpt
   call cprj_free(cprj_k)
   deallocate(kg_k,cprj_k)
  end do ! ikpt
 end do !isppol

!Datastructures deallocations
 if (mkmem==0) deallocate(cg_disk)
 do itypat=1,dtset%ntypat
  deallocate(typatom_fj(itypat)%phipphj)
 end do
 deallocate(typatom_fj)

!----------------------------------------------------------------------------------
!3- Write data on file
!----------------------------------------------------------------------------------

!Reduce data in case of parallelism
 if(mpi_enreg%paral_compil_kpt==1)then
  call timab(48,1,tsec)
  call leave_test(mpi_enreg)
  call xsum_master(psinablapsi,0,spaceComm_k,ierr)
  call timab(48,2,tsec)
 end if

!Write data (proc 0 only)
 if (mpi_enreg%me==0) then
  open(124,file=fildata,form='unformatted')
  write(124) nphicor
  do i=1,nphicor
   write(124) ncor(i),lcor(i),half*energy_cor(i)
  end do
  do isppol=1,nsppol
   do ikpt=1,nkpt
    do iatom=1,natom
     nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)
     write(124) ((psinablapsi(1:2,1,ib,jb,ikpt,isppol,iatom),ib=1,nband_k),jb=1,nphicor)
     write(124) ((psinablapsi(1:2,2,ib,jb,ikpt,isppol,iatom),ib=1,nband_k),jb=1,nphicor)
     write(124) ((psinablapsi(1:2,3,ib,jb,ikpt,isppol,iatom),ib=1,nband_k),jb=1,nphicor)
    end do
   end do
  end do
  close (124)
 end if

 deallocate(psinablapsi)

!DEBUG
 write(6,*)' optics_paw_core : exit '
!stop
!ENDDEBUG

 end subroutine optics_paw_core
!!***
