!{\src2tex{textfont=tt}}
!!****f* ABINIT/setup_sigma
!! NAME
!! setup_sigma
!!
!! FUNCTION
!!  Initialize the data type containing parameters for a sigma calculation.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! acell(3)=length scales of primitive translations (bohr)
!! Dtset<type(dataset_type)>=all input variables for this dataset
!! Dtfil<type(datafiles_type)>=variables related to files
!! rprim(3,3)=dimensionless real space primitive translations
!! MPI_enreg=information about MPI parallelization
!! ngfft(18)=information on the (fine) FFT grid used for the density.
!! Psps <Pseudopotential_type)>=Info on pseudopotential, only for consistency check of the KSS file 
!!
!! OUTPUT
!! Sp<Sigma_parameters> 
!! Kmesh <BZ_mesh_type> 
!! Qmesh <BZ_mesh_type> 
!! Cryst<Crystal_structure>=Info on unit cell and symmetries
!! Gsph_Max<Gvectors_type>=Info on G-sphere
!! Hdr_kss
!! Vcp<Coulombian_type>= datatype gathering information on the coulombian interaction and the cutoff technique.
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      assert,bstruct_init,findk,flush_unit,get_ng0sh,hdr_check,hdr_init
!!      hdr_update,hdr_vs_dtset,init_er_from_file,init_gvectors_type
!!      initcrystalfromhdr,initkmesh,leave_new,metric,mkrdim
!!      nullify_epsilonm1_results,nullify_gvectors,nullify_sigma_parameters
!!      printcrystal,rhoij_alloc,rhoij_copy,rhoij_free,setmesh,setshells
!!      setup_coulombian,setup_qmesh,testlda,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine setup_sigma(codvsn,acell,rprim,ngfftf,Dtset,Dtfil,Psps,Pawtab,MPI_enreg,&
& ngfft_gw,Hdr_kss,Hdr_out,Cryst,Kmesh,Qmesh,KS_BSt,Gsph_Max,Vcp,Er,Sp)
    
 use defs_basis
 use defs_datatypes
 use m_errors
 use m_crystal
 use m_bz_mesh
 use m_io_tools,   only : flush_unit
 use m_coulombian, only : setup_coulombian

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_12geometry
 use interfaces_13recipspace
 use interfaces_14iowfdenpot
 use interfaces_15gw, except_this_one => setup_sigma
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 character(len=6),intent(in) :: codvsn
 type(Datafiles_type),intent(in) :: Dtfil
 type(Dataset_type),intent(inout) :: Dtset
 type(Pseudopotential_type),intent(in) :: Psps
 type(Pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Dtset%usepaw)
 type(MPI_type),intent(inout) :: MPI_enreg
 type(Sigma_parameters),intent(out) :: Sp
 type(Epsilonm1_results),intent(out) :: Er
 type(Bandstructure_type),intent(out) :: KS_BSt
 type(BZ_mesh_type),intent(out) :: Kmesh,Qmesh
 type(Crystal_structure),intent(out) :: Cryst
 type(Gvectors_type),intent(out) :: Gsph_Max
 type(Hdr_type),intent(out) :: Hdr_kss,Hdr_out
 type(Coulombian_type),intent(out) :: Vcp
!arrays
 integer,intent(in) :: ngfftf(18)
 integer,intent(out) :: ngfft_gw(18)
 real(dp),intent(in) :: acell(3),rprim(3,3)

!Local variables-------------------------------
!scalars
 integer :: bantot,enforce_sym,ib,ibtot,ii,ikibz,io,isppol,itypat,jj,method
 integer :: mg0sh,mod10,mqmem,mpsang_kss,nbnds_kss
 integer :: nfftgw_tot,ng_kss,nsym_kss
 integer :: pertcase_,restart,restartpaw,timrev,umklp_opt
 real(dp),parameter :: OMEGASIMIN=0.01d0
 real(dp) :: domegas,domegasi,ucvol,efermi
 logical,parameter :: linear_imag_mesh=.TRUE.
 logical :: ltest,only_one_kpt,remove_inv 
 character(len=500) :: msg                   
 character(len=fnlen) :: fname
!arrays
 integer :: ng0sh_opt(3),G0(3),ibocc(Dtset%nsppol)
 integer,allocatable :: npwarr(:),nlmn(:)
 integer,pointer :: gvec_p(:,:)
 real(dp) :: gmet(3,3),gprimd(3,3),rmet(3,3),rprimd(3,3)
 real(dp),pointer :: energies_p(:,:,:)
 real(dp),allocatable :: doccde(:),eigen(:),occfact(:)
 real(dp),pointer :: occupations(:,:,:)
 type(Pawrhoij_type),allocatable :: Pawrhoij(:)
 
! *************************************************************************
 
 DBG_ENTER('COLL')

 ! === Check for calculations that are not implemented ===
 ltest=ALL(Dtset%nband(1:Dtset%nkpt*Dtset%nsppol)==Dtset%nband(1))
 call assert(ltest,'Dtset%nband must be constant',__FILE__,__LINE__)

 ! === Nullify pointers in the output structures ===
 call nullify_sigma_parameters(Sp)
 call nullify_epsilonm1_results(Er)
 !
 ! === Basic parameters ===
 Sp%ppmodel    = Dtset%ppmodel
 Sp%splitsigc  = Dtset%splitsigc 
 Sp%gwcalctyp  = Dtset%gwcalctyp
 Sp%nbnds      = Dtset%nband(1) 
 Sp%symsigma   = Dtset%symsigma
 Sp%zcut       = Dtset%zcut
 Sp%soenergy   = Dtset%soenergy
 !
 ! === For HF, SEX or COHSEX use Hybertsen-Louie PPM (only $\omega=0$) ===
 ! * Use fake screening for HF.
 mod10=MOD(Sp%gwcalctyp,10)
 if (mod10==5.or.mod10==6.or.mod10==7) Sp%ppmodel=2
 if (mod10<5.and.MOD(Sp%gwcalctyp,1)/=1) then
  ! * One shot GW (PPM or contour deformation).
  Sp%nomegasrd   = Dtset%nomegasrd 
  Sp%maxomega4sd = Dtset%omegasrdmax
  Sp%deltae     = (2*Sp%maxomega4sd)/(Sp%nomegasrd-1)
 else
  ! * For AC no need to evaluate derivative by finite differences.
  Sp%nomegasrd  =1 
  Sp%maxomega4sd=zero 
  Sp%deltae     =zero
 end if
 !
 !=== For analytic continuation define the number of imaginary frequencies for Sigma ===
 ! * Tests show than more than 12 freqs in the Pade approximant worsen the results!
 Sp%nomegasi=0

 if (mod10==1) then 
  Sp%nomegasi  =Dtset%nomegasi
  Sp%omegasimax=Dtset%omegasimax 
  Sp%omegasimin=OMEGASIMIN 
  write(msg,'(4a,i3,2(2a,f8.3),a)')ch10,&
&  ' Parameters for analytic continuation : ',ch10,&
&  '  number of imaginary frequencies for sigma =  ',Sp%nomegasi,ch10,&
&  '  min frequency for sigma on imag axis [eV] =  ',Sp%omegasimin*Ha_eV,ch10,&
&  '  max frequency for sigma on imag axis [eV] =  ',Sp%omegasimax*Ha_eV,ch10
  call wrtout(std_out,msg,'COLL')

  !TODO this should not be done here but in init_sigma_results

  allocate(Sp%omegasi(Sp%nomegasi))

  if (linear_imag_mesh) then 
   ! * Linear mesh along the imaginary axis.
   domegasi=Sp%omegasimax/(Sp%nomegasi-1)
   do io=1,Sp%nomegasi
    Sp%omegasi(io)=CMPLX(zero,(io-1)*domegasi)
   end do
  else 
   ! * Logarithmic mesh along the imaginary axis.
   stop "not implemented"
   !domegasi=(Sp%omegasimax/Sp%omegasimin)**(one/(Sp%nomegasi-1))
   !Sp%omegasi(1)=czero ; ldi=domegasi
   !do io=2,Sp%nomegasi
   ! omega(io)=CMPLX(zero,ldi*Sp%omegasimin)
   ! Sp%omegasi(io)=ldi*domegasi
   !end do
  end if
  
  write(msg,'(4a)')ch10,&
&  ' setup_sigma : calculating Sigma(iw)',&
&  ' at imaginary frequencies [eV] (Fermi Level set to 0) ',ch10
  call wrtout(std_out,msg,'COLL') 
  call wrtout(ab_out,msg,'COLL')
  do io=1,Sp%nomegasi
   write(msg,'(2(f10.3,2x))')Sp%omegasi(io)*Ha_eV
   call wrtout(std_out,msg,'COLL') 
   call wrtout(ab_out,msg,'COLL')
  end do

  ltest=(Sp%omegasimax>0.1d-4.and.Sp%nomegasi>0)
  call assert(ltest,'Wrong value of omegasimax or nomegasi',__FILE__,__LINE__)
  if (Sp%gwcalctyp/=1) then 
   ! For AC, only one shot GW is allowed
   write(msg,'(a)')' SC-GW with Analytic continuation is not implemented' 
   MSG_ERROR(msg)
  end if 
 end if 

 if (Sp%symsigma/=0.and.Sp%gwcalctyp>=20) then
  write(msg,'(a)')' SC-GW with symmetries is not available' 
  MSG_ERROR(msg)
 end if

 ! * COHSEX with PAW is not available
 if (Dtset%usepaw/=0.and.mod10==7) then
  write(msg,'(a)')' PAW+COHSEX is not implemented'
  MSG_ERROR(msg)
 end if
 !
 ! === Setup parameters for Spectral function ===
 Sp%nomegasr  =Dtset%nfreqsp 
 Sp%maxomega_r=Dtset%freqspmax
 if (Sp%nomegasr>0) then
  domegas=2*Sp%maxomega_r/(Sp%nomegasr-1)
  !TODO this should be moved to Sr% and done in init_sigma_results
  allocate(Sp%omega_r(Sp%nomegasr))
  do io=1,Sp%nomegasr
   Sp%omega_r(io)=-Sp%maxomega_r+domegas*(io-1)
  end do
  write(msg,'(4a,i8,2(2a,f8.3),a)')ch10,&
&  ' Parameters for the calculation of the spectral function : ',ch10,&
&  '  Number of points    = ',Sp%nomegasr,ch10,&
&  '  Max frequency  [eV] = ',Sp%maxomega_r*Ha_eV,ch10,&
&  '  Frequency step [eV] = ',domegas*Ha_eV,ch10
  call wrtout(std_out,msg,'COLL')
 else
  !In indefo all these quantities are set to zero
  !Sp%nomegasr=1 
  !allocate(Sp%omega_r(Sp%nomegasr))
  !Sp%omega_r(1)=0
 end if
 !
 ! === Check input ===
 if (Sp%ppmodel==3.or.Sp%ppmodel==4) then 
  if (Sp%gwcalctyp>=10) then 
   write(msg,'(a,i3,a)')&
&   ' The ppmodel chosen and gwcalctyp ',Dtset%gwcalctyp,' are not yet compatible. '
   MSG_ERROR(msg)
  end if
  if (Sp%nspinor==2) then 
   write(msg,'(a,i3,a)')&
&   ' The ppmodel chosen and nspinor ',Sp%nspinor,' are not yet compatible. '
   MSG_ERROR(msg)
  end if
 end if 
 !
 ! === Dimensional primitive translations rprimd (from input), gprimd, metrics and unit cell volume ===
 call mkrdim(acell,rprim,rprimd)  
 call metric(gmet,gprimd,-1,rmet,rprimd,ucvol) 
 !
 ! === Define consistently npw, nsh, and ecut for wavefunctions and Sigma_X ===
 !now this part is done in invars2m
 !call setshells(Dtset%ecutwfn, Dtset%npwwfn, Dtset%nshwfn, Dtset%nsym,gmet,gprimd,Dtset%symrel,'wfn',ucvol)
 !call setshells(Dtset%ecutsigx,Dtset%npwsigx,Dtset%nshsigx,Dtset%nsym,gmet,gprimd,Dtset%symrel,'mat',ucvol)

 Sp%npwwfn=Dtset%npwwfn 
 Sp%npwx  =Dtset%npwsigx 
 Sp%npwvec=MAX(Sp%npwwfn,Sp%npwx)
 !
 ! === Read parameters of the KSS, verifify them and retrieve all G-vectors ===
 call testlda(Dtset,Dtfil%filkss,Dtset%accesswff,Dtset%localrdwf,nsym_kss,nbnds_kss,&
& ng_kss,mpsang_kss,gvec_p,energies_p,Hdr_kss,MPI_enreg)

 ltest=(Psps%mpsang==mpsang_kss) 
 call assert(ltest,'Psps%mpsang/=mpsang_kss',__FILE__,__LINE__)

 if (Sp%npwvec>ng_kss) then
  Sp%npwvec=ng_kss 
  if (Sp%npwwfn>ng_kss) Sp%npwwfn=ng_kss 
  if (Sp%npwx  >ng_kss) Sp%npwx  =ng_kss
  write(msg,'(3a,3(a,i8,a))')ch10,&
&  ' Number of G-vectors found less than required',ch10,&
&  '  calculation will proceed with npwvec  = ',Sp%npwvec,ch10,&
&  '  calculation will proceed with npwsigx = ',Sp%npwx,ch10,&
&  '  calculation will proceed with npwwfn  = ',Sp%npwwfn,ch10
  MSG_WARNING(msg)
 end if

 if (Sp%nbnds>nbnds_kss) then
  Sp%nbnds      =nbnds_kss 
  Dtset%nband(:)=nbnds_kss
  Dtset%mband   =MAXVAL(Dtset%nband)
  write(msg,'(4a,i4,a)')ch10,&
&  ' Number of bands found less then required',ch10,&
&  ' calculation will proceed with nbnds = ',nbnds_kss,ch10
  MSG_WARNING(msg)
 end if

 ! === Get important dimensions from the KSS header ===
 ! * Check also the consistency btw Hdr_kss and Dtset.
 Sp%nsppol =Hdr_kss%nsppol
 Sp%nspinor=Hdr_kss%nspinor 
 Sp%nsig_ab=Hdr_kss%nspinor**2  !FIXME Is it useful calculating only diagonal terms?
 call hdr_vs_dtset(Hdr_kss,Dtset) 

 ! === Create crystal_structure data type ===
 remove_inv=(nsym_kss/=Hdr_kss%nsym) 
 timrev=  2 ! This information is not reported in the header
            ! 1 => do not use time-reversal symmetry 
            ! 2 => take advantage of time-reversal symmetry

 call InitCrystalFromHdr(Hdr_kss,Cryst,timrev,remove_inv)
 call PrintCrystal(Cryst)

 !==== Set up of the k-points and tables in the whole BZ ===
 call InitKmesh(Hdr_kss%nkpt,Hdr_kss%kptns,Cryst,Kmesh,Dtset%prtvol)

 !=== Setup of k-points and bands for the GW corrections ===
 ! * maxbdgw and minbdgw are the Max and min band index for GW corrections over k-points. 
 !   They are used to dimension wfr_gw and calculate the matrix elements.

 if (Dtset%nkptgw==0) then
  ! * If not precised, calculate all k-points in the IBZ and all bands.
  !   This convention is particularly useful for self-consistent HF.
  Sp%nkcalc=Kmesh%nibz
  allocate(Sp%xkcalc(3,Sp%nkcalc),Sp%kcalc(Sp%nkcalc))
  allocate(Sp%minbnd(Sp%nkcalc),Sp%maxbnd(Sp%nkcalc))
  Sp%xkcalc(:,:)=Kmesh%ibz(:,:) 
  Sp%minbnd(:)=1        ; Sp%minbdgw=MINVAL(Sp%minbnd) 
  Sp%maxbnd(:)=Sp%nbnds ; Sp%maxbdgw=MAXVAL(Sp%maxbnd)
 else
  ! * Treat only the k-points and bands specified in the input file.
  Sp%nkcalc=Dtset%nkptgw
  allocate(Sp%xkcalc(3,Sp%nkcalc),Sp%kcalc(Sp%nkcalc))
  allocate(Sp%minbnd(Sp%nkcalc),Sp%maxbnd(Sp%nkcalc))
  Sp%xkcalc(:,:)=Dtset%kptgw(:,:)
  Sp%minbnd(:)=Dtset%bdgw(1,:) ; Sp%minbdgw=MINVAL(Sp%minbnd) 
  Sp%maxbnd(:)=Dtset%bdgw(2,:) ; Sp%maxbdgw=MAXVAL(Sp%maxbnd) 
  if (ANY(Sp%maxbnd(:)>Sp%nbnds)) then
   write(msg,'(6a)')ch10,&
&   ' At least one band where the GW corrections are required ',ch10,&
&   ' exceeds the number of treated bands.',ch10,&
&   ' ACtion : Increase the number of bands in the input file (or in the KSS file) '
   MSG_ERROR(msg)
  end if
 end if
 !
 !=== Check if the k-points are in the BZ ===
 !FB Honestly the code is not able to treat k-points, which are not in the IBZ.
 !This extension should require to change the code in different places.
 !Therefore, one should by now prevent the user from calculating sigma for a k-point not in the IBZ.
 umklp_opt=0
 call findk(Sp%nkcalc,Kmesh%nbz,Sp%xkcalc,Kmesh%bz,Sp%kcalc,umklp_opt)
 !call findk(Sp%nkcalc,Kmesh%nibz,Sp%xkcalc,Kmesh%ibz,Sp%kcalc,umklp_opt)

 ! check if there are duplicated k-point in Sp%
 ! TODO this should be done in chkinp.
  do ii=1,Sp%nkcalc
   do jj=ii+1,Sp%nkcalc
    if (isamek(Sp%xkcalc(:,ii),Sp%xkcalc(:,jj),G0)) then
     write(msg,'(6a)')ch10,&
&     '  kptgw contains duplicated k-points. This is not allowed since ',ch10,&
&     '  the QP corrections for this k-point will be calculated more than once.',ch10,& 
&     '  Check your input file '
     MSG_ERROR(msg)
    end if
   end do
  end do

 ! === Read external file and initialize basic dimension of Er% ===
 ! TODO use mqmem as input variable instead of gwmem

 ! === If required, use a matrix for $\Sigma_c$ which is smaller than that stored on file ===
 ! * By default the entire matrix is read and used,
 ! * Define consistently npweps, nsheps, and ecuteps for \Sigma_c according the input
 if (Dtset%npweps>0.or.Dtset%ecuteps>0.or.Dtset%nsheps>0) then
  call setshells(Dtset%ecuteps,Dtset%npweps,Dtset%nsheps,Dtset%nsym,gmet,gprimd,Dtset%symrel,'eps',ucvol)
 end if

 mqmem=0 ; if (Dtset%gwmem/10==1) mqmem=1

 if (Dtset%getscr/=0.or.Dtset%irdscr/=0) then
  fname=Dtfil%filscr 
 else if (Dtset%getsuscep/=0.or.Dtset%irdsuscep/=0) then
  fname=Dtfil%filchi0 
 else 
  fname=Dtfil%filscr 
  !FIXME this has to be cleaned, in tgw2_3 Dtset%get* and Dtset%ird* are  not defined
  !call assert(.FALSE.,'getscr, irscr, getsuscep or irdsuscep are not defined',__FILE__,__LINE__)
 end if

 call init_Er_from_file(Er,fname,mqmem,Dtset%npweps,Dtset%accesswff,Dtset%localrdwf,MPI_enreg)

 ! MG commented since it prevents from using a new KSS file on a shifted k-mesh.
 ! This is to allow old screening files in which symmetries were stored in the wrong order.  
 !if (Er%Hscr%Hdr%headform >= 57) then
 ! call hdr_vs_dtset(Er%Hscr%Hdr,Dtset) 
 !end if
 
 Sp%npwc=Er%npwe          
 if (Sp%npwc>Sp%npwx) then 
  Sp%npwc=Sp%npwx
  write(msg,'(2a)')ch10,&
&  ' Found npw_correlation > npw_exchange, Imposing npwc=npwx '
  MSG_COMMENT(msg)
  ! There is a good reason for doing so, see csigme.F90 and the size of the arrays 
  ! rhotwgp and rhotwgp: we need to define a max size and we opt for Sp%npwx.
 end if 
 Er%npwe=Sp%npwc
 Dtset%npweps=Er%npwe

 ! === Setup of q-mesh in the whole BZ ===
 ! * Stop if a nonzero umklapp is needed to reconstruct the BZ. In this case, indeed, 
 !   epsilon^-1(Sq) should be symmetrized in csigme using a different expression.

 call setup_Qmesh(Er%nqibz,Cryst,Dtset%prtvol,Er%qibz,Qmesh)

 ! === Find optimal value for G-sphere enlargment due to oscillator matrix elements ===
 ! * Here I have to be sure that Qmesh%bz is always inside the BZ, not always true size bz is buggy
 ! * -one is used because we loop over all the possibile differences, unlike screening

 mg0sh=5
 call get_ng0sh(Sp%nkcalc,Sp%xkcalc,Kmesh%nbz,Kmesh%bz,Qmesh%nbz,Qmesh%bz,gmet,-one,mg0sh,ng0sh_opt)
 Sp%mG0(:)=ng0sh_opt(:)

 ! === Make biggest G-sphere of Sp%npwvec vectors ===
 only_one_kpt=(Kmesh%nbz==1)
 call nullify_Gvectors(Gsph_Max)
 call init_Gvectors_type(only_one_kpt,Gsph_Max,Cryst,Sp%npwvec,gvec_p,gmet,gprimd)
 deallocate(gvec_p)

 ! === Get Fourier components of the Coulombian for all q-points in the IBZ ===
 ! * If required, use a cutoff in the interaction 
 ! * Pcv%vc_sqrt contains Vc^{-1/2}
 ! * Setup also the analytical calculation of the q->0 component
 ! FIXME recheck ngfftf since I got different charge outside the cutoff region
 call setup_coulombian(Dtset,Gsph_Max,Qmesh,Kmesh,Sp%npwx,Cryst%rprimd,ngfftf,MPI_enreg,Vcp)

 ! === Setup of the FFT mesh for the oscilator strengths === 
 ! * ngfft_gw(7:18)==Dtset%ngfft(7:18) which is initialized before entering screening.
 ! * Here we redefine ngfft_gw(1:6) according to the following options :
 !
 ! method==0 --> FFT grid read from fft.in (debugging purpose)
 ! method==1 --> Normal FFT mesh
 ! method==2 --> Slightly augmented FFT grid to calculate exactly rho_tw_g (see setmesh.F90)
 ! method==3 --> Doubled FFT grid, same as the the FFT for the density,
 !
 ! enforce_sym==1 ==> Enforce a FFT mesh compatible with all the symmetry operation and FFT library
 ! enforce_sym==0 ==> Find the smallest FFT grid compatbile with the library, do not care about symmetries

 ngfft_gw(1:18)=Dtset%ngfft(1:18) 
 method=2
 if (Dtset%fftgw==00 .or. Dtset%fftgw==01) method=0
 if (Dtset%fftgw==10 .or. Dtset%fftgw==11) method=1
 if (Dtset%fftgw==20 .or. Dtset%fftgw==21) method=2
 if (Dtset%fftgw==30 .or. Dtset%fftgw==31) method=3
 enforce_sym=MOD(Dtset%fftgw,10) 

 call setmesh(gmet,Gsph_Max%gvec,ngfft_gw,Sp%npwvec,MAX(Sp%npwx,Sp%npwc),Sp%npwwfn,&
& nfftgw_tot,method,Sp%mG0,Cryst,enforce_sym)

 ! === Initialize the band structure datatype ===
 ! * Copy KSS energies and occupations up to Sp%nbnds==Dtset%nband(:)
 ! TODO Recheck symmorphy and inversion

 bantot=SUM(Dtset%nband(1:Dtset%nkpt*Dtset%nsppol))
 allocate(doccde(bantot),eigen(bantot),occfact(bantot))
 doccde(:)=zero ; eigen(:)=zero ; occfact(:)=zero 

 jj=0 ; ibtot=0
 do isppol=1,Dtset%nsppol
  do ikibz=1,Dtset%nkpt
   do ib=1,Hdr_kss%nband(ikibz*isppol)
    ibtot=ibtot+1
    if (ib<=Sp%nbnds) then 
     jj=jj+1
     occfact(jj)=Hdr_kss%occ(ibtot)
     eigen  (jj)=energies_p(ib,ikibz,isppol)
    end if
   end do
  end do
 end do
 deallocate(energies_p)

 ! Make sure that Dtset%wtk==Kmesh%wt due to the dirty treatment of 
 ! symmetry operations in the old GW code (symmorphy and inversion) 
 ltest=(ALL(ABS(Dtset%wtk(1:Kmesh%nibz)-Kmesh%wt(1:Kmesh%nibz))<tol6))
 call assert(ltest,'Mismatch between Dtset%wtk and Kmesh%wt',__FILE__,__LINE__)

 allocate(npwarr(Dtset%nkpt)) ; npwarr(:)=Sp%npwwfn

 call bstruct_init(bantot,KS_BSt,Dtset%nelect,doccde,eigen,Dtset%istwfk,Kmesh%ibz,Dtset%nband,&
& Kmesh%nibz,npwarr,Dtset%nsppol,Dtset%nspinor,Dtset%tphysel,Dtset%tsmear,Dtset%occopt,occfact,Kmesh%wt) 

 ! this fails simply because in case of NSCF occ are zero
 ! TODO outkss should calculate occ factors in case of NSCF run. 
 !ltest=(ALL(ABS(occfact-KS_BSt%occ)<tol6)) 
 !call assert(ltest,'difference in occfact')
 !write(*,*)MAXVAL(ABS(occfact(:)-KS_BSt%occ(:))) 

 deallocate(doccde,eigen,npwarr)

 ! === Create Sigma header === 
 ! TODO Fix problems with symmorphy and k-points
 pertcase_=0
 call hdr_init(KS_BSt,codvsn,Dtset,Hdr_out,Pawtab,pertcase_,Psps)

 ! === Get Pawrhoij from the header of the KSS file ===
 allocate(Pawrhoij(Cryst%natom*Dtset%usepaw))
 if (Dtset%usepaw==1) then
  allocate(nlmn(Cryst%ntypat))
  do itypat=1,Cryst%ntypat
   nlmn(itypat)=Pawtab(itypat)%lmn_size
  end do
  call rhoij_alloc(1,nlmn,Dtset%nspden,Dtset%nsppol,Pawrhoij,Cryst%typat)
  deallocate(nlmn)
  call rhoij_copy(Hdr_kss%Pawrhoij,Pawrhoij)
 end if

 call hdr_update(bantot,1.0d20,1.0d20,Hdr_out,Cryst%natom,1.0d20,&
& Cryst%rprimd,occfact,Pawrhoij,Dtset%usepaw,Cryst%xred)

! call hdr_update(bantot,1.0d20,1.0d20,Hdr_out,Cryst%natom,1.0d20,&
!& Cryst%rprimd,KS_BSt%occ,Pawrhoij,Dtset%usepaw,Cryst%xred)

 ! This is just to do a check, the file format is wrong!
 call hdr_check(1002,1002,Hdr_out,Hdr_kss,'COLL',restart,restartpaw)

 deallocate(occfact)
 call rhoij_free(Pawrhoij) ; deallocate(Pawrhoij)

 ! === Final compatibility tests ===
 if (Psps%ntypat/=Cryst%ntypat) STOP 'BUG ntypat'
 ltest=ALL(KS_BSt%istwfk==1) 
 call assert(ltest,'istwfk must be 1',__FILE__,__LINE__)
 ltest=(KS_BSt%mband==Sp%nbnds.and.ALL(KS_BSt%nband==Sp%nbnds))
 call assert(ltest,'BUG in definition of KS_BSt%nband',__FILE__,__LINE__)

 if (Dtset%symsigma/=0 .and. Sp%nomegasr/=0) then
  if (idx_spatial_inversion(Cryst) == 0) then 
   write(msg,'(5a)')' setup_sigma : BUG :',ch10,&
&   ' It is not yet possible to use symsigma/=0 to calculate the spectral function ',ch10,&
&   ' when the system does not have the spatial inversion. Please use symsigma=0 '
   MSG_ERROR(msg)
  end if
 end if

 DBG_EXIT('COLL')

end subroutine setup_sigma
!!***
