!{\src2tex{textfont=tt}}
!!****f* ABINIT/setup_ppmodel
!! NAME
!! setup_ppmodel
!!
!! FUNCTION
!!  Initialize some values of several arrays of the Er% datastructure 
!!  that are used in case of plasmonpole calculations
!!  Just a wrapper around different plasmonpole routines.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  paral_kgb=variable related to band parallelism
!!  Qmesh<bz_mesh_type>=the q-mesh used for the inverse dielectric matrix
!!    %nibz=number of irreducible q-points
!!    %ibz(3,%nibz)=the irred q-point
!!  Er<epsilonm1_results>=the inverse dielectric matrix 
!!    %nomega=number of frequencies in $\epsilon^{-1}$
!!    %epsm1=the inverse dielctric matrix 
!!    %omega=frequencies in epsm1
!!    %npwe=number of G vectors for the correlation part
!!  MPI_enreg<MPI_type>=informations about MPI parallelization
!!  ngfftf(18)=contain all needed information about the 3D fine FFT mesh, see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  gmet(3,3)=reciprocal space metric ($\textrm{bohr}^{-2}$).
!!  gprimd(3,3)=dimensional primitive translations for reciprocal space ($\textrm{bohr}^{-1}$)
!!  nfftf=the number of points in the FFT mesh (for this processor)
!!  rhor_tot(nfftf)=the total charge in real space
!!  PPm<PPmodel_type>: 
!!    %ppmodel=the type of  plasmonpole model 
!!
!! OUTPUT
!!  
!!
!! SIDE EFFECTS
!!  PPm<PPmodel_type>: 
!!  == if ppmodel 1 or 2 ==
!!   %omegatw and %bigomegatwsq=PPmodel parameters 
!!  == if ppmodel 3 ==
!!   %omegatw, %bigomegatwsq and %eigpot=PPmodel parameters
!!  == if ppmodel 4 ==
!!   %omegatw and %bigomegatwsq=PPmodel parameters 
!!
!! NOTES
!! TODO: rhor_tot should be replaced by rhog_tot
!! FFT parallelism won"t work 
!! Solve Issue with MPI_enreg
!!
!! PARENTS
!!  
!!
!! CHILDREN
!!  
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine setup_ppmodel(PPm,paral_kgb,Qmesh,Er,MPI_enreg,nfftf,gvec,ngfftf,gmet,gprimd,rhor_tot,&
& epsm1q,iqiA) !Optional

 use defs_basis
 use defs_datatypes
 use m_errors,   only : assert
 use m_io_tools, only : flush_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => setup_ppmodel
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nfftf,paral_kgb
 integer,intent(in),optional :: iqiA
 type(BZ_mesh_type),intent(in) :: Qmesh
 type(Epsilonm1_results),intent(inout) :: Er
 type(MPI_type),intent(inout) :: MPI_enreg
 type(PPmodel_type),intent(inout) :: PPm
!arrays
 integer,intent(in) :: gvec(3,Er%npwe),ngfftf(18)
 real(dp),intent(in) :: gmet(3,3),gprimd(3,3)
 real(dp),intent(inout) :: rhor_tot(nfftf)
 complex(gwpc),intent(in),optional :: epsm1q(Er%npwe,Er%npwe,Er%nomega)

!Local variables-------------------------------
!scalars
 integer :: istat,master,npwc2,npwc3,nqiA,rank,spaceComm
 logical :: ltest,single_q
 character(len=500) :: msg

! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' setup_ppmodel : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

 call xcomm_init  (MPI_enreg,spaceComm)  
 call xme_init    (MPI_enreg,rank     )          
 call xmaster_init(MPI_enreg,master   )  
 !
 ! === if iqiA is present, then consider only one qpoint to save memory ===
 ! * This means the object has been already initialized
 nqiA=Qmesh%nibz ; single_q=.FALSE.
 if (PRESENT(epsm1q)) then 
  nqiA=1 ; single_q=.TRUE.
  ltest=PRESENT(iqiA)
  call assert(ltest,'For single q-point mode, also iqiA must be present',__FILE__,__LINE__)
 end if
 !
 ! Allocate plasmonpole parameters 
 ! TODO ppmodel==1 by default, should be set to 0 if AC and CD
 SELECT CASE (PPm%model)

 CASE (0)
  write(msg,'(a)')' Skipping Plasmompole model calculation' 
  call wrtout(std_out,msg,'COLL') ; RETURN

 CASE (1) 
  ! === Godby-Needs, q-dependency enters only through epsilon^-1 ===
  if (.not.single_q) then
   call cppm1par(Er%npwe,nqiA,Er%nomega,Er%epsm1,Er%omega,PPm%bigomegatwsq,PPm%omegatw,PPm%drude_plsmf)
  else
   call cppm1par(Er%npwe,nqiA,Er%nomega,epsm1q,  Er%omega,PPm%bigomegatwsq,PPm%omegatw,PPm%drude_plsmf)
  end if

 CASE (2)
  ! === Hybertsen-Louie ===
  if (.not.single_q) then
   call cppm2par(paral_kgb,Er%npwe,nqiA,Er%nomega,Er%epsm1,PPm%bigomegatwsq,PPm%omegatw,&
&   ngfftf,gvec,gprimd,rhor_tot,nfftf,Qmesh,gmet)
  else
   call cppm2par(paral_kgb,Er%npwe,nqiA,Er%nomega,epsm1q,PPm%bigomegatwsq,PPm%omegatw,&
&   ngfftf,gvec,gprimd,rhor_tot,nfftf,Qmesh,gmet,iqiA)
  end if

 CASE (3)
  ! === von Linden-Horsh model ===
  ! TODO Check better double precision, this routine is in a messy state
  if (.not.single_q) then
   call cppm3par(paral_kgb,Er%npwe,nqiA,Er%nomega,Er%epsm1,PPm%bigomegatwsq,&
&   PPm%omegatw,ngfftf,gvec,gprimd,rhor_tot,nfftf,PPm%eigpot,Qmesh)
  else
   call cppm3par(paral_kgb,Er%npwe,nqiA,Er%nomega,epsm1q,PPm%bigomegatwsq,&
&   PPm%omegatw,ngfftf,gvec,gprimd,rhor_tot,nfftf,PPm%eigpot,Qmesh,iqiA)
  end if

 CASE (4)
  ! === Engel Farid ===
  ! TODO Check better double precision, this routine is in a messy state
  if (.not.single_q) then
   call cppm4par(paral_kgb,Er%npwe,nqiA,Er%epsm1,Er%nomega,PPm%bigomegatwsq,&
&   PPm%omegatw,ngfftf,gvec,gprimd,rhor_tot,nfftf,Qmesh)
  else
   call cppm4par(paral_kgb,Er%npwe,nqiA,epsm1q,Er%nomega,PPm%bigomegatwsq,&
&   PPm%omegatw,ngfftf,gvec,gprimd,rhor_tot,nfftf,Qmesh,iqiA)
  end if

 CASE DEFAULT
  write(msg,'(6a,i6)')ch10,&
&  ' setup_ppmodel: BUG -',ch10,&
&  '  The argument ppmodel should be 1 or 2,',ch10,&
&  '  however, ppmodel=',PPm%model
  call wrtout(std_out,msg,'COLL') ; call leave_new('COLL')
 END SELECT

#if defined DEBUG_MODE
 write(msg,'(a)')' setup_ppmodel : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine setup_ppmodel
!!***

subroutine getem1_from_PPm(PPm,iqibz,zcut,nomega,omega,Vcp,em1q)

 use defs_basis
 use defs_datatypes
 use m_errors,   only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqibz,nomega
 type(PPmodel_type),intent(in) :: PPm
 type(Coulombian_type),intent(in) :: Vcp
 real(dp),intent(in) :: zcut
!arrays
 complex(dpc),intent(in) :: omega(nomega)
 complex(dpc),intent(out) :: em1q(PPm%npwc,PPm%npwc,nomega)

!Local variables-------------------------------
!scalars
 integer :: istat,ig1,ig2,io,idm
 real(dp) :: den 
 complex(dpc) :: qpg1,qpg2,ug1,ug2
 complex(dpc) :: delta,num,em1ggp,otw,zzpq,yg1,yg2,bot1,bot2,chig1g2
 character(len=500) :: msg
 logical :: ltest
!arrays

! *************************************************************************

 ltest=(PPm%mqmem/=0)
 call assert(ltest,'mqmem==0 case in getem1_from_PPm not implemented',__FILE__,__LINE__)

 !TODO zcut should be an entry in PPm
 delta=CMPLX(zero,zcut)

 select case (PPm%model)

 case (1:2)
 ! === Godby or Hybertsen-Louie ===
 do io=1,nomega
 
  do ig2=1,PPm%npwc
   do ig1=1,PPm%npwc
    !den = omega(io)**2-REAL(PPm%omegatw(ig1,ig2,iqibz)**2)
    !if (den**2<zcut**2) den = omega(io)**2-REAL( (PPm%omegatw(ig1,ig2,iqibz)-delta)**2 )
    den = omega(io)**2-REAL( (PPm%omegatw(ig1,ig2,iqibz)-delta)**2 )
    em1ggp = PPm%bigomegatwsq(ig1,ig2,iqibz)/den
    if (ig1==ig2) em1ggp=em1ggp+one
    em1q(ig1,ig2,io)=em1ggp
    !em1q(ig1,ig2,io)=em1ggp*Vcp%vc_sqrt(ig1,iqibz)*Vcp%vc_sqrt(ig2,iqibz)
   end do
  end do

 end do !io

 case (3)

  !TODO Check coefficients 
  do io=1,nomega

   do ig2=1,PPm%npwc
    do ig1=1,PPm%npwc

     em1ggp=czero
     do idm=1,PPm%npwc
      !den=omega(io)**2-(omegatw(ig1,ig2,iqibz)-delta)**2
      !em1w(io)=em1w(io)+eigvec(ig1,idm,iqibz)*conjg(eigvec(ig2,idm,iqibz))*bigomegatwsq(ig1,ig2,iqibz)/den
      ug1 =PPm%eigpot(ig1,idm,iqibz)
      ug2 =PPm%eigpot(ig2,idm,iqibz)
      otw =PPm%bigomegatwsq(idm,1,iqibz)*PPm%omegatw(idm,1,iqibz)
      zzpq=PPm%bigomegatwsq(idm,1,iqibz)
      den=half*REAL(zzpq*otw*( one/(omega(io)-otw+delta) - one/(omega(io)+otw-delta) ))
      em1ggp=em1ggp+ug1*CONJG(ug2)*den
      !eigenvalues(idm,io)=one + half*REAL(zzpq*otw*( one/(omega(io)-otw+delta) - one/(omega(io)+otw-delta) ))
     end do

     if (ig2==ig1) em1ggp=em1ggp+one
     em1q(ig1,ig2,io)=em1ggp

    end do !ig1
   end do !ig2

  end do !iomega 

 case (4)
 ! Make e^-1

 do io=1,nomega

  do ig2=1,PPm%npwc
   qpg2=one/Vcp%vc_sqrt(ig2,iqibz)
   do ig1=1,PPm%npwc
    qpg1=one/Vcp%vc_sqrt(ig1,iqibz)

    chig1g2=czero 
    do idm=1,PPm%npwc
     otw =PPm%omegatw(idm,1,iqibz)
     bot1=PPm%bigomegatwsq(ig1,idm,iqibz)
     bot2=PPm%bigomegatwsq(ig2,idm,iqibz)
     yg1=SQRT(otw/four_pi)*qpg1*bot1
     yg2=SQRT(otw/four_pi)*qpg2*bot2
     chig1g2=chig1g2 + yg1*CONJG(yg2)/(omega(io)**2-(otw-delta)**2)
    end do

    em1ggp=four_pi*chig1g2/(qpg1*qpg2)
    if (ig1==ig2) em1ggp=em1ggp+one
    em1q(ig1,ig2,io)=em1ggp !*Vcp%vc_sqrt(ig1,iqibz)*Vcp%vc_sqrt(ig2,iqibz)

   end do !ig1
  end do !ig2

 end do !iomega

 case default
  write(msg,'(4a)')ch10,&
&  ' getem1_from_PPm : BUG- ',ch10,&
&  '  not allowed value for ppmodel '
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end select

end subroutine getem1_from_PPm
!!***


subroutine get_PPm_eigenvalues(PPm,iqibz,zcut,nomega,omega,Vcp,eigenvalues)

 use defs_basis
 use defs_datatypes
 use m_errors,   only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => get_PPm_eigenvalues
 use interfaces_linalg
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqibz,nomega
 type(PPmodel_type),intent(in) :: PPm
 type(Coulombian_type),intent(in) :: Vcp
 real(dp),intent(in) :: zcut
!arrays
 complex(dpc),intent(in) :: omega(nomega)
 complex(dpc),intent(out) :: eigenvalues(PPm%npwc,nomega)

!Local variables-------------------------------
!scalars
 integer :: info,lwork,istat,negw,ig1,ig2,io,idm,idx,sdim,iomega
 real(dp) :: den 
 complex(dpc) :: num,em1ggp,otw,zzpq,yg1,yg2,bot1,bot2,chig1g2
 character(len=500) :: msg
 logical :: ltest
!arrays
 real(dp),allocatable :: ww(:),rwork(:)
 complex(dpc),allocatable :: work(:),Adpp(:),eigvec(:,:),wwc(:),vs(:,:),Afull(:,:)
 complex(dpc),allocatable :: em1q(:,:,:)
 logical,allocatable :: bwork(:)
 logical :: sortcplx !BUG in abilint

! *************************************************************************

 ltest=(PPm%mqmem/=0)
 call assert(ltest,'mqmem==0 case in get_PPm_eigenvalues not implemented',__FILE__,__LINE__)

 allocate(em1q(PPm%npwc,PPm%npwc,nomega))

 call getem1_from_PPm(PPm,iqibz,zcut,nomega,omega,Vcp,em1q)
 !print*,em1q

 do iomega=1,nomega

  print*,'iomega',iomega

  if (ABS(REAL(omega(iomega)))>0.00001) then
   !if (.TRUE.) then
   ! === Eigenvalues for a generic complex matrix ===
                                                                                                         
   lwork=4*2*PPm%npwc
   allocate(wwc(PPm%npwc),work(lwork),rwork(PPm%npwc),bwork(PPm%npwc))
   allocate(vs(PPm%npwc,PPm%npwc),STAT=istat)
   allocate(Afull(PPm%npwc,PPm%npwc),STAT=istat)
 print*,'done'
                                                                                                         
   Afull=em1q(:,:,iomega)
                                                                                                         
   !for the moment no sort, maybe here I should sort using the real part?
   call ZGEES('V','N',sortcplx,PPm%npwc,Afull,PPm%npwc,sdim,wwc,vs,PPm%npwc,work,lwork,rwork,bwork,info)
   if (info/=0) then 
    write(msg,'(2a,i10)')' get_PPm_eigenvalues : Error in ZGEES, diagonalizing complex matrix, info = ',info
    call wrtout(std_out,msg,'COLL') 
   end if
                                                                                                         
 print*,'done'
   eigenvalues(:,iomega)=wwc(:)
                                                                                                         
   deallocate(wwc,work,rwork,bwork)
   deallocate(vs)
   deallocate(Afull)

  else 
   ! === Hermitian Case ===
   lwork=2*PPm%npwc-1
   allocate(ww(PPm%npwc),work(lwork),rwork(3*PPm%npwc-2))
   allocate(eigvec(PPm%npwc,PPm%npwc))
   allocate(Adpp(PPm%npwc*(PPm%npwc+1)/2),STAT=istat)
   if (istat/=0) STOP ' get_PPm_eigenvalues : out of memory in Adpp'

   print*,'in hermitian'
 
   idx=0
   do ig2=1,PPm%npwc
    do ig1=1,ig2
     idx=idx+1
     Adpp(idx)=em1q(ig1,ig2,iomega)
    end do
   end do

   ! For the moment we require also the eigenvectors.
   call ZHPEV('V','U',PPm%npwc,Adpp,ww,eigvec,PPm%npwc,work,rwork,info)

   if (info/=0) then 
    write(msg,'(2a,i10)')' get_PPm_eigenvalues : Error diagonalizing matrix, info = ',info
    call wrtout(std_out,msg,'COLL') 
   end if
   negw = (COUNT((REAL(ww)<tol6)))
   if (negw/=0) then 
    write(msg,'(3a,i5,a,i3,a,f8.4)')&
&    ' get_PPm_eigenvalues : WARNING - ',ch10,&
&    ' Found negative eigenvalues. No. ',negw,' at iqibz= ',iqibz,' minval= ',MINVAL(REAL(ww))
   end if

   eigenvalues(:,iomega)=ww(:)

   deallocate(ww,work,rwork)
   deallocate(eigvec)
   deallocate(Adpp)
  end if

 end do !iomega

 deallocate(em1q)

end subroutine get_PPm_eigenvalues
!!***
