!{\src2tex{textfont=tt}}
!!****f* ABINIT/screening_gwdistrb
!! NAME
!! screening_gwdistrb
!!
!! FUNCTION
!! Return the array gw_distrb used to define the distribution of the tasks inside cchi0.F90 and cchi0q0.F90.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  gwpara=Integer defining the parallelization level 
!!   ==== if gwpara==0
!!    | Sequential run.
!!   ==== if gwpara==1 
!!    | Parallelism over k-points.
!!   ==== if gwpara==2
!!    | Parallelism over bands.
!!  spaceComm=MPI communicator (for the time being MPI_COMM_WORLD)
!!  nkbz=Number of k-points in the FULL BZ.
!!  nbnds=Number of bands.
!!  nbvw
!!  nbcw
!!  nsppol=Number of polarizations.
!!  use_symmetries=.TRUE. if symmetries are used to reduce the BZ sum to the irreducible wedge 
!!   defined by the little group of the external k-point.
!!  Kmesh<BZ_mesh_type>=structure gathering data on the k-point sampling.
!!  Qmesh<BZ_mesh_type>=structure gathering data on the q-point sampling.
!!  Ltg_q<Little_group>=data type containing information on the little group of the external point at which
!!   GW correction are calculated.
!!  MPI_enreg<MPI_type>
!!
!! OUTPUT
!!  my_minb=minimum band index treated by this processor.
!!  my_maxb=Maximum band index treated by this processor.
!!  gw_distrb(nkbz,nbnds,nsppol)=Equal to the rank of the processor treating this partial 
!!   contribution to the matrix elements of sigma.
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      assert,findqg0,leave_new,split_work2,wrtout,xcomm_rank,xcomm_size
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine screening_gwdistrb(gwpara,gwcomp,spaceComm,nkbz,nbnds,nbvw,nbcw,nsppol,&
& use_symmetries,Kmesh,Qmesh,Ltg_q,MPI_enreg,my_minb,my_maxb,gw_distrb)
    
 use defs_basis
 use defs_datatypes
 use m_errors,   only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nkbz,nbnds,nsppol,gwpara,gwcomp,spaceComm
 integer,intent(in) :: nbvw,nbcw
 integer,intent(out) :: my_minb,my_maxb
 logical,intent(in) :: use_symmetries
 type(BZ_mesh_type),intent(in) :: Kmesh,Qmesh
 type(Little_group),intent(in) :: Ltg_q
 type(MPI_type),intent(in) :: MPI_enreg
!arrays
 integer,intent(out) :: gw_distrb(nkbz,nbnds,nsppol)

!Local variables-------------------------------
!scalars
 integer :: iband,ii,jj,iqm,ikbz,ikibz,isppol,ierr,irank,ikq
 integer :: master,rank,nprocs,ntasks,my_nbnds
 logical :: ltest
 character(len=500) :: msg      
!arrays
 integer :: g0(3)
 integer,allocatable :: istart(:),istop(:)
 
! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' screening_gwdistrb : enter'
 call wrtout(std_out,msg,'COLL') 
#endif

 ltest=(gwpara>=0.and.gwpara<=2)
 call assert(ltest,'gwpara must be 0,1, or 2',__FILE__,__LINE__)

 ! === Get MPI information ===
 call xcomm_size(spaceComm,nprocs,ierr)
 call xcomm_rank(spaceComm,rank,ierr)
 master=0

 if (gwpara==0) then
  gw_distrb(:,:,:)=rank
  call assert((nprocs==1),'When gwpara==0, nprocs must be 1',__FILE__,__LINE__)
  return
 end if

 !Warning if gwpara==2 in the old code, the first dimension if nkibz
 !        if gwpara==1 we use kkbz, this has to be rationalized
 allocate(istart(nprocs),istop(nprocs))
 gw_distrb(:,:,:)=-999
 my_minb=1
 my_maxb=nbnds

 if (gwpara==1) then
  ! === Parallelization over k-points ===

  if (.not.use_symmetries) then  
   ! === No symmetries: divide the full BZ among procs ===
   ! * If nprocs > Kmesh%nkbz, gw_distrb==-999 for rank > ntasks-1 and no harm should be done.
   call split_work2(Kmesh%nbz,nprocs,istart,istop)
   do irank=0,nprocs-1
    ii=istart(irank+1) 
    jj=istop (irank+1)
    gw_distrb(ii:jj,:,:)=irank
   end do 
  else  
   ! === Divide the IBZ_q among procs ===
   ! * Distribution might not be efficient for particular q-points.
   ! * gw_distrb is -999 for all the k-points not in the IBZ_q.
   ntasks=SUM(Ltg_q%ibzq(:)) 
   call split_work2(ntasks,nprocs,istart,istop)
   do irank=0,nprocs-1
    do ikbz=1,Kmesh%nbz
     do ikq=istart(irank+1),istop(irank+1)
      if (Ltg_q%bz2ibz(ikbz)==ikq) gw_distrb(ikbz,:,:)=irank
     end do 
    end do
   end do 
  end if 

  ! Announce the treatment of k-points by each proc
  do ikbz=1,Kmesh%nbz 
   do isppol=1,nsppol
    if (gw_distrb(ikbz,nbnds,isppol)==rank) then 
     write(msg,'(3(a,i4))')'P : treating k-point ',ikbz,' and spin ',isppol,' by node ',rank
     call wrtout(std_out,msg,'PERS')
    end if 
   end do 
  end do

 else if (gwpara==2) then

  write(msg,'(2a)')ch10,' loop over bands done in parallel (assuming time reversal!)'
  call wrtout(std_out,msg,'COLL')

  ! * Divide conduction states or divide all states in the case of completeness trick
  ! MG FIXME this part has to be checked, conflict due to merge with FB
  !if (Dtset%gwcomp==0) then
  if (gwcomp==0) then
   ! * Each proc has fully and partially occupied states.
   gw_distrb(:,1:nbvw,:)=rank
   call split_work2(nbcw,nprocs,istart,istop)
   my_minb=nbvw+istart(rank+1) 
   my_maxb=nbvw+istop (rank+1)
   do irank=0,nprocs-1
    gw_distrb(:,nbvw+istart(irank+1):nbvw+istop(irank+1),:)=irank
   end do 
  else
   call split_work2(nbnds,nprocs,istart,istop)
   my_minb=istart(rank+1)
   my_maxb=istop (rank+1)
   do irank=0,nprocs-1
    gw_distrb(:,istart(irank+1):istop(irank+1),:)=irank
   end do 
  end if
  my_nbnds=my_maxb-my_minb+1 
  ltest=(my_nbnds>0) 
  write(msg,'(4a,2(i4,a),a)')ch10,&
&  ' One or more processors has zero number of bands ',ch10,&
&  ' my_minb = ',my_minb,' my_maxb = ',my_maxb,ch10,&
&  ' This is a waste, decrease the number of processors '
  call assert(ltest,msg,__FILE__,__LINE__)

  ! Announce the treatment of bands by each node.
  do irank=0,nprocs-1
   if (irank==rank) then 
    write(msg,'(4(a,i4))')' treating ',my_nbnds,' bands from ',my_minb,' up to ',my_maxb,' by node ',irank
    call wrtout(std_out,msg,'PERS')
   end if 
  end do 
 
 end if !gwpara

 deallocate(istart,istop)

 ! === Check wheter gw_distrb agrees with the distribution of wfs ===
 do ikbz=1,Kmesh%nbz
  ikibz=Kmesh%tab(ikbz)
  do iband=1,nbnds
   do isppol=1,nsppol
    if (            gw_distrb(ikbz, iband,isppol)==rank.and. &
&       MPI_enreg%proc_distrb(ikibz,iband,isppol)/=rank) then
     write(msg,'(3a,4(a,i3),2a,i3)')ch10,&
&     ' screening_gwdistrb : BUG - ',ch10,&
&     ' Processor ',rank,' treats ikbz = ',ikbz,' iband = ',iband,' isppol = ',isppol,ch10,&
&     ' but it does not have the wavefunction corresponding to ikibz = ',ikibz
     call wrtout(std_out,msg,'COLL') 
     call leave_new('COLL')
    end if
   end do
  end do
 end do

#if defined DEBUG_MODE
 write(msg,'(a)')' screening_gwdistrb : exit'
 call wrtout(std_out,msg,'COLL') 
#endif

end subroutine screening_gwdistrb
!!***

!!****f* ABINIT/sigma_gwdistrb
!! NAME
!! sigma_gwdistrb
!!
!! FUNCTION
!! Return the array gw_distrb used to define the distribution of the tasks inside csigme.F90  
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  gwpara=Integer defining the parallelization level 
!!   ==== if gwpara==0
!!    | Sequential run.
!!   ==== if gwpara==1 
!!    | Parallelism over k-points.
!!   ==== if gwpara==2
!!    | Parallelism over bands.
!!  spaceComm=MPI communicator (for the time being MPI_COMM_WORLD)
!!  nkbz=Number of k-points in the FULL BZ.
!!  nbnds=Number of bands.
!!  nsppol=Number of polarizations.
!!  use_symmetries=.TRUE. if symmetries are used to reduce the BZ sum to the irreducible wedge 
!!   defined by the little group of the external k-point.
!!  mG0(3)
!!  Kmesh<BZ_mesh_type>=structure gathering data on the k-point sampling.
!!  Qmesh<BZ_mesh_type>=structure gathering data on the q-point sampling.
!!  Ltg_kgw<Little_group>=data type containing information on the little group of the external point at which
!!   GW correction are calculated.
!!  MPI_enreg<MPI_type>
!!
!! OUTPUT
!!  my_minb=minimum band index treated by this processor.
!!  my_maxb=Maximum band index treated by this processor.
!!  gw_distrb(nkbz,nbnds,nsppol)=Equal to the rank of the processor treating this partial 
!!   contribution to the matrix elements of sigma.
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      assert,findqg0,leave_new,split_work2,wrtout,xcomm_rank,xcomm_size
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine sigma_gwdistrb(gwpara,spaceComm,nkbz,nbnds,nsppol,&
& use_symmetries,mG0,Kmesh,Qmesh,Ltg_kgw,MPI_enreg,my_minb,my_maxb,gw_distrb)
    
 use defs_basis
 use defs_datatypes
 use m_errors,   only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => sigma_gwdistrb
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nkbz,nbnds,nsppol,gwpara,spaceComm
 integer,intent(out) :: my_minb,my_maxb
 logical,intent(in) :: use_symmetries
 type(BZ_mesh_type),intent(in) :: Kmesh,Qmesh
 type(Little_group),intent(in) :: Ltg_kgw
 type(MPI_type),intent(in) :: MPI_enreg
!arrays
 integer,intent(in) :: mG0(3)
 integer,intent(out) :: gw_distrb(nkbz,nbnds,nsppol)

!Local variables-------------------------------
!scalars
 integer :: iband,ii,jj,iqbz,ikibz,ikbz,iqibz_k,isppol,ierr,irank 
 integer :: rank,my_nbnds,nprocs,ntasks,master
 logical :: ltest
 character(len=500) :: msg      
!arrays
 integer :: g0(3)
 integer,allocatable :: istart(:),istop(:)
 real(dp) :: kgwmk(3),kgw(3)
 
! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' sigma_gwdistrb : enter'
 call wrtout(std_out,msg,'COLL') 
#endif

 ltest=(gwpara>=0.and.gwpara<=2)
 call assert(ltest,'gwpara must be 0,1, or 2',__FILE__,__LINE__)

 ! === Get MPI information ===
 call xcomm_size(spaceComm,nprocs,ierr)
 call xcomm_rank(spaceComm,rank,ierr)
 master=0

 if (gwpara==0) then
  gw_distrb(:,:,:)=rank
  call assert((nprocs==1),'When gwpara==0, nprocs must be 1',__FILE__,__LINE__)
  return
 end if

 !Warning if gwpara==2 in the old code, the first dimension if nkibz
 !        if gwpara==1 we use kkbz this has to rationalized

 allocate(istart(nprocs),istop(nprocs))
 gw_distrb(:,:,:)=-999 
 my_minb=1
 my_maxb=nbnds

 if (gwpara==1) then
  ! === Parallelization over k-points  ===

  if (.not.use_symmetries) then 
   ! === No symmetries, divide the full BZ among procs ===
   ! * If nprocs > Kmesh%nkbz, proc_distrb==-999 for rank>ntasks-1 and no harm should be done.
   call split_work2(Kmesh%nbz,nprocs,istart,istop)
   do irank=0,nprocs-1
    ii=istart(irank+1) 
    jj=istop (irank+1)
    gw_distrb(ii:jj,:,:)=irank
   end do 
  else  
   ! === Divide the IBZ_kgw among procs ===
   ! * Distribution might not be efficient for particular qs.
   ! * gw_distrb is -999 for all the k-points not in the IBZ_q.
   ntasks=SUM(Ltg_kgw%ibzq(:)) 
   call split_work2(ntasks,nprocs,istart,istop)  
   ! * Identify q and G0 where q+G0=kgw-k_bz
   ! TODO Rewrite findqg0
   kgw(:)=Ltg_kgw%ext_pt(:)
   do irank=0,nprocs-1
    do ikbz=1,Kmesh%nbz
     kgwmk(:)=kgw(:)-Kmesh%bz(:,ikbz) ! Warn xkcalc must be inside the BZ
     do iqibz_k=istart(irank+1),istop(irank+1)
      !call findqg0(iqbz,g0,kgwmk,Qmesh%nbz,Qmesh%bz,Sp%mG0) 
      call findqg0(iqbz,g0,kgwmk,Qmesh%nbz,Qmesh%bz,mG0) 
      if (Ltg_kgw%bz2ibz(iqbz)==iqibz_k) gw_distrb(ikbz,:,:)=irank
     end do
    end do 
   end do
  end if 

  ! === Announce the treatment of k-points by each proc ===
  do ikbz=1,Kmesh%nbz 
   do isppol=1,nsppol
    if (gw_distrb(ikbz,nbnds,isppol)==rank) then 
     write(msg,'(3(a,i4))')'P sigma : treating k-point ',ikbz,' and spin ',isppol,' by node ',rank
     call wrtout(std_out,msg,'PERS')
    end if
   end do 
  end do 

 else if (gwpara==2) then
  !
  ! === Setup of gw_distrb in case of band parallelism ===
  write(msg,'(2a)')ch10,' sigma : loop over bands done in parallel '
  call wrtout(std_out,msg,'COLL')

  call split_work2(nbnds,nprocs,istart,istop)
  my_minb=istart(rank+1) 
  my_maxb=istop (rank+1)
  if (my_minb>my_maxb) then 
   write(msg,'(6a,2(i6,a),a)')ch10,&
&   ' sigma : ERROR - ',ch10,&
&   '  One or more processors has zero number of bands ',ch10,&
&   '  my_minb = ',my_minb,' my_maxb = ',my_maxb,ch10,&
&   '  This is a waste, decrease the number of processors.'
   call wrtout(std_out,msg,'PERS') 
   call leave_new('COLL')
  end if 
  do irank=0,nprocs-1
   gw_distrb(:,istart(irank+1):istop(irank+1),:)=irank
  end do 

  ! * Announce the treatment of bands by each proc
  my_nbnds=my_maxb-my_minb+1
  do irank=0,nprocs-1
   if (irank==rank) then 
    write(msg,'(4(a,i4))')&
&    ' treating ',my_nbnds,' bands from ',my_minb,' up to ',my_maxb,' by node ',irank
    call wrtout(std_out,msg,'PERS')
   end if 
  end do 

 end if !gwpara

 deallocate(istart,istop)

 ! === Check wheter gw_distrb agrees with the distribution of wfs ===
 do ikbz=1,Kmesh%nbz
  ikibz=Kmesh%tab(ikbz)
  do iband=1,nbnds
   do isppol=1,nsppol
    if (            gw_distrb(ikbz, iband,isppol)==rank.and. &
&       MPI_enreg%proc_distrb(ikibz,iband,isppol)/=rank) then
     write(msg,'(3a,4(a,i3),2a,i3,a)')ch10,&
&     ' sigma_gwdistrb : BUG - ',ch10,&
&     ' Processor ',rank,' treats ikbz = ',ikbz,' iband = ',iband,' isppol = ',isppol,ch10,&
&     ' but it does not have the wavefunction corresponding to ikibz = ',ikibz
     call wrtout(std_out,msg,'COLL') 
     call leave_new('COLL')
    end if
   end do
  end do
 end do

#if defined DEBUG_MODE
 write(msg,'(a)')' sigma_gwdistrb : exit'
 call wrtout(std_out,msg,'COLL') 
#endif

end subroutine sigma_gwdistrb
!!***
