!{\src2tex{textfont=tt}}
!!****f* ABINIT/nullify_epsilonm1_results
!! NAME
!! nullify_epsilonm1_results
!!
!! FUNCTION
!! Initialize the pointer to null()
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! Er<Epsilonm1_results>=The data structure.
!!
!! OUTPUT
!!
!! PARENTS
!!      mrgscr,respfunc_methods,setup_sigma
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nullify_epsilonm1_results(Er)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_results),intent(inout) :: Er
! *************************************************************************
 
 nullify(Er%gvec)

 nullify(Er%qibz)
 nullify(Er%qlwl) 

 nullify(Er%epsm1) 
 nullify(Er%lwing)
 nullify(Er%omega)             
 nullify(Er%uwing)       

 !call nullify(Er%Hdr) Hdr is always read but nullification might be useful!

end subroutine nullify_epsilonm1_results
!!***

!!****f* ABINIT/destroy_epsilonm1_results
!! NAME
!! destroy_epsilonm1_results
!!
!! FUNCTION
!! Deallocate all the pointers in Er that result to be associated.
!! Perform also a cleaning of the Header.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      mrgscr,respfunc_methods,sigma
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine destroy_epsilonm1_results(Er)

 use defs_basis
 use defs_datatypes
 use m_io_screening, only : free_scrhdr

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_results),intent(inout) :: Er
! *************************************************************************

 if (ASSOCIATED(Er%gvec )) deallocate(Er%gvec)

 if (ASSOCIATED(Er%qibz )) deallocate(Er%qibz) 
 if (ASSOCIATED(Er%qlwl )) deallocate(Er%qlwl) 

 if (ASSOCIATED(Er%epsm1)) deallocate(Er%epsm1) 
 if (ASSOCIATED(Er%lwing)) deallocate(Er%lwing)
 if (ASSOCIATED(Er%omega)) deallocate(Er%omega)             
 if (ASSOCIATED(Er%uwing)) deallocate(Er%uwing)       

 call free_scrhdr(Er%Hscr)

end subroutine destroy_epsilonm1_results
!!***

!!****f* ABINIT/print_epsilonm1_results
!! NAME
!!  print_epsilonm1_results
!!
!! FUNCTION
!! Print the basic dimensions and the most important 
!! quantities reported in the Epsilonm1_results data type.
!!
!! INPUTS
!!  Er<Epsilonm1_results>=The data type.
!!  unit[optional]=the unit number for output.
!!  prtvol[optional]=verbosity level.
!!  mode_paral[optional]=either "COLL" or "PERS".
!!
!! OUTPUT
!!  Only printing. 
!!
!! PARENTS
!!      mrgscr,respfunc_methods
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE

subroutine print_epsilonm1_results(Er,unit,prtvol,mode_paral)

 use defs_basis
 use defs_datatypes
 use m_numeric_tools, only : print_arr

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,optional,intent(in) :: unit,prtvol
 character(len=4),optional,intent(in) :: mode_paral
 type(Epsilonm1_results),intent(in) :: Er

!Local variables-------------------------------
 integer :: iomega,iqibz,iqlwl,unt,verbose,rdwr
 character(len=100) :: fmt
 character(len=50) :: rfname,rforder,rfapprox,rftest,kxcname
 character(len=500) :: msg
 character(len=4) :: mode
! *************************************************************************

 unt=std_out ; if (PRESENT(unit))       unt=unit
 verbose=0   ; if (PRESENT(prtvol))     verbose=prtvol
 mode='COLL' ; if (PRESENT(mode_paral)) mode=mode_paral

 ! === chi0 or \epsilon^{-1} ? ===
 if (Er%ID==0) then
  rfname='Undefined'
 else if (Er%ID==1) then
  rfname='Irreducible Polarizability'
 else if (Er%ID==2) then
  rfname='Polarizability'
 else if (Er%ID==3) then
  rfname='Symmetrical Dielectric Matrix'
 else if (Er%ID==4) then
  rfname='Symmetrical Inverse Dielectric Matrix'
 else  
  write(msg,'(4a,i3)')ch10,&
&  ' print_epsilonm1_results : BUG - ',ch10,&
&  ' Wrong value of Er%ID = ',Er%ID
  call wrtout(unt,msg,'COLL') 
  call leave_new('COLL')
 end if

 ! === For chi, \espilon or \epsilon^{-1}, define the approximation ===
 rfapprox='None'
 if (Er%ID>=2.or.Er%ID<=4) then
  if (Er%ikxc==0) then 
   rfapprox='RPA'
  else if (Er%ikxc>0) then 
   rfapprox='Static TDDFT'
  else  
   rfapprox='TDDFT'
  end if
 end if

 ! === If TDDFT and \epsilon^{-1}, define the type ===
 rftest='None'
! if (Er%ID==0) then
!  if (Er%test_type==0) then 
!   rftest='TEST-PARTICLE'
!  else if (Er%test_type==1) then 
!   rftest='TEST-ELECTRON'
!  else 
!   write(msg,'(4a,i3)')ch10,&
!&   ' print_epsilonm1_results : BUG - ',ch10,&
!&   ' Wrong value of Er%test_type = ',Er%test_type
!   call wrtout(unt,msg,'COLL') 
!   call leave_new('COLL')
!  end if
! end if

 ! === Define time-ordering ===
 rforder='Undefined'
 if (Er%Tordering==1) then 
  rforder='Time-Ordered'
 else if (Er%Tordering==2) then 
  rforder='Advanced'
 else if (Er%Tordering==3) then 
  rforder='Retarded'
 else  
  write(msg,'(4a,i3)')ch10,&
&  ' print_epsilonm1_results : BUG - ',ch10,&
&  ' Wrong value of Er%Tordering = ',Er%Tordering
  call wrtout(unt,msg,'COLL') 
  call leave_new('COLL')
 end if

 kxcname='None'
 if (Er%ikxc/=0) then 
  !TODO Add function to retrieve kxc name
  STOP 'Add function to retrieve kxc name'
  kxcname='?????'
 end if

 write(msg,'(6a,5(3a))')ch10,&
& ' ==== Info on the Response Function ==== ',ch10,&
& '  Associated File ................  ',TRIM(Er%fname),ch10,&
& '  Response Function Type .......... ',TRIM(rfname),ch10,&
& '  Type of Approximation ........... ',TRIM(rfapprox),ch10,&
& '  XC kernel used .................. ',TRIM(kxcname),ch10,&
& '  Type of probing particle ........ ',TRIM(rftest),ch10,&
& '  Time-Ordering ................... ',TRIM(rforder),ch10
 call wrtout(unt,msg,mode) 
 write(msg,'(a,2i4,a,3(a,i4,a),a,3i4,2a,i4,a)')&
& '  Number of components ............ ',Er%nI,Er%nJ,ch10,&
& '  Number of q-points in the IBZ ... ',Er%nqibz,ch10,&
& '  Number of q-points for q-->0 .... ',Er%nqlwl,ch10,&
& '  Number of G-vectors ............. ',Er%npwe,ch10,&
& '  Number of frequencies ........... ',Er%nomega,Er%nomega_r,Er%nomega_i,ch10,&
& '  Value of mqmem .................. ',Er%mqmem,ch10
 call wrtout(unt,msg,mode) 

 if (Er%nqlwl/=0) then 
  write(msg,'(a,i3)')' q-points for long wavelength limit: ',Er%nqlwl
  call wrtout(unt,msg,mode) 
  do iqlwl=1,Er%nqlwl
   write(msg,'(1x,i5,a,3es16.8)')iqlwl,') ',Er%qlwl(:,iqlwl)
   call wrtout(unt,msg,mode)
  end do
 end if

 if (verbose>0) then
  ! TODO add additional stuff.
  ! === Print out head and wings in the long-wavelenght limit ===
  if (Er%nqlwl>0) then 
   write(msg,'(1x,2a)')' Heads and wings of chi0(G,G'')',ch10
   call wrtout(unt,msg,mode)
   do iqlwl=1,Er%nqlwl
    write(msg,'(1x,a,i2,a)')' chi0(qlwl =',iqlwl,')'
    call wrtout(unt,msg,mode)
    do iomega=1,Er%nomega
     write(msg,'(2x,a,i4,a,2f9.4,a)')&
&     ' Upper and lower wings at the ',iomega,' th omega',Er%omega(iomega)*Ha_eV,' [eV]'
     call wrtout(unt,msg,mode)
     call print_arr(Er%uwing(:,iomega,iqlwl),max_r=9,unit=unt)
     call print_arr(Er%lwing(:,iomega,iqlwl),max_r=9,unit=unt)
    end do
   end do
  end if

  write(msg,'(a,i4)')' Calculated Frequencies: ',Er%nomega
  call wrtout(unt,msg,mode) 
  do iomega=1,Er%nomega 
   write(msg,'(i4,es14.6)')iomega,Er%omega(iomega)*Ha_eV
   call wrtout(unt,msg,mode) 
  end do

  write(msg,'(a,i4)')' Calculated q-points: ',Er%nqibz
  call wrtout(unt,msg,mode) 
  do iqibz=1,Er%nqibz
   write(msg,'(1x,i4,a,3es16.8)')iqibz,') ',Er%qibz(:,iqibz)
   call wrtout(unt,msg,mode)
  end do

  rdwr=4
  !£call hdr_io_int(Er%fform,Er%Hscr%Hdr,rdwr,unt)
 end if ! verbose>0

end subroutine print_epsilonm1_results 
!!***


!!****f* ABINIT/Epsm1_symmetrizer
!! NAME
!!  Epsm1_symmetrizer
!!
!! FUNCTION
!!  Symmetrize the inverse dielectric matrix, namely calculate epsilon^{-1} at a generic 
!!  q-point in the BZ starting from the knowledge of the matrix at a q-point in the IBZ.
!!  The procedure is quite generic and can be used for every two-point function which has 
!!  the same symmetry as the crystal. 
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  nomega=Number of frequencies required. All frequencies from 1 up to nomega are symmetrized.
!!  npwc=Number of G vectors in symmetrized matrix, has to be smaller than Er%npwe.
!!  remove_exchange=If .TRUE., return e^{-1}-1 namely remove the exchange part.
!!  Er<Epsilonm1_results>=Data structure containing the inverse dielectric matrix.
!!  Gsph<Gvectors_type>=data related to the G-sphere
!!    %grottb
!!    %phmSGt 
!!  Qmesh<BZ_mesh_type>=Structure defining the q-mesh used for Er.
!!    %nbz=Number of q-points in the BZ
!!    %tab(nbz)=Index of the symmetric q-point in the IBZ, for each point in the BZ
!!    %tabo(nbz)=The operation that rotates q_ibz onto \pm q_bz (depending on tabi) 
!!    %tabi(nbz)=-1 if time-reversal has to be considered, 1 otherwise
!!  iq_bz=Index of the q-point in the BZ where epsilon^-1 is required. 
!!
!! OUTPUT
!!  epsm1_qbz(npwc,npwc,nomega)=The inverse dielectric matrix at the q-point defined by iq_bz. 
!!   Exchange part can be subtracted out.
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  In the present implementation we are not considering a possible umklapp vector G0 in the 
!!  expression Sq = q+G0. Treating this case would require some changes in the G-sphere 
!!  since we have to consider G-G0. The code however stops in sigma if a nonzero G0 is required 
!!  to reconstruct the BZ.
!! 
!!  * Remember the symmetry properties of \tilde\espilon^{-1}
!!    If q_bz=Sq_ibz+G0:
!! 
!!    $\epsilon^{-1}_{SG1-G0,SG2-G0}(q_bz) = e^{+iS(G2-G1).\tau}\epsilon^{-1}_{G1,G2)}(q)
!!
!!    If time-reversal symmetry can be used then :
!!    $\epsilon^{-1}_{G1,G2}(-q_bz) = e^{+i(G1-G2).\tau}\epsilon^{-1}_{-S^{-1}(G1+Go),-S^{-1}(G2+G0)}^*(q)
!!
!! TODO
!!  Symmetrization can be skipped if iq_bz correspond to a point in the IBZ
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE

subroutine Epsm1_symmetrizer(iq_bz,nomega,npwc,Er,Gsph,Qmesh,remove_exchange,epsm1_qbz) 

 use defs_basis
 use defs_datatypes
 use m_errors, only : assert

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iq_bz,nomega,npwc
 logical,intent(in) :: remove_exchange
 type(Epsilonm1_results),intent(in) :: Er
 type(Gvectors_type),intent(in) :: Gsph
 type(BZ_mesh_type),intent(in) :: Qmesh
!arrays
 complex(gwpc),intent(out) :: epsm1_qbz(npwc,npwc,nomega)  

!Local variables-------------------------------
!scalars
 integer :: iomega,ii,jj,iq_ibz,iiq,isymq,iq_loc
 character(len=500) :: msg
!arrays
 integer,pointer :: grottb(:)
 complex(gwpc),pointer :: phmSgt(:)

! *********************************************************************

#if defined DEBUG_MODE
 call assert( (Er%nomega>=nomega),'Too much frequencies required in Epsm1_symmetrizer')
 call assert( (Er%npwe  >=npwc),  'Too much G-vectors required in Epsm1_symmetrizer')
#endif

 ! FIXME here there is a problem with the small q, still cannot use BZ methods
 iq_ibz = Qmesh%tab (iq_bz) 
 isymq  = Qmesh%tabo(iq_bz) 
 iiq    = (3-Qmesh%tabi(iq_bz))/2

 grottb => Gsph%rottb (1:npwc,iiq,isymq)
 phmSgt => Gsph%phmSGt(1:npwc,isymq) 

 ! If out-of-memory, only Er%espm1(:,:,:,1) has been allocated and filled. 
 iq_loc=iq_ibz ; if (Er%mqmem==0) iq_loc=1 

 do iomega=1,nomega
  do ii=1,npwc
   do jj=1,npwc
    epsm1_qbz(grottb(ii),grottb(jj),iomega)=Er%epsm1(ii,jj,iomega,iq_loc)*phmSgt(ii)*CONJG(phmSgt(jj))
   end do
  end do
 end do
 !
 ! === Account for time-reversal ===
 if (iiq==2) then
  do iomega=1,nomega
   epsm1_qbz(:,:,iomega)=TRANSPOSE(epsm1_qbz(:,:,iomega))
  end do
 end if

 ! === Subtract the exchange contribution ===
 if (remove_exchange) then
  do iomega=1,nomega
   do ii=1,npwc
    epsm1_qbz(ii,ii,iomega)=epsm1_qbz(ii,ii,iomega)-1.0_gwp
   end do
  end do
 end if

end subroutine Epsm1_symmetrizer
!!***

!!****f* ABINIT/init_Er_from_file
!! NAME
!!  init_Er_from_file
!!
!! FUNCTION
!!  Initialize basic dimensions and the important (small) arrays in an Epsilonm1_results data type
!!  starting from a file containing either epsilon^{-1} (_SCR) or chi0 (_SUSC).
!!
!! INPUTS
!!  accesswff=Option defining the file format of the external file.
!!  fname=The name of the external file used to read the matrix.
!!  localrdwf=(parallel case) if 1, the file is local to each machine.
!!  mqmem=0 for out-of-core solution, /=0 if entire matrix has to be stored in memory. 
!!  npwe_asked=Number of G-vector to be used in the calculation, if <=0 use Max allowed number.
!!  MPI_enreg<MPI_type)=Information about the MPI parallelization.
!!
!! OUTPUT
!!  Er<Epsilonm1_results>=The structure initialized with basic dimensions and arrays.
!!
!! TODO MPI_enreg is redundant and should be removed, spaceComm is sufficient
!!
!! PARENTS
!!      mrgscr,respfunc_methods,setup_sigma
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE

subroutine init_Er_from_file(Er,fname,mqmem,npwe_asked,accesswff,localrdwf,MPI_enreg)

 use defs_basis
 use defs_datatypes
 use m_io_tools,     only : flush_unit, get_unit
 use m_io_screening, only : scr_hdr_io

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => init_Er_from_file
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: localrdwf,mqmem,accesswff,npwe_asked
 character(len=fnlen),intent(in) :: fname
 type(MPI_type),intent(in) :: MPI_enreg
 type(Epsilonm1_results),intent(inout) :: Er

!Local variables-------------------------------
!scalars
 integer :: ierr,iomega,ios,fform,rdwr,rank,master,spaceComm,unt
 character(len=500) :: msg                   
!arrays
 character(len=80) :: title(2) 

! *********************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' init_Er_from_file : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

 call nullify_epsilonm1_results(Er)

 !TODO pass spaceComm instead of MPI_enreg

 master=0
 call xcomm_init(MPI_enreg,spaceComm)   
 call xcomm_rank(spaceComm,rank,ierr)

 ! === Open file ===
 if (rank==master.or.localrdwf==1) then
  unt=get_unit()
  write(msg,'(3a)')' init_Er_from_file : testing file ',TRIM(fname),ch10
  call wrtout(std_out,msg,'COLL')
  open(unit=unt,file=fname,status='old',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(msg,'(6a)')ch10,&
&   ' init_Er_from_file : ERROR - ',ch10,&
&   ' opening file ',TRIM(fname),' as old '
   call wrtout(std_out,msg,'COLL') ; call leave_new('COLL')
  end if  
 end if

 rdwr=5
 call scr_hdr_io(fform,rdwr,unt,spaceComm,master,accesswff,localrdwf,Er%Hscr)

 if (rank==master.or.localrdwf==1) close(unt)

 ! === Master echoes the header ===
 if (rank==master) then
  rdwr=4
  call scr_hdr_io(fform,rdwr,std_out,spaceComm,master,accesswff,localrdwf,Er%Hscr)
 end if

 ! === Generic Info ===
 Er%ID         =0       ! To mean not yet initialized, epsm1 is calculated in mkdump_Er.F90
 Er%fname      =fname
 Er%fform      =fform

 Er%Tordering=Er%Hscr%Tordering

!TODO these quantitities should be check and initiliazed in mkdump_Er
!BEGIN HARCODED
 Er%nI=1
 Er%nJ=1
 Er%ikxc=0
 Er%test_type=-1    
!END HARDCODED

 Er%nqibz=Er%Hscr%nqibz
 Er%mqmem=mqmem ; if (mqmem/=0) Er%mqmem=Er%nqibz
 allocate(Er%qibz(3,Er%nqibz))
 Er%qibz(:,:)=Er%Hscr%qibz(:,:)

 Er%nqlwl=Er%Hscr%nqlwl
 allocate(Er%qlwl(3,Er%nqlwl))
 Er%qlwl(:,:)=Er%Hscr%qlwl(:,:)

 Er%nomega=Er%Hscr%nomega
 allocate(Er%omega(Er%nomega))
 Er%omega(:)=Er%Hscr%omega(:)

 if (Er%nomega==2) then
  Er%nomega_r=1 
  Er%nomega_i=1
 else
  ! Real frequencies are packed first.
  Er%nomega_r=1
  do iomega=1,Er%nomega
   if (REAL(Er%omega(iomega))>0.001*Ha_eV) Er%nomega_r=iomega
  end do
  Er%nomega_i=Er%nomega-Er%nomega_r
 end if     

 ! === Get G-vectors ===
 Er%npwe=Er%Hscr%npwe
 if (npwe_asked>0) then
  if (npwe_asked>Er%Hscr%npwe) then
   write(msg,'(4a,i8,2a,i8)')ch10,&
&   ' init_Er_from_file : WARNING -',ch10,&
&   '  Number of G-vectors saved on file is less than the value required = ',npwe_asked,ch10,&
&   '  Calculation will proceed with Max available npwe = ',Er%Hscr%npwe
   call wrtout(std_out,msg,'COLL') 
  else 
   ! Redefine the no. of G"s for W.
   Er%npwe=npwe_asked
  end if
 end if

 ! pointer to Er%Hscr%gvec ?
 allocate(Er%gvec(3,Er%npwe))
 Er%gvec(:,:)=Er%Hscr%gvec(:,1:Er%npwe)

#if defined DEBUG_MODE
 write(msg,'(a)')' init_Er_from_file : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine init_Er_from_file
!!***


!!****f* ABINIT/mkdump_Er
!! NAME
!!  mkdump_Er
!!
!! FUNCTION
!!  Dump the content of an Epsilonm1_results data type on file.
!!
!! INPUTS
!!  id_required=Identifier of the matrix to be calculated
!!  Vcp<Coulombian_type>=Structure gathering data on the Coulombian interaction
!!
!! OUTPUT
!!
!! PARENTS
!!      mrgscr,sigma
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE

subroutine mkdump_Er(Er,Vcp,dim_kxcg,kxcg,Dtfil,id_required,approx_type,ikxc_required,option_test,&
& fname_dump,accesswff,localrdwf,MPI_enreg)

 use defs_basis
 use defs_datatypes
 use m_gwdefs,   only : GW_TOLQ0
 use m_errors,   only : assert
 use m_io_tools, only : flush_unit, get_unit
 use m_geometry, only : normv
 use m_io_screening

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_12geometry
 use interfaces_15gw, except_this_one => mkdump_Er
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: id_required,approx_type,option_test,ikxc_required,dim_kxcg
 integer,intent(in) :: localrdwf,accesswff
 type(Datafiles_type),intent(in) :: Dtfil
 type(MPI_type),intent(in) :: MPI_enreg
 type(Epsilonm1_results),intent(inout) :: Er
 type(Coulombian_type),intent(in) :: Vcp
 character(len=fnlen),intent(in) :: fname_dump
!arrays 
 complex(gwpc),intent(in) :: kxcg(Er%npwe,Er%npwe*dim_kxcg) !FIXME this has to be rewritten LDA is (npwe,1)

!Local variables-------------------------------
!scalars
 integer :: ios,istat,iqibz,is_qeq0,mqmem_,npwe_asked
 integer :: unt_dump,fform,localrdwf_,test_type,rdwr 
 integer :: master,rank,spaceComm
 real(dp) :: ucvol
 character(len=80) :: title(2)
 character(len=500) :: msg                   
 type(ScrHdr_type) :: Hscr_cp
!arrays
 real(dp) :: gmet(3,3),gprimd(3,3),rmet(3,3)
 complex(gwpc),pointer :: epsm1(:,:,:)

! *********************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' mkdump_Er : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

 call assert((id_required==4),'Value of id_required not coded',__FILE__,__LINE__) 

 call metric(gmet,gprimd,-1,rmet,Vcp%rprimd,ucvol)

 !£ if (Er%ID/=0) call reset_Epsilonm1(Er)
 Er%ID=id_required

 if (Er%ID==Er%Hscr%ID) then
  ! === The two-point function we are asking is already stored on file ===
  ! * According to mqmem either read and store the entire matrix in memory or do nothing.
  if (Er%mqmem>0) then
   ! === In-core solution ===
   allocate(Er%lwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%uwing(Er%npwe,Er%nomega,Er%nqlwl))
   if (Er%nqlwl>0) then 
    !pointer ?
    Er%lwing(:,:,:)=Er%Hscr%lwing(1:Er%npwe,1:Er%nomega,1:Er%nqlwl)
    Er%uwing(:,:,:)=Er%Hscr%uwing(1:Er%npwe,1:Er%nomega,1:Er%nqlwl)
   end if

   allocate(Er%epsm1(Er%npwe,Er%npwe,Er%nomega,Er%nqibz),STAT=istat)
   if (istat/=0) then 
    write(*,*)' Out-of-memory in Er%epsm1 (in-core)'
    call leave_new('COLL')
   end if
   call read_screening(Er%fname,Er%npwe,Er%nqibz,Er%nomega,Er%epsm1,MPI_enreg,accesswff,localrdwf)
  else 
   ! === Out-of-core solution ===
   ! TODO? write a binary file with direct access
   write(msg,'(3a)')ch10,&
&   ' mkdump_Er : mqmem==0,',&
&   ' allocating single slice of screening (slower but less memory)' 
   call wrtout(std_out,msg,'COLL')
   continue 
  end if

  RETURN

 else 
  ! === The matrix stored on file do not correspond to the quantity required ===
  ! * Presently only the transformation chi0 => e^-1 is coded
  ! * According to Er%mqmem either calculate e^-1 dumping the result to a file 
  !   for a subsequent use or calculate e^-1 keeping everything in memory.

  if (Er%mqmem==0) then 
   call xcomm_init  (MPI_enreg,spaceComm)  
   call xmaster_init(MPI_enreg,master   ) 
   call xme_init    (MPI_enreg,rank     )             

   ! === Open file and write the header for the SCR file ===
   ! * For the moment only master works.
   if (rank==master) then
    write(msg,'(3a)')ch10,&
&    ' mkdump_Er : calculating and writing epsilon^-1 matrix on file ',TRIM(fname_dump)
    call wrtout(std_out,msg,'COLL')
    unt_dump=get_unit()
    open(unit=unt_dump,file=fname_dump,status='unknown',form='unformatted',iostat=ios)
    if (ios/=0) then 
     write(msg,'(6a)')ch10,&
     ' mkdump_Er : ERROR -',ch10,&
     '  opening file ',TRIM(fname_dump),' as new-unformatted'
    call wrtout(std_out,msg,'COLL') ; call leave_new('COLL')
    end if  

    ! === Update the entries in the header that have been modified ===
    ! TODO, write function to return title, just for info
    ! TODO nullification of pointers in fortran structures is needed to avoid problems during the copy.
    call copy_scrhdr(Er%Hscr,Hscr_cp)
    Hscr_cp%ID        = id_required
    Hscr_cp%ikxc      = ikxc_required
    Hscr_cp%test_type = option_test 
    Hscr_cp%title(1)  = 'SCR file: epsilon^-1'
    Hscr_cp%title(2)  = 'TESTPARTICLE' 

    rdwr=2 ; fform=Hscr_cp%fform ; localrdwf_=0
    call scr_hdr_io(fform,rdwr,unt_dump,spaceComm,master,accesswff,localrdwf_,Hscr_cp)
    call free_scrhdr(Hscr_cp)

    !allocate(Er%epsm1(Er%npwe,Er%npwe,Er%nomega,1))
    !epsm1 => Er%epsm1(:,:,:,1)
    allocate(epsm1(Er%npwe,Er%npwe,Er%nomega))

    do iqibz=1,Er%nqibz
     is_qeq0=0
     if (normv(Er%qibz(:,iqibz),gmet,'G')<GW_TOLQ0) is_qeq0=1

     call read_screening(Er%fname,Er%npwe,Er%nqibz,Er%nomega,epsm1,MPI_enreg,accesswff,localrdwf,iqiA=iqibz)

     call make_epsm1_driver(iqibz,Er%npwe,Er%nI,Er%nJ,Er%nomega,Er%nomega_r,Er%omega,&
&     approx_type,option_test,Er%nqibz,Er%qibz,Vcp,Dtfil%filnam_ds(4),gmet,dim_kxcg,kxcg,MPI_enreg,epsm1)

     call write_screening(unt_dump,accesswff,Er%npwe,Er%nomega,Er%omega,epsm1)
    end do

    close(unt_dump)
    deallocate(epsm1)
   end if !master

   ! Now Er% "belongs" to the file "fname_dump", thus 
   ! each proc has to destroy and re-initialize the object.
   call destroy_Epsilonm1_results(Er)

   mqmem_=Er%mqmem ; npwe_asked=Er%npwe
   call init_Er_from_file(Er,fname_dump,mqmem_,npwe_asked,accesswff,localrdwf,MPI_enreg)

   !Now Er% has been reinitialized and ready-to-use.
   Er%ID=id_required
   call print_epsilonm1_results(Er)

  else 
   ! ========================
   ! === In-core solution ===
   ! ========================
   allocate(Er%lwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%uwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%epsm1(Er%npwe,Er%npwe,Er%nomega,Er%nqibz),STAT=istat)
   if (istat/=0) then 
    write(*,*)' Out-of-memory in Er%epsm1 (in-core)'
    call leave_new('COLL')
   end if

   call read_screening(Er%fname,Er%npwe,Er%nqibz,Er%nomega,Er%epsm1,MPI_enreg,accesswff,localrdwf)

   do iqibz=1,Er%nqibz
    !is_qeq0=0
    !if (normv(Er%qibz(:,iqibz),gmet,'G')<GW_TOLQ0) is_qeq0=1
    epsm1 => Er%epsm1(:,:,:,iqibz)
                                                                                                           
    call make_epsm1_driver(iqibz,Er%npwe,Er%nI,Er%nJ,Er%nomega,Er%nomega_r,Er%omega,&
     approx_type,option_test,Er%nqibz,Er%qibz,Vcp,Dtfil%filnam_ds(4),gmet,dim_kxcg,kxcg,MPI_enreg,epsm1)
   end do

   Er%ID=id_required
   call print_epsilonm1_results(Er)

  end if

 end if

#if defined DEBUG_MODE
 write(msg,'(a)')' mkdump_Er : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine mkdump_Er
!!***


!!****f* ABINIT/get_epsm1
!! NAME
!!  get_epsm1
!!
!! FUNCTION
!!  Working in progress but the main is idea is as follows:
!!
!!  Return the symmetrized inverse dielectric matrix.
!!  This method implements both in-core and the out-of-core solution 
!!  In the later, epsilon^-1 or chi0 are read from file.
!!  It is possible to specify options to retrieve (RPA |TDDDT, [TESTCHARGE|TESTPARTICLE]).
!!  All dimensions are already initialized in the Er% object, this method 
!!  should act as a wrapper around rdscr and make_epsm1_driver. A better 
!!  implementation will be done in the following once the coding of file handlers is completed.
!!
!! INPUTS
!!  Dtfil<Datafiles_type)>=datatype containing filenames
!!  Vcp<Coulombian_type>=Structure gathering data on the Coulombian interaction
!!  iqibzA[optional]=Index of the q-point to be read from file (only for out-of-memory solutions)
!!  accesswff=option definig the file format.
!!  localrdwf=1 if file is local to each machine
!!  option_test
!!  gmet(3,3)=reciprocal space metric tensor in bohr**-2.
!!  MPI_enreg=informations about MPI parallelization
!!
!! OUTPUT
!!  Er%epsm1
!!
!! TODO
!!  Remove this routine. Now everything should be done with mkdump_Er
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE


subroutine get_epsm1(Er,Vcp,Dtfil,approx_type,option_test,accesswff,localrdwf,gmet,MPI_enreg,iqibzA)

 use defs_basis
 use defs_datatypes
 use m_io_tools, only : flush_unit
 use m_errors,   only : assert
 use m_io_screening

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: localrdwf,accesswff,option_test,approx_type
 integer,optional,intent(in) :: iqibzA
 type(Coulombian_type),intent(in) :: Vcp
 type(Datafiles_type),intent(in) :: Dtfil
 type(MPI_type),intent(in) :: MPI_enreg
 type(Epsilonm1_results),intent(inout) :: Er
!arrays
 real(dp),intent(in) :: gmet(3,3)

!Local variables-------------------------------
!scalars
 integer :: istat,iqibz,unt
 character(len=500) :: msg                   
!arrays
 real(dp) :: qibz_dum(3,Er%nqibz)
 complex(gwpc) :: omega_dum(Er%nomega)
 complex(gwpc),pointer :: epsm1(:,:,:)

! *********************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' get_epsm1 : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

 select case (Er%mqmem)
  case (0)
   ! === Out-of-core solution ===
   if (associated(Er%lwing)) deallocate(Er%lwing)
   if (associated(Er%uwing)) deallocate(Er%uwing)
   if (associated(Er%epsm1)) deallocate(Er%epsm1)
   allocate(Er%lwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%uwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%epsm1(Er%npwe,Er%npwe,Er%nomega,1),STAT=istat)
   if (istat/=0) then 
    write(*,*)' Out-of-memory in Er%epsm1 (out-of-core)'
    call leave_new('COLL')
   end if

   call read_screening(Er%fname,Er%npwe,Er%nqibz,Er%nomega,Er%epsm1,MPI_enreg,accesswff,localrdwf,iqiA=iqibzA)

   if (Er%ID==4) then 
     ! === If q-slice of epsilon^-1 has been read then return === 
     !call print_epsilonm1_results(Er)
     RETURN 
   else 
    call assert(.FALSE.,'Wrong Er%ID',__FILE__,__LINE__)
   end if

  case default
   ! ========================
   ! === In-core solution ===
   ! ========================
   stop 'you should not be here'
   allocate(Er%lwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%uwing(Er%npwe,Er%nomega,Er%nqlwl))
   allocate(Er%epsm1(Er%npwe,Er%npwe,Er%nomega,Er%nqibz),STAT=istat)
   if (istat/=0) then 
    write(*,*)' Out-of-memory in Er%epsm1 (in-core)'
    call leave_new('COLL')
   end if

   call read_screening(Er%fname,Er%npwe,Er%nqibz,Er%nomega,Er%epsm1,MPI_enreg,accesswff,localrdwf)

   if (Er%ID==4) then 
     ! === If epsilon^-1 has been read then return === 
     RETURN 
   else 
    call assert(.FALSE.,'Wrong Er%ID',__FILE__,__LINE__)
   end if

 end select

#if defined DEBUG_MODE
 write(msg,'(a)')' get_epsm1 : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine get_epsm1
!!***

!!****f* ABINIT/decompose_epsm1
!! NAME
!! decompose_epsm1
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      mrgscr
!!
!! CHILDREN
!!      assert,wrtout,zgees,zhpev
!!
!! SOURCE
!Decompose the complex symmetrized dielectric 
!TODO nomega_r or nomega?
subroutine decompose_epsm1(Er,iqibz,eigenvalues)

 use defs_basis
 use defs_datatypes
 use m_errors, only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_linalg
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqibz
 type(Epsilonm1_results),intent(in) :: Er
 complex(dpc),intent(out) :: eigenvalues(Er%npwe,Er%nomega)
!arrays

!Local variables-------------------------------
!scalars
 integer :: info,lwork,iomega,istat,negw,ig1,ig2,idx,sdim
 logical :: ltest
 character(len=500) :: msg                   
!arrays
 real(dp),allocatable :: ww(:),rwork(:)
 complex(dpc),allocatable :: work(:),Adpp(:),eigvec(:,:),Afull(:,:),vs(:,:),wwc(:)
 logical,allocatable :: bwork(:)
 logical :: sortcplx !BUG in abilint

! *********************************************************************

 ltest=(Er%mqmem/=0)
 call assert(ltest,'mqmem==0 case not implemented',__FILE__,__LINE__)

 do iomega=1,Er%nomega

  if (ABS(REAL(Er%omega(iomega)))>0.00001) then
  !if (.TRUE.) then
   ! === Eigenvalues for a generic complex matrix ===

   lwork=4*2*Er%npwe
   allocate(wwc(Er%npwe),work(lwork),rwork(Er%npwe),bwork(Er%npwe))
   allocate(vs(Er%npwe,Er%npwe),STAT=istat)
   allocate(Afull(Er%npwe,Er%npwe),STAT=istat)

   Afull=Er%epsm1(:,:,iomega,iqibz)

   !for the moment no sort, maybe here I should sort using the real part?
   call ZGEES('V','N',sortcplx,Er%npwe,Afull,Er%npwe,sdim,wwc,vs,Er%npwe,work,lwork,rwork,bwork,info)
   if (info/=0) then 
    write(msg,'(2a,i10)')' decompose_epsm1 : Error in ZGEES, diagonalizing complex matrix, info = ',info
    call wrtout(std_out,msg,'COLL') 
   end if

   eigenvalues(:,iomega)=wwc(:)

   deallocate(wwc,work,rwork,bwork)
   deallocate(vs)
   deallocate(Afull)

  else 
   ! === Hermitian version ===

   lwork=2*Er%npwe-1
   allocate(ww(Er%npwe),work(lwork),rwork(3*Er%npwe-2))
   allocate(eigvec(Er%npwe,Er%npwe))
   allocate(Adpp(Er%npwe*(Er%npwe+1)/2),STAT=istat)
   if (istat/=0) STOP ' decompose_epsm1 : out of memory in Adpp'

   idx=0 ! Pack the matrix
   do ig2=1,Er%npwe
    do ig1=1,ig2
     idx=idx+1
     Adpp(idx)=Er%epsm1(ig1,ig2,iomega,iqibz)
    end do 
   end do

   ! For the moment we require also the eigenvectors.
   call ZHPEV('V','U',Er%npwe,Adpp,ww,eigvec,Er%npwe,work,rwork,info)
   if (info/=0) then 
    write(msg,'(2a,i10)')' decompose_epsm1 : Error in ZHPEV, diagonalizing matrix, info = ',info
    call wrtout(std_out,msg,'COLL') 
   end if

   negw=(COUNT((REAL(ww)<tol6)))
   if (negw/=0) then 
    write(msg,'(3a,i5,a,i3,a,f8.4)')&
&    ' decompose_epsm1 : WARNING - ',ch10,&
&    ' Found negative eigenvalues. No. ',negw,' at iqibz= ',iqibz,' minval= ',MINVAL(REAL(ww))
    call wrtout(std_out,msg,'COLL') 
   end if

   eigenvalues(:,iomega)=ww(:)

   deallocate(ww,work,rwork)
   deallocate(eigvec)
   deallocate(Adpp)
  end if
 
 end do !iomega

! contains 
! function sortcplx(carg) result(res)
!
!  implicit none 
!
!  complex(dpc),intent(in) :: carg
!  logical :: res
!
!  res=.TRUE.
!
! end function sortcplx


end subroutine decompose_epsm1
!!***
