!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawr
!! NAME
!! pawr
!!
!! FUNCTION
!! Evaluate matrix elements of the position operator between PAW AE partial waves.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  Pawtab(ntypat) <type(pawtab_type)>=paw tabulated data read at start:
!!     %lmn_size
!!     %lmn2_size
!!     %indklmn
!!     %phiphj 
!!  Pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data:
!!     %mesh_size=Dimension of radial mesh
!!     %rad(mesh_size)=The coordinates of all the points of the radial mesh
!!  Pawang <type(pawang_type)>=paw angular mesh and related data
!!     %lmax=Maximum value of angular momentum l+1
!!     %gntselect((2*l_max-1)**2,l_max**2,l_max**2)= selection rules for Gaunt coefficients
!!     %realgnt
!!  Psps <type(pseudopotential_type)>=Information on pseudopotentials
!!     %indlmn
!!  natom=number of atoms in unit cell
!!  ntypat=number of types of atom
!!  typat(natom)=type of each atom
!!  xcart(3,natom)=cartesian coordinates
!!
!! OUTPUT
!!  rcart_onsite(3,lmn2_size_max,natom)
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      cchi0q0
!!
!! CHILDREN
!!      flush_unit,simp_gen,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawr(Pawtab,Pawrad,Pawang,Psps,natom,ntypat,typat,xcart,lmn2_size_max,rcart_onsite)

 use defs_basis
 use defs_datatypes
 use m_errors,   only : assert
 use m_io_tools, only : flush_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_11util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: lmn2_size_max,natom,ntypat
 type(Pawang_type),intent(in) :: Pawang
 type(Pseudopotential_type),intent(in) :: Psps
!arrays
 integer,intent(in) :: typat(natom)
 real(dp),intent(in) :: xcart(3,natom)
 real(dp),intent(inout) :: rcart_onsite(3,lmn2_size_max,natom)
 type(Pawrad_type),intent(in) :: Pawrad(ntypat)
 type(Pawtab_type),intent(in) :: Pawtab(ntypat)

!Local variables-------------------------------
!scalars
 integer,parameter :: ll1=1
 integer :: iatom,idir,ignt,il,ilm,ilm_G,ilmn,iln,im,itypat,jl,jlm,jlmn,jln,jm,k0lm
 integer :: k0lmn,k0ln,klm,klmn,kln,lmn_size,mesh_size,mm_G,lmn2_size,ilmjl
 real(dp) :: fact,intff,rgnt
 logical :: ltest
 character(len=500) :: msg
!arrays
 real(dp) :: r0(3)
 real(dp),allocatable :: ff(:),rad(:)
 real(dp),allocatable :: rc_tmp(:,:)

! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' pawr : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

 fact=two*SQRT(pi/three)
 rcart_onsite(:,:,:)=zero

 do itypat=1,ntypat
  lmn_size  =Pawtab(itypat)%lmn_size
  lmn2_size =Pawtab(itypat)%lmn2_size
  mesh_size =Pawrad(itypat)%mesh_size

  allocate(ff(mesh_size),rad(mesh_size))
  rad(1:mesh_size)=Pawrad(itypat)%rad(1:mesh_size)

  allocate(rc_tmp(3,lmn2_size))
  rc_tmp=zero
  !
  ! === Loop on (jl,jm,jn) channels 
  do jlmn=1,lmn_size
   jl =Psps%indlmn(1,jlmn,itypat)
   jm =Psps%indlmn(2,jlmn,itypat)
   jlm=Psps%indlmn(4,jlmn,itypat)
   jln=Psps%indlmn(5,jlmn,itypat)
  
   k0lmn=jlmn*(jlmn-1)/2 
   k0lm =jlm *(jlm -1)/2
   k0ln =jln *(jln -1)/2
   !
   ! === Loop on (il,im,in) channels; klmn is the index for packed form ===
   do ilmn=1,jlmn 
    il =Psps%indlmn(1,ilmn,itypat)
    im =Psps%indlmn(2,ilmn,itypat)
    ilm=Psps%indlmn(4,ilmn,itypat)
    iln=Psps%indlmn(5,ilmn,itypat)
  
    klmn=k0lmn+ilmn 
    klm =k0lm +ilm
    kln =k0ln +iln
    !
    ! === For each cartesian direction, use expansion in terms of RSH ===
    ! TODO Add a check if l=1 is in the set
    do idir=1,3
     if (idir==1) mm_G= 1
     if (idir==2) mm_G=-1
     if (idir==3) mm_G= 0
     ilm_G=1+ll1**2+ll1+mm_G
     ignt=Pawang%gntselect(ilm_G,klm)
     if (ignt/=0) then
      rgnt=Pawang%realgnt(ignt)
      ff(1)=zero
      !ff(2:mesh_size)=(Pawtab(itypat)%phiphj(2:mesh_size,kln)-Pawtab(itypat)%tphitphj(2:mesh_size,kln))*rad(2:mesh_size)
      ff(2:mesh_size)=Pawtab(itypat)%phiphj(2:mesh_size,kln)*rad(2:mesh_size)
      call simp_gen(intff,ff,Pawrad(itypat))
      rc_tmp(idir,klmn)=fact*intff*rgnt
     end if
    end do !idir

   end do !ilmn
  end do !jllmn
  
  ! === Make matrix elements for each atom of this type ===      
  do jlmn=1,lmn_size
   jl =Psps%indlmn(1,jlmn,itypat)
   jm =Psps%indlmn(2,jlmn,itypat)
   jln=Psps%indlmn(5,jlmn,itypat)

   k0lmn=jlmn*(jlmn-1)/2 
   k0ln =jln *(jln -1)/2

   do ilmn=1,jlmn 
    il =Psps%indlmn(1,ilmn,itypat)
    im =Psps%indlmn(2,ilmn,itypat)
    iln=Psps%indlmn(5,ilmn,itypat)
                                
    klmn=k0lmn+ilmn 
    kln =k0ln +iln

    intff=zero
    if (il==jl.and.jm==im) then 
     ff(1:mesh_size)=Pawtab(itypat)%phiphj(1:mesh_size,kln)
     call simp_gen(intff,ff,Pawrad(itypat))
    end if
    do iatom=1,natom
     if (typat(iatom)/=itypat) CYCLE
     rcart_onsite(:,klmn,iatom)=rc_tmp(:,klmn) + xcart(:,iatom)*intff
    end do

   end do ! ilmn
  end do !jlmn

  deallocate(ff,rad)
  deallocate(rc_tmp)
 end do !itypat

#if defined DEBUG_MODE
 write(msg,'(a)')' pawr : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine pawr
!!***

