!{\src2tex{textfont=tt}}
!!****f* ABINIT/joint_dos
!! NAME
!! joint_dos
!!
!! FUNCTION
!!  Calculate the joint density of states 
!!   $J(\omega,q)=\sum_{k,b1,b2} \delta(\omega-\epsilon_{k-q,b2}+\epsilon_{k,b1})$
!!  for a given set of external q-points. 
!!  Two different quadrature methods are employed according to the input variable method:
!!   method=1 => simple gaussian broadenig 
!!   method=2 => tetrahedron method
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  fname=Name of the output file.
!!  Cryst<Crystal_structure>=Info on unit cell and its symmetries
!!    %nsym=number of symmetry operations
!!    %symrec(3,3,nsym)=symmetry operations in reciprocal space (reduced coordinates)
!!    %tnons(3,nsym)=fractional translations
!!    %timrev=2 if time-reversal holds, 1 otherwise
!!  qibz(3,:)=q-points in reduced coordinates. If size is 0, calculate all the q-points
!!  BSt<Bandstructure_type>=Type gathering info on the electronic band structure
!!   %kpt(3,nkpt)=the irreducible k-points (reduced coordinates)
!!   %nkpt=Number of irreducible k-points
!!   %nsppol=Number of Independendent spin polarizations
!!   %eig(mband,nkpt,nsppol)=energies
!!   %occ(mband,nkpt,nsppol)=occupation numbers
!!   %nband(nkpt*nsppol)=number of bands for each k-point and spin
!!  method=1 for gaussian broadening, 2 for tetrahedron 
!!  step=freqency step for JDOS
!!  broad=only for gaussian method, the broadening in Ha 
!!  
!! OUTPUT
!!  Only write
!!
!! SIDE EFFECTS
!!
!! TODO
!!  This should be a method of Bandstructure_type, waiting for restructuring
!!  of the build systems to solve dependencies.
!!  Ideally this method should report a class (J)DOS, 
!!
!! PARENTS
!!
!! CHILDREN
!!      assert,destroy_bz_mesh_type,destroy_little_group,find_qmesh,flush_unit
!!      get_bz_diff,get_bz_item,initkmesh,leave_new,nullify_little_group,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine joint_dos(qibz,Cryst,BSt,fname,method,step,broad)

 use defs_basis
 use defs_datatypes
 use m_bz_mesh
 use m_numeric_tools, only : arth
 use m_io_tools,      only : flush_unit, get_unit
 use m_errors,        only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => joint_dos
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: method
 real(dp),intent(in) :: broad,step
 character(len=fnlen),intent(in) :: fname
 type(Crystal_structure),intent(in) :: Cryst
 type(Bandstructure_type),intent(in) :: BSt
!arrays
 real(dp),target,intent(in) :: qibz(:,:)

!Local variables-------------------------------
!scalars
 integer :: ib1,ib2,iend,ikbz,ikibz,ikmq_bz,ikmq_ibz,iomega,nqibz
 integer :: iqibz,isppol,istart,isym_k,isym_kmq,itim_k,itim_kmq,nband_k,nband_kmq
 integer :: nfound,nomega,npwe,npwvec,prtvol,unt,use_umklp
 real(dp),parameter :: TOL_OCC=tol6
 real(dp) :: dossmear,ene1,ene2,gaussfactor,gaussprefactor,gaussval,max_transition,occ1
 real(dp) :: occ2,trans,xx
 logical :: ltest
 character(len=500) :: msg
 type(BZ_mesh_type) :: Kmesh,Qmesh
 type(Little_group) :: Ltg_q
!arrays
 integer :: G0(3)
 real(dp) :: gmet_dummy(3,3),kbz(3),kmq(3),qq(3)
 real(dp) :: eminmax(2,BSt%nsppol)
 real(dp),allocatable :: jdos(:,:,:),omega(:) 
 real(dp),pointer :: qcalc(:,:)

! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' joint_dos : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif
 !
 ! === Check input ===
 ltest=(Cryst%timrev==1.or.Cryst%timrev==2)
 call assert(ltest,'timrev should be 1 or 2,',__FILE__,__LINE__)
 ltest=(method==1.or.method==2)
 call assert(ltest,'method should be 1 or 2,',__FILE__,__LINE__)
 !
 ! === Initialize the k-mesh structure ===
 prtvol=0 
 call InitKmesh(BSt%nkpt,BSt%kptns,Cryst,Kmesh,prtvol)

 nqibz=SIZE(qibz,DIM=2)
 if (nqibz/=0) then 
  qcalc => qibz(:,:)
 else
  call find_Qmesh(Cryst,Kmesh,Qmesh,prtvol)
  nqibz=Qmesh%nibz
  qcalc => Qmesh%ibz(:,:)
 end if 

 ! === Linear mesh starting at zero ===
 eminmax=get_minmax(BSt,'eig')
 max_transition=MAXVAL(eminmax(2,:)-eminmax(1,:)) 
 if (method==1) max_transition=max_transition+five*broad+tol6

 nomega=NINT(max_transition/step)+1
 allocate(omega(nomega))
 omega(:)=arth(zero,step,nomega)

 allocate(jdos(nomega,BSt%nsppol,nqibz)) ; jdos=zero

 SELECT CASE (method) 

 CASE (1)
  ! === Gaussian method ===
  gaussprefactor=one/(dossmear*SQRT(two_pi))
  gaussfactor=one/(sqrt2*dossmear)
  write(msg,'(4a,f8.5,2a,f8.5)')ch10,&
&  ' joint_dos : calculating Joint DOS using gaussian method :',ch10,&
&  ' gaussian smearing [eV] = ',broad*Ha_eV,ch10,&
&  ' energy step       [eV] = ',step*Ha_eV

 CASE (2)
  ! === Tetrahedron method ===
  write(msg,'(2a)')ch10,&
&  ' mkphdos : calculating joint DOS using tetrahedron method '
  stop "not implemented yet"

 CASE DEFAULT 
  STOP 'Wrong value for method'
 END SELECT

 call wrtout(std_out,msg,'COLL')

 call nullify_little_group(Ltg_q)

 do iqibz=1,nqibz
  qq(:)=qcalc(:,iqibz) 

  !TODO add little group
  !use_umklp=1 ; npwvec=0 ; npwe=0
  !call setup_little_group(qq,Kmesh,Cryst,npwvec,gvec,npwe,use_umklp,prtvol,Ltg_q)

  do ikbz=1,Kmesh%nbz
   do isppol=1,BSt%nsppol
    !
    ! === Get k and k-q in BZ and their symmetric in the IBZ ===
    call get_BZ_item(Kmesh,ikbz,kbz,ikibz,isym_k,itim_k)
    call get_BZ_diff(Kmesh,kbz,qq,ikmq_bz,G0,nfound)
    if (nfound/=1) then 
     call leave_new('COLL') 
    end if
    call get_BZ_item(Kmesh,ikmq_bz,kmq,ikmq_ibz,isym_kmq,itim_kmq)

    nband_k  =BSt%nband(ikibz   +(isppol-1)*BSt%nkpt)
    nband_kmq=BSt%nband(ikmq_ibz+(isppol-1)*BSt%nkpt)

    do ib2=1,nband_kmq
     occ2 = BSt%occ(ib2,ikmq_ibz,isppol)
     ene2 = BSt%eig(ib2,ikmq_ibz,isppol)

     do ib1=1,nband_k
      occ1 = BSt%occ(ib1,ikibz,isppol) ; if (ABS(occ1*(one-occ2))<TOL_OCC) CYCLE !occ1 might be not monotonic
      ene1 = BSt%eig(ib1,ikibz,isppol)

      ! three*broad should be enough, five should give smooth curves for coarse k-meshes.
      trans=ene2-ene1
      iend  =NINT((trans+five*broad)/step) ; if (iend>nomega) iend  =nomega
      istart=NINT((trans-five*broad)/step) ; if (istart<=0)   istart=1
      !
      ! === Accumulate ===
      do iomega=istart,iend
       xx=(omega(iomega)-trans)*gaussfactor
       gaussval=gaussprefactor*EXP(-xx*xx)
       jdos(iomega,isppol,iqibz)=jdos(iomega,isppol,iqibz)+gaussval!+Kmesh%wtk(ikibz)*gaussval
      end do

     end do !ib1
    end do !ib2
   end do !isppol
  end do !ikbz

 end do !iqibz
 !
 ! === Write results ===
 !fnam='JDOS' ; call isfile(fname,'new')
 unt=get_unit()
 open(file=fname,unit=unt,form='formatted')
 write(unt,'(a)')         '# Joint density of states. All in eV units '
 write(unt,'(a,es16.8,a)')'# Frequency step ',step*Ha_eV,' [eV]'
 write(unt,'(a,es16.8,a)')'# Max Frequency  ',max_transition*Ha_eV,' [eV]'
 write(unt,'(a,i2)')      '# Number of Independendent polarization',BSt%nsppol
 write(unt,'(a,i5)')      '# Number of k-points in BZ ',Kmesh%nbz
 write(unt,'(a,i5)')      '# Number of analysed q-points',nqibz
 do iqibz=1,nqibz
  write(unt,'(a,i4,a,3es16.8)')'# ',iqibz,') ',qcalc(:,iqibz)
 end do
 write(unt,'(a)')'#'
 write(unt,'(a)')'# do iomega=1,nomega '
 write(unt,'(a)')'#  print*, omega(iomega),((jdos(iomega,isppol,iqibz),isppol=1,nsppol),iqibz=1,nqibz)'
 write(unt,'(a)')'# end do '
 write(unt,'(a)')'#'
 do iomega=1,nomega
  write(unt,'(es16.8)')omega(iomega),((jdos(iomega,isppol,iqibz),isppol=1,BSt%nsppol),iqibz=1,nqibz)
 end do
 close(unt)

 nullify(qcalc)

 ! === Free memory ===
 deallocate(omega,jdos)

 call destroy_Little_group(Ltg_q)
 call destroy_BZ_mesh_type(Kmesh)
 if (SIZE(qibz,DIM=2)==0) then
  call destroy_BZ_mesh_type(Qmesh)
 end if

#if defined DEBUG_MODE
 write(msg,'(a)')' joint_dos : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

end subroutine joint_dos
!!***
