!{\src2tex{textfont=tt}}
!!****f* ABINIT/write_sigma_results_header
!! NAME
!! write_sigma_results_header
!!
!! FUNCTION
!! input/output sigma results
!! This file contains 4 routines : 
!!  write_sigma_results_header,
!!  write_sigma_results, rdgw,
!!  rdgw
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  Sp=sigma_parameters
!!  Cryst<Crystal_structure>= Info on the Crystal structure
!!  Kmesh<Bz_mesh_type>= Description of the BZ sampling.
!!
!! OUTPUT
!!  (for writing routines, no output) otherwise, should be described
!!
!! NOTES
!!
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      int2char
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine write_sigma_results_header(Sp,Er,Cryst,Kmesh,Qmesh)

 use defs_basis
 use defs_datatypes
 use m_io_tools, only : flush_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bz_mesh_type),intent(in) :: Kmesh,Qmesh
 type(Crystal_structure),intent(in) :: Cryst
 type(Epsilonm1_results),intent(in) :: Er
 type(Sigma_parameters),intent(in) :: Sp

!Local variables-------------------------------
!scalars
 integer :: mod10
 character(len=500) :: msg

! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' write_sigma_results_header : enter '
  call wrtout(std_out,msg,'COLL')
  call flush_unit(std_out)
#endif

 write(msg,'(a)')' SIGMA fundamental parameters:'
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 mod10=MOD(Sp%gwcalctyp,10)
 SELECT CASE (mod10)
 CASE (0)
  write(msg,'(a,i2)')' PLASMON POLE MODEL ',Sp%ppmodel
 CASE (1)
  write(msg,'(a)')' ANALYTIC CONTINUATION'
 CASE (2)
  write(msg,'(a)')' CONTOUR DEFORMATION'
 CASE (5)
  write(msg,'(a)')' Hartree-Fock'
 CASE (6)
  write(msg,'(a)')' Screened Exchange'
 CASE (7)
  write(msg,'(a)')' COHSEX'
 CASE (8)
  write(msg,'(a,i2)')' MODEL GW with PLASMON POLE MODEL ',Sp%ppmodel
 CASE (9)
  write(msg,'(a)')' MODEL GW without PLASMON POLE MODEL'
 CASE DEFAULT
  write(msg,'(4a,i3)')ch10,&
&  ' write_sigma_results_header : BUG ',ch10,&
&  ' wrong value for Sp%gwcalctyp = ',Sp%gwcalctyp 
  call wrtout(std_out,msg,'COLL') ; call leave_new('COLL')
 END SELECT
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 write(msg,'(a,i12)')' number of plane-waves for SigmaX         ',Sp%npwx
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of plane-waves for SigmaC and W   ',Sp%npwc
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of plane-waves for wavefunctions  ',Sp%npwwfn
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of bands                          ',Sp%nbnds
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of independent spin polarizations ',Sp%nsppol
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of spinorial components           ',Sp%nspinor
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of k-points in IBZ                ',Kmesh%nibz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of q-points in IBZ                ',Qmesh%nibz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of symmetry operations            ',Cryst%nsym
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of k-points in BZ                 ',Kmesh%nbz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of q-points in BZ                 ',Qmesh%nbz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of frequencies for dSigma/dE      ',Sp%nomegasrd
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,f12.2)')' frequency step for dSigma/dE [eV]        ',Sp%deltae*Ha_eV
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of omega for Sigma on real axis   ',Sp%nomegasr
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,f12.2)')' max omega for Sigma on real axis  [eV]   ',Sp%maxomega_r*Ha_eV
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,f12.2)')' zcut for avoiding poles [eV]             ',Sp%zcut*Ha_eV
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 if (Sp%soenergy>0.1d-4) then 
  write(msg,'(a,f12.2)')' scissor energy [eV]                      ',Sp%soenergy*Ha_eV
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 end if

 if (MOD(Sp%gwcalctyp,10)==1) then
  write(msg,'(a,i12)')' number of imaginary frequencies for Sigma',Sp%nomegasi
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
  write(msg,'(a,f12.2)')' max omega for Sigma on imag axis  [eV]   ',Sp%omegasimax*Ha_eV
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 end if 

 write(msg,'(2a)')ch10,' EPSILON^-1 parameters (SCR file):'
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 !write(std_out,*) titem1(2)(1:79)
 write(msg,'(a,i12)')' dimension of the eps^-1 matrix on file   ',Er%Hscr%npwe
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' dimension of the eps^-1 matrix used      ',Er%npwe
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of plane-waves for wavefunctions  ',Er%Hscr%npwwfn_used
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of bands                          ',Er%Hscr%nbnds_used
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of q-points in IBZ                ',Qmesh%nibz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of frequencies                    ',Er%nomega
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of real frequencies               ',Er%nomega_r
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of imag frequencies               ',Er%nomega_i
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 write(msg,'(3a)')ch10,' matrix elements of self-energy operator (all in [eV])',ch10
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 if (Sp%gwcalctyp<10) then
  write(msg,'(a)')' Perturbative Calculation'
 else if (Sp%gwcalctyp<20) then
  write(msg,'(a)')' Self-Consistent on Energies only'
 else
  write(msg,'(a)')' Self-Consistent on Energies and Wavefunctions'
 end if
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

#if defined DEBUG_MODE
 write(msg,'(a)')' write_sigma_results_header : exit '
 call wrtout(std_out,msg,'COLL')
 call flush_unit(std_out)
#endif

end subroutine write_sigma_results_header
!!***


!!****f* ABINIT/write_sigma_results
!! NAME
!! write_sigma_results
!!
!! FUNCTION
!! write the final results of the GW calculation
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2009 ABINIT group (FBruneval, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! KS_BSt<Bandstructure_type>=Info on the KS band structure energies.
!!    %eig(mband,nkibz,nsppol)= KS energies
!! ikibz= index of the k-point in the array kibz, where GW corrections are calculated 
!! ikcalc= index of the k-point in the array sp%kcalc 
!! Kmesh<Bz_mesh_type>=Info on the k-point mesh
!! sp=sigma_parameters datatype
!! sr=sigma results datatype
!!
!! OUTPUT
!!  (for writing routines, no output) otherwise, should be described
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      int2char
!!
!! SOURCE
!!

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine write_sigma_results(ikcalc,ikibz,Sp,Sr,Kmesh,KS_BSt)

 use defs_basis
 use defs_datatypes
 use m_gwdefs, only : unt_gw, unt_sig, unt_sgr, unt_sgm

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => write_sigma_results
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ikcalc,ikibz
 type(Bandstructure_type),intent(in) :: KS_BSt
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Sigma_parameters),intent(in) :: Sp
 type(Sigma_results),intent(in) :: Sr
!arrays

!Local variables-------------------------------
!scalars
 integer :: ib,io,is
 character(len=500) :: msg
!arrays
 character(len=12) :: tag_spin(2)
 real(dp),pointer :: ks_energy(:,:,:)

! *************************************************************************

 !unt_gw  = 21  ! File with GW corrections.
 !unt_sig = 22  ! Self-energy as a function of frequency.
 !unt_sgr = 23  ! Derivative wrt omega of the Self-energy.
 !unt_sgm = 20  ! Sigma on the Matsubara axis.

 !TODO pass the object instead of the pointer
 ks_energy => KS_BSt%eig(:,:,:)

 tag_spin=(/'            ','            '/)
 if (Sr%nsppol==2) tag_spin=(/',  SPIN UP  ',',  SPIN DOWN'/)

 do is=1,Sr%nsppol
  write(msg,'(2a,3f8.3,a)')ch10,' k = ',Sp%xkcalc(:,ikcalc),tag_spin(is)
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

  write(msg,'(a)')&
&  ' Band     E0 <VxcLDA>   SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E'

  if (Sr%usepawu/=0) then
   write(msg,'(a)')&
&   ' Band     E0 <VxcLDA>   <H_U>  SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E'
  end if

  if (Sp%gwcalctyp>=10) then
   write(msg,'(2a)')&
&   ' Band     E_lda   <Vxclda>   E(N-1)  <Hhartree>   SigX  SigC[E(N-1)]',&
&   '    Z     dSigC/dE  Sig[E(N)]  DeltaE  E(N)_pert E(N)_diago'
  end if
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

  write(unt_gw,'(3f10.6)')Sp%xkcalc(:,ikcalc)
  write(unt_gw,'(i4)')Sp%maxbnd(ikcalc)-Sp%minbnd(ikcalc)+1

  write(unt_sig,'("# k = ",3f10.6)')Sp%xkcalc(:,ikcalc)
  write(unt_sig,'("# b = ",2i10)')Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)

  write(unt_sgr,'("# k = ",3f10.6)')Sp%xkcalc(:,ikcalc)
  write(unt_sgr,'("# b = ",2i10)')Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)

  do ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)

   if (Sp%gwcalctyp>=10) then
    call print_Sigma_QPSC(Sr,ikibz,ib,is,Kmesh,ks_energy,unit=ab_out)
    call print_Sigma_QPSC(Sr,ikibz,ib,is,Kmesh,ks_energy,unit=std_out,prtvol=1)
   else
    call print_Sigma_perturbative(Sr,ikibz,ib,is,unit=ab_out)
    call print_Sigma_perturbative(Sr,ikibz,ib,is,unit=std_out,prtvol=1)
   end if

   write(unt_gw,'(i6,3f9.4)')         &
&   ib,                               &
&   REAL (Sr%egw(ib,ikibz,is)) *Ha_eV,&
&   REAL (Sr%degw(ib,ikibz,is))*Ha_eV,&
&   AIMAG(Sr%egw(ib,ikibz,is)) *Ha_eV
   
  end do !ib

  if (Sr%e0gap(ikibz,is)**2+Sr%egwgap(ikibz,is)**2+Sr%degwgap(ikibz,is)**2 > tol10) then
   ! Output the direct gap for each spin
   ! If all the gaps are zero, this means that it could not be computed in the calling routine
   write(msg,'(2a,f8.3)')ch10,' E^0_gap       ',Sr%e0gap(ikibz,is)*Ha_eV
   call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
   write(msg,'(a,f8.3)')      ' E^GW_gap      ',Sr%egwgap(ikibz,is)*Ha_eV
   call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
   write(msg,'(a,f8.3,a)')    ' DeltaE^GW_gap ',Sr%degwgap(ikibz,is)*Ha_eV,ch10
   call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
  end if

  ! === Output spectral function ===
  do io=1,Sr%nomega_r
   write(unt_sig,'(100(e11.5,2x))')&
&   REAL(Sr%omega_r(io))*Ha_eV,&
&   (REAL(Sr%sigxcme(ib,ikibz,io,is))*Ha_eV,&
&   AIMAG(Sr%sigxcme(ib,ikibz,io,is))*Ha_eV,&
&   one/pi*ABS(AIMAG(Sr%sigcme(ib,ikibz,io,is)))&
&   /( (REAL(Sr%omega_r(io)-Sr%hhartree(ib,ib,ikibz,is)-Sr%sigxcme(ib,ikibz,io,is)))**2&
&     +(AIMAG(Sr%sigcme(ib,ikibz,io,is)))**2) /Ha_eV,&
&   ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc))
  end do

  do ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)
   write(unt_sgr,'("# ik, ib",2i5)')ikibz,ib
   do io=1,Sr%nomega4sd
    write(unt_sgr,'(100(e11.5,2x))')             &
&    REAL (Sr%omega4sd  (ib,ikibz,io,is))   *Ha_eV,&
&    REAL (Sr%sigxcme4sd(ib,ikibz,io,is)) *Ha_eV,&
&    AIMAG(Sr%sigxcme4sd(ib,ikibz,io,is)) *Ha_eV
   end do
  end do

  if (MOD(sp%gwcalctyp,10)==1) then 
   ! For AC write matrix elements of sigma along the imaginary axis
   do ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)
    write(unt_sgm,'("# ik, ib",2i5)')ikibz,ib
    do io=1,Sr%nomega_i
     write(unt_sgm,'(3(e11.5,2x))')             &
&     AIMAG(Sr%omega_i(io))              *Ha_eV,&
&     REAL (Sr%sigxcmesi(ib,ikibz,io,is))*Ha_eV,&
&     AIMAG(Sr%sigxcmesi(ib,ikibz,io,is))*Ha_eV
    end do
   end do
  end if 

 end do !is

end subroutine write_sigma_results
!!***


!!****f* ABINIT/rdgw
!! NAME
!! rdgw
!!
!! FUNCTION
!!  This subroutine reads the GW corrections from a _GW file
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2009 ABINIT group (FBruneval, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  Bst<Bandstructure_type>=type describing the Band structure.
!!    %nbnds=number of bands.
!!    %nkpt=number of irred k-points.
!!    %nsppol=number of spin
!!    %kptns(3,nkpt)=irreducible k-points
!!
!! OUTPUT
!!  gwenergy(nkpt,nbnds,nsppol) : QP energies as read or derived from the data contained
!!   in the external file
!! 
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      int2char
!!
!! SOURCE
!!

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rdgw(Bst,fname,gwenergy)

 use defs_basis
 use defs_datatypes
 use m_numeric_tools, only : linfit
 use m_io_tools,      only : get_unit
 use m_errors,        only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => rdgw
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 character(len=*),intent(in) :: fname
 type(Bandstructure_type),intent(inout) :: Bst
!arrays
 real(dp),intent(out) :: gwenergy(Bst%mband,Bst%nkpt,Bst%nsppol)

!Local variables ------------------------------
!scalars
 integer :: ib,ibr,ik,ikibz,ikr,ios,is,nn,nbR,nkR,nsR,unt,nbv
 real(dp) :: alpha,beta,degw,egw,smrt
 logical :: ltest
 character(len=500) :: msg
!arrays
 integer,allocatable :: vbik(:,:) 
 real(dp) :: kread(3)
 real(dp),allocatable :: gwcorr(:,:,:)
!************************************************************************

 ltest=ALL(Bst%nband(:)==Bst%mband) 
 call assert(ltest,'nband should be costant',__FILE__,__LINE__)

 write(msg,'(2a)')' reading GW corrections from file ',TRIM(fname)
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 
 unt=get_unit()
 open(unt,file=fname,status='old',iostat=ios)
 if (ios/=0) then 
  write(msg,'(6a)')ch10,&
&  ' rdgw: ERROR- ',ch10,  &
&  ' opening file: ',TRIM(fname),' as old'
  call wrtout(std_out,msg,'COLL') ; call leave_new('COLL')
 end if

 read(unt,*)nkR,nsR 
 if (nkR/=Bst%nkpt) then  
  write(msg,'(4a,i4,a,i4,3a)')ch10,&
&  ' rdgw : WARNING - ,',ch10,&
&  ' Found less k-points than that required ',nkR,'/',Bst%nkpt,ch10,&
&  ' Some k-points will be skipped ',ch10
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 end if 
 ltest=(nsR==Bst%nsppol)
 call assert(ltest,'mismatch in nsppol',__FILE__,__LINE__)

 allocate(gwcorr(Bst%mband,Bst%nkpt,Bst%nsppol)) ; gwcorr(:,:,:)=zero

 do is=1,Bst%nsppol
  do ikr=1,nkR
   read(unt,*)kread
   read(unt,*)nbR
   ikibz=0
   do ik=1,Bst%nkpt
    if (ALL(ABS(kread(:)-Bst%kptns(:,ik))<0.0001)) ikibz=ik
   end do
   do ib=1,nbR
    read(unt,*)ibr,egw,degw
    if (ibr<=Bst%mband .and.ikibz/=0) gwcorr(ibr,ikibz,is)=degw/Ha_eV
   end do
  end do 
 end do
 close(unt)

 allocate(vbik(BSt%nkpt,BSt%nsppol))
 vbik(:,:) = get_valence_idx(BSt)

 do is=1,Bst%nsppol
  do ik=1,Bst%nkpt
   ! nbv is the index of the (valence band| Fermi band) for each spin
   nbv=vbik(ik,is) ; nn=Bst%mband-nbv

   do ib=nbv+1,Bst%mband
    if (gwcorr(ib,ik,is)==0) then
     nn=ib-1-nbv
     if (nn>1) then
      write(msg,'(a)')' linear extrapolating (conduction) GW corrections beyond the read values'
      call wrtout(std_out,msg,'COLL') 
      smrt=linfit(nn,gwenergy(nbv+1:nbv+nn,ik,is),gwcorr(nbv+1:nbv+nn,ik,is),alpha,beta)
     else
      write(msg,'(a)')' assuming constant (conduction) GW corrections beyond the read values'
      call wrtout(std_out,msg,'COLL') 
      alpha=zero 
      beta =gwcorr(nbv+nn,ik,is)
     end if
     EXIT !ib loop
    end if
   end do !ib

   do ib=nbv+nn+1,Bst%mband
    gwcorr(ib,ik,is)= alpha*gwenergy(ib,ik,is) + beta
   end do

   nn=nbv
   do ib=nbv,1,-1
    if (gwcorr(ib,ik,is)==0) then
     nn=nbv-ib
     if (nn>1) then
      write(msg,'(a)')' linear extrapolating (valence) GW corrections beyond the read values'
      call wrtout(std_out,msg,'COLL') 
      smrt=linfit(nn,gwenergy(nbv-nn+1:nbv,ik,is),gwcorr(nbv-nn+1:nbv,ik,is),alpha,beta)
     else
      write(msg,'(a)')' assuming constant (valence) GW corrections beyond the read values'
      call wrtout(std_out,msg,'COLL') 
      alpha=zero 
      beta =gwcorr(nbv,ik,is)
     end if
     exit !ib
    end if
   end do !ib

   do ib=1,nbv-nn
    gwcorr(ib,ik,is)=alpha*gwenergy(ib,ik,is) + beta
   end do

  end do !ik
 end do !is

 write(msg,'(a)')' k  s     GW corrections [eV] '
 call wrtout(std_out,msg,'COLL')
 do is=1,Bst%nsppol
  do ik=1,Bst%nkpt
   write(*,'(i3,1x,i3,10f7.2/50(10x,10f7.2/))')ik,is,(Ha_eV*gwcorr(ib,ik,is),ib=1,Bst%mband)
  end do
 end do 
 gwenergy(:,:,:)=gwenergy(:,:,:)+gwcorr(:,:,:)

 write(msg,'(a)')' k   s    GW eigenvalues [eV]'
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 do is=1,Bst%nsppol
  do ik=1,Bst%nkpt
   write(std_out,'(i3,7x,10f7.2/50(10x,10f7.2/))')ik,is,(Ha_eV*gwenergy(ib,ik,is),ib=1,Bst%mband)
  end do
 end do
 write(std_out,*)

 deallocate(gwcorr,vbik)

end subroutine rdgw
!!***


!!****f* ABINIT/print_Sigma_perturbative 
!! NAME
!! print_Sigma_perturbative
!!
!! FUNCTION
!!  write the results of the GW calculation done with the perturbative approach
!!

!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group (MG).
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      gw_tools,iosig
!!
!! CHILDREN
!!      int2char
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine print_Sigma_perturbative(Sr,ik_ibz,iband,isp,unit,prtvol,mode_paral,witheader)

 use defs_basis
 use defs_datatypes
 use m_errors, only : assert

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iband,ik_ibz,isp
 integer,optional,intent(in) :: prtvol,unit
 character(len=4),optional,intent(in) :: mode_paral
 logical,optional,intent(in) :: witheader
 type(Sigma_results),intent(in) :: Sr

!Local variables-------------------------------
!scalars
 integer :: unt,verbose
 logical :: ltest
 character(len=4) :: mode
 character(len=500) :: msg

! *********************************************************************

 unt=std_out ; if (PRESENT(unit))       unt=unit
 verbose=0   ; if (PRESENT(prtvol))     verbose=prtvol
 mode='COLL' ; if (PRESENT(mode_paral)) mode=mode_paral

 if (PRESENT(witheader)) then 
  if (witheader) then
   write(msg,'(a)')' Band     E0 <VxcLDA>   SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E '
   call wrtout(unt,msg,mode) 
  end if 
 end if

 if (Sr%usepawu==0) then 

  if (Sr%nsig_ab/=1) then
   write(msg,'(i5,9f8.3)')                       & 
&        iband,                                  &
&        Sr%e0          (iband,ik_ibz,1)*Ha_eV,  &
&        SUM(Sr%vxcme   (iband,ik_ibz,:))*Ha_eV, &
&        SUM(Sr%sigxme  (iband,ik_ibz,:))*Ha_eV, &
&   REAL(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,&
&   REAL(Sr%ze0         (iband,ik_ibz,1)),       &
&   REAL(SUM(Sr%dsigmee0(iband,ik_ibz,:))),      &
&   REAL(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,&
&   REAL(Sr%degw        (iband,ik_ibz,1))*Ha_eV, &
&   REAL(Sr%egw         (iband,ik_ibz,1))*Ha_eV
    call wrtout(unt,msg,mode) 
   if (verbose/=0) then
    write(msg,'(i5,9f8.3)')                        & 
&          iband,                                  &
&          zero,                                   &
&          zero,                                   &
&          zero,                                   &
&    AIMAG(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,&
&    AIMAG(Sr%ze0         (iband,ik_ibz,1)),       &
&    AIMAG(SUM(Sr%dsigmee0(iband,ik_ibz,:))),      &
&    AIMAG(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,&
&    AIMAG(Sr%degw        (iband,ik_ibz,1))*Ha_eV, &
&    AIMAG(Sr%egw         (iband,ik_ibz,1))*Ha_eV
     call wrtout(unt,msg,mode) 
   end if
  else
   write(msg,'(i5,9f8.3)')                    & 
&        iband,                               &
&        Sr%e0      (iband,ik_ibz,isp)*Ha_eV, &
&        Sr%vxcme   (iband,ik_ibz,isp)*Ha_eV, &
&        Sr%sigxme  (iband,ik_ibz,isp)*Ha_eV, &
&   REAL(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&   REAL(Sr%ze0     (iband,ik_ibz,isp)),      &
&   REAL(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&   REAL(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&   REAL(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&   REAL(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
    call wrtout(unt,msg,mode) 

   if (verbose/=0) then
    write(msg,'(i5,9f8.3)')                     & 
&          iband,                               &
&          zero,                                &
&          zero,                                &
&          zero,                                &
&    AIMAG(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&    AIMAG(Sr%ze0     (iband,ik_ibz,isp)),      &
&    AIMAG(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&    AIMAG(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&    AIMAG(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&    AIMAG(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
     call wrtout(unt,msg,mode) 
   end if
  end if

 else 
  ! === PAW+U+GW calculation ===
  ltest=(Sr%nsig_ab==1)
  call assert(ltest,'LDA+U with spinor not implemented',&
&  __FILE__,__LINE__)
  write(msg,'(i5,10f8.3)')                   & 
&       iband,                               &
&       Sr%e0      (iband,ik_ibz,isp)*Ha_eV, &
&       Sr%vxcme   (iband,ik_ibz,isp)*Ha_eV, &
&       Sr%vUme    (iband,ik_ibz,isp)*Ha_eV, &
&       Sr%sigxme  (iband,ik_ibz,isp)*Ha_eV, &
&  REAL(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&  REAL(Sr%ze0     (iband,ik_ibz,isp)),      &
&  REAL(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&  REAL(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&  REAL(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&  REAL(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
   call wrtout(unt,msg,mode) 

  if (verbose/=0) then
   write(msg,'(i5,10f8.3)')                    & 
&         iband,                               &
&         zero,                                &
&         zero,                                &
&         zero,                                &
&         zero,                                &
&   AIMAG(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&   AIMAG(Sr%ze0     (iband,ik_ibz,isp)),      &
&   AIMAG(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&   AIMAG(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&   AIMAG(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&   AIMAG(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
    call wrtout(unt,msg,mode) 
  end if
 end if

end subroutine print_Sigma_perturbative 
!!***


!!****f* ABINIT/print_Sigma_QPSC
!! NAME
!! print_Sigma_QPSC
!!
!! FUNCTION
!! write the results of the GW calculation in case of self-consistency
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      iosig
!!
!! CHILDREN
!!      int2char
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine print_Sigma_QPSC(Sr,ik_ibz,iband,isp,Kmesh,ks_energy,unit,prtvol,mode_paral)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!this should be in the datatype
!scalars
 integer,intent(in) :: iband,ik_ibz,isp
 integer,intent(in),optional :: prtvol,unit
 character(len=4),intent(in),optional :: mode_paral
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Sigma_results),intent(in) :: Sr
!arrays
 real(dp),intent(in) :: ks_energy(Sr%nbnds,Kmesh%nibz,Sr%nsppol)

!Local variables-------------------------------
!scalars
 integer :: unt,verbose
 character(len=4) :: mode
 character(len=500) :: msg

! *********************************************************************

 unt=std_out ; if (PRESENT(unit))       unt=unit
 verbose=0   ; if (PRESENT(prtvol))     verbose=prtvol
 mode='COLL' ; if (PRESENT(mode_paral)) mode=mode_paral

! write(msg,'(a)')&
!& ' Band     E0 <VxcLDA>   SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E'
! call wrtout(unt,msg,mode) 

 if (Sr%usepawu==0) then
  if (Sr%nsig_ab/=1) then
   write(msg,'(i5,12(2x,f8.3))')                       & 
&        iband,                                        &
&        ks_energy        (iband,ik_ibz,1)*Ha_eV,      &
         !sr%e0           (iband,ikibz,1)*Ha_eV,       &
&        SUM(Sr%vxcme   (iband,ik_ibz,:))*Ha_eV,       &
&        Sr%e0          (iband,ik_ibz,1)*Ha_eV,        &
&   REAL(SUM(Sr%hhartree(iband,iband,ik_ibz,:)))*Ha_eV,&
&        SUM(Sr%sigxme  (iband,ik_ibz,:))*Ha_eV,       &
&   REAL(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,      &
&   REAL(Sr%ze0         (iband,ik_ibz,1)),             &
&   REAL(SUM(Sr%dsigmee0(iband,ik_ibz,:))),            &
&   REAL(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,      &
&   REAL(Sr%degw        (iband,ik_ibz,1))*Ha_eV,       &
&   REAL(Sr%egw         (iband,ik_ibz,1))*Ha_eV,       &
&        Sr%en_qp_diago (iband,ik_ibz,1)*Ha_eV
   call wrtout(unt,msg,mode) 

   write(msg,'(i5,12(2x,f8.3))')                        & 
&         iband,                                        &
&         zero,                                         &
          !sr%e0          (iband,ikibz,isp)*Ha_eV,      &
&         zero,                                         &
&         zero,                                         &
&   AIMAG(SUM(Sr%hhartree(iband,iband,ik_ibz,:)))*Ha_eV,&
&         zero,                                         &
&   AIMAG(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,      &
&   AIMAG(Sr%ze0         (iband,ik_ibz,1)),             &
&   AIMAG(SUM(Sr%dsigmee0(iband,ik_ibz,:))),            &
&   AIMAG(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,      &
&   AIMAG(Sr%degw        (iband,ik_ibz,1))*Ha_eV,       &
&   AIMAG(Sr%egw         (iband,ik_ibz,1))*Ha_eV,       &
&         zero
   if (verbose/=0) call wrtout(unt,msg,mode) 
  else
   write(msg,'(i5,12(2x,f8.3))')                       & 
&        iband,                                        &
&        ks_energy       (iband,ik_ibz,isp)*Ha_eV,     &
         !sr%e0          (iband,ikibz,isp)*Ha_eV,      &
&        Sr%vxcme      (iband,ik_ibz,isp)*Ha_eV,       &
&        Sr%e0         (iband,ik_ibz,isp)*Ha_eV,       &
&   REAL(Sr%hhartree   (iband,iband,ik_ibz,isp))*Ha_eV,&
&        Sr%sigxme     (iband,ik_ibz,isp)*Ha_eV,       &
&   REAL(Sr%sigcmee0   (iband,ik_ibz,isp))*Ha_eV,      &
&   REAL(Sr%ze0        (iband,ik_ibz,isp)),            &
&   REAL(Sr%dsigmee0   (iband,ik_ibz,isp)),            &
&   REAL(Sr%sigmee     (iband,ik_ibz,isp))*Ha_eV,      &
&   REAL(Sr%degw       (iband,ik_ibz,isp))*Ha_eV,      &
&   REAL(Sr%egw        (iband,ik_ibz,isp))*Ha_eV,      &
&        Sr%en_qp_diago(iband,ik_ibz,isp)*Ha_eV
   call wrtout(unt,msg,mode) 

   write(msg,'(i5,12(2x,f8.3))')                         & 
&         iband,                                         &
&         zero,                                          &
          !sr%e0          (iband,ikibz,isp)*Ha_eV,       &
&         zero,                                          &
&         zero,                                          &
&   AIMAG(Sr%hhartree  (iband,iband,ik_ibz,isp))*Ha_eV,&
&         zero,                                          &
&   AIMAG(Sr%sigcmee0   (iband,ik_ibz,isp))*Ha_eV,     &
&   AIMAG(Sr%ze0        (iband,ik_ibz,isp)),           &
&   AIMAG(Sr%dsigmee0   (iband,ik_ibz,isp)),           &
&   AIMAG(Sr%sigmee     (iband,ik_ibz,isp))*Ha_eV,     &
&   AIMAG(Sr%degw       (iband,ik_ibz,isp))*Ha_eV,     &
&   AIMAG(Sr%egw        (iband,ik_ibz,isp))*Ha_eV,     &
&         zero
   if (verbose/=0) call wrtout(unt,msg,mode) 
  end if
 else 
  ! === PAW+U+GW calculation ===
  STOP "PAW+U+GW not yet implemented"
 end if

end subroutine print_Sigma_QPSC
!!***
