!{\src2tex{textfont=tt}}
!!****f* ABINIT/gw_methods
!! NAME
!! gw_methods
!!
!! FUNCTION
!!  This file contains methods acting on the data types used in the 
!!  GW part of abinit. This methods can be used to nullify the pointers 
!!  defined in the data types before starting the calculation and to 
!!  deallocate the memory occupied before exiting.
!!
!! COPYRIGHT
!!  Copyright (C) 2007-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  
!!
!! OUTPUT
!!  
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  All the pointer defined in the data types could be nullified 
!!  using the null() functions. Unfortunately null() has been 
!!  introduced in the F95 specifications and this might lead 
!!  to portability problems.
!!
!! TODO 
!!  write other methods to write the content of the data type.
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nullify_epsilonm1_parameters(Ep)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(epsilonm1_parameters),intent(inout) :: Ep

!Local variables-------------------------------
 !character(len=500) :: msg                   

! *************************************************************************

 nullify(Ep%qcalc)
 nullify(Ep%qibz)
 nullify(Ep%qlwl   )

 nullify(Ep%omegasf)
 nullify(Ep%omega  ) 

end subroutine nullify_epsilonm1_parameters
!!***


!!****f* ABINIT/destroy_epsilonm1_parameters
!! NAME
!! destroy_epsilonm1_parameters
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine destroy_epsilonm1_parameters(Ep)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_parameters),intent(inout) :: Ep

!Local variables-------------------------------
 !character(len=500) :: msg                   

! *************************************************************************

 if (associated(Ep%qcalc  ))  deallocate(Ep%qcalc)
 if (associated(Ep%qibz   ))  deallocate(Ep%qibz)
 if (associated(Ep%qlwl   ))  deallocate(Ep%qlwl)

 if (associated(Ep%omegasf))  deallocate(Ep%omegasf)
 if (associated(Ep%omega  ))  deallocate(Ep%omega) 

end subroutine destroy_epsilonm1_parameters
!!***

!!****f* ABINIT/nullify_sigma_parameters
!! NAME
!! nullify_sigma_parameters
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      setup_sigma
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nullify_sigma_parameters(Sp)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(inout) :: Sp

! *************************************************************************

 nullify(Sp%kcalc )
 nullify(Sp%minbnd)
 nullify(Sp%maxbnd)
 nullify(Sp%xkcalc) 
 nullify(Sp%omegasi)
 nullify(Sp%omega_r)

end subroutine nullify_sigma_parameters
!!***


!!****f* ABINIT/destroy_sigma_parameters
!! NAME
!! destroy_sigma_parameters
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine destroy_sigma_parameters(Sp)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(inout) :: Sp

!Local variables-------------------------------
 !character(len=500) :: msg                   

! *************************************************************************

 if (associated(Sp%kcalc ))  deallocate(Sp%kcalc )
 if (associated(Sp%minbnd))  deallocate(Sp%minbnd)
 if (associated(Sp%maxbnd))  deallocate(Sp%maxbnd)

 if (associated(Sp%xkcalc))  deallocate(Sp%xkcalc) 

 if (associated(Sp%omegasi)) deallocate(Sp%omegasi) 
 if (associated(Sp%omega_r)) deallocate(Sp%omega_r) 

end subroutine destroy_sigma_parameters
!!***


!!****f* ABINIT/nullify_sigma_results
!! NAME
!! nullify_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      gw_methods
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nullify_sigma_results(Sr)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_results),intent(inout) :: Sr

!Local variables-------------------------------
 !character(len=500) :: msg                   

! *************************************************************************

!integer 
 nullify(Sr%maxbnd     )
 nullify(Sr%minbnd     )

 !nullify(Sr%ame       )
 nullify(Sr%degwgap    )
 nullify(Sr%egwgap     )
 nullify(Sr%en_qp_diago)
 nullify(Sr%e0         )
 nullify(Sr%e0gap      )
 nullify(Sr%omega_r    )
 nullify(Sr%xkcalc     )
 nullify(Sr%sigxme     )
 nullify(Sr%vxcme      )
 nullify(Sr%vUme       )

 nullify(Sr%degw       )
 nullify(Sr%dsigmee0   )
 nullify(Sr%egw        )
 nullify(Sr%eigvec_qp  )
 nullify(Sr%hhartree   )
 nullify(Sr%sigcme     )
 nullify(Sr%sigmee     )
 nullify(Sr%sigcmee0   )
 nullify(Sr%sigcmesi   )
 nullify(Sr%sigcme4sd  )
 nullify(Sr%sigxcme    )
 nullify(Sr%sigxcmesi  )
 nullify(Sr%sigxcme4sd )
 nullify(Sr%ze0        )
 nullify(Sr%omega_i    )
 nullify(Sr%omega4sd   )

end subroutine nullify_sigma_results
!!***


!!****f* ABINIT/init_sigma_results
!! NAME
!! init_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!! usepawu=1 if we used LDA+U as starting point (only for PAW)
!!
!! OUTPUT
!!
!! TODO
!!  Write documentation.
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine init_sigma_results(Sp,nkibz,usepawu,Sr)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_15gw, except_this_one => init_sigma_results
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: nkibz,usepawu
!scalars
 type(Sigma_parameters),intent(in) :: Sp
 type(Sigma_results),intent(inout) :: Sr

!Local variables-------------------------------
 !character(len=500) :: msg                   
!scalars
 integer :: b1gw,b2gw,mod10

! *************************************************************************

 call nullify_sigma_results(Sr)

 ! === Copy important dimensions ===
 mod10=MOD(Sp%gwcalctyp,10)

!BEGIN NEW
 Sr%nkcalc     =Sp%nkcalc
 Sr%gwcalctyp  =Sp%gwcalctyp
 Sr%deltae     =Sp%deltae
 Sr%maxomega4sd=Sp%maxomega4sd
 Sr%maxomega_r =Sp%maxomega_r
 Sr%scissor_ene=Sp%soenergy
 !FIXME this should be done in allocate_sigma_results
 allocate(Sr%minbnd(Sr%nkcalc),Sr%maxbnd(Sr%nkcalc))
 Sr%minbnd=Sp%minbnd ; Sr%maxbnd=Sp%maxbnd
 allocate(Sr%xkcalc(3,Sr%nkcalc))
 Sr%xkcalc=Sp%xkcalc
!END NEW

 Sr%b1gw     =Sp%minbdgw ! * min and Max GW band index over k and spin. 
 Sr%b2gw     =Sp%maxbdgw !   Used to dimension arrays.
 Sr%nbnds    =Sp%nbnds
 Sr%nkibz    =nkibz
 Sr%nsppol   =Sp%nsppol
 Sr%nsig_ab  =Sp%nsig_ab
 Sr%nomega_r =Sp%nomegasr  !FIXME change name
 Sr%nomega_i =Sp%nomegasi
 Sr%nomega4sd=Sp%nomegasrd
 Sr%usepawu  =usepawu

 !======================================================
 ! === Allocate arrays in the sigma_results datatype ===
 !======================================================
 b1gw=Sr%b1gw  
 b2gw=Sr%b2gw   

 !TODO use this routine
! call allocate_sigma_results(Sr,b1gw,b2gw,Sr%nbnds,Sr%nkibz,Sr%nsppol,&
!& Sr%nsig_ab,Sr%nomega_r,Sr%nomega_i,Sr%nomega4sd,omega_r=Sp%omega_r,omega_i=Sp%omegasi)

 ! hhartree(b1,b2,k,s)= <b1,k,s|T+v_{loc}+v_{nl}+v_{H}|b2,k,s>
 allocate(Sr%hhartree(b1gw:b2gw,b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab)) 
 Sr%hhartree=czero

 ! === QP amplitudes and energies ===
 allocate(Sr%en_qp_diago(Sr%nbnds,Sr%nkibz,Sr%nsppol))        ; Sr%en_qp_diago(:,:,:)=zero
 allocate(Sr%eigvec_qp(Sr%nbnds,Sr%nbnds,Sr%nkibz,Sr%nsppol)) ; Sr%eigvec_qp(:,:,:,:)=czero

 ! Dont know if it is better to do this here or in the sigma
 ! * Initialize with KS wavefunctions and energies
 !do ib=1,Sr%nbnds
 ! Sr%en_qp_diago(ib,:,:)=en(:,ib,:)
 ! Sr%eigvec_qp(ib,ib,:,:)=cone
 !end do 

 allocate(Sr%vxcme   (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%vUme    (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigxme  (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))

 allocate(Sr%sigcme  (b1gw:b2gw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigxcme (b1gw:b2gw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))

 allocate(Sr%sigcmee0(b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%ze0     (b1gw:b2gw,Sr%nkibz,Sr%nsppol))
 allocate(Sr%dsigmee0(b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigmee  (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%degw    (b1gw:b2gw,Sr%nkibz,Sr%nsppol))

 allocate(Sr%e0 (Sr%nbnds,Sr%nkibz,Sr%nsppol)) 
 allocate(Sr%egw(Sr%nbnds,Sr%nkibz,Sr%nsppol))

 allocate(Sr%e0gap  (Sr%nkibz,Sr%nsppol))
 allocate(Sr%degwgap(Sr%nkibz,Sr%nsppol))
 allocate(Sr%egwgap (Sr%nkibz,Sr%nsppol))
 !allocate(Sr%ame(Sr%nbnds,Sr%nkibz,Sr%nomega_r))
 !
 ! === These quantities are used to evaluate $\Sigma(E)$ around the KS\QP eigenvalue ===
 allocate(Sr%omega4sd  (b1gw:b2gw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol))
 allocate(Sr%sigcme4sd (b1gw:b2gw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigxcme4sd(b1gw:b2gw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))

 !TODO Find  better treatment
 ! Mesh along the real axis.
 if (Sr%nomega_r>0) then
  allocate(Sr%omega_r(Sr%nomega_r))
  Sr%omega_r(:)=Sp%omega_r(:)
 end if

 Sr%e0        =zero
 Sr%egw       =czero
 Sr%e0gap     =zero
 Sr%sigcme    =czero
 Sr%sigxme    =czero
 Sr%sigxcme   =czero
 Sr%sigcmee0  =czero
 Sr%ze0       =czero
 Sr%dsigmee0  =czero
 Sr%sigmee    =czero
 Sr%omega4sd  =czero
 Sr%sigcme4sd =czero
 Sr%sigxcme4sd=czero
 Sr%degw      =czero

 ! === Analytical Continuation ===
 if (mod10==1) then 
  ! FIXME omegasi should not be in Sp% here we should construct the mesh
  allocate(Sr%omega_i(Sr%nomega_i)) ; Sr%omega_i=Sp%omegasi
  allocate(Sr%sigcmesi (b1gw:b2gw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  allocate(Sr%sigxcmesi(b1gw:b2gw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  Sr%sigcmesi =czero
  Sr%sigxcmesi=czero
 end if

end subroutine init_sigma_results
!!***


!!****f* ABINIT/destroy_sigma_results
!! NAME
!! destroy_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      gw_tools,sigma
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine destroy_sigma_results(Sr)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_results),intent(inout) :: Sr

!Local variables-------------------------------
 !character(len=500) :: msg                   

! *************************************************************************

!integer
 if (associated(Sr%maxbnd     ))    deallocate(Sr%maxbnd)
 if (associated(Sr%minbnd     ))    deallocate(Sr%minbnd)

 !if (associated(Sr%ame       ))    deallocate(Sr%ame) 
 if (associated(Sr%degwgap    ))    deallocate(Sr%degwgap)
 if (associated(Sr%egwgap     ))    deallocate(Sr%egwgap)
 if (associated(Sr%en_qp_diago))    deallocate(Sr%en_qp_diago)
 if (associated(Sr%e0         ))    deallocate(Sr%e0)
 if (associated(Sr%e0gap      ))    deallocate(Sr%e0gap)
 if (associated(Sr%omega_r    ))    deallocate(Sr%omega_r)
 if (associated(Sr%xkcalc     ))    deallocate(Sr%xkcalc)
 if (associated(Sr%sigxme     ))    deallocate(Sr%sigxme)
 if (associated(Sr%vxcme      ))    deallocate(Sr%vxcme)
 if (associated(Sr%vUme       ))    deallocate(Sr%vUme)
 
 if (associated(Sr%degw       ))    deallocate(Sr%degw)
 if (associated(Sr%dsigmee0   ))    deallocate(Sr%dsigmee0)
 if (associated(Sr%egw        ))    deallocate(Sr%egw)
 if (associated(Sr%eigvec_qp  ))    deallocate(Sr%eigvec_qp)
 if (associated(Sr%hhartree   ))    deallocate(Sr%hhartree)
 if (associated(Sr%sigcme     ))    deallocate(Sr%sigcme)
 if (associated(Sr%sigmee     ))    deallocate(Sr%sigmee)
 if (associated(Sr%sigcmee0   ))    deallocate(Sr%sigcmee0)
 if (associated(Sr%sigcmesi   ))    deallocate(Sr%sigcmesi)
 if (associated(Sr%sigcme4sd  ))    deallocate(Sr%sigcme4sd)
 if (associated(Sr%sigxcme    ))    deallocate(Sr%sigxcme)
 if (associated(Sr%sigxcmesi  ))    deallocate(Sr%sigxcmesi)
 if (associated(Sr%sigxcme4sd ))    deallocate(Sr%sigxcme4sd)
 if (associated(Sr%ze0        ))    deallocate(Sr%ze0)
 if (associated(Sr%omega_i    ))    deallocate(Sr%omega_i)
 if (associated(Sr%omega4sd   ))    deallocate(Sr%omega4sd)

end subroutine destroy_sigma_results
!!***

!!****f* ABINIT/allocate_sigma_results
!! NAME
!! allocate_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      gw_etsf_io
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE
subroutine allocate_sigma_results(Sr,b1gw,b2gw,nbnds,nkibz,nkcalc,nsppol,nsig_ab,nomega_r,nomega_i,nomega4sd,&
& omega_r,omega_i) ! Optional

 use defs_basis
 use defs_datatypes
 use m_errors, only : assert_eq

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_15gw, except_this_one => allocate_sigma_results
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: b1gw,b2gw,nkibz,nsppol,nsig_ab,nbnds
 integer,intent(in) :: nomega_r,nomega_i,nomega4sd,nkcalc
 type(Sigma_results),intent(inout) :: Sr
!arrays
 complex(dpc),optional,intent(in) :: omega_r(:),omega_i(:)

!Local variables-------------------------------
 integer :: ii
! *************************************************************************

 call nullify_sigma_results(Sr)

 Sr%nkcalc=nkcalc
 allocate(Sr%minbnd(Sr%nkcalc),Sr%maxbnd(Sr%nkcalc))

 allocate(Sr%xkcalc(3,Sr%nkcalc))

 ! hhartree(b1,b2,k,s)= <b1,k,s|T+v_{loc}+v_{nl}+v_{H}|b2,k,s>
 allocate(Sr%hhartree(b1gw:b2gw,b1gw:b2gw,nkibz,nsppol*nsig_ab)) 
 Sr%hhartree=czero

 ! === QP amplitudes and energies ===
 allocate(Sr%en_qp_diago(nbnds,nkibz,nsppol))        
 allocate(Sr%eigvec_qp(nbnds,nbnds,nkibz,nsppol)) 
 Sr%en_qp_diago=zero
 Sr%eigvec_qp  =czero

 allocate(Sr%vxcme   (b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%vUme    (b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%sigxme  (b1gw:b2gw,nkibz,nsppol*nsig_ab))

 allocate(Sr%sigcme  (b1gw:b2gw,nkibz,nomega_r,nsppol*nsig_ab))
 allocate(Sr%sigxcme (b1gw:b2gw,nkibz,nomega_r,nsppol*nsig_ab))

 allocate(Sr%sigcmee0(b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%ze0     (b1gw:b2gw,nkibz,nsppol))
 allocate(Sr%dsigmee0(b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%sigmee  (b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%degw    (b1gw:b2gw,nkibz,nsppol))

 allocate(Sr%e0 (nbnds,nkibz,nsppol)) 
 allocate(Sr%egw(nbnds,nkibz,nsppol))

 allocate(Sr%e0gap  (nkibz,nsppol))
 allocate(Sr%degwgap(nkibz,nsppol))
 allocate(Sr%egwgap (nkibz,nsppol))
 !allocate(Sr%ame(nbnds,nkibz,nomega_r))

 ! === These quantities are used to evaluate $\Sigma(E)$ around the KS\QP eigenvalue ===
 allocate(Sr%omega4sd  (b1gw:b2gw,nkibz,nomega4sd,nsppol))
 allocate(Sr%sigcme4sd (b1gw:b2gw,nkibz,nomega4sd,nsppol*nsig_ab))
 allocate(Sr%sigxcme4sd(b1gw:b2gw,nkibz,nomega4sd,nsppol*nsig_ab))

 ! Mesh along the real axis.
 if (nomega_r>0) then
  allocate(Sr%omega_r(nomega_r))
  if (PRESENT(omega_r)) then 
   ii=assert_eq(SIZE(omega_r),SIZE(Sr%omega_r),&
&   'DIM omega_r=/Sr%omega_r',__FILE__,__LINE__)
   Sr%omega_r(:)=omega_r(:)
  end if
 end if

 ! === Analytical Continuation ===
 !if (mod10==1) then 
  if (nomega_i>0) then
  ! FIXME omegasi should not be in Sp% here we should construct the mesh
  allocate(Sr%omega_i(nomega_i)) 
  !; Sr%omega_i=Sp%omegasi FIXME this has to be done outside
  allocate(Sr%sigcmesi (b1gw:b2gw,nkibz,nomega_i,nsppol*nsig_ab))
  allocate(Sr%sigxcmesi(b1gw:b2gw,nkibz,nomega_i,nsppol*nsig_ab))
  Sr%omega_i  =czero
  Sr%sigcmesi =czero
  Sr%sigxcmesi=czero
  if (PRESENT(omega_i)) then 
   ii=assert_eq(SIZE(Sr%omega_i),SIZE(omega_i),&
&   'DIM Sr%omega_i /= omega_i',__FILE__,__LINE__)
   Sr%omega_i=omega_i
  end if
 end if

 Sr%e0        =zero
 Sr%egw       =czero
 Sr%e0gap     =zero
 Sr%sigcme    =czero
 Sr%sigxme    =czero
 Sr%sigxcme   =czero
 Sr%sigcmee0  =czero
 Sr%ze0       =czero
 Sr%dsigmee0  =czero
 Sr%sigmee    =czero
 Sr%omega4sd  =czero
 Sr%sigcme4sd =czero
 Sr%sigxcme4sd=czero
 Sr%degw      =czero

end subroutine allocate_sigma_results
!!***
