!{\src2tex{textfont=tt}}
!!****f* ABINIT/abi_Bands_read
!! NAME
!! abi_Bands_read
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!  Data written in file whose name is filapp//'-etsf.nc'
!!
!! PARENTS
!!      gw_etsf_io
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine abi_Bands_read(Bst,filapp)

 use defs_basis
 use defs_datatypes
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_13ionetcdf
 use interfaces_14iowfdenpot
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 character(len=fnlen),intent(in) :: filapp
 type(Bandstructure_type),target,intent(out) :: Bst
!arrays

!Local variables-------------------------------
#if defined HAVE_ETSF_IO
!scalars
 integer :: ncid,fform,usewvl,formeig,idx,isppol,nkpt,iband,ikpt
 integer,target :: nelect_int
 real(dp) :: fixmom_
 logical :: lstat
 character(len=fnlen) :: filetsf
 character(len=etsf_io_low_error_len) :: errmess
 type(ETSF_dims) :: Dims
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_basisdata) :: Basisdata
 type(Hdr_type) :: Hdr
 type(ETSF_groups) :: GroupFolder
 type(ETSF_electrons),target :: Electrons
 type(ETSF_kpoints),target :: Kpoints
!type(etsf_geometry), pointer :: geometry => null()
!  type(etsf_electrons), pointer :: electrons => null()
!  type(etsf_kpoints), pointer :: kpoints => null()
!  type(etsf_basisdata), pointer :: basisdata => null()
!  type(etsf_GWdata), pointer :: gwdata => null()
!  type(etsf_main), pointer :: main => null()
!end type etsf_groups
!arrays
 real(dp),allocatable,target :: eig_vec(:),occ_vec(:)
#endif

 character(len=500) :: msg

! *************************************************************************

#if defined HAVE_ETSF_IO

 ! === Open the file ===
 filetsf=TRIM(filapp)//'-etsf.nc'
 write(msg,'(3a)')ch10,' abi_Bands_read : about to read file ',TRIM(filetsf)
 call wrtout(std_out,msg,'COLL')

 call etsf_io_low_open_read(ncid,filetsf,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Read dimensions handled by ETSF ===
 call etsf_io_dims_get(ncid,Dims,lstat,Error_data)
 if (.not.lstat) goto 1000

 ! TODO : do not handle k_dependent = 1
 Bst%bantot   = Dims%max_number_of_states * Dims%number_of_kpoints * Dims%number_of_spins
 Bst%mband    = Dims%max_number_of_states
 Bst%nkpt     = Dims%number_of_kpoints
 Bst%nspinor  = Dims%number_of_spinor_components
 Bst%nsppol   = Dims%number_of_spins
 !Bst%nspden   = Dims%number_of_components

 allocate(Bst%istwfk(Bst%nkpt))
 allocate(Bst%nband(Bst%nkpt*Bst%nsppol))
 allocate(Bst%npwarr(Bst%nkpt))      
 allocate(Bst%kptns(3,Bst%nkpt))    
 allocate(Bst%eig(Bst%mband,Bst%nkpt,Bst%nsppol))       
 allocate(Bst%occ(Bst%mband,Bst%nkpt,Bst%nsppol))
 allocate(Bst%doccde(Bst%mband,Bst%nkpt,Bst%nsppol))
 allocate(Bst%wtk(Bst%nkpt))        

 usewvl=0
 call etsf_io_low_read_var(ncid,'usewvl',usewvl,lstat,error_data=Error_data)
 if (.not.lstat) goto 1000

 ! Get all variables included in ETSF
 if (usewvl==0) then
  BasisData%number_of_coefficients => Bst%npwarr
  call etsf_io_basisdata_get(ncid,Basisdata,lstat,Error_data)
  if (.not.lstat) goto 1000
 end if

 Electrons%fermi_energy            => Bst%fermie
 Electrons%number_of_electrons     => nelect_int !WARNING this is integer
 Electrons%smearing_width          => Bst%tsmear 
 Electrons%number_of_states%data1D => Bst%nband 

 ! DFPT not treated, we read correctly but the object should be modified a bit. 
 formeig=0
 allocate(eig_vec((2*Bst%mband)**formeig*Bst%mband*Bst%nkpt*Bst%nsppol))
 allocate(occ_vec(Bst%mband*Bst%nkpt*Bst%nsppol))
 Electrons%eigenvalues%data1D      => eig_vec  !then we have to unpack
 Electrons%occupations%data1D      => occ_vec

 Kpoints%reduced_coordinates_of_kpoints => Bst%kptns
 Kpoints%kpoint_weights                 => Bst%wtk

 GroupFolder%Electrons => Electrons
 GroupFolder%Kpoints   => Kpoints

 call etsf_io_data_read(filetsf,GroupFolder,lstat,Error_data)

 idx=0 !call my helper function once modules will be supported.
 do isppol=1,Bst%nsppol
  do ikpt=1,Bst%nkpt
   do iband=1,Bst%nband(ikpt+(isppol-1)*nkpt)
    idx=idx+1
    Bst%eig(iband,ikpt,isppol)=eig_vec(idx)
    Bst%occ(iband,ikpt,isppol)=occ_vec(idx)
   end do
  end do
 end do
 deallocate(eig_vec,occ_vec)

 ! === Read the abinit header ===
 ! * Fill missing quantities in Bst.
 call hdr_io_etsf(fform,Hdr,1,ncid)

 Bst%tphysel = Hdr%tphysel
 Bst%istwfk  = Hdr%istwfk
 Bst%occopt  = Hdr%occopt
 call hdr_clean(Hdr)

 ! === Close the file ===
 call etsf_io_low_close(ncid,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Finalize the object ===
 !FIXME At the moment this has to be done outside the routine
 ! Moreover I have to solve the problem with the convention for the Fermi level
 fixmom_=99.99_dp 
 !call update_occ(BSt,fixmom_)

 1000 continue
 if (.not.lstat) then
  ! === Handle the error ===
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,' abi_Bands_read: ERROR -',ch10,errmess(1:min(475, len(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

#else 
 write(msg,'(4a)')ch10,&
& ' abi_Bands_read : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine abi_Bands_read
!!***

!!****f* ABINIT/etsf_dump_QP
!! NAME
!! etsf_dump_QP
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE
subroutine etsf_dump_QP(Sr,QP_BSt,KS_BSt,Hdr,Cryst,Kmesh,filapp)

 use defs_basis
 use defs_datatypes
#if defined HAVE_ETSF_IO
 use m_numeric_tools, only : c2r
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_13ionetcdf
 use interfaces_15gw, except_this_one => etsf_dump_QP
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bandstructure_type),intent(in) :: QP_BSt,KS_BSt
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Crystal_structure),intent(in) :: Cryst
 type(Sigma_results),intent(in) :: Sr
 type(Hdr_type),intent(inout) :: Hdr
 character(len=fnlen),intent(in) :: filapp
!arrays

!Local variables ---------------------------------------
 character(len=500) :: msg
#if defined HAVE_ETSF_IO
!scalars
 integer :: ncid,nbgw,ndim_sig,b1gw,b2gw,fform,cplex
 logical :: lstat
 character(len=fnlen) :: filetsf
 character(len=etsf_io_low_error_len) :: errmess
 type(ETSF_dims) :: dims
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_gwdata) :: GWdata
!arrays
 real(dp),target,allocatable :: gw_corrections(:,:,:,:) 
 real(dp),allocatable :: rdata2(:,:),rdata3(:,:,:),rdata4(:,:,:,:),rdata5(:,:,:,:,:)
#endif

! *************************************************************************

#if defined HAVE_ETSF_IO

 call abi_crystal_put(Cryst,filapp)
 call abi_Bands_put  (KS_Bst,filapp)
  !check here that I have problems

 filetsf=TRIM(filapp)//'-etsf.nc'
 write(msg,'(3a)')ch10,' etsf_dump_QP : about to open file ',TRIM(filetsf)
 call wrtout(std_out,msg,'COLL')

 call etsf_io_low_open_modify(ncid,filetsf,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Write the abinit header ===
 ! Have to update the occupations?
 fform=502
 call hdr_io_etsf(fform,Hdr,2,ncid)

 ! === Write the GW correction ===
 write(msg,'(a)')' etsf_dump_QP : about to write GW corrections'
 call wrtout(std_out,msg,'COLL')
 !FIXME this has to be done in a cleaner way use Sr%egw
 allocate(gw_corrections(2,KS_BSt%mband,KS_BSt%nkpt,KS_BSt%nsppol))
 gw_corrections=zero
 gw_corrections(1,:,:,:) = QP_BSt%eig - KS_BSt%eig
 !£gw_corrections = c2r(Sr%degw)
 GWdata%gw_corrections%data4D => gw_corrections

 call etsf_io_gwdata_put(ncid,GWdata,lstat,Error_data)
 if (.not.lstat) goto 1000

 nullify(GWdata%gw_corrections%data4D)
 deallocate(gw_corrections)

 ! === Up to now we have an ETSF file ===
 ! * Now add variables for internal use in abinit.

 call etsf_io_low_set_define_mode(ncid,lstat,Error_data)
 if (.not.lstat) goto 1000

 b1gw=Sr%b1gw ; b2gw=Sr%b2gw
 nbgw=b2gw-b1gw+1
 ndim_sig=Sr%nsppol*Sr%nsig_ab
 cplex=2

 call etsf_io_low_write_dim(ncid,'cplex',cplex,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  ! Needed to store complex quantities

 call etsf_io_low_write_dim(ncid,'b1gw',Sr%b1gw,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! min GW band

 call etsf_io_low_write_dim(ncid,'b2gw',Sr%b2gw,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! Max GW band

 call etsf_io_low_write_dim(ncid,'nbgw',nbgw,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! Number of GW bands

 call etsf_io_low_write_dim(ncid,'nkcalc',Sr%nkcalc,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! No. of points calculated

 call etsf_io_low_write_dim(ncid,'ndim_sig',ndim_sig,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000 
 
 if (Sr%nomega_r>0) then ! No. of real frequencies, might be zero.
  call etsf_io_low_write_dim(ncid,'nomega_r',Sr%nomega_r,lstat,Error_data=Error_data) 
  if (.not.lstat) goto 1000 
 end if

 if (Sr%nomega_i>0) then ! No. of imaginary frequencies, might be zero.
  call etsf_io_low_write_dim(ncid,'nomega_i',Sr%nomega_i,lstat,Error_data=Error_data) 
  if (.not.lstat) goto 1000 
 end if

 call etsf_io_low_write_dim(ncid,'nomega4sd',Sr%nomega4sd,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! No. of points for sigma derivative.

 call etsf_io_low_write_dim(ncid,'nsig_ab',Sr%nsig_ab,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! No. of components of sigma (1 if collinear, 4 if noncollinear)

 !call etsf_io_low_write_dim(ncid,'usepawu',Sr%usepawu,lstat,Error_data=Error_data) ! 1 if LDA+U TODO changes name to avoid problems with Hdr
 !if (.not.lstat) goto 1000 

 ! =======================
 ! == Define variables ===
 ! =======================
 ! TODO use more verbose names!

 call etsf_io_low_def_var(ncid,'gwcalctyp',etsf_io_low_integer,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'omegasrdmax',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'deltae',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'omegasrmax',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'scissor_ene',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'xkcalc',etsf_io_low_double,&
& (/pad('number_of_reduced_dimensions'),pad('nkcalc')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'minbnd',etsf_io_low_integer,&
& (/'nkcalc'/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'maxbnd',etsf_io_low_integer,&
& (/'nkcalc'/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_def_var(ncid,'omega_r',etsf_io_low_double,&
&  (/'nomega_r'/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

!here Sr% starts
 call etsf_io_low_def_var(ncid,'degwgap',etsf_io_low_double,&
& (/pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'egwgap',etsf_io_low_double,&
& (/pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'en_qp_diago',etsf_io_low_double,&
& (/pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'e0',etsf_io_low_double,&
& (/pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'e0gap',etsf_io_low_double,&
& (/pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigxme',etsf_io_low_double,&
& (/pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'vxcme',etsf_io_low_double,&
& (/pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'vUme',etsf_io_low_double,&
& (/pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'degw',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'dsigmee0',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'egw',etsf_io_low_double,&
& (/pad('cplex'),pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'eigvec_qp',etsf_io_low_double,&
& (/pad('cplex'),pad('max_number_of_states'),pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'hhartree',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_def_var(ncid,'sigcme',etsf_io_low_double,&
&  (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega_r'),pad('ndim_sig')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_def_var(ncid,'sigmee',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigcmee0',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigcmesi',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigcme4sd',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega4sd'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_def_var(ncid,'sigxcme',etsf_io_low_double,&
&  (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega_r'),pad('ndim_sig')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 if (Sr%nomega_i>0) then
  call etsf_io_low_def_var(ncid,'sigxcmesi',etsf_io_low_double,&
&  (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega_i'),pad('ndim_sig')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_def_var(ncid,'sigxcme4sd',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega4sd'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'ze0',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_i>0) then
  call etsf_io_low_def_var(ncid,'omega_i',etsf_io_low_double,& 
&  (/pad('cplex'),pad('nomega_i')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_def_var(ncid,'omega4sd',etsf_io_low_double,& 
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega4sd'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! =====================
 ! === Start writing ===
 ! =====================
 call etsf_io_low_set_write_mode(ncid,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'gwcalctyp',Sr%gwcalctyp,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'omegasrdmax',Sr%maxomega4sd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'deltae',Sr%deltae,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'omegasrmax',Sr%maxomega_r,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'scissor_ene',Sr%scissor_ene,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'xkcalc',Sr%xkcalc,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'minbnd',Sr%minbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'maxbnd',Sr%maxbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'degwgap',Sr%degwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'egwgap',Sr%egwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'en_qp_diago',Sr%en_qp_diago,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'e0',Sr%e0,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'e0gap',Sr%e0gap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_write_var(ncid,'omega_r',Sr%omega_r,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_write_var(ncid,'sigxme',Sr%sigxme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'vxcme',Sr%vxcme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'vUme',Sr%vUme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! * Have to transfer complex arrays
 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol))
 rdata4=c2r(Sr%degw)
 call etsf_io_low_write_var(ncid,'degw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata4=c2r(Sr%dsigmee0)
 call etsf_io_low_write_var(ncid,'dsigmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 rdata4=c2r(Sr%egw)
 call etsf_io_low_write_var(ncid,'egw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata5(cplex,Sr%nbnds,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 rdata5=c2r(Sr%eigvec_qp)
 call etsf_io_low_write_var(ncid,'eigvec_qp',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 allocate(rdata5(cplex,nbgw,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata5=c2r(Sr%hhartree)
 call etsf_io_low_write_var(ncid,'hhartree',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigcme)
  call etsf_io_low_write_var(ncid,'sigcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata5)
 end if

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata4=c2r(Sr%sigmee)
 call etsf_io_low_write_var(ncid,'sigmee',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata4=c2r(Sr%sigcmee0)
 call etsf_io_low_write_var(ncid,'sigcmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigcmesi)
  call etsf_io_low_write_var(ncid,'sigcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata5)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 rdata5=c2r(Sr%sigcme4sd)
 call etsf_io_low_write_var(ncid,'sigcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigxcme)
  call etsf_io_low_write_var(ncid,'sigxcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata5)
 end if

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigxcmesi)
  call etsf_io_low_write_var(ncid,'sigxcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 rdata5=c2r(Sr%sigxcme4sd)
 call etsf_io_low_write_var(ncid,'sigxcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol))
 rdata4=c2r(Sr%ze0)
 call etsf_io_low_write_var(ncid,'ze0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata2(cplex,Sr%nomega_i))
  rdata2=c2r(Sr%omega_i)
  call etsf_io_low_write_var(ncid,'omega_i',rdata2,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata2)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol))
 rdata5=c2r(Sr%omega4sd)
 call etsf_io_low_write_var(ncid,'omega4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 ! === Close the file ===
 call etsf_io_low_close(ncid,lstat,Error_data)
 if (.not.lstat) goto 1000

 1000 continue
 if (.not.lstat) then
  ! === Handle the error ===
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,' etsf_dump_QP: ERROR -',ch10,errmess(1:min(475, len(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

 write(msg,'(a)')' etsf_dump_QP: exit '
 call wrtout(std_out,msg,'COLL')

#else 
 write(msg,'(4a)')ch10,&
& ' etsf_dump_QP : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine etsf_dump_QP
!!***

!!****f* ABINIT/abi_crystal_put
!! NAME
!! abi_crystal_put
!!
!! FUNCTION
!! Output system geometry to a file, using the NETCDF file format and ETSF I/O.
!! Data are taken from the Crystal_structure object.
!!
!! COPYRIGHT
!! Copyright (C) 2006-2009 ABINIT group (MG, Yann Pouillon)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  Crystal_structure<Crystal_structure>=Object defining the unit cell and its symmetries.
!!     %natom=Number of atoms in the unit cell
!!     %ntypat=Number of types of atoms in the unit cell.
!!     %npsp=Number of pseudopotentials.
!!     %space_group=Space group identifier.
!!     %typat(natom)=Type of each atom in the unit cell.
!!     %ziontypat(ntypat)=Charge of the pseudo-ion (No of valence electrons needed to screen exactly the pseudopotential).
!!     %znucl(ntypat)=Nuclear charge for each type of pseudopotential.
!!     %title(npsps)=The content of first line read from the psp file.
!!     %rprimd(3,3)=Real space dimensional primitive translations (bohr)
!!     %xred(3,natom)=Reduced coordinates of atoms.
!!     %symrel=Symmetry operations in real space (in terms of rprimd)
!!     %tnons(3,nsym)=Fractional translations.
!!     %isymmorphic=.TRUE. if space group is symmorphic i.e all tnons are zero.
!!     %symafm(nsym)=(Anti)ferromagnetic symmetries.
!!  filapp=character string giving the root to form the name of the GEO file
!!
!! OUTPUT
!!  Data written in file whose name is filapp//'-etsf.nc'
!!
!! NOTES
!!  alchemy not treated, Crystal should be correctly Initialized at the beginning of the run.
!!
!! PARENTS
!!      gw_etsf_io
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine abi_crystal_put(Cryst,filapp)

 use defs_basis
 use defs_datatypes, only : Crystal_structure
#if defined HAVE_ETSF_IO
 use m_errors,   only : assert
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_11util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 character(len=fnlen),intent(in) :: filapp
 type(Crystal_structure),target,intent(in) :: Cryst
!arrays

!Local variables-------------------------------
 character(len=500) :: msg
#if defined HAVE_ETSF_IO
!scalars
 integer :: ityp,ungeo
 integer,target :: space_group
 real(dp) :: amu,rcov
 logical :: lstat,ltest
 character(len=fnlen) :: filgeo
 character(len=etsf_io_low_error_len) :: errmess
 character(len=etsf_charlen) :: symmorphic
 type(ETSF_dims) :: Dims
 type(ETSF_groups) :: Group_folder
 type(ETSF_geometry),target :: Geo_folder
 type(ETSF_io_low_error) :: Error_data
!arrays
 character(len=2),allocatable,target :: symbols(:)
 character(len=80),allocatable,target :: psp_desc(:),symbols_long(:)
#endif

! *************************************************************************

#if defined HAVE_ETSF_IO
 ! FIXME alchemy not treated since Cryst should be initialized in invars2
 ltest=(Cryst%npsp==Cryst%ntypat)
 call assert(ltest,'alchemy not supported',__FILE__,__LINE__)

 ! === Set-up atomic symbols ===
 allocate(symbols(Cryst%ntypat),symbols_long(Cryst%ntypat),psp_desc(Cryst%ntypat))
 do ityp=1,Cryst%ntypat  
  call atmdata(amu,rcov,symbols(ityp),Cryst%znucl(ityp)) 
  write(symbols_long(ityp),'(a2,a78)') symbols(ityp),REPEAT(CHAR(0),78)
  write(psp_desc(ityp),'(2a)') &
&  Cryst%title(ityp)(1:MIN(80,LEN_TRIM(Cryst%title(ityp)))),REPEAT(CHAR(0),MAX(0,80-LEN_TRIM(Cryst%title(ityp))))
 end do

 ! === Open the file ===
 filgeo=TRIM(filapp)//'-etsf.nc'
 write(msg,'(2a)')' abi_etsf_geo_put : about to open file ',TRIM(filgeo)
 call wrtout(std_out,msg,'COLL')
 call etsf_io_low_open_modify(ungeo,filgeo,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Define ETSF Dimensions and write on file ===
 ! * Use low level procedures to write dimensions, since 
 !   etsf_io_dims_def correctly complains that some ETSF dims are missing.
 ! * If dimensions already exist, check that definitions are coherent.
 !Dims%number_of_atoms               = Cryst%natom
 !Dims%number_of_atom_species        = Cryst%ntypat
 !Dims%number_of_symmetry_operations = Cryst%nsym
 !call etsf_io_dims_def(ungeo,Dims,lstat,Error_data)
 !if (.not.lstat) goto 1000

 call etsf_io_low_write_dim(ungeo,'number_of_atoms',Cryst%natom,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  
 call etsf_io_low_write_dim(ungeo,'number_of_atoms_species',Cryst%ntypat,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  
 call etsf_io_low_write_dim(ungeo,'number_of_symmetry_operations',Cryst%nsym,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  

 ! === Close the file, due to call to etsf_io_data_write  ===
 call etsf_io_low_close(ungeo,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Fill-in ETSF geometry folder ===
 space_group=0
 if (Cryst%space_group>0) space_group=Cryst%space_group
 Geo_folder%space_group                   => space_group
 Geo_folder%primitive_vectors             => Cryst%rprimd
 Geo_folder%reduced_symmetry_matrices     => Cryst%symrel
 Geo_folder%reduced_symmetry_translations => Cryst%tnons
 Geo_folder%atom_species                  => Cryst%typat
 Geo_folder%reduced_atom_positions        => Cryst%xred
 if (Cryst%npsp==Cryst%ntypat) then
  Geo_folder%valence_charges              => Cryst%ziontypat
 end if
 Geo_folder%atomic_numbers                => Cryst%znucl
 Geo_folder%atom_species_names            => symbols_long
 Geo_folder%chemical_symbols              => symbols
 Geo_folder%pseudopotential_types         => psp_desc

 !FIXME symmorphic is missing
 symmorphic='no'
 if (Cryst%isymmorphic) symmorphic='yes'

 Group_folder%geometry => Geo_folder

 call etsf_io_data_write(filgeo,Group_folder,lstat,Error_data)
 if (.not.lstat) goto 1000
 deallocate(symbols,symbols_long,psp_desc)
 !
 ! === At this point we have an ETSF-compliant file ===
 ! * Add additional stuff for internal use in abinit.
 ! TODO add spinat.

 call etsf_io_low_open_modify(ungeo,filgeo,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ungeo,'symafm',etsf_io_low_integer,&
& (/'number_of_symmetry_operations'/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_set_write_mode(ungeo,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ungeo,'symafm',Cryst%symafm,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_close(ungeo,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 1000 continue
 if (.not.lstat) then
  ! === Handle the error ===
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,&
&  ' abi_crystal_put: ERROR -',ch10,&
&  errmess(1:min(470,len(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

#else
 write(msg,'(4a)')ch10,&
& ' abi_crystal_put : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine abi_crystal_put
!!***
  
!!****f* ABINIT/abi_bands_put
!! NAME
!! abi_bands_put
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      gw_etsf_io
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE


subroutine abi_Bands_put(Bst,filapp)

 use defs_basis
 use defs_datatypes
#if defined HAVE_ETSF_IO
 use m_errors,   only : assert
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 character(len=fnlen),intent(in) :: filapp
 type(Bandstructure_type),target,intent(in) :: Bst
!arrays

!Local variables-------------------------------
 character(len=500) :: msg
#if defined HAVE_ETSF_IO
!scalars
 integer :: untbst,fform,usewvl,formeig,idx,isppol,nkpt,iband,ikpt
 integer,target :: nelect_int
 real(dp) :: fixmom_
 logical :: lstat,ltest
 character(len=fnlen) :: filbst
 character(len=etsf_io_low_error_len) :: errmess
 type(ETSF_dims) :: Dims
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_basisdata) :: Basisdata
 type(Hdr_type) :: Hdr
 type(ETSF_groups) :: GroupFolder
 type(ETSF_electrons),target :: Electrons
 type(ETSF_kpoints),target :: Kpoints
!type(etsf_geometry), pointer :: geometry => null()
!  type(etsf_electrons), pointer :: electrons => null()
!  type(etsf_kpoints), pointer :: kpoints => null()
!  type(etsf_basisdata), pointer :: basisdata => null()
!  type(etsf_GWdata), pointer :: gwdata => null()
!  type(etsf_main), pointer :: main => null()
!end type etsf_groups
!arrays
 real(dp),allocatable,target :: eig_vec(:),occ_vec(:)
#endif

! *************************************************************************

#if defined HAVE_ETSF_IO
 ! === Open the file ===
 filbst=TRIM(filapp)//'-etsf.nc'
 write(msg,'(3a)')ch10,' abi_Bands_put : about to modify file ',TRIM(filbst)
 call wrtout(std_out,msg,'COLL')

 call etsf_io_low_open_modify(untbst,filbst,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Write dimensions handled by ETSF ===
 ! * Use low level procedures to write dimensions, since 
 !   etsf_io_dims_def correctly complains that some ETSF dims are missing.

 !FIXME: do not handle k_dependent = 1
 !Dims%max_number_of_states        = Bst%mband    
 !Dims%number_of_kpoints           = Bst%nkpt
 !Dims%number_of_spinor_components = Bst%nspinor  
 !Dims%number_of_spins             = Bst%nsppol  
 !!Dims%number_of_components       = Bst%nspden 
 !call etsf_io_dims_def(untbst,Dims,lstat,Error_data)
 !if (.not.lstat) goto 1000

 call etsf_io_low_write_dim(untbst,'max_number_of_states',Bst%mband,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  
 call etsf_io_low_write_dim(untbst,'number_of_kpoints',Bst%nkpt,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  
 call etsf_io_low_write_dim(untbst,'number_of_spinor_components',Bst%nspinor,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  
 call etsf_io_low_write_dim(untbst,'number_of_spins',Bst%nsppol,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  


 usewvl=0 !FIXME
 ! Get all variables included in ETSF
 if (usewvl==0) then
  BasisData%number_of_coefficients => Bst%npwarr
  call etsf_io_basisdata_put(untbst,Basisdata,lstat,Error_data)
  if (.not.lstat) goto 1000
 end if

 ! === Close the file, due to call to etsf_io_data_write  ===
 call etsf_io_low_close(untbst,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 Electrons%fermi_energy            => Bst%fermie
 nelect_int=NINT(Bst%nelect)
 Electrons%number_of_electrons     => nelect_int  !WARNING in ETSF this is integer
 Electrons%smearing_width          => Bst%tsmear 
 Electrons%number_of_states%data1D => Bst%nband 

 ! DFPT not treated, we allocate correctly but the object should be modified a bit. 
 formeig=0
 allocate(eig_vec((2*Bst%mband)**formeig*Bst%mband*Bst%nkpt*Bst%nsppol))
 allocate(occ_vec(Bst%mband*Bst%nkpt*Bst%nsppol))
 idx=0 !call my helper function once modules will be supported.
 do isppol=1,Bst%nsppol
  do ikpt=1,Bst%nkpt
   do iband=1,Bst%nband(ikpt+(isppol-1)*nkpt)
    idx=idx+1
    eig_vec(idx)=Bst%eig(iband,ikpt,isppol)
    occ_vec(idx)=Bst%occ(iband,ikpt,isppol)
   end do
  end do
 end do

 Electrons%eigenvalues%data1D => eig_vec
 Electrons%occupations%data1D => occ_vec

 Kpoints%reduced_coordinates_of_kpoints => Bst%kptns
 Kpoints%kpoint_weights                 => Bst%wtk

 GroupFolder%Electrons => Electrons
 GroupFolder%Kpoints   => Kpoints

 call etsf_io_data_write(filbst,GroupFolder,lstat,Error_data)

 deallocate(eig_vec,occ_vec)

 ! === Write additional stuff contained in the the abinit header ===
 ! * Define additional variables.
 call etsf_io_low_open_modify(untbst,filbst,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(untbst,'tphysel',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(untbst,'occopt',etsf_io_low_integer, &
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(untbst,'istwfk',etsf_io_low_integer,&
& (/'number_of_kpoints'/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Write data ===
 call etsf_io_low_set_write_mode(untbst,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(untbst,'occopt',Bst%occopt,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(untbst,'tphysel',Bst%tphysel,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(untbst,'istwfk',Bst%istwfk,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Close the file ===
 call etsf_io_low_close(untbst,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 1000 continue
 if (.not.lstat) then
  ! === Handle the error ===
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,&
&  ' abi_Bands_put: ERROR -',ch10,&
&  errmess(1:min(470, len(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

 ! === Finalize the object ===
 !FIXME At the moment this has to be done outside the routine
 ! Moreover I have to solve the problem with the convention for the Fermi level
 ! Maybe it makes sense if fixmom is included in the object!
 fixmom_=99.99_dp 
 !call update_occ(BSt,fixmom_)

#else 
 write(msg,'(4a)')ch10,&
& ' abi_Bands_put : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine abi_Bands_put
!!***

!!****f* ABINIT/abi_etsf_get_QP
!! NAME
!! abi_etsf_get_QP
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      gw_tools
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine abi_etsf_get_QP(Sr,KS_BSt,Hdr,Cryst,filapp)

 use defs_basis
 use defs_datatypes
 use m_crystal
 use m_numeric_tools, only : r2c
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_13ionetcdf
 use interfaces_15gw, except_this_one => abi_etsf_get_QP
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bandstructure_type),intent(out) :: KS_BSt
 type(Crystal_structure),intent(out) :: Cryst
 type(Sigma_results),intent(out) :: Sr
 type(Hdr_type),intent(out) :: Hdr
 character(len=fnlen),intent(in) :: filapp
!arrays

!Local variables ---------------------------------------
 character(len=500) :: msg
#if defined HAVE_ETSF_IO
!scalars
 integer :: ncid,nbgw,ndim_sig,b1gw,b2gw,fform,cplex,timrev
 integer :: prtvol
 logical :: lstat
 character(len=fnlen) :: filetsf
 character(len=etsf_io_low_error_len) :: errmess
 type(ETSF_dims) :: Dims
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_gwdata) :: GWdata
!arrays
 real(dp),target,allocatable :: gw_corrections(:,:,:,:) 
 real(dp),allocatable :: rdata2(:,:),rdata3(:,:,:),rdata4(:,:,:,:),rdata5(:,:,:,:,:)
#endif

! *************************************************************************

#if defined HAVE_ETSF_IO
 filetsf=TRIM(filapp)//'-etsf.nc'
 write(msg,'(3a)')ch10,' abi_etsf_get_QP : about to read file ',TRIM(filetsf)
 call wrtout(std_out,msg,'COLL')
 call etsf_io_low_open_read(ncid,filetsf,lstat,Error_data=Error_data,with_etsf_header=.TRUE.)
 if (.not.lstat) goto 1000

 ! === Read KS band structure ===
 call abi_Bands_read(KS_Bst,filapp)

 ! === Read the abinit header ===
 call hdr_io_etsf(fform,Hdr,1,ncid)

 timrev=2
 call InitCrystalFromHdr(Hdr,Cryst,timrev,remove_inv=.FALSE.)

 ! === Read dimensions handled by ETSF ===
 call etsf_io_dims_get(ncid,Dims,lstat,Error_data)
 if (.not.lstat) goto 1000

 ! FIXME: don't handle k_dependent = 1
 !hdr%bantot   = dims%max_number_of_states * dims%number_of_kpoints * dims%number_of_spins
 !hdr%natom    = dims%number_of_atoms
 Sr%nbnds     = Dims%max_number_of_states
 Sr%nkibz     = Dims%number_of_kpoints
 !hdr%nspden   = dims%number_of_components
 !hdr%nspinor  = dims%number_of_spinor_components
 Sr%nsppol     = Dims%number_of_spins
 !hdr%nsym     = dims%number_of_symmetry_operations
 !hdr%ntypat   = dims%number_of_atom_species

 call etsf_io_low_read_dim(ncid,'b1gw',Sr%b1gw,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'b2gw',Sr%b2gw,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 !call etsf_io_low_read_dim(ncid,'nbgw',??,lstat,Error_data=Error_data)
 !if (.not.lstat) goto 1000

 !FIXME
 call etsf_io_low_read_dim(ncid,'nkcalc',Sr%nkcalc,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 !call etsf_io_low_read_dim(ncid,'ndim_sig',Sr%ndim_sig,lstat,Error_data=Error_data)
 !if (.not.lstat) goto 1000

 ! The following dimensions might be not specified
 call etsf_io_low_read_dim(ncid,'nomega_r',Sr%nomega_r,lstat,Error_data=Error_data)
 if (Sr%nomega_r==etsf_no_dimension) lstat=.TRUE.
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'nomega_i',Sr%nomega_i,lstat,Error_data=Error_data)
 if (Sr%nomega_i==etsf_no_dimension) lstat=.TRUE.
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'nomega4sd',Sr%nomega4sd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'nsig_ab',Sr%nsig_ab,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 !call etsf_io_low_read_dim(ncid,'usepawu',Sr%usepawu,lstat,Error_data=Error_data)
 !if (.not.lstat) goto 1000

 ! == Initialize the structure ===
 call allocate_sigma_results(Sr,&
& Sr%b1gw,Sr%b2gw,Sr%nbnds,Sr%nkibz,Sr%nkcalc,Sr%nsppol,Sr%nsig_ab,Sr%nomega_r,Sr%nomega_i,Sr%nomega4sd)

 b1gw=Sr%b1gw 
 b2gw=Sr%b2gw
 nbgw=b2gw-b1gw+1

 ! ======================
 ! === Read variables ===
 ! ======================

 call etsf_io_low_read_var(ncid,'gwcalctyp',Sr%gwcalctyp,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'omegasrdmax',Sr%maxomega4sd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'deltae',Sr%deltae,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'omegasrmax',Sr%maxomega_r,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'scissor_ene',Sr%scissor_ene,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'xkcalc',Sr%xkcalc,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'minbnd',Sr%minbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'maxbnd',Sr%maxbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'degwgap',Sr%degwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'egwgap',Sr%egwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'en_qp_diago',Sr%en_qp_diago,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'e0',Sr%e0,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'e0gap',Sr%e0gap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_read_var(ncid,'omega_r',Sr%omega_r,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_read_var(ncid,'sigxme',Sr%sigxme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'vxcme',Sr%vxcme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'vUme',Sr%vUme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 cplex=2
 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'degw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%degw=r2c(rdata4)
 deallocate(rdata4)

 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'dsigmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%dsigmee0=r2c(rdata4) 
 deallocate(rdata4)

 allocate(rdata4(cplex,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'egw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%egw=r2c(rdata4)
 deallocate(rdata4)

 allocate(rdata5(cplex,Sr%nbnds,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'eigvec_qp',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%eigvec_qp=r2c(rdata5)
 deallocate(rdata5)

 allocate(rdata5(cplex,Sr%b1gw:Sr%b2gw,Sr%b1gw:Sr%b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'hhartree',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%hhartree=r2c(rdata5)
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigcme=r2c(rdata5)
  deallocate(rdata5)
 end if

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigmee',rdata4,lstat,Error_data=Error_data)
 Sr%sigmee=r2c(rdata4)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigcmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigcmee0=r2c(rdata4) 
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigcmesi=r2c(rdata5) 
  deallocate(rdata5)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigcme4sd=r2c(rdata5)
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigxcme=r2c(rdata5)
  deallocate(rdata5)
 end if

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigxcmesi=r2c(rdata5)
  deallocate(rdata5)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigcme4sd=r2c(rdata5)
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigxcme=r2c(rdata5)
  deallocate(rdata5)
 end if

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcmesi',rdata5,lstat,Error_data=Error_data)
  Sr%sigxcmesi=r2c(rdata5)
  if (.not.lstat) goto 1000
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigxcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigxcme4sd=r2c(rdata5)
 deallocate(rdata5)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'ze0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%ze0=r2c(rdata4)
 !Sr%ze0=CMPLX(rdata4(1,:,:,:),rdata4(2,:,:,:))
 !write(*,*)rdata4
 !write(*,*)Sr%ze0
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata2(cplex,Sr%nomega_i))
  call etsf_io_low_read_var(ncid,'omega_i',rdata2,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%omega_i=r2c(rdata2)
  deallocate(rdata2)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'omega4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%omega4sd=r2c(rdata5)
 deallocate(rdata5)

 call etsf_io_low_close(ncid,lstat,Error_data)
 if (.not.lstat) goto 1000

 1000 continue
 if (.not.lstat) then
  ! === Handle the error ===
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,&
&  ' abi_etsf_get_QP: ERROR -',ch10,&
&  errmess(1:MIN(460,LEN(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

#else
 write(msg,'(4a)')ch10,&
& ' abi_etsf_get_QP : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine abi_etsf_get_QP
!!***
