!{\src2tex{textfont=tt}}
!!****f* ABINIT/get_bands_sym_GW
!! NAME
!! get_bands_sym_GW
!!
!! FUNCTION
!!  Find the irreducible representation associated to a set of degenerate bands at a given k-point 
!!  The irreducible representation is obtained by rotating a set of degenerate wave functions using 
!!  the symmetry operations belonging to the little group of k. 
!!  Two states are considered to be degenerate if their energy differs by less than EDIFF_TOL.
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  EDIFF_TOL(optional)= tolerance on the energy difference of two states (if not specified is set to 0.001 eV)
!!  nbnds=number of bands at this k-point (same for spin up and down)
!!  nsppol=number of independent spin polarizations
!!  only_trace=if .TRUE. only the trace of a single matrix per class is calculated (standard procedure if
!!   only the symmetry of bands is required). If .FALSE. all the matrices for each irreducible representation
!!   are calculated and stored in BSym
!!  Kmesh<BZ_mesh_type>=datatype gathering information on the k-mesh used 
!!    %nibz=Number of points in the IBZ.
!!  Wfs(Wavefunctions_information)= structure gathering information on wave functions
!!  MPI_enreg=MPI-parallelisation information (some already initialized,
!!  Cryst<Crystal_structure>=Type gathering info on the crystal structure.
!!    %nsym=Number of operations in space group
!!    %ntypat=Number of type of atoms (onlu for PAW)
!!    %symrec(3,3,nsym)=Symmetry operations in reciprocal space (reduced coordinates)
!!    %tnons(3,nsym)=Fractional translations
!!    %typat(natom)=Type of each atom
!!  BSt<Bandstructure_type>
!!  usepaw=1 if PAW
!!  Pawang <type(pawang_type)>=paw angular mesh and related data
!!  Pawtab(ntypat*usepaw) <type(pawtab_type)>=paw tabulated starting data
!!  Psps<pseudopotential_type>
!!    %indlmn(6,lmnmax,ntypat)=array giving l,m,n,lm,ln,spin for i=lmn (for each atom type)
!!
!! OUTPUT
!!  BSym<Bands_Symmetries>=structure containing info on the little group of the k-point as well
!!   as the character of the representation associated to each set of degenerate states
!!  if BSym%isymmorphic the symmetry analysis cannot be performed, usually it means that 
!!   k is at zone border and there are non-symmorphic translations (see Notes)
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! * The irreducible representation, D(R_t), multiplies wave functions as a row vector:
!! 
!!    $ R_t \psi_a = \sum_b M(R_t)_{ba} \psi_b $
!! 
!!   As a result, if R_t belongs to the little group of k (Sk=k+G0), we obtain:
!! 
!!    $ M_ab(R_t) = e^{-i(k+G0).\tau} \int e^{iG0.r} u_{ak}(r)^* u_{bk}(R^{-1}(r-\tau)) \,dr $.
!!
!! * The irreducible representation of the small _point_ group of k, D_ab(R), suffices to
!!   classify degenerate eigenstates. The matrix if given by:
!!
!!    $ M_ab(R) = e^{+k.\tau} M_ab(R_t) = e^{-iG0.\tau} \int e^{iG0.r} u_{ak}(r)^* u_{bk}(R^{-1}(r-\tau))\,dr $
!!  
!!   The phase outside the integral should be zero since symmetry analysis at border zone in non-symmorphic
!!   space groups is not available. Anyway it is included in our expressions for the sake of consistency.
!!
!! * For PAW there is an additional onsite terms involving <phi_i|phi_j(R^{-1}(r-\tau)> and 
!!   the pseudized version that can be  evaluated using the rotation matrix for 
!!    real spherical harmonis, zarot(mp,m,l,R). $ Y_{lm}(Rr)= \sum_{m'} zarot(m',m,ll,R) Y_{lm'}(r) $
!!
!!    $ M^{onsite}_ab(R_t) = sum_{c ij} \<p_j^{c'}|\tpsi_a\>\<p_j^c|\tpsi_b\> \
!!      \delta_{\li\lj} D_{\mi\mj}^\lj (R^{-1}) \int (\phi_i-\tphi_i)(\phi_j-\tphi_j)\,dr $
!!
!!   where c' is the rotated atom i.e c' = R c + \tau and D is the rotation matrix.
!!
!!   Remember that zarot(m',m,l,R)=zarot(m,m',l,R^{-1})
!!   and $ Y^l_m(ISG) = sum_{m'} D_{m'm}(S) Y_{m'}^l(G) (-i)^l $
!!       $ D_{m'm}^l (R) = D_{m,m'}^l (R^{-1}) $
!!
!! * The method does not work if k is at zone border and the little group of k 
!!   contains a non-symmorphic fractional translation. 
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine get_Bands_Sym_GW(nspinor,nbnds,mkmem,nsppol,usepaw,only_trace,&
& Cryst,Kmesh,BSt,ngfft,Wfs,Pawtab,Pawang,Psps,Cprj_ibz,MPI_enreg,BSym,&
& EDIFF_TOL) ! optional

 use defs_basis
 use defs_datatypes
 use m_io_tools,      only : flush_unit
 use m_errors,        only : assert
 use m_numeric_tools, only : get_trace

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_15gw, except_this_one => get_Bands_Sym_GW
 use interfaces_15nonlocal
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nbnds,mkmem,nspinor,nsppol,usepaw
 real(dp),intent(in),optional :: EDIFF_TOL
 logical,intent(in) :: only_trace
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Crystal_structure),intent(in) :: Cryst
 type(MPI_type),intent(inout) :: MPI_enreg
 type(Pawang_type),intent(in) :: Pawang
 type(pseudopotential_type),intent(in) :: Psps
 type(Wavefunctions_information),intent(inout) :: Wfs
 type(Bandstructure_type),intent(in) :: BSt
 type(Bands_Symmetries),target,intent(out) :: BSym(Kmesh%nibz)
!arrays
 integer,intent(in) :: ngfft(18)
 type(Cprj_type),intent(in) :: Cprj_ibz(Cryst%natom,nspinor*nbnds*mkmem*nsppol*usepaw)
 type(Pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*usepaw)

!Local variables-------------------------------
!scalars
 integer :: dim_cplx,iat,ib,ib1,ib2,ib_end,ig,ib_start,iclass,icplx,idx,idx_ks,il,ikibz
 integer :: ilmn,ilpm,im,ir,isp,iat_sym,isym,isym_class,itypat,ix,iy,iz,jb1,jb2,jl,jlmn
 integer :: jlpm,jm,k0lmn,klmn,lmax,mm,nbnds_,ncplx_MAX,ngfft1,ngfft2
 integer :: ngfft3,nlmn,nsym_class,shift,nfft
 integer :: paral_kgb,igfft
 real(dp) :: EDIFF_TOL_,G0r,arg,dmimj,dmjmi,fact,fij,im_p,re_p,sij
 complex(dpc) :: phmG0t,trace,ctest1,ctest2
 logical :: ltest,iscompatibleFFT,littlegroup_classif
 character(len=500) :: msg
!arrays
 integer :: G0(3),R0(3)
 integer,allocatable :: Rm1rt(:)
 integer,allocatable :: dimlmn(:),irottb(:,:)
 real(dp) :: kibz(3),kpG0(3),tmp(2),phkR0(2)
 real(dp),allocatable :: DS_mmpl(:,:,:)
 real(dp),allocatable :: ene_k(:,:)
 complex(dpc),allocatable :: phase(:,:),ug2_rot(:) 
 complex(gwpc),allocatable :: ur1(:),ur2(:),ur2_rot(:)
 real(dp),allocatable :: ug2rot_FFT(:,:),ur2rot_FFT(:)
 type(Bands_Symmetries),pointer :: BSym_k
 type(Degenerate_Bands),allocatable :: PAWCplx(:,:)
 type(Cprj_type),allocatable :: Cprj_b(:,:),Cprj_brot(:,:)

 complex(dpc),external :: ZDOTC               

! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' get_Bands_symmetries : enter'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
#endif

 ! === Perform initial consistency check ===
 ltest=(nspinor==1)
 call assert(ltest,'nspinor/=1 not implemeented',__FILE__,__LINE__)
 ltest=(mkmem/=0) 
 call assert(ltest,'mkmem==0 not implemented',__FILE__,__LINE__)
 ltest=(mkmem==Kmesh%nibz) 
 call assert(ltest,'k-point distribution not implemented',__FILE__,__LINE__)
 nbnds_=Wfs%my_maxb-Wfs%my_minb+1 
 ltest=(nbnds_==nbnds) 
 call assert(ltest,'Bands cannot be distributed',__FILE__,__LINE__)

 EDIFF_TOL_=0.001/Ha_eV ; if (PRESENT(EDIFF_TOL)) EDIFF_TOL_=ABS(EDIFF_TOL)

 ! === Get index of the rotated FFT points ===
 ! * FFT mesh in real space _must_ be compatible with symmetries.
 ngfft1=ngfft(1) 
 ngfft2=ngfft(2) 
 ngfft3=ngfft(3)
 nfft=PRODUCT(ngfft(1:3)) ! No FFT parallelism

 allocate(irottb(nfft,Cryst%nsym))
 call rotate_FFT_mesh(Cryst,ngfft,irottb,iscompatibleFFT)

 call assert(iscompatibleFFT,'For symmetry analysis, FFT mesh should be conpatible with symmetries',&
& __FILE__,__LINE__)

 ! === Begin fat loop on the irreducible k-points ===
 do ikibz=1,Kmesh%nibz
  !
  ! * Initialize the Bsym structure for this k-point.
  kibz=Kmesh%ibz(:,ikibz) 
  !if (ANY(ABS(kibz)>tol6)) CYCLE !only gamma for check

  allocate(ene_k(nbnds,nsppol))
  ene_k=BSt%eig(:,ikibz,:) 
  call init_Bands_Symmetries(kibz,Cryst,only_trace,nspinor,nsppol,nbnds,EDIFF_TOL_,ene_k,Bsym(ikibz))
  deallocate(ene_k)

  BSym_k => BSym(ikibz)

  if (BSym_k%is_symmorphic) then
   write(*,*)' Non-symmorphic small group and zone border '
   write(*,*)' Character analysis not available '
   !STOP 'define irred_repr'
   GOTO 10
   !CYCLE
  end if

  ! * Precalculate phase e^{iG0.r} on the FFT mesh.
  allocate(phase(ngfft1*ngfft2*ngfft3, Bsym_k%nsym_sgk)) 
  phase=cone

  do isym=1,Bsym_k%nsym_sgk
   G0=BSym_k%G0(:,isym) 
   if (ALL(G0==0)) CYCLE
   do iz=0,ngfft3-1
    do iy=0,ngfft2-1
     do ix=0,ngfft1-1
      G0r=two_pi*(  G0(1)*(ix/DBLE(ngfft1)) &
                   +G0(2)*(iy/DBLE(ngfft2)) &
                   +G0(3)*(iz/DBLE(ngfft3)) )
      ir=1+ix+iy*ngfft1+iz*ngfft1*ngfft2
      phase(ir,isym)=CMPLX(COS(G0r),SIN(G0r),kind=dpc)
     end do
    end do
   end do
  end do
  !
  ! === Additional computation for PAW ===
  ! The onsite contribution reads:
  !  $M_{12} = \sum_{aij} \delta_{l_i,l_j} <p_i^{rot}|\tpsi_1>^* <p_j|\tpsi_2> S_ij D^{l_i}{m_i,m_j}(R^{-1})$
  ! where D is the rotation matrix of real spherical harmonics (zarot). 
  ! **** WARNING this part has to be tested ****

  if (usepaw==1) then 
   
   allocate(dimlmn(Cryst%natom))
   do iat=1,Cryst%natom
    dimlmn(iat)=Pawtab(Cryst%typat(iat))%lmn_size
   end do

   allocate(Cprj_b   (Cryst%natom,nbnds)) ; call cprj_alloc(Cprj_b,   0,dimlmn)
   allocate(Cprj_brot(Cryst%natom,nbnds)) ; call cprj_alloc(Cprj_brot,0,dimlmn)

   lmax=Pawang%l_max-1 !l_max == Max_{type} (l+1)
   allocate(DS_mmpl(2*lmax+1,2*lmax+1,lmax+1))  

   ncplx_MAX=MAXVAL(Bsym_k%ncplx) 
   allocate(PAWCplx(ncplx_MAX,nsppol)) 
   call nullify_Degenerate_Bands(PAWCplx)

   do isp=1,nsppol
    !
    ! === Retrieve matrix elements of PAW projectors ===
    ! TODO mkmem==0 not implemented mkmem==nkibz
    shift =nspinor*nbnds*mkmem*(isp-1)      
    idx_ks=nspinor*nbnds*(ikibz-1)+shift
    do ib=1,nbnds
     do iat=1,Cryst%natom
      Cprj_b(iat,ib)%cp(:,:)=Cprj_ibz(iat,idx_ks+ib)%cp(:,:)
     end do
    end do
    !
    ! === Loop over the set of degenerate bands for this spin ===
    do icplx=1,BSym_k%ncplx(isp) 

     ib_start = BSym_k%Cplx(icplx,isp)%ib_start
     ib_end   = BSym_k%Cplx(icplx,isp)%ib_end
     dim_cplx = BSym_k%Cplx(icplx,isp)%dim_cplx

     allocate(PAWCplx(icplx,isp)%trace(BSym_k%nclass))
     PAWCplx(icplx,isp)%trace(:)=czero

     !FIXME here there is a crash if only_trace is false
     if (.not.only_trace) then 
      allocate(PAWCplx(icplx,isp)%Rirr(dim_cplx,dim_cplx,BSym_k%nsym_sgk))
     end if
     !
     ! === Loop over classes ===
     idx=0
     do iclass=1,BSym_k%nclass
      nsym_class=BSym_k%nelements(iclass)

      ! * Loop over elements in each class.
      do isym_class=1,nsym_class
       !
       ! * If only the character is required, do this block only once.
       idx=idx+1 
       if (only_trace.and.isym_class/=1) CYCLE
       isym=BSym_k%sgk2symrec(idx)
       !if (isym/=1) CYCLE
       !
       ! === Rotate PAW projections ===
       ! * DS_mmpl is the rotation matrix of real spherical harmonics associated to symrec(:,:,isym).
       ! * DS_mmpl multiply harmonics as row vectors, we need R^{-1} but we read R and invert m,mp in the equation below 

       DS_mmpl(:,:,:)=Pawang%zarot(:,:,:,isym)

       do iat=1,Cryst%natom
        iat_sym=Cryst%indsym(4,isym,iat) 
        R0(:)=Cryst%indsym(1:3,isym,iat)
        arg=two_pi*DOT_PRODUCT(kibz,R0)
        phkR0(1)=COS(arg)
        phkR0(2)=SIN(arg)
        !phkR0(1)=one
        !phkR0(2)=zero
        do ib=1,nbnds
         Cprj_brot(iat,ib)%cp(1,:)= phkR0(1)*Cprj_b(iat_sym,ib)%cp(1,:) &
&                                  -phkR0(2)*Cprj_b(iat_sym,ib)%cp(2,:)

         Cprj_brot(iat,ib)%cp(2,:)= phkR0(1)*Cprj_b(iat_sym,ib)%cp(2,:) &
&                                  +phkR0(2)*Cprj_b(iat_sym,ib)%cp(1,:)
        end do
       end do

       !call rotate_cprj(isym,nbnds,Cryst,Psps,Pawang,Pawtab,Cprj_b,Cprj_brot)
       !
       ! * Loop over band indeces.
       do ib1=ib_start,ib_end
        do ib2=ib_start,ib_end
         if (only_trace.and.ib1/=ib2) CYCLE
         !
         ! * Accumulating atom-centered contributions.
         tmp(:)=zero
         do iat=1,Cryst%natom
          nlmn=dimlmn(iat)
          itypat=Cryst%typat(iat)

          do jlmn=1,nlmn 
           k0lmn=jlmn*(jlmn-1)/2 
           jl=Psps%indlmn(1,jlmn,itypat)
           jm=Psps%indlmn(2,jlmn,itypat)
           jlpm=1+jl+jm 

           do ilmn=1,jlmn  
            il=Psps%indlmn(1,ilmn,itypat)
            if (il/=jl) CYCLE ! Selection rule on l
            if (im/=jm) CYCLE ! Selection rule on m
            im=Psps%indlmn(2,ilmn,itypat)
            ilpm=1+il+im 

            klmn=k0lmn+ilmn 
            sij=Pawtab(itypat)%sij(klmn) 
            !if (ABS(sij<tol14)) CYCLE

            ! Here we get the matrix associated to R^{-1}.
            !this should be correct
            dmjmi=DS_mmpl(jlpm,ilpm,jl+1) ; dmimj=DS_mmpl(ilpm,jlpm,jl+1) 
            !dmjmi=DS_mmpl(ilpm,jlpm,jl+1) ; dmimj=DS_mmpl(jlpm,ilpm,jl+1) 

            re_p=  dmjmi* ( Cprj_b(iat,ib1)%cp(1,ilmn)*Cprj_brot(iat,ib2)%cp(1,jlmn)  &
&                          +Cprj_b(iat,ib1)%cp(2,ilmn)*Cprj_brot(iat,ib2)%cp(2,jlmn) )&
&                 +dmimj* ( Cprj_b(iat,ib1)%cp(1,jlmn)*Cprj_brot(iat,ib2)%cp(1,ilmn)  &
&                          +Cprj_b(iat,ib1)%cp(2,jlmn)*Cprj_brot(iat,ib2)%cp(2,ilmn) )

            im_p=  dmjmi* ( Cprj_b(iat,ib1)%cp(1,ilmn)*Cprj_brot(iat,ib2)%cp(2,jlmn)  &
&                          -Cprj_b(iat,ib1)%cp(2,ilmn)*Cprj_brot(iat,ib2)%cp(1,jlmn) )&
&                 +dmimj* ( Cprj_b(iat,ib1)%cp(1,jlmn)*Cprj_brot(iat,ib2)%cp(2,ilmn)  &
&                          -Cprj_b(iat,ib1)%cp(2,jlmn)*Cprj_brot(iat,ib2)%cp(1,ilmn) )

            fij=one ; if (jlmn==ilmn) fij=half
            tmp(1)= tmp(1) + fij*sij*re_p 
            tmp(2)= tmp(2) + fij*sij*im_p

           end do !ilmn
          end do !jlmn
         end do !iat
         !
         ! === Save values ===
         jb1=ib1-ib_start+1 ; jb2=ib2-ib_start+1 
         PAWCplx(icplx,isp)%Rirr(jb1,jb2,idx)=CMPLX(tmp(1),tmp(2),kind=dpc)
        end do !ib2
       end do !ib1
       !
       ! === Calculate trace for each class ===
       if (isym_class==1) then 
        PAWCplx(icplx,isp)%trace(iclass) = get_trace( PAWCplx(icplx,isp)%Rirr(:,:,idx) )
       end if

      end do !isym_class
     end do !icl
    end do !icplx
   end do !isp

   deallocate(dimlmn)
   deallocate(DS_mmpl)
   call cprj_free(Cprj_b   ) ; deallocate(Cprj_b   )
   call cprj_free(Cprj_brot) ; deallocate(Cprj_brot)
  end if !PAW
  !
  ! === Evaluate matrix elements on the FFT mesh ===
  ! * If PAW we have to add the on-site contribution.
  fact=one/nfft 
  allocate(ur1(nfft),ur2(nfft),ur2_rot(nfft)) 
  allocate(ug2_rot(Wfs%npwwfn))
  allocate(ug2rot_FFT(2,nfft),ur2rot_FFT(2*nfft))
  allocate(Rm1rt(nfft))

  do isp=1,nsppol

   ! === Loop over set of degenerate states ===
   do icplx=1,BSym_k%ncplx(isp)

    ib_start=BSym_k%Cplx(icplx,isp)%ib_start
    ib_end  =BSym_k%Cplx(icplx,isp)%ib_end
    dim_cplx=BSym_k%Cplx(icplx,isp)%dim_cplx
    !
    ! === Loop over classes ===
    idx=0
    do iclass=1,BSym_k%nclass
     nsym_class=BSym_k%nelements(iclass)

     ! === Loop over elements in each class ===
     ! * If only the character is required, do this block once.
     do isym_class=1,nsym_class

      idx=idx+1 
      if (BSym_k%only_trace.and.isym_class/=1) CYCLE
      isym=BSym_k%sgk2symrec(idx)
      Rm1rt(:)=irottb(:,isym)

      !recheck this 
      littlegroup_classif=.TRUE.
      if (littlegroup_classif) then
       ! Classify states according to the little group.
       kpG0(:)=two_pi*( kibz + BSym_k%G0(:,idx) )
       arg=-two_pi*DOT_PRODUCT(kpG0(:),Cryst%tnons(:,isym))
      else 
       ! Classify states according to the small point group.
       arg=-two_pi*DOT_PRODUCT(BSym_k%G0(:,idx),Cryst%tnons(:,isym))
      end if

      !if (ABS(arg)<tol6) then 
      ! phmG0t=cone
      !else 
       phmG0t=CMPLX(COS(arg),SIN(arg),kind=dpc)
       !write(*,*)'Warning phase/=cone',phmG0t
      !end if
      !
      ! === Loop over matrix elements ===
      do ib1=ib_start,ib_end
       call get_wfr(Wfs,MPI_enreg,ib1,ikibz,isp,ur1)
       jb1=ib1-ib_start+1 

       do ib2=ib_start,ib_end
        if (BSym_k%only_trace.and.ib1/=ib2) CYCLE

        ! === Rotate the wave function and apply phase ===
        ! * Note that the k-point is the same within a lattice vector
        ! * Here I can calculate the product in reciprocal space!!
        call get_wfr(Wfs,MPI_enreg,ib2,ikibz,isp,ur2)
        do ir=1,nfft
         ur2_rot(ir)=ur2(Rm1rt(ir))*phase(ir,idx)
         ur2rot_FFT(2*(ir-1)+1)=REAL (ur2_rot(ir))
         ur2rot_FFT(2*ir)      =AIMAG(ur2_rot(ir))
        end do

        paral_kgb=0
        call fourdp(2,ug2rot_FFT,ur2rot_FFT,-1,MPI_enreg,nfft,Wfs%ngfft,paral_kgb,0)

        ug2_rot=czero
        do ig=1,Wfs%npwwfn
         igfft=Wfs%igfft0(ig)
         ug2_rot(ig)=CMPLX(ug2rot_FFT(1,igfft),ug2rot_FFT(2,igfft),kind=dpc)
        end do

        jb2=ib2-ib_start+1
        ! Here I have a crash if .FALSE.
        if (.not.only_trace) then
         ctest1=DOT_PRODUCT(Wfs%wfg(:,ib1,ikibz,isp),ug2_rot)*phmG0t
         ctest2=DOT_PRODUCT(ur1,ur2_rot)*fact*phmG0t
         !write(99,'(5es16.8)')ctest1,ctest2,ABS(ctest2-ctest1)
         BSym_k%Cplx(icplx,isp)%Rirr(jb1,jb2,idx)=ctest2
         if (usepaw==1) then 
          BSym_k%Cplx(icplx,isp)%Rirr(jb1,jb2,idx)=BSym_k%Cplx(icplx,isp)%Rirr(jb1,jb2,idx)+ &
&          PAWCplx(icplx,isp)%Rirr(jb1,jb2,idx)
         end if
        end if
       end do !ib2
      end do !ib1
      !
      ! === Calculate trace for each class ===
      ! * For PAW add onsite contribution.
      if (isym_class==1) then 
       trace = get_trace( BSym_k%Cplx(icplx,isp)%Rirr(:,:,idx) )
       if (usepaw==1) trace = trace + PAWCplx(icplx,isp)%trace(iclass)
       BSym_k%Cplx(icplx,isp)%trace(iclass)=trace
      end if

     end do !isymc_class 
    end do !iclass
   end do !icplx

  end do !isp

  deallocate(ur1,ur2,ur2_rot)
  deallocate(ug2_rot)
  deallocate(ug2rot_FFT,ur2rot_FFT)
  deallocate(Rm1rt,phase)

  if (usepaw==1) then 
   call destroy_Degenerate_Bands(PAWCplx)
   deallocate(PAWCplx)
  end if

  10 continue
  call finalize_Bands_Sym(BSym_k)
  call print_Bands_Symmetries(BSym_k)

 end do !ikibz

 deallocate(irottb)

!#if defined DEBUG_MODE
 write(msg,'(a)')' get_Bands_symmetres : exit'
 call wrtout(std_out,msg,'COLL') 
 call flush_unit(std_out)
 STOP
!#endif

end subroutine get_Bands_Sym_GW
!!***

!!****f* ABINIT/finalize_Bands_Sym
!! NAME
!! finalize_Bands_Sym
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      get_bands_sym_GW
!!
!! CHILDREN
!!
!! SOURCE
subroutine finalize_Bands_Sym(Bsym)

 use defs_basis
 use defs_datatypes
 use m_io_tools, only : flush_unit
 use m_errors,   only : assert

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bands_Symmetries),intent(inout) :: BSym

!Local variables-------------------------------
 integer :: ideg,isppol,nclass_found,icplx,ncfound,ifound,ib1,ib2,iclass,isearch
 integer :: ii,jj,ndeg,ndeg_found
 logical :: found,ltest

!arrays
 integer,allocatable :: tmp_deg(:)
 integer,pointer :: deg_found(:)
 complex(dpc),allocatable :: trace_found(:,:,:)
 complex(dpc) :: tmp_trace(BSym%nclass)

! *************************************************************************

 allocate(BSym%which_irred(BSym%nbnds,BSym%nsppol))

 select case (BSym%is_symmorphic) 

 case (.TRUE.)
  ! In this case the symmetry analysis cannot be performed
  ! The simplest thing we can do is to locate all the set of bands 
  ! with the same degeneracy and assign them to the same "irred representation"

  ! TODO this has to checked
  do isppol=1,BSym%nsppol

   allocate(tmp_deg(BSym%ncplx(isppol)))
   do icplx=1,BSym%ncplx(isppol)
    tmp_deg(icplx)=BSym%Cplx(icplx,isppol)%dim_cplx
   end do
!call get_diff_items(tmp_deg,ndeg,deg_found)

   deallocate(tmp_deg)

   do icplx=1,BSym%ncplx(isppol)
    do ii=1,ndeg_found
     if (BSym%Cplx(icplx,isppol)%dim_cplx==deg_found(ii)) then
      ib1=BSym%Cplx(icplx,isppol)%ib_start
      ib2=BSym%Cplx(icplx,isppol)%ib_end
      BSym%which_irred(ib1:ib2,isppol)=ii
      EXIT
     end if
    end do
   end do

  end do !isppol

 case (.FALSE.)
  ! * Since we still do not have a  lookup table definining the
  !   irreducible representation we have to search, for each spin,
  !   the different representation that have been calculated
  allocate(BSym%nclasses_found(BSym%nsppol))
  allocate(trace_found(BSym%nclass,MAXVAL(BSym%ncplx),BSym%nsppol))

  do isppol=1,BSym%nsppol

   trace_found(:,1,isppol)=BSym%Cplx(1,isppol)%trace(:)
   ncfound=1

   do icplx=2,BSym%ncplx(isppol)
    tmp_trace(:)=BSym%Cplx(icplx,isppol)%trace(:)

    ! === If not found add it to the list ===
    found=.FALSE. ; isearch=1
    do while ((.not.found) .and. (isearch<=ncfound))
     found = ALL( ABS(tmp_trace-trace_found(:,isearch,isppol))<tol6 )
     isearch=isearch+1
    end do

    if (.not.found) then 
     ncfound=ncfound+1
     trace_found(:,ncfound,isppol)=tmp_trace(:)
    end if
   end do

   ltest=(ncfound<=BSym%nclass)
   print*,'WARNING!!!! ncfound should be <= Bsym%nclass'
   !£call assert(ltest,'ncfound should be <= BSym%nclass',__FILE__,__LINE__)
   BSym%nclasses_found(isppol)=ncfound
  end do !isppol

  allocate(BSym%irred_repr(BSym%nclass,MAXVAL(BSym%nclasses_found),BSym%nsppol))

  do isppol=1,BSym%nsppol
   ncfound=BSym%nclasses_found(isppol)
   BSym%irred_repr(:,1:ncfound,isppol)=trace_found(:,1:ncfound,isppol)
   do ideg=1,BSym%ncplx(isppol)
    ib1=BSym%Cplx(ideg,isppol)%ib_start
    ib2=BSym%Cplx(ideg,isppol)%ib_end
    tmp_trace=BSym%Cplx(ideg,isppol)%trace(:)
    found=.FALSE. ; isearch=1
    do iclass=1,ncfound
     if ( ALL( ABS(tmp_trace-trace_found(:,iclass,isppol))<tol6 ) ) then
      BSym%which_irred(ib1:ib2,isppol)=iclass
      EXIT
     end if
    end do

   end do !ideg
  end do !isppol
  deallocate(trace_found)

 end select

end subroutine finalize_Bands_Sym
!!*** 

!!****f* ABINIT/rotate_cprj
!! NAME
!! rotate_cprj
!!
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! isym=index of the symmetry in the symrec arrays that preserves the given k-point within a reciprocal lattice vector
!! Cryst<Crystal_structure>=Type defining the crystal structure
!!   %ntypat=number of types of atom
!!   %natom=number of atoms
!!   %typat(natom)=type of eahc atom
!! nbnds=number of bands for this k-point ans spin
!! Pawang<Pawang_type>=PAWangular mesh and related data
!! Pawtab(ntypat)<Pawtab_type>=PAW tabulated starting data
!! Cprj_in(natom,nbnds)<type(cprj_type)>= projected input wave functions <Proj_i|Cnk> 
!!  with all NL projectors at fixed k-point 
!!
!! OUTPUT
!! Cprj_out(natom,nbnds) <type(cprj_type)>= projection of the smooth PAW wave function onto 
!!  projectors centered on equivalent sites of the crystal (non restricted to be in the firs unit cell)
!!  The equivalent site is defined according to the symmetry operation isym. Thus Cprj_out contains
!!
!!  Cprj_out(a,b)=<p_j^{R^{-1}(L_a-\tau)} | \tpsi_nk> if  R is the isym operation  with fractional translation \tau
!!  L_a is the position of the initial atom inside the first unit cell
!!  Note that atom a might be in a cell different from the initial one. No wrapping is done.
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rotate_cprj(isym,nbnds,Cryst,Psps,Pawang,Pawtab,Cprj_in,Cprj_out)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: isym,nbnds
 type(Crystal_structure),intent(in) :: Cryst
 type(Pawang_type),intent(in) :: Pawang
 type(Pseudopotential_type),intent(in) :: Psps
!arrays
 type(Cprj_type),intent(in) :: Cprj_in(Cryst%natom,nbnds)
 type(Cprj_type),intent(out) :: Cprj_out(Cryst%natom,nbnds)
 type(Pawtab_type),intent(in) :: Pawtab(Cryst%ntypat)

!Local variables-------------------------------
!scalars
 integer :: iat,ib,iband,indexj,itypat,jl,jl0,jlmn,jln,jln0,jlpm,jm,jn,ll,lmax
 integer :: mmp,nlmn
!arrays
 real(dp) :: tmp(2)
 real(dp),allocatable :: DRm1_mmpl(:,:,:)

! *************************************************************************

 lmax=Pawang%l_max-1 ! l_max == Max_{type} (l+1)
 allocate(DRm1_mmpl(2*lmax+1,2*lmax+1,lmax+1))  

 DRm1_mmpl(:,:,:)=Pawang%zarot(:,:,:,isym)

 ! === Loop over atoms to be symmetrized for this k-point ===
 do iat=1,Cryst%natom
  itypat=Cryst%typat(iat)
  nlmn=Pawtab(itypat)%lmn_size
  jl0=-1 ; jln0=-1 ; indexj=1

  ! === Loop on (jl,jm,jn) components to be symmetrized ===
  do jlmn=1,nlmn
   jl  =Psps%indlmn(1,jlmn,itypat)
   jm  =Psps%indlmn(2,jlmn,itypat)
   jn  =Psps%indlmn(3,jlmn,itypat)
   jln =Psps%indlmn(5,jlmn,itypat) 
   jlpm=1+jl+jm 
   if (jln/=jln0) indexj=indexj+2*jl0+1

   ! === For each band, calculate contribution due to rotated real spherical harmonics ===
   ! * we have to apply zarot(R^{-1}) so we use the transpose in the m,mp subspace
   ! <p_j^{R^{-1}(L_a-\tau)}|\tpsi_nk> = \sum_x D_{x,m_j}^l(R^-1) <p_{\nj\li x},\tpsi_nk> 

   do iband=1,nbnds
    tmp(:)=zero
    do mmp=1,2*jl+1
     ! pristine
     tmp(1)=tmp(1)+DRm1_mmpl(jlpm,mmp,jl+1)*Cprj_in(iat,iband)%cp(1,indexj+mmp)
     tmp(2)=tmp(2)+DRm1_mmpl(jlpm,mmp,jl+1)*Cprj_in(iat,iband)%cp(2,indexj+mmp)
     ! trial
     !tmp(1)=tmp(1)+DRm1_mmpl(mmp,jlpm,jl+1)*Cprj_in(iat,iband)%cp(1,indexj+mmp)
     !tmp(2)=tmp(2)+DRm1_mmpl(mmp,jlpm,jl+1)*Cprj_in(iat,iband)%cp(2,indexj+mmp)
    end do
    !
    ! * Save values.
    Cprj_out(iat,iband)%cp(1,jlmn)=tmp(1)
    Cprj_out(iat,iband)%cp(2,jlmn)=tmp(2)
   end do !iband
   jl0=jl ; jln0=jln

  end do !jlmn
 end do !iat

 deallocate(DRm1_mmpl)

end subroutine rotate_cprj
!!***
