!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_mkrho
!! NAME
!! wvl_mkrho
!!
!! FUNCTION
!! This method is just a wrapper around the BigDFT routine to compute the
!! density from the wavefunctions.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  mpi_enreg=informations about MPI parallelization
!!  occ(dtset%mband)=occupation numbers.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!
!! OUTPUT
!!  rhor(dtset%nfft)=electron density in r space
!!
!! SIDE EFFECTS
!!  proj <type(wvl_projector_type)>=projectors informations for wavelets.
!!   | proj(OUT)=computed projectors.
!!
!! PARENTS
!!      afterscfloop,gstate,mkrho,scfcv,wvl_vtorho
!!
!! CHILDREN
!!      create_glr,leave_new,sumrho,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_mkrho(dtset, mpi_enreg, occ, rhor, wfs)

 use defs_basis
  use defs_datatypes
  use defs_wvltypes
#if defined HAVE_BIGDFT
  use BigDFT_API, only : sumrho, create_Glr, locreg_descriptors
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars
 type(MPI_type),intent(in) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
 type(wvl_wf_type),intent(in) :: wfs
!arrays
 real(dp),intent(in) :: occ(dtset%mband)
 real(dp),intent(inout) :: rhor(dtset%nfft,dtset%nspden)

!Local variables-------------------------------
!scalars
 character(len=500) :: message
#if defined HAVE_BIGDFT
 type(locreg_descriptors) :: ld
#endif

! *************************************************************************

#if defined HAVE_BIGDFT
 
 call create_Glr(dtset%wvl%atoms%geocode, &
& dtset%wvl%n(1), dtset%wvl%n(2), dtset%wvl%n(3), &
& dtset%wvl%fGrid(1, 1), dtset%wvl%fGrid(1, 2), &
& dtset%wvl%fGrid(1, 3), dtset%wvl%fGrid(2, 1), &
& dtset%wvl%fGrid(2, 2), dtset%wvl%fGrid(2, 3), &
& dtset%wvl%ni(1), dtset%wvl%ni(2), dtset%wvl%ni(3), wfs%keys, wfs%bounds, ld)

 call sumrho(mpi_enreg%me, mpi_enreg%nproc, wfs%nstates, wfs%mbandp, ld, dtset%ixc, &
& dtset%wvl%h(1) / 2.d0, dtset%wvl%h(2) / 2.d0, dtset%wvl%h(3) / 2.d0, &
& occ, wfs%psi, rhor, dtset%wvl%ni(1) * dtset%wvl%ni(2) * &
& mpi_enreg%nscatterarr(mpi_enreg%me, 1), mpi_enreg%nscatterarr, &
& dtset%nsppol, dtset%nspinor, wfs%spinar, .false.)
#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_mkrho : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 call wrtout(6,message,'COLL')
 call leave_new('COLL')
#endif
end subroutine wvl_mkrho
!!***
