!{\src2tex{textfont=tt}}
!!****f* ABINIT/spin_current
!! NAME
!! spin_current
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (Mver)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  atindx(natom)=index table for atoms (see scfcv.f)
!!  atindx1(natom)=inverse of atindx
!!  cg(2,mpw*dtset%nspinor*mband*mkmem*nsppol)=wavefunctions
!!                  (may be read from disk instead of input)
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!  eigen(mband*nkpt*nsppol)=array for holding eigenvalues (hartree)
!!  gmet = reciprocal space metric
!!  gprimd = dimensionful reciprocal space vectors
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  kg(3,mpw*mkmem)=reduced (integer) coordinates of G vecs in basis sphere
!!  mpi_enreg=informations about MPI parallelization
!!  nattyp(dtset%ntypat)=number of atoms of each type
!!  nfftf = fft grid dimensions for fine grid
!!  ph1d = phase factors in 1 radial dimension
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!   | mpsang= 1+maximum angular momentum
!!  rhog(2,nfftf)=Fourier transform of total electron density (including compensation density in PAW)
!!  rhor(nfftf,nspden)=total electron density (including compensation density in PAW)
!!  rmet = real space metric tensor
!!  symrec(3,3,nsym)=symmetries in reciprocal space, reduced coordinates
!!  ucvol = unit cell volume
!!  wffnow=unit number for current wf disk file
!!  ylm(mpw*mkmem,mpsang*mpsang*useylm)= real spherical harmonics for each G and k point
!!  ylmgr(mpw*mkmem,3,mpsang*mpsang*useylm)= gradients of real spherical harmonics
!!
!! OUTPUT
!!   only output to file
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      afterscfloop
!!
!! CHILDREN
!!      gamma_function,spline,splint,xredxcart
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine spin_current(atindx,atindx1,cg,dtfil,dtset,eigen,gmet,gprimd,hdr,kg,mpi_enreg,&
  &   nattyp,nfftf,ph1d,psps,rhog,rhor,rmet,symrec,ucvol,wffnow,ylm,ylmgr)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_15common, except_this_one => spin_current
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nfftf
 real(dp),intent(in) :: ucvol
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(hdr_type),intent(inout) :: hdr
 type(pseudopotential_type),intent(in) :: psps
 type(wffile_type),intent(in) :: wffnow
!arrays
 integer,intent(in) :: atindx(dtset%natom),atindx1(dtset%natom)
 integer,intent(in) :: kg(3,dtset%mpw*dtset%mkmem),nattyp(dtset%ntypat)
 integer,intent(in) :: symrec(3,3,dtset%nsym)
 real(dp),intent(in) :: cg(2,dtset%mpw*dtset%nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
 real(dp),intent(in) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol),gmet(3,3)
 real(dp),intent(in) :: gprimd(3,3),rhog(2,nfftf),rhor(nfftf,dtset%nspden)
 real(dp),intent(in) :: rmet(3,3)
 real(dp),intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
 real(dp),intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
 real(dp),intent(inout) :: ph1d(2,3*(2*dtset%mgfft+1)*dtset%natom)

!Local variables-------------------------------
!scalars
 integer :: cplex,fft_option,i1,i1p
 integer :: i2,i2p,i3,i3p,ia,iatom,iband,icartdir,icg,ig,igp
 integer :: ikg,ikpt,iocc,iost,irealsp,irealsp_p,ispindir,ispinor,ispinorp
 integer :: npw,spcur_unit
 real(dp) :: arg,prefact_nk
 character(len=500) :: message
 character(len=fnlen) :: filnam
!arrays
 integer,allocatable :: gbound(:,:),kg_k(:,:)
 real(dp),allocatable :: density_matrix(:,:,:,:,:),dpsidr(:,:,:,:,:,:)
 real(dp),allocatable :: density(:,:,:,:)
 real(dp),allocatable :: dummy_denpot(:,:,:)
 real(dp),allocatable :: gpsi(:,:,:,:),kgcart(:,:)
 real(dp),allocatable :: ph3d(:,:,:),phkxred(:,:),position_op(:,:,:,:)
 real(dp),allocatable :: psi(:,:,:),psi_r(:,:,:,:,:)
 real(dp),allocatable :: spincurrent(:,:,:,:,:)
 real(dp),allocatable :: vso_realspace_nl(:,:,:,:,:)
 real(dp),allocatable :: vso_realspace(:,:,:,:,:)
 real(dp),allocatable :: dummy_fofgout(:,:)
 character :: spin_symbol(3)

! *************************************************************************
!source

 write (*,*) ' Entering subroutine spin_current '
 write (*,*) ' dtset%ngfft = ', dtset%ngfft
 write (*,*) ' hdr%istwfk = ', hdr%istwfk

!===================== init and checks ============================  
!check if nspinor is 2
 if (dtset%nspinor /= 2) then
  write(message, '(a,a,a,a,i6,a,i6,a,a)' ) ch10,&
&  ' spin_current : ERROR -',ch10,&
&  '  nspinor must be 2, but it is ',dtset%nspinor,ch10
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if

 if (dtset%nsppol /= 1) then
  write(message, '(a,a,a,a,i6,a)' ) ch10,&
&  ' spin_current : ERROR -',ch10,&
&  ' nsppol must be 1 but it is ',dtset%nsppol,ch10
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if

 if (dtset%mkmem /= dtset%nkpt) then
  write(message, '(a,a,a,a,i6,a,i6,a,a)' ) ch10,&
&  ' spin_current : ERROR -',ch10,&
&  ' mkmem =  ',dtset%mkmem,' must be equal to nkpt ',dtset%nkpt,&
&  ch10,' keep all kpt in memory'
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if

 if (dtset%usepaw /= 0) then
  write(message, '(a,a,a,a,i6,a,a,a)' ) ch10,&
&  ' spin_current : ERROR -',ch10,&
&  ' usepaw =  ',dtset%usepaw,' must be equal to 0 ',&
&  ch10,' Not functional for PAW case yet.'
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if

 cplex=2
 fft_option = 0 ! just do direct fft
 spin_symbol = (/'x','y','z'/)

 
 write (*,*) ' psps%mpsang,psps%mpssoang ', psps%mpsang,psps%mpssoang

!======================= main code ================================  
!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------
!first get normal contribution to current, as psi tau dpsidr + dpsidr tau psi
!where tau are 1/2 the pauli matrices
!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------

!init plane wave coeff counter
 icg = 0
!init plane wave counter
 ikg = 0
!init occupation/band counter
 iocc = 1
 
!rspace point, cartesian direction, spin pol=x,y,z
 allocate (spincurrent(dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),3,3)) 
 spincurrent = zero

 allocate(dummy_denpot(cplex*dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6)))
 allocate(dpsidr(2,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),dtset%nspinor,3))
 allocate(psi_r(2,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),dtset%nspinor))

 allocate(gbound(2*dtset%mgfft+8,2))

 allocate (density_matrix(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor,&
& dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor))
 density_matrix= zero
 allocate (density(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor,dtset%nspinor))
 density= zero

!loop over kpoints
 do ikpt=1,dtset%nkpt


! number of plane waves for this kpt
  npw = hdr%npwarr(ikpt)

! allocate arrays dep on number of pw
  allocate (kg_k(3,npw))
  allocate (gpsi(2,npw,dtset%nspinor,3)) ! cmplx,ng,nspinor,cartesian direction
  allocate (psi(2,npw,dtset%nspinor))
  allocate (kgcart(3,npw))

! get cartesian coordinates of k+G vectors around this kpoint
  do ig=1,npw
   kgcart(:,ig) = matmul(gprimd(:,:),dtset%kpt(:,ikpt)+kg(:,ikg+ig))
   kg_k (:,ig) = kg(:,ikg+ig)
  end do

! get gbound
  call sphereboundary(gbound,dtset%istwfk(ikpt),kg_k,dtset%mgfft,npw)

! loop over bands
  do iband=1,dtset%nband(ikpt)

!  prefactor for sum over bands and kpoints
   prefact_nk = hdr%occ(iocc) * dtset%wtk(ikpt)

!  initialize this wf
   gpsi=zero
   psi=zero
   psi(:,1:npw,1) = cg(:,icg+1:icg+npw)

!  multiply psi by G
   do ig=1,npw
    gpsi(:,ig,:,1) = kgcart(1,ig)*psi(:,ig,:) 
    gpsi(:,ig,:,2) = kgcart(2,ig)*psi(:,ig,:) 
    gpsi(:,ig,:,3) = kgcart(3,ig)*psi(:,ig,:) 
   end do

!  loop over spinorial components
   do ispinor=1,dtset%nspinor
!   FT Gpsi_x to real space
    call fourwf(cplex,dummy_denpot,gpsi(:,:,ispinor,1),dummy_fofgout,&
&    dpsidr(:,:,:,:,ispinor,1),gbound,gbound,&
&    hdr%istwfk(ikpt),kg_k,kg_k,dtset%mgfft,mpi_enreg,1,dtset%ngfft,npw,&
&    npw,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),&
&    fft_option,dtset%paral_kgb,0,one,one)

!   FT Gpsi_y to real space
    call fourwf(cplex,dummy_denpot,gpsi(:,:,ispinor,2),dummy_fofgout,&
&    dpsidr(:,:,:,:,ispinor,2),gbound,gbound,&
&    hdr%istwfk(ikpt),kg_k,kg_k,dtset%mgfft,mpi_enreg,1,dtset%ngfft,npw,&
&    npw,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),&
&    fft_option,dtset%paral_kgb,0,one,one)

!   FT Gpsi_z to real space
    call fourwf(cplex,dummy_denpot,gpsi(:,:,ispinor,3),dummy_fofgout,&
&    dpsidr(:,:,:,:,ispinor,3),gbound,gbound,&
&    hdr%istwfk(ikpt),kg_k,kg_k,dtset%mgfft,mpi_enreg,1,dtset%ngfft,npw,&
&    npw,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),&
&    fft_option,dtset%paral_kgb,0,one,one)

!   FT psi to real space
    call fourwf(cplex,dummy_denpot,psi(:,:,ispinor),dummy_fofgout,&
&    psi_r(:,:,:,:,ispinor),gbound,gbound,&
&    hdr%istwfk(ikpt),kg_k,kg_k,dtset%mgfft,mpi_enreg,1,dtset%ngfft,npw,&
&    npw,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),&
&    fft_option,dtset%paral_kgb,0,one,one)

   end do ! ispinor

!  get 3 pauli matrix contributions to the current: x,y,z, cart dir, spin dir
   do icartdir=1,3

!   x pauli spin matrix 
    spincurrent(:,:,:,icartdir,1) =  spincurrent(:,:,:,icartdir,1) + prefact_nk * &
!   Re(psi_r(up)^* dpsidr(down))
&    real(psi_r(1,:,:,:,1)*dpsidr(1,:,:,:,2,icartdir)  &
&    + psi_r(2,:,:,:,1)*dpsidr(2,:,:,:,2,icartdir)  &
!   Re(psi_r(down)^* dpsidr(up))
&    + psi_r(1,:,:,:,2)*dpsidr(1,:,:,:,1,icartdir)  &
&    + psi_r(2,:,:,:,2)*dpsidr(2,:,:,:,1,icartdir))
!   y pauli spin matrix
    spincurrent(:,:,:,icartdir,2) =  spincurrent(:,:,:,icartdir,2) + prefact_nk * &
!   Re(-i psi_r(up)^* dpsidr(down))
&    real(psi_r(1,:,:,:,1)*dpsidr(2,:,:,:,2,icartdir)  &
&    - psi_r(2,:,:,:,1)*dpsidr(1,:,:,:,2,icartdir)  &
!   Re(i psi_r(down)^* dpsidr(up))
&    - psi_r(1,:,:,:,2)*dpsidr(2,:,:,:,1,icartdir)  &
&    + psi_r(2,:,:,:,2)*dpsidr(1,:,:,:,1,icartdir))
!   z pauli spin matrix
    spincurrent(:,:,:,icartdir,3) =  spincurrent(:,:,:,icartdir,3) + prefact_nk * &
!   Re(psi_r(up)^* dpsidr(up))
&    real(psi_r(1,:,:,:,1)*dpsidr(1,:,:,:,1,icartdir)  &
&    - psi_r(2,:,:,:,1)*dpsidr(2,:,:,:,1,icartdir)  &
!   Re(-psi_r(down)^* dpsidr(down))
&    - psi_r(1,:,:,:,2)*dpsidr(1,:,:,:,2,icartdir)  &
&    + psi_r(2,:,:,:,2)*dpsidr(2,:,:,:,2,icartdir))
   end do ! end icartdir

!  
!  accumulate non local density matrix in real space
!  NOTE: if we are only using the local part of the current, this becomes the
!   density spinor matrix! (much lighter to calculate)
!  
   do ispinor=1,dtset%nspinor
    do i3=1,dtset%ngfft(3)
     do i2=1,dtset%ngfft(2)
      do i1=1,dtset%ngfft(1)
       irealsp = i1 + (i2-1)*dtset%ngfft(1) + (i3-1)*dtset%ngfft(2)*dtset%ngfft(1)

       do ispinorp=1,dtset%nspinor
         density(1,irealsp,ispinor,ispinorp) = &
&        density(1,irealsp,ispinor,ispinorp) + &
&             prefact_nk * (psi_r(1,i1,i2,i3,ispinor)*psi_r(1,i1,i2,i3,ispinorp)&
&                        +  psi_r(2,i1,i2,i3,ispinor)*psi_r(2,i1,i2,i3,ispinorp))
         density(2,irealsp,ispinor,ispinorp) = &
&        density(2,irealsp,ispinor,ispinorp) + &
&             prefact_nk * (psi_r(1,i1,i2,i3,ispinor)*psi_r(2,i1,i2,i3,ispinorp)&
&                        -  psi_r(2,i1,i2,i3,ispinor)*psi_r(1,i1,i2,i3,ispinorp))

!        do i3p=1,dtset%ngfft(3)
!         do i2p=1,dtset%ngfft(2)
!          do i1p=1,dtset%ngfft(1)
!           irealsp_p = i1p + (i2p-1)*dtset%ngfft(1) + (i3p-1)*dtset%ngfft(2)*dtset%ngfft(1)
!           
! NOTE : sign changes in second terms below because rho = psi*(r) psi(rprime)
!
!           density_matrix(1,irealsp,ispinor,irealsp_p,ispinorp) = &
!&           density_matrix(1,irealsp,ispinor,irealsp_p,ispinorp) + &
!&           prefact_nk * (psi_r(1,i1,i2,i3,ispinor)*psi_r(1,i1p,i2p,i3p,ispinorp)&
!&           +  psi_r(2,i1,i2,i3,ispinor)*psi_r(2,i1p,i2p,i3p,ispinorp))
!           density_matrix(2,irealsp,ispinor,irealsp_p,ispinorp) = &
!&           density_matrix(2,irealsp,ispinor,irealsp_p,ispinorp) + &
!&           prefact_nk * (psi_r(1,i1,i2,i3,ispinor)*psi_r(2,i1p,i2p,i3p,ispinorp)&
!&           -  psi_r(2,i1,i2,i3,ispinor)*psi_r(1,i1p,i2p,i3p,ispinorp))
!          end do
!         end do
!        end do ! end irealspprime

       end do !end ispinorp do
       
      end do
     end do
    end do ! end irealsp
   end do !end ispinor do

!  update pw counter
   icg=icg+npw
   iocc=iocc+1
  end do ! iband

  ikg=ikg+npw

! deallocate arrays dep on npw for this kpoint
  deallocate (kg_k)
  deallocate (gpsi,psi,kgcart,dummy_fofgout)

 end do ! ikpt

 deallocate (dpsidr,psi_r)

!prefactor for contribution to spin current
!prefactor is 1/2 * 1/2 * 2 Re(.):
!1/2 from the formula for the current
!1/2 from the use of the normalized Pauli matrices
!2 from the complex conjugate part 
!total = 1/2
 spincurrent = half * spincurrent

!make array of positions for all points on grid
 allocate (position_op(3,dtset%ngfft(1),dtset%ngfft(2),dtset%ngfft(3)))
 do i3=1,dtset%ngfft(3)
  do i2=1,dtset%ngfft(2)
   do i1=1,dtset%ngfft(1)
    position_op(:,i1,i2,i3) = matmul(hdr%rprimd,(/i1-one,i2-one,i3-one/))&
&    /(/dtset%ngfft(1),dtset%ngfft(2),dtset%ngfft(3)/)
   end do
  end do 
 end do

!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------
!add electric field term to current. Non local term in case of pseudopotential SO
!   present theory is that it is equal to A(r,r') = (W_SO(r,r') + W_SO(r',r))
!   For the strictly local part of the current, this becomes 2 W_SO(r,r)
!
!   W_SO is the prefactor in the spinorbit part of the potential, such that it
!   can be written V_SO = W_SO . p (momentum operator)
!   decomposed from V_SO = v_SO(r,r') L.S = v_SO(r,r') (rxp).S = v_SO(r,r') (Sxr).p
!   and ensuring symmetrization for the r operator wrt the two arguments of v_SO(r,r')
!   Hence:
!   W_SO(r,r) = v_SO(r,r) (Sxr)
!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------

! allocate (vso_realspace_nl(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor,&
!& dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor))

! call vso_realspace_nonlop(atindx,atindx1,dtfil,dtset,gmet,gprimd,hdr,kg,&
!       & mpi_enreg,nattyp,ph1d,position_op,psps,rmet,ucvol,vso_realspace_nl,ylm,ylmgr)
!anticommutator of VSO with position operator
!   --- not needed in local spin current case ---

 allocate (vso_realspace(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),&
&    dtset%nspinor,dtset%nspinor,3))

 call vso_realspace_local(density,dtfil,dtset,hdr,position_op,psps,vso_realspace)


!multiply by density (or density matrix for nonlocal case)

!add to spin current


!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------
!output 3 components of current for each real space point
!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------
 do ispindir=1,3
  filnam=trim(dtfil%filnam_ds(4))//"_SPCUR_"//spin_symbol(ispindir)
  spcur_unit=200
  open (file=filnam,unit=spcur_unit,status='unknown',iostat=iost)
  if (iost /= 0) then
   write (message,'(2a)')' spin_current: ERROR- opening file ',trim(filnam)
   call wrtout(06,message,'COLL')
   call leave_new('COLL')
  end if

! print header
  write (spcur_unit,'(a)') '#'
  write (spcur_unit,'(a)') '#  spin current density, for all real space points'
  write (spcur_unit,'(a,3(I5,1x))') '#  fft grid is ', dtset%ngfft(1), dtset%ngfft(2),   dtset%ngfft(3)
  write (spcur_unit,'(a,a,a)') '# ', spin_symbol(ispindir), '-spin current, as a vector'
  write (spcur_unit,'(a,a)') '#  cart x     *  cart y    *  cart z    ***',&
&  ' x component of j   *  y component of j  * z component of j   '
! 
! NOTE: have chosen actual dims of grid (n123) instead of fft box, for which n45
! may be different
! 
  do i3=1,dtset%ngfft(3)
   do i2=1,dtset%ngfft(2)
    do i1=1,dtset%ngfft(1)
     write (spcur_unit,'(3(E12.5,1x),3x,3(E20.10,1x))')&
&     position_op(:,i1,i2,i3), &
&     spincurrent(i1,i2,i3,1:3,ispindir)
    end do
   end do
  end do

  close (spcur_unit)

 end do ! end ispindir
 
 deallocate (dummy_denpot)
 deallocate (vso_realspace)
 !deallocate (vso_realspace_nl)
 deallocate (spincurrent)

 write (*,*) ' Exiting subroutine spin_current '

end subroutine spin_current


!!***

!{\src2tex{textfont=tt}}
!!****f* ABINIT/vso_realspace_nonlop
!! NAME
!!   vso_realspace_nonlop
!!
!! FUNCTION
!!
!!  Calculate real space (non local) values of the SO part of the
!!   pseudopotentials, from calls to nonlop, then Fourier transforming
!!   As of 10/2008 this routine is probably useless, as the nonlop
!!   call does not allow one to extract, e.g. L x pauli matrices, to
!!   get the factor in front of the momentum operator (ie. the effective A
!!   field)
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (Mver)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!      gamma_function,spline,splint,xredxcart
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine vso_realspace_nonlop(atindx,atindx1,dtfil,dtset,gmet,gprimd,hdr,kg,&
       & mpi_enreg,nattyp,ph1d,position_op,psps,rmet,ucvol,vso_realspace_nl,ylm,ylmgr)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_15nonlocal
!End of the abilint section

 implicit none

 ! args
   
   type(hdr_type),intent(inout) :: hdr
   type(dataset_type),intent(in) :: dtset
   type(pseudopotential_type),intent(in) :: psps
   type(MPI_type),intent(inout) :: mpi_enreg
   type(datafiles_type),intent(in) :: dtfil

   real(dp),intent(in) :: ucvol

   real(dp),intent(in) :: rmet(3,3)
   real(dp),intent(in) :: gprimd(3,3),gmet(3,3)
   real(dp),intent(in) :: position_op(3,dtset%ngfft(1),dtset%ngfft(2),dtset%ngfft(3))

   integer,intent(in) :: kg(3,dtset%mpw*dtset%mkmem),nattyp(dtset%ntypat)
   integer,intent(in) :: atindx(dtset%natom),atindx1(dtset%natom)

   real(dp),intent(inout) :: ph1d(2,3*(2*dtset%mgfft+1)*dtset%natom)

   real(dp),intent(out) :: vso_realspace_nl(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),&
       & dtset%nspinor,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor)

   real(dp),intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp),intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)

 !local
 ! variables for ph3d mkffnl and company
 ! dummy variables for nonlop
 ! real variables for nonlop
   integer :: choice,cplex,cpopt_dummy,dimenl1,dimenl2,dimffnl,fft_option
   integer :: idir_dummy,ider,ikg, ikpt, npw,ia,iatom,signs,only_SO,paw_opt_dummy
   integer :: matblk,ispinor,ispinorp,igp
   integer :: spcur_unit,iost
   integer :: i1,i2,i3,i1p,i2p,i3p,irealsp,irealsp_p
   integer,allocatable :: gbound(:,:),kg_k(:,:)

   real(dp) :: lambda_dummy,arg
   real(dp),allocatable :: dummy_denpot(:,:,:)
   real(dp),allocatable :: ph3d(:,:,:),phkxred(:,:),vso_realrecip(:,:,:,:,:)
   real(dp),allocatable :: vectin_ft(:,:),vectin(:,:),svectout_dummy(:,:)
   real(dp),allocatable :: vectout(:,:),vectout_ft(:,:,:,:),sij_dummy(:,:)
   real(dp),allocatable :: enlout_dummy(:),ffnl(:,:,:,:)
   real(dp),allocatable :: dummy_fofgout(:,:),kpg_dummy(:,:)

   character(len=fnlen) :: filnam
   character(len=500) :: message

   type(cprj_type),allocatable :: cprjin_dummy(:)

 !src

!variables for nonlop
 choice = 1 ! NL energy contribution, not derivatives
 signs = 2 ! get function of G instead of contracted KS matrix element
!only_SO 1 gets the full SO potential  (V_SO L.S) (G,s,G',s')
!only_SO 2 gets a partial SO potential (V_SO   S) (G,s,G',s') then FT wrt G,G'
 only_SO = 2

 cplex=2
 fft_option = 0 ! just do direct fft

 cpopt_dummy = -1
 idir_dummy = 0 ! should not be used
 lambda_dummy = zero
 paw_opt_dummy=0

!allocate stuff for nonlop that does not depend on npw/kpt
 allocate (cprjin_dummy(dtset%natom*((cpopt_dummy+3)/3)))
 allocate (sij_dummy(dimenl1,dtset%ntypat*((paw_opt_dummy+1)/3)))
 allocate (enlout_dummy(1))
 allocate (dummy_denpot(cplex*dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6)))
 allocate (gbound(2*dtset%mgfft+8,2))

!dimensions for ffnl and nonlop
 dimenl1 = psps%dimekb
 dimenl2 = dtset%ntypat
 dimffnl=1
 matblk=dtset%natom

!choose which kpt we will use to get V_SO (closest to Gamma probably best)
 ikg=0
 do ikpt=1,dtset%nkpt
  if ( sum(abs(dtset%kpt(:,ikpt))) < tol10) exit
  ikg=ikg+hdr%npwarr(ikpt)
 end do
 write (*,*) 'Found Gamma to be ikpt ', ikpt, dtset%kpt(:,ikpt)
 write (*,*) ' ikg = ', ikg

 npw = hdr%npwarr(ikpt)

 allocate (kg_k(3,npw))
 kg_k = kg(:,ikg+1:ikg+npw)


!rebuild phkxred
 allocate (phkxred(2,dtset%natom))
 do ia=1,dtset%natom
  iatom=atindx(ia)
  arg=two_pi*(dtset%kpt(1,ikpt)*hdr%xred(1,ia)&
&  +dtset%kpt(2,ikpt)*hdr%xred(2,ia)&
&  +dtset%kpt(3,ikpt)*hdr%xred(3,ia))
  phkxred(1,iatom)=cos(arg)
  phkxred(2,iatom)=sin(arg)
 end do

!rebuild ph3d
 allocate(ph3d(2,npw,matblk))
 call ph1d3d(1,dtset%natom,kg_k,dtset%kpt(:,ikpt),matblk,dtset%natom,npw,&
& dtset%ngfft(1),dtset%ngfft(2),dtset%ngfft(3),&
& phkxred,ph1d,ph3d)


!rebuild ffnl
 ider=0
 allocate(ffnl(npw,dimffnl,psps%lmnmax,dtset%ntypat))
 allocate (kpg_dummy(npw,0))
 call mkffnl(psps%dimekb,dimffnl,psps%ekb,ffnl,psps%ffspl,&
& gmet,gprimd,ider,idir_dummy,psps%indlmn,kg_k,&
& kpg_dummy,dtset%kpt(:,ikpt),psps%lmnmax,&
& psps%lnmax,psps%mpsang,psps%mqgrid_ff,0,&
& npw,dtset%ntypat,psps%pspso,psps%qgrid_ff,rmet,&
& psps%usepaw,psps%useylm,ylm,ylmgr)

!get gbound
 call sphereboundary(gbound,dtset%istwfk(ikpt),kg_k,dtset%mgfft,npw)

!allocations for nonlop
 allocate (vectin (2,dtset%nspinor*npw))
 allocate (vectout(2,dtset%nspinor*npw))

 allocate (svectout_dummy(2,dtset%nspinor*npw*(paw_opt_dummy/3)))
 allocate (vectin_ft(2,npw))
 allocate (vectout_ft(2,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6)))
 allocate (vso_realrecip(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),dtset%nspinor,&
& npw,dtset%nspinor))

!for each spinorial component   
  do ispinorp=1,dtset%nspinor
! for each planewave G',
   do igp=1,npw
!  make wavefunction with only that component
!  probably to be changed: loop over ks states and call nonlop with them
!  eventually premultiplying with r????
!  
!  Aaaaah maybe not: want full spatial
!  dependency and nonlop gives you a projected quantity summed over the G of the
!  KS state
!  
!  This is actually a barbaric way of extracting the so potential 1 GG' pair
!  at a time
    vectin = zero
    vectin(1,(ispinorp-1)*npw+igp) = one
   
!  and call nonlop -> get <G|V_SO|G'> for all G
!  added flag to not calculate scalar relativistic term, only SO
    call nonlop(atindx1,choice,cpopt_dummy,cprjin_dummy,dimenl1,dimenl2,dimffnl,dimffnl,&
&    psps%ekb,enlout_dummy,ffnl,ffnl,gmet,gprimd,idir_dummy,psps%indlmn,dtset%istwfk(ikpt),&
&    kg_k,kg_k,kpg_dummy,kpg_dummy,dtset%kpt(:,ikpt),dtset%kpt(:,ikpt),&
&    lambda_dummy,psps%lmnmax,matblk,dtset%mgfft,&
&    mpi_enreg,psps%mpsang,psps%mpssoang,dtset%natom,nattyp,dtset%ngfft,0,0,dtset%nloalg,&
&    1,npw,npw,dtset%nspinor,dtset%ntypat,only_SO,paw_opt_dummy,phkxred,&
&    phkxred,ph1d,ph3d,ph3d,psps%pspso,signs,sij_dummy,svectout_dummy,&
&    0,ucvol,psps%useylm,vectin,vectout)
   

!  FT wrt G, one spinorial component of vectout at a time
   do ispinor=1,dtset%nspinor
    vectin_ft = vectout(:,(ispinor-1)*npw+1:(ispinor)*npw)

    call fourwf(cplex,dummy_denpot,vectin_ft,dummy_fofgout,&
&    vectout_ft,gbound,gbound,&
&    hdr%istwfk(ikpt),kg_k,kg_k,dtset%mgfft,mpi_enreg,1,dtset%ngfft,npw,&
&    npw,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),&
&    fft_option,dtset%paral_kgb,0,one,one)

    vso_realrecip(:,:,ispinor,igp,ispinorp)=&
&    reshape(vectout_ft(:,1:dtset%ngfft(1),1:dtset%ngfft(2),1:dtset%ngfft(3)),&
&    (/2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3)/))
   end do  ! ispinor
  end do  ! igp

 end do ! ispinorp

 deallocate (kpg_dummy,svectout_dummy)

!FT wrt Gprim 
 do ispinor=1,dtset%nspinor
  do irealsp=1,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3)
   do ispinorp=1,dtset%nspinor
    vectin_ft = vso_realrecip(:,irealsp,ispinor,1:npw,ispinorp)

    call fourwf(cplex,dummy_denpot,vectin_ft,dummy_fofgout,&
&    vectout_ft,gbound,gbound,&
&    hdr%istwfk(ikpt),kg_k,kg_k,dtset%mgfft,mpi_enreg,1,dtset%ngfft,npw,&
&    npw,dtset%ngfft(4),dtset%ngfft(5),dtset%ngfft(6),&
&    fft_option,dtset%paral_kgb,0,one,one)

    vso_realspace_nl(:,irealsp,ispinor,:,ispinorp) = &
&    reshape(vectout_ft(:,1:dtset%ngfft(1),1:dtset%ngfft(2),1:dtset%ngfft(3)),&
&    (/2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3)/))
   end do 
  end do
 end do
 deallocate (vso_realrecip,vectout_ft)

!DEBUG check symmetric quality of vso_realspace_nl
!do ispinor=1,dtset%nspinor
!do irealsp=1,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3)
!do ispinorp=1,dtset%nspinor
!do irealsp_p=1,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3)
!write (1666,'(2E16.10)') vso_realspace_nl(:,irealsp,ispinor,irealsp_p,ispinorp) &
!&                      - vso_realspace_nl(:,irealsp_p,ispinorp,irealsp,ispinor)
!end do 
!end do
!end do 
!end do
!ENDDEBUG

 deallocate (kg_k,vectin, vectout) ! these do depend on npw
 deallocate (ffnl,phkxred,ph3d)  ! these do depend on npw

 deallocate (cprjin_dummy,sij_dummy,enlout_dummy) ! nonlop dummies indep of npw
 deallocate (dummy_denpot,gbound) ! dummies for fourwf indep of npw

!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------
!output SO potential (non local) for each pair of real space points
!-----------------------------------------------------------------------------------------
!-----------------------------------------------------------------------------------------
 filnam=trim(dtfil%filnam_ds(4))//"_VSO_rrp"
 spcur_unit=200
 open (file=filnam,unit=spcur_unit,status='unknown',iostat=iost)
 if (iost /= 0) then
  write (message,'(2a)')' spin_current: ERROR- opening file ',trim(filnam)
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

!print header
 write (spcur_unit,'(a)') &
& '#  SO operator (nonlocal) as a function of real space point rprime, for fixed r'
 write (spcur_unit,'(a,3(I5,1x))') &
& '#  fft grid is ', dtset%ngfft(1), dtset%ngfft(2),   dtset%ngfft(3)
 write (spcur_unit,'(a)') &
& '#  cart xprime * cart yprime * cart zprime ***   V_SO '
!
!NOTE: have chosen actual dims of grid (n123) instead of fft box, for which n45
!may be different - forced to be odd for FT
!
 i1=1
 i2=1
 i3=1
 write (spcur_unit,'(a,3(E12.5,1x))') &
& '# position of first r point for V_SO(r,rprime): ', &
& position_op(:,i1,i2,i3)
!look at a given spinorial component of V_SO matrix:
 ispinor=1
 ispinorp=2

!do i3=1,dtset%ngfft(3)
!do i2=1,dtset%ngfft(2)
!do i1=1,dtset%ngfft(1)

 irealsp = i1 + (i2-1)*dtset%ngfft(1) + (i3-1)*dtset%ngfft(2)*dtset%ngfft(1)
 do i3p=1,dtset%ngfft(3)
  do i2p=1,dtset%ngfft(2)
   do i1p=1,dtset%ngfft(1)
    irealsp_p = i1p + (i2p-1)*dtset%ngfft(1) + (i3p-1)*dtset%ngfft(2)*dtset%ngfft(1)
!   write (spcur_unit,'(3(E12.5,1x),3x,3(E12.5,1x),3x,2(E20.10,1x))')&
    write (spcur_unit,'(3(E12.5,1x),3x,2(E20.10,1x))')&
&    position_op(:,i1p,i2p,i3p), &
&    vso_realspace_nl(:,irealsp,ispinor,irealsp_p,ispinorp)
   end do
  end do
 end do

!end do
!end do
!end do

 close (spcur_unit)

end subroutine vso_realspace_nonlop
!!***

!{\src2tex{textfont=tt}}
!!****f* ABINIT/vso_realspace_local
!! NAME
!!   vso_realspace_local
!!
!! FUNCTION
!!
!!  Calculate real space (local - (r,r)) values of the SO part of the
!!   pseudopotential. Reconstructed explicitly in the HGH/GTH case.
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (Mver)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      spin_current
!!
!! CHILDREN
!!      gamma_function,spline,splint,xredxcart
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine vso_realspace_local(density,dtfil,dtset,hdr,position_op,psps,vso_realspace)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_12geometry
 use interfaces_lib03numeric
!End of the abilint section

 implicit none

 ! args
   
  type(hdr_type),intent(inout) :: hdr
  type(dataset_type),intent(in) :: dtset
  type(pseudopotential_type),intent(in) :: psps
  type(datafiles_type),intent(in) :: dtfil

  real(dp),intent(in) :: position_op(3,dtset%ngfft(1),dtset%ngfft(2),dtset%ngfft(3))
  real(dp),intent(in) :: density(2,dtset%ngfft(1),dtset%ngfft(2),dtset%ngfft(3),&
      & dtset%nspinor,dtset%nspinor)

  real(dp),intent(out) :: vso_realspace(2,dtset%ngfft(1)*dtset%ngfft(2)*dtset%ngfft(3),&
      & dtset%nspinor,dtset%nspinor,3)

  ! local
  integer :: i,j,l, lmax,ipsp,iatom, ir1,ir2,ir3, ispinor, ispinorp
  integer :: rcexponent,irealsp
  integer :: nradgrid,iradgrid

  real(dp) :: gammai, gammaj, relative_position(3), radial_cutoff, norm_rel_pos
  real(dp) :: expfact,lfact, vso_interpol, x,y,z
  real(dp) :: xcart(3,dtset%natom),splint_x(1),splint_y(1)

  real(dp), allocatable :: radial_grid(:)
  real(dp), allocatable :: prefact_ijl(:,:,:,:),tmpvso(:),tmpvso_pp(:)
  real(dp), allocatable :: vso_radial(:,:),vso_radial_pp(:,:),tmp_spline(:)
  real(dp), allocatable :: offdiag_l_fact(:,:,:),kpar_matrix(:,:)

   ! src

   ! recalculate xcart (option = 1)
   call xredxcart(dtset%natom,1,hdr%rprimd,xcart,hdr%xred)


   lmax = psps%mpsang-1

! content of gth pseudo type:
! These are {rloc, C(1...4)} coefficients for psppar(0, :, :) indices,
! Followed by the h coefficients for psppar(1:2, 1:, :) indices.
!  size (0:2, 0:4, npsp)
! potential radius r_l is in psppar(l+1,0,ipsp)
!real(dp), pointer :: psppar(:, :, :)
! The covalence radii for each pseudo (?) size (npsp)
!real(dp), pointer :: radii_cov(:)
! Cut-off radii for core part and long-range part.
! radii_cf(:, 1) is for the long-range cut-off and
! radii_cf(:, 2) is for the core cut-off.
!  size (npsp, 2)
!real(dp), pointer :: radii_cf(:, :)
! Spin orbit coefficients in HGH/GTH formats: k11p
! etc... see psp3ini.F90
!   dimension = num l channels, 3 coeffs, num psp =
!   (1:lmax+1,1:3,npsp)
!real(dp), pointer :: psp_k_par(:, :, :)

! v_SO^l (r,r') = sum_i sum_j sum_m Y_{lm} (\hat{r}) p_i^l (r) k_{ij}^l p_j^l(r') Y^{*}_lm (\hat{r'})
! 
! v_SO^l (r,r)  = sum_ij  p_i^l (r) k_{ij}^l p_j^l(r) sum_m Y_{lm} (\hat{r}) Y^{*}_lm (\hat{r})
!               = (2l+1)/4\pi sum_ij  p_i^l (r) k_{ij}^l p_j^l(r) (eq B.17 Patrick Rinke thesis)
!  p are gaussian projectors (from HGH paper prb 58 3641)
! sum_l v_SO^l (r,r) is a purely radial quantity (function of |r|), so spline it

! maximum distance needed in unit cell
  radial_cutoff = four * maxval(psps%gth_params%psppar(:, 0, :))

! setup radial grid; Should we use a logarithmic grid? The spline functions can
! take it...
  nradgrid = 201 ! this is heuristic
  allocate (radial_grid(nradgrid))
  do iradgrid=1,nradgrid
    radial_grid(iradgrid) = (iradgrid-1)*radial_cutoff/(nradgrid-1)
  end do

! calculate prefactors independent of r
  allocate (prefact_ijl(3,3,0:lmax,psps%npsp),offdiag_l_fact(3,3,0:lmax),kpar_matrix(3,3))

  ! these factors complete the full 3x3 matrix of k (or h) parameters for the
  !  HGH pseudos
  offdiag_l_fact = zero
  ! l=0
  offdiag_l_fact(1,2,0) = -half*sqrt(three/five)
  offdiag_l_fact(1,3,0) = half*sqrt(five/21._dp)
  offdiag_l_fact(2,3,0) = -half*sqrt(100._dp/63._dp)
  ! l=1
  offdiag_l_fact(1,2,1) = -half*sqrt(five/seven)
  offdiag_l_fact(1,3,1) = sixth*sqrt(35._dp/11._dp)
  offdiag_l_fact(2,3,1) = -sixth*14._dp/sqrt(11._dp)
  ! l=2
  offdiag_l_fact(1,2,2) = -half*sqrt(seven/nine)
  offdiag_l_fact(1,3,2) = half*sqrt(63._dp/143._dp)
  offdiag_l_fact(2,3,2) = -half*18._dp /sqrt(143._dp)
  ! l=3
  offdiag_l_fact(1,2,3) = zero
  offdiag_l_fact(1,3,3) = zero
  offdiag_l_fact(2,3,3) = zero

  ! get prefactors for evaluation of V_SO: terms that do not depend on r
  prefact_ijl = zero
  do l=0,lmax
    !  first the diagonal i=j term
    do i=1,3
      call gamma_function(l+(4._dp*i-1._dp)*0.5_dp, gammai)
      gammai = sqrt(gammai)
      rcexponent = 2*l+2*i+2*i-1
      do ipsp=1,psps%npsp
         prefact_ijl(i,i,l,ipsp) = psps%gth_params%psp_k_par(l+1,i,ipsp) &
        &    / ( (psps%gth_params%psppar(l+1,0,ipsp))**(rcexponent) &
        &    * gammai * gammai)
      end do
    end do
    ! now the off diagonal elements
    kpar_matrix(1,2) = offdiag_l_fact (1,2,l)* psps%gth_params%psp_k_par(l+1,2,ipsp)
    kpar_matrix(2,1) = kpar_matrix(1,2)
    kpar_matrix(1,3) = offdiag_l_fact (1,3,l)* psps%gth_params%psp_k_par(l+1,3,ipsp)
    kpar_matrix(3,1) = kpar_matrix(1,3)
    kpar_matrix(2,3) = offdiag_l_fact (2,3,l)* psps%gth_params%psp_k_par(l+1,3,ipsp)
    kpar_matrix(3,2) = kpar_matrix(2,3)

    ! for the f case only the 1,1 matrix element is non 0 - it is done above and
    !  all these terms are actually 0
    if (l > 2) cycle

    do i=1,3
      call gamma_function(l+(4._dp*i-1._dp)*0.5_dp, gammai)
      gammai = sqrt(gammai)
      do j=1,3
        if (j==i) cycle
        rcexponent = 2*l+2*i+2*j-1
        call gamma_function(l+(4._dp*j-1._dp)*0.5_dp,gammaj)
        gammaj = sqrt(gammaj)
        do ipsp=1,psps%npsp
           prefact_ijl(i,j,l,ipsp) = kpar_matrix(i,j) &
      &    / ( (psps%gth_params%psppar(l+1,0,ipsp))**rcexponent &
      &    * gammai * gammaj )
        end do
      end do
    end do
  end do

  deallocate (kpar_matrix,offdiag_l_fact)

  prefact_ijl = prefact_ijl * two

! calculate v_SO on radial grid
  allocate (vso_radial(nradgrid,psps%npsp))
  vso_radial = zero
  do l=0,lmax
    lfact=(2._dp*l+1._dp)/four/pi
    do iradgrid=1,nradgrid
      norm_rel_pos = radial_grid(iradgrid)
      do ipsp=1,psps%npsp
        expfact = exp(-norm_rel_pos**2 / &
    &      (psps%gth_params%psppar(l+1,0,ipsp))**2)

        do i=1,3
        do j=1,3
          rcexponent = 2*l +2*i+2*j-4
          vso_radial(iradgrid,ipsp) = vso_radial(iradgrid,ipsp) + &
  &            prefact_ijl(i,j,l,ipsp)*(norm_rel_pos**rcexponent) * &
  &            expfact
        end do ! j
        end do ! i
      end do ! ipsp
    end do ! iradgrid
  end do ! lmax

! spline v_SO(radial coord): get second derivative coefficients 
  allocate (vso_radial_pp(nradgrid,psps%npsp),tmp_spline(nradgrid),tmpvso(nradgrid),tmpvso_pp(nradgrid))
  do ipsp=1,psps%npsp
    tmpvso = vso_radial(:,ipsp)
    call spline( radial_grid, tmpvso, nradgrid, zero, radial_grid(nradgrid), tmpvso_pp, tmp_spline )
    vso_radial_pp(:,ipsp) = tmpvso_pp
  end do
  deallocate (tmp_spline,tmpvso,tmpvso_pp)

!  to optimize this I should precalculate the distances which are actually needed by
!  symmetry, or only sum over irreducible points in space and use weights

! for each physical atom present in unit cell
  vso_realspace = zero
  do iatom=1,dtset%natom
    !atom type will be dtset%typat(iatom)
  
! for each point on grid
   do ir3=1,dtset%ngfft(3)
    do ir2=1,dtset%ngfft(2)
     do ir1=1,dtset%ngfft(1)
       irealsp = ir1 + (ir2-1)*dtset%ngfft(1) + (ir3-1)*dtset%ngfft(2)*dtset%ngfft(1)

! relative position from atom to point
       relative_position = position_op(:,ir1,ir2,ir3) - xcart(:,iatom)
       x=relative_position(1)
       y=relative_position(2)
       z=relative_position(3)

! calculate norm^2
       norm_rel_pos = relative_position(1)**2+relative_position(2)**2+relative_position(3)**2

! if norm^2 is too large, skip this point
       if (norm_rel_pos > radial_cutoff*radial_cutoff) cycle

! calculate norm
       splint_x(1) = sqrt(norm_rel_pos)

! spline interpolate vso only depends on position (through pos - atomic position)
       call splint (nradgrid,radial_grid,vso_radial(:,dtset%typat(iatom)),&
          & vso_radial_pp(:,dtset%typat(iatom)),1,splint_x,splint_y)
       vso_interpol=splint_y(1)

! multiply by vectorial spin factor (S x r)
! NOTE: this r is taken relative to atom center. It could be that the r operator should
! applied in an absolute way wrt the origin...
       vso_realspace(1,irealsp,:,:,1)=reshape((/y,   zero,zero,-y/),(/2,2/))
       vso_realspace(2,irealsp,:,:,1)=reshape((/zero,z,  -z,    zero/),(/2,2/))

       vso_realspace(1,irealsp,:,:,2)=reshape((/-x,  z,   z,   x/),(/2,2/))
       vso_realspace(2,irealsp,:,:,2)=reshape((/zero,zero,zero,zero/),(/2,2/))

       vso_realspace(1,irealsp,:,:,3)=reshape((/zero,-y, -y,   zero/),(/2,2/))
       vso_realspace(2,irealsp,:,:,3)=reshape((/zero,-x, -x,    zero/),(/2,2/))

       vso_realspace(:,irealsp,:,:,:) = vso_realspace(:,irealsp,:,:,:)*vso_interpol

     end do
    end do
   end do
  end do ! iatom

  deallocate (prefact_ijl,vso_radial,vso_radial_pp)

end subroutine vso_realspace_local
!!***
