!{\src2tex{textfont=tt}}
!!****f* ABINIT/testlda
!! NAME
!! testlda
!!
!! FUNCTION
!! Test QPLDA or ABINIT LDA or KSS type file
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (GMR, VO, LR, RWG, MG, RShaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  accesswff=define the access mode (FORTRAN or NETCDF with ETSF-IO)
!!  localrdwf=1 if each machine can access the file, 0 if only master
!!  Dtset<type(dataset_type)>=all input variables for this dataset, variables used :
!!    %nsppol=only for checking purpose 
!!  filkss=Name of the KSS file. "-etsf.nc" will be appended in case of ETSF-IO 
!!  (TODO: remove this kind of a hack, using a module to store units and filenames
!!  MPI_enreg<type(MPI_type)>=datatype gathering information about the MPI parallelisation
!!
!! OUTPUT
!!  mpsang=1+maximum angular momentum for nonlocal pseudopotential
!!  nbnds_kss=number of bands contained in the KSS file
!!  ng_kss=number of plane waves in KSS file
!!  nsym_out=number of symmetries
!!  Hdr<hdr_type>=The abinit header.
!!
!! SIDE EFFECTS
!!  gvec_p(3,ng_kss)=
!!   In input : pointer to integers, supposed to be not associated.
!!   In output: the G vectors reported in the KSS file.
!!  energies(nbnds_kss,Hdr%nkpt,Hdr%nsppol)=
!!   In input : pointer to real, supposed to be not associated.
!!   In output: the energies of the wavefunctions 
!!
!! NOTES
!!  Starting version 5.6, KSS files in single precision are not supported anymore.
!!
!! TODO
!!  Pass spaceComm instead of MPI_enreg.
!!
!! PARENTS
!!      rdm,setup_screening,setup_sigma
!!
!! CHILDREN
!!      assert,etsf_io_basisdata_get,etsf_io_dims_get,etsf_io_electrons_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      flush_unit,hdr_comm,hdr_io,hdr_io_etsf,leave_new,leave_test,wrtout
!!      xcast_mpi,xcomm_init,xmaster_init,xme_init
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine testlda(Dtset,filkss,accesswff,localrdwf,nsym_out,nbnds_kss,ng_kss,mpsang,gvec_p,energies_p,Hdr,MPI_enreg) 

 use defs_basis
 use defs_datatypes
 use m_io_tools, only : flush_unit, get_unit
 use m_errors, only : assert
#if defined HAVE_NETCDF
 use netcdf
#endif
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_13io_mpi
 use interfaces_13ionetcdf
 use interfaces_lib01hidempi
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: accesswff,localrdwf
 integer,intent(out) :: mpsang,nbnds_kss,ng_kss,nsym_out
 character(len=fnlen),intent(in) :: filkss
 type(Dataset_type),intent(in) :: Dtset
 type(MPI_type),intent(in) :: MPI_enreg
 type(Hdr_type),intent(out) :: Hdr
!arrays
 integer,pointer :: gvec_p(:,:)
 real(dp),pointer :: energies_p(:,:,:)

!Local variables-------------------------------
#if defined HAVE_ETSF_IO
 integer,allocatable,target :: kg_k(:,:)
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_electrons),target :: Electrons_folder
 type(ETSF_dims) :: Dims
 type(ETSF_basisdata),target :: Wave_folder
 logical :: lstat
 character(len=etsf_io_low_error_len) :: errmess
 real(dp),allocatable,target :: eigen(:),occ_vec(:)
#endif
!scalars
 integer :: fform,iatom,iband,ierr,ig,ii,ikpt,il,ios,ispinor,isppol,itypat,master
 integer :: nshells,nsym_kss,rank,rdwr,spaceComm,untkss
 logical :: ltest
 character(len=500) :: msg
 character(len=fnlen) :: fname
!arrays
 real(dp),allocatable :: tmp_enek(:)
 character(len=80) :: title(2)

! *************************************************************************

#if defined DEBUG_MODE
 write(msg,'(a)')' testlda : enter'
 call wrtout(std_out,msg,'COLL')
 call flush_unit(std_out)
#endif

#if !defined HAVE_ETSF_IO
 if (accesswff==3) then 
  write(msg,'(6a)')ch10,&
&  ' testlda: BUG - ',ch10,&
&  '  when accesswff==3, support for the ETSF I/O library ',ch10,&
&  '  must be compiled. Use --enable-etsf-io when configuring '
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if
#endif
!
!=== Get MPI info ===
 call xcomm_init   (MPI_enreg,spaceComm)
 call xme_init     (MPI_enreg,rank     )
 call xmaster_init (MPI_enreg,master   )

 if (rank==master.or.localrdwf==1) then

! === Read the header of the GS wavefunction file ===
! TODO: remove this kind of a hack, using a module to store units and filenames.
  if (accesswff==0) fname=filkss 
  if (accesswff==3) fname=TRIM(filkss)//'-etsf.nc'
  untkss=get_unit()
  rdwr=1

  select case (accesswff)

   case (0)
!   * Fortran unformatted file.
    write(msg,'(3a)')ch10,&
&    ' testlda : testing Fortran KSS structure file ',TRIM(fname)
    call wrtout(std_out,msg,'COLL')
    open(untkss,file=fname,status='old',form='unformatted',iostat=ios)
    if (ios/=0) then
     write(msg,'(6a)')ch10,&
&     ' testlda : ERROR- ',ch10,&
&     '  opening file: ',TRIM(fname),' as old-unformatted '
     call wrtout(std_out,msg,'COLL')
     call leave_new('COLL')
    end if
    call hdr_io(fform,Hdr,rdwr,untkss)

#if defined HAVE_ETSF_IO
   case (3)
!   * NETCDF-ETSF file format.
    write(msg,'(3a)')ch10,&
&    ' testlda : testing NETCDF-ETSF KSS file ',TRIM(fname)
    call wrtout(std_out,msg,'COLL')
    call etsf_io_low_open_read(untkss,fname,lstat,Error_data=Error_data)
    if (.not.lstat) then
     call etsf_io_low_error_to_str(errmess,Error_data)
     write(msg,'(4a)')ch10,' testlda: ERROR -',ch10,errmess(1:min(475,len(errmess)))
     call wrtout(std_out, msg, 'COLL')
     call leave_new('COLL')
    end if
    call hdr_io_etsf(fform,Hdr,rdwr,untkss)
#endif

    case default
    write(msg,'(4a,i4)')ch10,&
&    ' testlda : BUG - ',ch10,&
&    ' wrong value for accesswff = ',accesswff 
    call wrtout(std_out, msg, 'COLL')
    call leave_new('COLL')

  end select

  if (fform==602) then
   write(msg,'(6a)')ch10,&
&   ' testlda : ERROR - ',ch10,&
&   ' starting v5.6, KSS files in single precision are not supported anymore,',ch10,&
&   ' Please, use an older version of abinit.'
   call wrtout(std_out,msg,'COLL')
   call leave_new('COLL')
  end if

  if (fform>=1.and.fform<=2) then
!  STA or the QPLDA form are *OBSOLETE*
   write(msg,'(4a,i4)')ch10,&
&   ' testlda : ERROR ',ch10,&
&   '  (STA|QPLDA) format not supported anymore. fform = ',fform
   call wrtout(std_out,msg,'COLL')
   call leave_new('COLL')
  end if

  if (fform/=502) then
   write(msg,'(4a,i4)')ch10,&
&   ' testlda : ERROR ',ch10,&
&   '  Found unknown file format, fform = ',fform
   call wrtout(std_out,msg,'COLL')
   call leave_new('COLL')
  end if

! === Header successfully read ===
! * Now read basic dimensions.
! * Note that, in case of Fortran file, nsym_out is read from the second record
  nsym_out=Hdr%nsym

  write(msg,'(1x,47a)')('-',ii=1,47)
  call wrtout(std_out,msg,'COLL')
  write(msg,'(3a,a6,a,i3)')&
&  ' KSS abinit double precision form',ch10,&
&  ' generated by ABINIT ',Hdr%codvsn,' header version ',Hdr%headform
  call wrtout(std_out,msg,'COLL')

  if ( Hdr%headform/=23 .and. Hdr%headform/=34 .and. &
&  Hdr%headform/=40 .and. Hdr%headform/=41 .and. &
&  Hdr%headform/=42 .and. Hdr%headform/=44 .and. &
&  Hdr%headform/=53 .and. Hdr%headform/=56 .and. &
&  Hdr%headform/=57 ) then 
   write(msg,'(4a,i4)')ch10,&
&   ' testlda : ERROR - ',ch10,&
&   '  unknown header version = ',Hdr%headform
   call wrtout(std_out,msg,'COLL')
   call leave_new('COLL')
  end if

  if (accesswff==0) then 
   read(untkss) title(1)
   read(untkss) title(2)
   write(msg,'(2a,1x,a79,a,1x,a79,a)')' title of file: ',ch10,title(1)(:79),ch10,title(2)(:79),ch10
   call wrtout(std_out,msg,'COLL')
   read(untkss)nsym_kss,nbnds_kss,ng_kss,nshells,mpsang
   read(untkss) !(((symrel2(jj,ii,isym),ii=1,3),jj=1,3),isym=1,nsym_kss)
   read(untkss) !((tnons(i,isym),i=1,3),isym=1,nsym_kss)

   allocate(gvec_p(3,ng_kss))
   read(untkss)((gvec_p(ii,ig),ii=1,3),ig=1,ng_kss)
   nsym_out=nsym_kss

#if defined HAVE_ETSF_IO
  else if (accesswff==3) then 
!  TODO spin-orbit not treated, number of projectors not treated
   call etsf_io_dims_get(untkss,Dims,lstat,Error_data)
   nsym_kss =Dims%number_of_symmetry_operations
   nbnds_kss=Dims%max_number_of_states
   ng_kss   =Dims%max_number_of_coefficients
   mpsang   =Dims%max_number_of_angular_momenta

   allocate(gvec_p(3,ng_kss),kg_k(3,ng_kss))
   Wave_folder%reduced_coordinates_of_plane_waves%data2D => kg_k(:,:)
   call etsf_io_basisdata_get(untkss,Wave_folder,lstat,Error_data)
   gvec_p(:,:)=kg_k(:,:) 
   deallocate(kg_k)
   nshells=0 ! nshells is not defined in the ETSF spefications but it is not used 
#endif
  end if

  ltest=ALL(gvec_p(:,1)==0)
  call assert(ltest,'First G-vector should be Gamma',__FILE__,__LINE__)
! 
! === Output important dimensions on the log file ===
  write(msg,'(a,i8)')' number of atomic species       ',Hdr%ntypat
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of atoms                ',Hdr%natom
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' Highest angular component +1   ',mpsang
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of symmetry operations  ',nsym_out
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of plane waves          ',ng_kss
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of irred k-points       ',Hdr%nkpt
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of bands                ',nbnds_kss
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of spinorial components ',Hdr%nspinor
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of spin polarisations   ',Hdr%nsppol
  call wrtout(std_out,msg,'COLL')
  write(msg,'(a,i8)')' number of density components   ',Hdr%nspden
  call wrtout(std_out,msg,'COLL')
  write(msg,'(1x,47a)')('-',ii=1,47)
  call wrtout(std_out,msg,'COLL')
! 
! === Check the value of some variables ===
! This is due to the awful treatment of symmetries done in outkss
  if (Hdr%nsym/=nsym_kss) then
   write(msg,'(4a,2i3)')ch10,&
&   ' testlda : WARNING - ',ch10,&
&   '  code does not use the original set of symmetries : Hdr%nsym/=nsym_kss ',Hdr%nsym,nsym_kss
   call wrtout(std_out,msg,'COLL')
  end if

! In case of parallelism over bands or Adler-Wiser with timereversal find the band
! index separating the occupied and partially occupied from the empty states (for each spin)
! Each processor will store in memory the occupied states while the conduction
! states will be shared between different processors

  write(msg,'(2a)')ch10,' testlda: reading occupation numbers ...'
  call wrtout(std_out,msg,'COLL')
! NOTE : In old version of the code, the number of bands defined in the header was different
! from the value reported in in the first section of a KSS file generated using kssform 3 (if nbandkss<nband). 
! NOW the BUG has been fixed but we keep these tests. 
  call assert(ALL(Hdr%nband(:)==Hdr%nband(1)),'nband must be constant')
  call assert(ALL(Hdr%nband(:)==nbnds_kss),   'nband must be equal to nbnds_kss')
  allocate(energies_p(nbnds_kss,Hdr%nkpt,Hdr%nsppol))
  energies_p(:,:,:)=zero
  allocate(tmp_enek(1:nbnds_kss))

  if (accesswff==0) then 
!  Read eigenvalues from the KSS file in the FORTRAN format
!  read(untkss)   !title(1) 
!  read(untkss)   !title(2)
!  read(untkss)   !nsym_kss,nbandkss,npwkss,nshells,mpsang
!  read(untkss)   !(((symrel2(jj,ii,isym),ii=1,3),jj=1,3),isym=1,nsym_kss)
!  read(untkss)   !((tnons(i,isym),i=1,3),isym=1,nsym_kss)
!  read(untkss)   !((gvec(i,ig),i=1,3),ig=1,ngx)
   read(untkss)    !(shlim(i),i=1,nshells)
   if (Hdr%usepaw==0) read(untkss)   !((vkbsignd(il,is),il=1,mpsang),is=1,Hdr%ntypat)

   do isppol=1,Hdr%nsppol
    do ikpt=1,Hdr%nkpt

     if (Hdr%usepaw==0) then
      do itypat=1,Hdr%ntypat
       do il=1,mpsang
        read(untkss) !vkbdb(:,itypat,il)
        read(untkss) !vkbdd(:,itypat,il)
       end do
      end do
     end if

     read(untkss) tmp_enek(1:nbnds_kss)
     energies_p(1:nbnds_kss,ikpt,isppol)=tmp_enek(1:nbnds_kss)

     do iband=1,nbnds_kss
      read(untkss) !wfgd(npwkss*nspinor)
      if (Hdr%usepaw==1) then
       do ispinor=1,Hdr%nspinor
        do iatom=1,Hdr%natom
         read(untkss) !(cprjnk_k(ia,ibsp)%cp(:,1:cprjnk_k(ia,ibsp)%nlmn))
        end do
       end do
      end if
     end do

    end do !ikpt
   end do !isppol

#if defined HAVE_ETSF_IO
  else if (accesswff==3) then 
   allocate(eigen(nbnds_kss))
   eigen(:)=zero
!  allocate(occ_vec(nbnds_kss))
   do isppol=1,Hdr%nsppol
    do ikpt=1,Hdr%nkpt
     Electrons_folder%eigenvalues%data1D         => eigen
     Electrons_folder%eigenvalues__kpoint_access =  ikpt
     Electrons_folder%eigenvalues__spin_access   =  isppol
!    NOTE : occupation numbers have been read from Hdr, and are recalculated in fermi.
!    Electrons_folder%occupations%data1D         => occ_vec
!    Electrons_folder%occupations__kpoint_access = ikpt
!    Electrons_folder%occupations__spin_access   = isppol
     call etsf_io_electrons_get(untkss,Electrons_folder,lstat,Error_data)
     if (.not.lstat) then
      call etsf_io_low_error_to_str(errmess,Error_data)
      write(msg,'(4a)')ch10,' testlda: ERROR -',ch10,errmess(1:min(475, len(errmess)))
      call wrtout(std_out,msg,'COLL')
     end if
     energies_p(1:nbnds_kss,ikpt,isppol)=eigen(1:nbnds_kss)
     if (.FALSE.) write(*,*)isppol,ikpt,eigen(:)*Ha_eV 
    end do 
   end do 
   nullify(Electrons_folder%eigenvalues%data1D)
   deallocate(eigen) 
!  nullify(Electrons_folder%occupations%data1D) 
!  deallocate(occ_vec)
#endif
  end if

  deallocate(tmp_enek)

  if (accesswff==0) then 
   close(untkss)
#if defined HAVE_ETSF_IO
  else if (accesswff==3) then 
   call etsf_io_low_close(untkss,lstat,Error_data)
#endif
  end if

 end if ! (rank==master.or.localrdwf==1)
!
!==========================================
!=== Cast data if KSS file is not local === 
!==========================================
 if (MPI_enreg%nproc>1.and.localrdwf==0) then
  call hdr_comm(Hdr,master,rank,spaceComm)
  call xcast_mpi(mpsang,   master,spaceComm,ierr)
  call xcast_mpi(nbnds_kss,master,spaceComm,ierr)
  call xcast_mpi(ng_kss,   master,spaceComm,ierr)
  call xcast_mpi(nsym_out, master,spaceComm,ierr)
  if (rank/=master) then ! this proc did not read.
   allocate(gvec_p(3,ng_kss)) 
   allocate(energies_p(nbnds_kss,Hdr%nkpt,Hdr%nsppol))
  end if
  call xcast_mpi(gvec_p,    master,spaceComm,ierr)
  call xcast_mpi(energies_p,master,spaceComm,ierr)
  call leave_test(MPI_enreg)
 end if

#if defined DEBUG_MODE
 write(msg,'(a)')' testlda : exit'
 call wrtout(std_out,msg,'PERS')
 call flush_unit(std_out)
#endif

end subroutine testlda
!!***
