!{\src2tex{textfont=tt}}
!!****f* ABINIT/hdr_tools
!! NAME
!! hdr_tools
!!
!! FUNCTION
!! This module contains methods of the Hdr structrure. 
!! At the moment it contains few routines but feel free to add your 
!! own piece of code. For example it would be useful to have a set of
!! methods to dump the crystalline structure according to the file format 
!! employed by an external graphical software ...
!!
!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! TODO
!! !£It should be a module
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

!! NAME
!! get_nelect_from_Hdr
!!
!! FUNCTION
!!  Return the number of electrons from the occupation numbers
!!
!! INPUTS
!!  Hdr<Hdr_type>
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

function get_nelect_from_Hdr(Hdr) result(nelect)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ---------------------------------------------
!scalars
 type(Hdr_type),intent(in) :: Hdr
 real(dp) :: nelect

!Local variables ---------------------------------------
!scalars
 integer :: idx,isppol,ikibz,nband_k

! *************************************************************************

!* Cannot use znucl because we might have additional charge or alchemy.
 nelect=zero ; idx=0
 do isppol=1,Hdr%nsppol
  do ikibz=1,Hdr%nkpt                                                                              
   nband_k=Hdr%nband(ikibz+(isppol-1)*Hdr%nkpt)
   nelect = nelect + Hdr%wtk(ikibz)*SUM(Hdr%occ(idx+1:idx+nband_k))
   idx=idx+nband_k
  end do
 end do

!Might also check also Hdr%znuclpsp(:) to avoid round off errors

end function get_nelect_from_Hdr
!!***
