!{\src2tex{textfont=tt}}
!!****f* ABINIT/hdr_copy
!! NAME
!! hdr_copy
!!
!! FUNCTION
!! Make a deep copy of the abinit header.
!!
!! INPUTS
!!  Hdr_in=The header to be copied.
!!
!! OUTPUT 
!!  Hdr_cp=The deep copy of Hdr_in.
!!
!! NOTES
!!  The present version deal with versions of the header up to 56.
!!
!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! PARENTS
!!      m_scr_hdr,m_wannier2abinit
!!
!! CHILDREN
!!      deep_copy,leave_new,rhoij_alloc,rhoij_copy,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine hdr_copy(Hdr_in,Hdr_cp)

 use defs_basis
 use defs_datatypes
 use m_copy, only : deep_copy

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
 use interfaces_11util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Hdr_type),intent(in) :: Hdr_in
 type(Hdr_type),intent(inout) :: Hdr_cp

!Local variables-------------------------------
!scalars
 integer :: cplex
 character(len=500) :: msg
!arrays
 integer,pointer :: nlmn(:)
! *************************************************************************

!TODO add method to nullify header, deep_copy might crash if 
!a pointer in the Hdr is not initialized to null()

 if (Hdr_in%headform>57) then 
  write(msg,'(6a,i3,2a)')ch10,&
&  ' hdr_copy : BUG - ',ch10,&
&  '  hdr_copy deals with versions of the header only up to 56. ',ch10,&
&  '  However headform = ',Hdr_in%headform,ch10,&
&  '  Change the source to add the changes done in the new version. '  
  call wrtout(std_out,msg,'COLL') 
  call leave_new('COLL')
 end if
 
!=== Integer values ===
 Hdr_cp%bantot   = Hdr_in%bantot        
 Hdr_cp%date     = Hdr_in%date          
 Hdr_cp%headform = Hdr_in%headform      
 Hdr_cp%intxc    = Hdr_in%intxc 
 Hdr_cp%ixc      = Hdr_in%ixc 
 Hdr_cp%natom    = Hdr_in%natom 
 Hdr_cp%nkpt     = Hdr_in%nkpt 
 Hdr_cp%npsp     = Hdr_in%npsp 
 Hdr_cp%nspden   = Hdr_in%nspden
 Hdr_cp%nspinor  = Hdr_in%nspinor 
 Hdr_cp%nsppol   = Hdr_in%nsppol 
 Hdr_cp%nsym     = Hdr_in%nsym 
 Hdr_cp%ntypat   = Hdr_in%ntypat 
 Hdr_cp%occopt   = Hdr_in%occopt       
 Hdr_cp%pertcase = Hdr_in%pertcase     
 Hdr_cp%usepaw   = Hdr_in%usepaw 
 Hdr_cp%usewvl   = Hdr_in%usewvl       
 Hdr_cp%ngfft(:) = Hdr_in%ngfft(:)     

!=== Integer pointers ====
 call deep_copy( Hdr_in%istwfk,  Hdr_cp%istwfk   )
 call deep_copy( Hdr_in%lmn_size,Hdr_cp%lmn_size )
 call deep_copy( Hdr_in%nband,   Hdr_cp%nband    )
 call deep_copy( Hdr_in%npwarr,  Hdr_cp%npwarr   )

 Hdr_cp%nwvlarr(:) = Hdr_in%nwvlarr(:)   

 call deep_copy( Hdr_in%pspcod,Hdr_cp%pspcod )
 call deep_copy( Hdr_in%pspdat,Hdr_cp%pspdat )
 call deep_copy( Hdr_in%pspso ,Hdr_cp%pspso  )
 call deep_copy( Hdr_in%pspxc ,Hdr_cp%pspxc  )
 call deep_copy( Hdr_in%so_psp,Hdr_cp%so_psp )
 call deep_copy( Hdr_in%symafm,Hdr_cp%symafm )
 call deep_copy( Hdr_in%symrel,Hdr_cp%symrel )
 call deep_copy( Hdr_in%typat ,Hdr_cp%typat  )

!=== Real variables ====
 Hdr_cp%ecut        = Hdr_in%ecut               
 Hdr_cp%ecutdg      = Hdr_in%ecutdg             
 Hdr_cp%ecutsm      = Hdr_in%ecutsm             
 Hdr_cp%ecut_eff    = Hdr_in%ecut_eff           
 Hdr_cp%etot        = Hdr_in%etot 
 Hdr_cp%fermie      = Hdr_in%fermie
 Hdr_cp%residm      = Hdr_in%residm 
 Hdr_cp%qptn(:)     = Hdr_in%qptn(:)
 Hdr_cp%rprimd(:,:) = Hdr_in%rprimd(:,:)        
 Hdr_cp%stmbias     = Hdr_in%stmbias            
 Hdr_cp%tphysel     = Hdr_in%tphysel            
 Hdr_cp%tsmear      = Hdr_in%tsmear             

!=== Real pointers ===
 call deep_copy( Hdr_in%kptns     ,Hdr_cp%kptns     )   
 call deep_copy( Hdr_in%occ       ,Hdr_cp%occ       )       
 call deep_copy( Hdr_in%tnons     ,Hdr_cp%tnons     )   
 call deep_copy( Hdr_in%wtk       ,Hdr_cp%wtk       )
 call deep_copy( Hdr_in%xred      ,Hdr_cp%xred      )
 call deep_copy( Hdr_in%zionpsp   ,Hdr_cp%zionpsp   )
 call deep_copy( Hdr_in%znuclpsp  ,Hdr_cp%znuclpsp  )
 call deep_copy( Hdr_in%znucltypat,Hdr_cp%znucltypat)

!=== Character pointers ===
 Hdr_cp%codvsn = Hdr_in%codvsn              
 call deep_copy( Hdr_in%title,Hdr_cp%title )

!=== For PAW have to copy Pawrhoij ====
!Warnings: 
!* alchemy requires a different treatment but for the moment it is not available within PAW.
 if (Hdr_in%usepaw==1) then
  cplex= Hdr_in%Pawrhoij(1)%cplex
  nlmn => Hdr_in%lmn_size(1:Hdr_in%ntypat)
  allocate(Hdr_cp%Pawrhoij(Hdr_in%natom)) 
  call rhoij_alloc(cplex,nlmn,Hdr_in%nspden,Hdr_in%nsppol,Hdr_cp%Pawrhoij,Hdr_in%typat)
  call rhoij_copy(Hdr_in%Pawrhoij,Hdr_cp%Pawrhoij)
 end if

end subroutine hdr_copy
!!***
