!{\src2tex{textfont=tt}}
!!****f* ABINIT/pspheads_comm
!! NAME
!! pspheads_comm
!!
!! FUNCTION
!! Communicate pspheads to all processors
!!
!! COPYRIGHT
!! Copyright (C) 2009 ABINIT group (DCA, XG, GMR, FrD, AF, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  npsp=number of pseudopotentials
!!  test_paw=0 if no PAW, 1 if PAW
!!
!! SIDE EFFECTS
!!  pspheads(npsp)=<type pspheader_type>=all the important information from the
!!   pseudopotential file headers, as well as the psp file names. On one processor at input,
!!   on all processors at output
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pspheads_comm(npsp,mpi_enreg,pspheads,test_paw)

 use defs_basis
 use defs_datatypes
#if defined MPI && defined MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

 implicit none
#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 integer,intent(in) :: npsp
 integer,intent(inout) :: test_paw
 type(pspheader_type),intent(inout) :: pspheads(npsp)
 type(MPI_type), intent(in) :: mpi_enreg

!Local variables-------------------------------
!integer,parameter :: n1xccc_default=2501
!integer :: idum,ii,ilmax,ios,ipsang,ipsp,lang,lmax,mmax,mpsang,n1xccc,nmesh,pspcod
!integer :: pspso,pspxc,test_paw
!integer :: usexml
!real(dp) :: al,e990,e999,fchrg,hdum(3),qchrg,r1,rchrg,rp,rr,rs
!character(len=fnlen) :: filpsp
!character(len=3) :: testxc
!character(len=500) :: message
!character(len=80) :: pspline
!integer :: nproj(0:3),nprojso(1:3)
!integer,allocatable :: orb(:)
!character(len=70)         :: testxml

!no_abirules

#if defined MPI 
          !Variables introduced for MPI version
           integer :: ierr
           integer,allocatable :: list_int(:)
           real(dp) :: tsec(2)
           real(dp),allocatable :: list_dpr(:)
           character(len=fnlen),allocatable :: list_char(:)
#endif

!*************************************************************************

#if defined MPI 
            call timab(48,1,tsec)
            call leave_test(mpi_enreg)

           !Broadcast the characters (file names and titles)
            allocate(list_char(2*npsp))
            list_char(1:npsp)=pspheads(1:npsp)%filpsp
            list_char(npsp+1:2*npsp)=pspheads(1:npsp)%title
            call MPI_BCAST(list_char,2*npsp*fnlen,MPI_CHARACTER,0,&
          &  MPI_COMM_WORLD,ierr)
            pspheads(1:npsp)%filpsp=list_char(1:npsp)
            pspheads(1:npsp)%title=list_char(npsp+1:2*npsp)
            deallocate(list_char)

           !Brodcast the integers
            allocate(list_int(1+13*npsp))
            list_int(1       :  npsp)=pspheads(1:npsp)%nproj(0)
            list_int(1+  npsp:2*npsp)=pspheads(1:npsp)%nproj(1)
            list_int(1+2*npsp:3*npsp)=pspheads(1:npsp)%nproj(2)
            list_int(1+3*npsp:4*npsp)=pspheads(1:npsp)%nproj(3)
            list_int(1+4*npsp:5*npsp)=pspheads(1:npsp)%lmax
            list_int(1+5*npsp:6*npsp)=pspheads(1:npsp)%xccc
            list_int(1+6*npsp:7*npsp)=pspheads(1:npsp)%pspxc
            list_int(1+7*npsp:8*npsp)=pspheads(1:npsp)%pspdat
            list_int(1+8*npsp:9*npsp)=pspheads(1:npsp)%pspcod
            list_int(1+9*npsp:10*npsp)=pspheads(1:npsp)%pspso
            list_int(1+10*npsp:11*npsp)=pspheads(1:npsp)%nprojso(1)
            list_int(1+11*npsp:12*npsp)=pspheads(1:npsp)%nprojso(2)
            list_int(1+12*npsp:13*npsp)=pspheads(1:npsp)%nprojso(3)
            list_int(1+13*npsp)        =test_paw

            call MPI_BCAST(list_int,1+13*npsp,MPI_INTEGER,0,&
          &  MPI_COMM_WORLD,ierr)

            pspheads(1:npsp)%nproj(0) =list_int(1       :  npsp)
            pspheads(1:npsp)%nproj(1) =list_int(1+  npsp:2*npsp)
            pspheads(1:npsp)%nproj(2) =list_int(1+2*npsp:3*npsp)
            pspheads(1:npsp)%nproj(3) =list_int(1+3*npsp:4*npsp)
            pspheads(1:npsp)%lmax     =list_int(1+4*npsp:5*npsp)
            pspheads(1:npsp)%xccc     =list_int(1+5*npsp:6*npsp)
            pspheads(1:npsp)%pspxc    =list_int(1+6*npsp:7*npsp)
            pspheads(1:npsp)%pspdat   =list_int(1+7*npsp:8*npsp)
            pspheads(1:npsp)%pspcod   =list_int(1+8*npsp:9*npsp)
            pspheads(1:npsp)%pspso    =list_int(1+9*npsp:10*npsp)
            pspheads(1:npsp)%nprojso(1)=list_int(1+10*npsp:11*npsp)
            pspheads(1:npsp)%nprojso(2)=list_int(1+11*npsp:12*npsp)
            pspheads(1:npsp)%nprojso(3)=list_int(1+12*npsp:13*npsp)
            test_paw                   =list_int(1+13*npsp)
            deallocate(list_int)

           !Broadcast zionpsp and znuclpsp
            allocate(list_dpr(2*npsp))
            list_dpr(1:npsp)=pspheads(1:npsp)%zionpsp
            list_dpr(1+npsp:2*npsp)=pspheads(1:npsp)%znuclpsp
            call MPI_BCAST(list_dpr,2*npsp,MPI_DOUBLE_PRECISION,0,&
          &  MPI_COMM_WORLD,ierr)
            pspheads(1:npsp)%zionpsp =list_dpr(1:npsp)
            pspheads(1:npsp)%znuclpsp=list_dpr(1+npsp:2*npsp)
            deallocate(list_dpr)

           !Broadcast additional integers for PAW psps (testpaw was spread, previously)
            if (test_paw==1) then
             allocate(list_int(5*npsp))
             list_int(1       :  npsp)=pspheads(1:npsp)%pawheader%basis_size
             list_int(1+  npsp:2*npsp)=pspheads(1:npsp)%pawheader%l_size
             list_int(1+2*npsp:3*npsp)=pspheads(1:npsp)%pawheader%lmn_size
             list_int(1+3*npsp:4*npsp)=pspheads(1:npsp)%pawheader%mesh_size
             list_int(1+4*npsp:5*npsp)=pspheads(1:npsp)%pawheader%pawver
             call MPI_BCAST(list_int,5*npsp,MPI_INTEGER,0,&
           &  MPI_COMM_WORLD,ierr)
             pspheads(1:npsp)%pawheader%basis_size=list_int(1       :  npsp)
             pspheads(1:npsp)%pawheader%l_size    =list_int(1+  npsp:2*npsp)
             pspheads(1:npsp)%pawheader%lmn_size  =list_int(1+2*npsp:3*npsp)
             pspheads(1:npsp)%pawheader%mesh_size =list_int(1+3*npsp:4*npsp)
             pspheads(1:npsp)%pawheader%pawver    =list_int(1+4*npsp:5*npsp)
             deallocate(list_int)
            end if

            call timab(48,2,tsec)
#endif

end subroutine pspheads_comm
!!***
