!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_atoms_data_set
!!
!! NAME
!! wvl_atoms_data_set
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_atoms_data_set(acell, dtset)

  use defs_basis
  use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

  implicit none

!Arguments ------------------------------------
!scalars
  type(dataset_type), intent(inout)      :: dtset
  !arrays
  real(dp), intent(in)                   :: acell(3)

!Local variables-------------------------------
!scalars
#if defined HAVE_BIGDFT
  integer :: iat, itype
#else
  character(len=500) :: message
#endif

! *********************************************************************

#if defined HAVE_BIGDFT
!We create the atoms_data structure from this dataset
!to be used later in BigDFT routines.
 if (dtset%icoulomb == 0) then
  dtset%wvl%atoms%geocode = 'P'
 else if (dtset%icoulomb == 1) then
  dtset%wvl%atoms%geocode = 'F'
 else if (dtset%icoulomb == 2) then
  dtset%wvl%atoms%geocode = 'S'
 end if
 write(dtset%wvl%atoms%units, "(A)") "Bohr"
 dtset%wvl%atoms%nat      =  dtset%natom
 dtset%wvl%atoms%ntypes   =  dtset%ntypat
 allocate(dtset%wvl%atoms%atomnames(dtset%ntypat))
 do itype = 1, dtset%ntypat, 1
  write(dtset%wvl%atoms%atomnames(itype), "(A,I2)") "At. type", dtset%typat(itype)
 end do
 dtset%wvl%atoms%alat1    =  acell(1)
 dtset%wvl%atoms%alat2    =  acell(2)
 dtset%wvl%atoms%alat3    =  acell(3)
 dtset%wvl%atoms%iatype   => dtset%typat
!All atoms are free to move.
 allocate(dtset%wvl%atoms%lfrztyp(dtset%natom))
 dtset%wvl%atoms%lfrztyp  =  .false.
!No chrage or polarisation on atoms in a first step.
 allocate(dtset%wvl%atoms%natpol(dtset%natom))
 dtset%wvl%atoms%natpol   =  100

 nullify(dtset%wvl%atoms%psppar)
 nullify(dtset%wvl%atoms%npspcode)
 nullify(dtset%wvl%atoms%iasctype)
 nullify(dtset%wvl%atoms%nzatom)
 nullify(dtset%wvl%atoms%nelpsp)

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_atoms_data_set : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 call wrtout(6,message,'COLL')
 call leave_new('COLL')
#endif  
end subroutine wvl_atoms_data_set
!!***

!!****f* ABINIT/wvl_atoms_data_set_psp
!!
!! NAME
!! wvl_atoms_data_set_psp
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine wvl_atoms_data_set_psp(dtset, psps)

  use defs_basis
  use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

  implicit none

!Arguments ------------------------------------
!scalars
  type(dataset_type), intent(inout)      :: dtset
  type(pseudopotential_type), intent(in) :: psps
!arrays

!Local variables-------------------------------
!scalars
#if defined HAVE_BIGDFT
  integer :: iat, itype
#else
  character(len=500) :: message
#endif

! *********************************************************************

#if defined HAVE_BIGDFT
!We create the atoms_data structure, the part that is dependent from psp.
 dtset%wvl%atoms%psppar   => psps%gth_params%psppar
 dtset%wvl%atoms%npspcode => psps%pspcod
 dtset%wvl%atoms%iasctype => psps%gth_params%semicore
 allocate(dtset%wvl%atoms%nzatom(dtset%ntypat))
 dtset%wvl%atoms%nzatom   =  dtset%znucl
 allocate(dtset%wvl%atoms%nelpsp(dtset%ntypat))
 dtset%wvl%atoms%nelpsp   =  dtset%ziontypat
 dtset%wvl%atoms%natsc    =  0
 do iat = 1, dtset%natom, 1
  if (dtset%wvl%atoms%iasctype(dtset%wvl%atoms%iatype(iat)) > 0) then
   dtset%wvl%atoms%natsc = dtset%wvl%atoms%natsc + 1
  end if
 end do
#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_atoms_data_set_psp : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 call wrtout(6,message,'COLL')
 call leave_new('COLL')
#endif  
end subroutine wvl_atoms_data_set_psp
!!***

!!****f* ABINIT/wvl_atoms_data_free
!!
!! NAME
!! wvl_atoms_data_free
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine wvl_atoms_data_free(dtset)

  use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

  implicit none

!Arguments ------------------------------------
!scalars
  type(dataset_type), intent(inout) :: dtset
!arrays

!Local variables-------------------------------
!scalars
#if defined HAVE_BIGDFT
  integer :: iat, itype
#else
  character(len=500) :: message
#endif

! *********************************************************************

#if defined HAVE_BIGDFT

 if (associated(dtset%wvl%atoms%atomnames)) deallocate(dtset%wvl%atoms%atomnames)
 nullify(dtset%wvl%atoms%psppar)
 nullify(dtset%wvl%atoms%npspcode)
 nullify(dtset%wvl%atoms%iasctype)
 nullify(dtset%wvl%atoms%iatype)
 if (associated(dtset%wvl%atoms%nzatom))  deallocate(dtset%wvl%atoms%nzatom)
 if (associated(dtset%wvl%atoms%nelpsp))  deallocate(dtset%wvl%atoms%nelpsp)
 if (associated(dtset%wvl%atoms%lfrztyp)) deallocate(dtset%wvl%atoms%lfrztyp)
 if (associated(dtset%wvl%atoms%natpol))  deallocate(dtset%wvl%atoms%natpol)

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_atoms_data_free : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 call wrtout(6,message,'COLL')
 call leave_new('COLL')
#endif
end subroutine wvl_atoms_data_free
!!***

!!****f* ABINIT/wvl_atoms_data_copy
!!
!! NAME
!! wvl_atoms_data_copy
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
subroutine wvl_atoms_data_copy(dtto, dtfrom)

  use defs_basis
  use defs_datatypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi
!End of the abilint section

  implicit none

!Arguments ------------------------------------
!scalars
  type(dataset_type), intent(inout)      :: dtto
  type(dataset_type), intent(in)         :: dtfrom
  !arrays

!Local variables-------------------------------
!scalars
#if defined HAVE_BIGDFT
  integer :: iat, itype
#else
  character(len=500) :: message
#endif

! *********************************************************************

#if defined HAVE_BIGDFT
 dtto%wvl%atoms%geocode  = dtfrom%wvl%atoms%geocode
 write(dtto%wvl%atoms%units, "(A)") dtfrom%wvl%atoms%units
 dtto%wvl%atoms%nat      =  dtfrom%wvl%atoms%nat
 dtto%wvl%atoms%ntypes   =  dtfrom%wvl%atoms%ntypes
 allocate(dtto%wvl%atoms%atomnames(size(dtfrom%wvl%atoms%atomnames)))
 dtto%wvl%atoms%atomnames = dtfrom%wvl%atoms%atomnames
 dtto%wvl%atoms%alat1    =  dtfrom%wvl%atoms%alat1
 dtto%wvl%atoms%alat2    =  dtfrom%wvl%atoms%alat2
 dtto%wvl%atoms%alat3    =  dtfrom%wvl%atoms%alat3
 dtto%wvl%atoms%iatype   => dtto%typat
!All atoms are free to move.
 allocate(dtto%wvl%atoms%lfrztyp(size(dtfrom%wvl%atoms%lfrztyp)))
 dtto%wvl%atoms%lfrztyp  =  .false.
!No chrage or polarisation on atoms in a first step.
 allocate(dtto%wvl%atoms%natpol(size(dtfrom%wvl%atoms%natpol)))
 dtto%wvl%atoms%natpol   =  100

!The data relative to the psp.
 if (associated(dtfrom%wvl%atoms%psppar)) then
  dtto%wvl%atoms%psppar   => dtfrom%wvl%atoms%psppar
 else
  nullify(dtto%wvl%atoms%psppar)
 end if
 if (associated(dtfrom%wvl%atoms%npspcode)) then
  dtto%wvl%atoms%npspcode => dtfrom%wvl%atoms%npspcode
 else
  nullify(dtto%wvl%atoms%npspcode)
 end if
 if (associated(dtfrom%wvl%atoms%iasctype)) then
  dtto%wvl%atoms%iasctype => dtfrom%wvl%atoms%iasctype
 else
  nullify(dtto%wvl%atoms%iasctype)
 end if
 if (associated(dtfrom%wvl%atoms%nzatom)) then
  allocate(dtto%wvl%atoms%nzatom(size(dtfrom%wvl%atoms%nzatom)))
  dtto%wvl%atoms%nzatom   =  dtfrom%wvl%atoms%nzatom
 else
  nullify(dtto%wvl%atoms%nzatom)
 end if
 if (associated(dtfrom%wvl%atoms%nelpsp)) then
  allocate(dtto%wvl%atoms%nelpsp(size(dtfrom%wvl%atoms%nelpsp)))
  dtto%wvl%atoms%nelpsp   =  dtfrom%wvl%atoms%nelpsp
 else
  nullify(dtto%wvl%atoms%nelpsp)
 end if
 dtto%wvl%atoms%natsc    = dtfrom%wvl%atoms%natsc

#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_atoms_data_set : BigDFT library is not compiled.', ch10, &
& '   Action, used the flag --enable-bigdft when configuring.'
 call wrtout(6,message,'COLL')
 call leave_new('COLL')
#endif  
end subroutine wvl_atoms_data_copy
!!***
