/* abi_common.h */

/*
 * Copyright (c) 2008-2009 ABINIT Group (MG)
 * All rights reserved.
 *
 * This file is part of the ABINIT software package. For license information,
 * please see the COPYING file in the top-level directory of the ABINIT source
 * distribution.
 *
 */

#define HAVE_LONG_LINES 1

#define TOSTRING(x)     #x
#define BSIZE(array)  PRODUCT(SHAPE(array)) * DBLE(KIND(array))

/*
#define JOIN(x, y)   x .jn. y
#define F90INFO(f90name, lineno)  JOIN( JOIN(f90name, ":"), TOSTRING(lineno))
*/

/* 
 * ABI_ basic abinit macros.
 * DBG_ denote macros for debugging. Defined only if abinit is compiled in DEBUG_MODE.
 * MSG_ denote macros for logging.
 * MEM_ for memory profiling and checking.
 * */

#if defined DEBUG_MODE 
#  if defined HAVE_LONG_LINES 
#    define DBG_ASSERT(lg1) call assert(lg1,TOSTRING(lg1),__FILE__,__LINE__)
#    define DBG_CHKPT(msg)  call checkpoint(msg,__FILE__,__LINE__)
/*
* C99 __func__ doesn't work with Fortran code but we might use abilint to define a 
* CPP varible, ABI_func, containing the name of the F90 procedure.
#    define DBG_ENTER(mode) call sentinel(1,mode,ABI_func)
#    define DBG_EXIT(mode)  call sentinel(2,mode,ABI_func)
* For the moment we use __FILE__
*/
#    define DBG_ENTER(mode) call sentinel(1,mode,__FILE__)
#    define DBG_EXIT(mode)  call sentinel(2,mode,__FILE__)
#  else
#    define DBG_ASSERT(lg1) call assert(lg1,TOSTRING(lg1)) 
#    define DBG_CHKPT(msg)  call checkpoint(msg)
#    define DBG_ENTER(mode) call sentinel(1,mode)
#    define DBG_EXIT(mode)  call sentinel(2,mode)
#  endif
#else
#  define DBG_ASSERT(lg1) 
#  define DBG_CHKPT(msg)  
#  define DBG_ENTER(mode)
#  define DBG_EXIT(mode)
#endif



/* Macros for memory checking and profiling *
#define HAVE_MEMCHECK 0
#if defined HAVE_MEMCHECK

#  if defined HAVE_LONG_LINES 
#    define MEM_CHECK(istat, array) call memcheck(istat,BSIZE(array),TOSTRING(array),__FILE__,__LINE__)  
#  else
#    define MEM_CHECK(istat, array) call memcheck(istat,BSIZE(array),TOSTRING(array))  
#  endif

#else
#   define MEM_CHECK(istat, array)  
#endif
*/

/* Macro for basic messages (COLLECTIVE and PERSONAL version) */
#if defined HAVE_LONG_LINES

#  define ABI_DIE(msg)         call die(msg, __FILE__, __LINE__) 

#  define MSG_COMMENT(msg)      call msg_hndl(msg,"COMMENT","COLL",__FILE__,__LINE__) 
#  define MSG_WARNING(msg)      call msg_hndl(msg,"WARNING","COLL",__FILE__,__LINE__)
#  define MSG_ERROR(msg)        call msg_hndl(msg,"ERROR"  ,"COLL",__FILE__,__LINE__) 
#  define MSG_BUG(msg)          call msg_hndl(msg,"BUG"    ,"COLL",__FILE__,__LINE__) 
#  define MSG_PERS_COMMENT(msg) call msg_hndl(msg,"COMMENT","PERS",__FILE__,__LINE__) 
#  define MSG_PERS_WARNING(msg) call msg_hndl(msg,"WARNING","PERS",__FILE__,__LINE__)
#  define MSG_PERS_ERROR(msg)   call msg_hndl(msg,"ERROR"  ,"PERS",__FILE__,__LINE__) 
#  define MSG_PERS_BUG(msg)     call msg_hndl(msg,"BUG"    ,"PERS",__FILE__,__LINE__) 

#else
/* 
 * Safe macros for emergency cases! 
 * Useful if __FILE__ expands to the full path name exceeding
 * the max number of Fortran columns. ISO doesn't define any standard!
 */ 
#  define ABI_DIE(msg)     call die(msg) 

#  define MSG_COMMENT(msg)      call msg_hndl(msg,"COMMENT","COLL") 
#  define MSG_WARNING(msg)      call msg_hndl(msg,"WARNING","COLL")
#  define MSG_ERROR(msg)        call msg_hndl(msg,"ERROR"  ,"COLL") 
#  define MSG_BUG(msg)          call msg_hndl(msg,"BUG"    ,"COLL") 
#  define MSG_PERS_COMMENT(msg) call msg_hndl(msg,"COMMENT","PERS") 
#  define MSG_PERS_WARNING(msg) call msg_hndl(msg,"WARNING","PERS")
#  define MSG_PERS_ERROR(msg)   call msg_hndl(msg,"ERROR"  ,"PERS") 
#  define MSG_PERS_BUG(msg)     call msg_hndl(msg,"BUG"    ,"PERS") 

#endif
