!{\src2tex{textfont=tt}}
!!****f* ABINIT/scalapack
!! NAME
!! scalapack
!!
!! FUNCTION
!! This module contains functions and subroutine using ScaLAPACK library.
!! The code have to be compiled with the HAVE_SCALAPACK CPP flags.
!!
!! COPYRIGHT
!! Copyright (C) 2001-2009 ABINIT group (CS,GZ,FB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#if defined HAVE_SCALAPACK

!-------------------------------------------------------
! set up of a processor grid for ScaLAPACK
! as a function of the total number of processors attributed to the grid
!-------------------------------------------------------

SUBROUTINE build_grid_scalapack(grid,nbprocs, communicator)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(grid_scalapack),INTENT(out)     :: grid
  INTEGER,INTENT(in)                     :: nbprocs
  INTEGER, INTENT(in)                    :: communicator

  INTEGER  :: i

  grid%nbprocs=nbprocs

  ! Search for a rectangular grid of processors 
  i=INT(SQRT(float(nbprocs)))
  DO WHILE (MOD(nbprocs,i) /= 0)
     i = i-1
  END DO

  grid%dims(1) = i
  grid%dims(2) = INT(nbprocs/i)

  grid%ictxt = communicator

  CALL BLACS_GRIDINIT(grid%ictxt,'R',grid%dims(1),grid%dims(2))           

END SUBROUTINE build_grid_scalapack
!!***


!-------------------------------------------------------
! Build of the data related to one processor in a grid
!-------------------------------------------------------

SUBROUTINE build_processor_scalapack(processor,grid,myproc, comm)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(processor_scalapack),INTENT(out)  :: processor
  TYPE(grid_scalapack),INTENT(in)       :: grid
  INTEGER,INTENT(in)                      :: myproc
  INTEGER,INTENT(in)                      :: comm

  processor%grid= grid

  processor%myproc = myproc

  processor%comm = comm

  CALL BLACS_GRIDINFO(grid%ictxt,processor%grid%dims(1), &
       &              processor%grid%dims(2),processor%coords(1), &
       &              processor%coords(2))

  ! These values are the same as those computed by BLACS_GRIDINFO
  ! except in the case where the mmyproc argument is not the
  ! local proc
  processor%coords(1) = INT((myproc) / grid%dims(2))
  processor%coords(2) = MOD((myproc), grid%dims(2))


END SUBROUTINE build_processor_scalapack

!-------------------------------------------------------
! general initilisation of ScaLAPACK
!-------------------------------------------------------

SUBROUTINE init_scalapack(processor,communicator)

  use defs_scalapack
  use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => init_scalapack
!End of the abilint section

 implicit none
#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

  TYPE(processor_scalapack),INTENT(out)    :: processor
  INTEGER, INTENT(in)                       :: communicator

  TYPE(grid_scalapack)                    :: grid
  INTEGER                                   :: nbproc,myproc
  INTEGER                                   :: ierr


  CALL MPI_COMM_SIZE(communicator, nbproc, ierr)
  CALL MPI_COMM_RANK(communicator, myproc, ierr)

  CALL build_grid_scalapack(grid, nbproc, communicator)
  CALL build_processor_scalapack(processor, grid, myproc, communicator)


END SUBROUTINE init_scalapack


!-------------------------------------------------------
! General closing of ScaLAPACK
!-------------------------------------------------------

SUBROUTINE end_scalapack(processor)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(processor_scalapack),INTENT(inout)    :: processor

  CALL BLACS_GRIDEXIT(processor%grid%ictxt)

  !CALL BLACS_EXIT(0)

END SUBROUTINE end_scalapack

!-------------------------------------------------------
! Initialisation of a SCALAPACK matrix (each proc initialize its own part of the matrix)
!-------------------------------------------------------

SUBROUTINE init_matrix_scalapack(matrix,nbli_global, &
     &                                      nbco_global,processor,istwf_k,tbloc)

  use defs_scalapack
  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => init_matrix_scalapack
!End of the abilint section

  implicit none

  TYPE(matrix_scalapack),INTENT(out)           :: matrix
  TYPE(processor_scalapack),INTENT(in),TARGET  :: processor
  INTEGER,INTENT(in)                           :: nbli_global,nbco_global
  INTEGER,INTENT(in)                           :: istwf_k
  INTEGER,INTENT(in),OPTIONAL                  :: tbloc

  INTEGER, PARAMETER                :: SIZE_BLOCS = 40
  INTEGER             :: info,sizeb

  INTEGER :: NUMROC
  EXTERNAL NUMROC

  IF (PRESENT(tbloc)) THEN
     sizeb = tbloc
  ELSE
     sizeb  = SIZE_BLOCS
  END IF

  ! Records of the matrix type :
  matrix%processor => processor
  matrix%sizeb_blocs(1) = MIN(sizeb,nbli_global)
  matrix%sizeb_blocs(2) = MIN(sizeb,nbco_global)
  matrix%sizeb_global(1) = nbli_global
  matrix%sizeb_global(2) = nbco_global


  ! Size of the local buffer
  matrix%sizeb_local(1) = NUMROC(nbli_global,matrix%sizeb_blocs(1), &
       &                            processor%coords(1),0, &
       &                            processor%grid%dims(1))

  matrix%sizeb_local(2) = NUMROC(nbco_global,matrix%sizeb_blocs(2), &
       &                            processor%coords(2),0, &
       &                            processor%grid%dims(2))

  CALL idx_loc(matrix,matrix%sizeb_global(1),matrix%sizeb_global(2), &
       &       matrix%sizeb_local(1),matrix%sizeb_local(2))

  ! Initialisation of the SCALAPACK description of the matrix
  CALL DESCINIT(matrix%descript%tab, nbli_global, nbco_global, &
       &        matrix%sizeb_blocs(1), matrix%sizeb_blocs(2), 0,0 , &
       &        processor%grid%ictxt, MAX(1,matrix%sizeb_local(1)), &
       &        info)

  IF (info /= 0) THEN
     write(6,*) processor%myproc,'error initialisation matrix scalapack',info 
     call leave_new('PERS')
  END IF

  if (istwf_k/=2) then
     ALLOCATE(matrix%buffer_cplx(matrix%sizeb_local(1),matrix%sizeb_local(2)))
     matrix%buffer_cplx(:,:) = (0._DP,0._DP)
  else
     ALLOCATE(matrix%buffer_real(matrix%sizeb_local(1),matrix%sizeb_local(2)))
     matrix%buffer_real(:,:) = 0._DP
  endif

END SUBROUTINE init_matrix_scalapack

!-------------------------------------------------------
! Destruction of the records of a SCALAPACK matrix
!-------------------------------------------------------
SUBROUTINE destruction_matrix_scalapack(matrix)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(inout)    :: matrix

  NULLIFY(matrix%processor)
  matrix%sizeb_global = 0
  IF (ASSOCIATED(matrix%buffer_cplx)) THEN
     DEALLOCATE(matrix%buffer_cplx)
  ENDIF
  IF (ASSOCIATED(matrix%buffer_real)) THEN
     DEALLOCATE(matrix%buffer_real)
  ENDIF
  IF (ASSOCIATED(matrix%ipiv)) THEN
     DEALLOCATE(matrix%ipiv)
  ENDIF
  matrix%sizeb_blocs = 0
  matrix%sizeb_local = 0
  matrix%descript%tab = 0

END SUBROUTINE destruction_matrix_scalapack


!-------------------------------------------------------
! Access to a component thanks to its local indices
!-------------------------------------------------------

FUNCTION matrix_get_local_cplx(matrix,i,j)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(in)    :: matrix
  INTEGER, INTENT(in)                   :: i,j
  COMPLEX(dp)                           :: matrix_get_local_cplx

  matrix_get_local_cplx = matrix%buffer_cplx(i,j)

END FUNCTION matrix_get_local_cplx

FUNCTION matrix_get_local_real(matrix,i,j)

  use defs_scalapack 
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(in)    :: matrix
  INTEGER, INTENT(in)                   :: i,j
  REAL(dp)                           :: matrix_get_local_real

  matrix_get_local_real = matrix%buffer_real(i,j)
  
END FUNCTION matrix_get_local_real

!-------------------------------------------------------
! Positioning of a component of a matrix thanks to its local indices
!-------------------------------------------------------

SUBROUTINE matrix_set_local_cplx(matrix,i,j,value)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(out)   :: matrix

  INTEGER, INTENT(in)                   :: i,j
  COMPLEX(dp)                           :: value

  matrix%buffer_cplx(i,j) = value

END SUBROUTINE matrix_set_local_cplx

SUBROUTINE matrix_set_local_real(matrix,i,j,value)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(out)   :: matrix

  INTEGER, INTENT(in)                   :: i,j
  REAL(dp)                           :: value

  matrix%buffer_real(i,j) = value

END SUBROUTINE matrix_set_local_real



!-------------------------------------------------------
! Determination of the local indices of a term of a matrix with respect
! to its lobal indices independently of the proc 
!-------------------------------------------------------

SUBROUTINE idx_loc(matrix,i,j,iloc,jloc)

  use defs_scalapack
  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => idx_loc
!End of the abilint section

  implicit none

  TYPE(matrix_scalapack),INTENT(in)    :: matrix
  INTEGER, INTENT(in)                   :: i,j
  INTEGER, INTENT(out)                  :: iloc,jloc

  INTEGER :: NUMROC
  EXTERNAL NUMROC
  iloc = glob_loc(matrix,i,1)

  jloc = glob_loc(matrix,j,2)

END SUBROUTINE idx_loc

!-------------------------------------------------------
! 
!-------------------------------------------------------
FUNCTION glob_loc(matrix,idx,lico)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(in)    :: matrix
  INTEGER, INTENT(in)                   :: idx, lico

  INTEGER :: glob_loc

  INTEGER :: NUMROC
  EXTERNAL NUMROC

  glob_loc = NUMROC(idx,matrix%sizeb_blocs(lico), &
       &        matrix%processor%coords(lico),0, &
       &        matrix%processor%grid%dims(lico))


END FUNCTION glob_loc

!-------------------------------------------------------
! Determination of the global indices of a term of the matrix with respect
! to its local indices
!-------------------------------------------------------

SUBROUTINE idx_glob(matrix,iloc,jloc,i,j)

  use defs_scalapack
  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => idx_glob
!End of the abilint section

  implicit none

  TYPE(matrix_scalapack),INTENT(in)    :: matrix
  INTEGER, INTENT(out)                  :: i,j
  INTEGER, INTENT(in)                   :: iloc,jloc

  INTEGER :: nbcycli,nbcycco,resteli,resteco,nblocsli,nblocsco
  i = loc_glob(matrix,matrix%processor,iloc,1)
  j = loc_glob(matrix,matrix%processor,jloc,2)

END SUBROUTINE idx_glob

!-------------------------------------------------------
! Determination of the global index from a local index (row or column)
! as a function of a given processor
!-------------------------------------------------------
FUNCTION loc_glob(matrix,proc,idx,lico)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(in)    :: matrix
  TYPE(processor_scalapack),INTENT(in) :: proc
  INTEGER, INTENT(in)                   :: idx,lico

  INTEGER :: loc_glob

  INTEGER :: nbcyc,reste,nblocs

  nbcyc = INT((idx-1)/matrix%sizeb_blocs(lico))
  reste = MOD(idx-1,matrix%sizeb_blocs(lico))
  nblocs = nbcyc*proc%grid%dims(lico)+ &
       & proc%coords(lico)

  loc_glob = nblocs * matrix%sizeb_blocs(lico) + reste + 1

END FUNCTION loc_glob


!-----------------------------------------------------------------
! Routine to fill a SCALAPACK matrix with respect to a full matrix
!-----------------------------------------------------------------

SUBROUTINE matrix_from_global(matrix,reference,istwf_k)

  use defs_scalapack
  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => matrix_from_global
!End of the abilint section

  implicit none

  TYPE(matrix_scalapack),INTENT(inout)  :: matrix
  REAL(dp),DIMENSION(:)                  :: reference
  INTEGER,INTENT(in)                     :: istwf_k
  COMPLEX(dp)::val_cplx
  REAL(dp)   ::val_real

  INTEGER :: i,j,iglob,jglob,ind
  REAL(dp) :: err
  INTEGER :: cptr

!    err = 0._DP
!    cptr = 0

  DO i=1,matrix%sizeb_local(1)
     DO j=1,matrix%sizeb_local(2)
        CALL idx_glob(matrix,i,j,iglob,jglob)

        ind = jglob*(jglob-1)+2*iglob-1

        if (istwf_k/=2) then
           val_cplx = dcmplx(reference(ind),reference(ind+1))
           CALL matrix_set_local_cplx(matrix,i,j,val_cplx)
        else
           val_real = reference(ind)
           CALL matrix_set_local_real(matrix,i,j,val_real)

           if(abs(reference(ind+1))>1.0d-10)then
              write(6,'(a,a,a,a,2i5,1es16.6,a,a)')ch10,&
                   &     ' scalapack : BUG ',&
                   &     '  For istwf_k=2, observed the following element of matrix :',ch10,&
                   &     iglob,jglob,reference(ind+1),ch10,&
                   &     '  with a non-negligible imaginary part.'
              call leave_new('PERS')
           end if

        endif

!          cptr = cptr + 1
     END DO
  END DO

!    IF (cptr /= 0) THEN
!       PRINT *,matrix%processor%myproc,"error Linf matrix scalapack", &
!            &  err,"on",cptr,"terms"
!    END IF

END SUBROUTINE matrix_from_global


SUBROUTINE matrix_to_global(matrix,reference,istwf_k)

  use defs_scalapack
  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => matrix_to_global
!End of the abilint section

  implicit none

  TYPE(matrix_scalapack),INTENT(in)        :: matrix
  REAL(dp),DIMENSION(:),INTENT(inout)       :: reference!(nband_k*(nband_k+1))
  INTEGER,INTENT(in)           :: istwf_k!,nband_k

  INTEGER  :: i,j,iglob,jglob,ind
  REAL(dp) :: err
  INTEGER  :: cptr

!    err = 0._DP
!    cptr = 0

  DO i=1,matrix%sizeb_local(1)
     DO j=1,matrix%sizeb_local(2)
        CALL idx_glob(matrix,i,j,iglob,jglob)

        ind = jglob*(jglob-1)+2*iglob-1

        if (ind <= matrix%sizeb_global(2)*(matrix%sizeb_global(2)+1)) then
           if (istwf_k/=2) then
              reference(ind)   = REAL(matrix_get_local_cplx(matrix,i,j))
              reference(ind+1) = IMAG(matrix_get_local_cplx(matrix,i,j))
           else
              reference(ind) = matrix_get_local_real(matrix,i,j)
           endif
        endif
!          cptr = cptr + 1
     END DO
  END DO

!    IF (cptr /= 0) THEN
!       PRINT *,matrix%processor%myproc,"erreur Linf matrix scalapack", &
!            &  err,"on",cptr,"terms"
!    END IF

END SUBROUTINE matrix_to_global






!-------------------------------------------------------------------
! Routine to fill a full matrix with respect to a SCALAPACK matrix
!-------------------------------------------------------------------
SUBROUTINE matrix_to_reference(matrix,reference,istwf_k)

  use defs_scalapack
  use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_01manage_mpi, except_this_one => matrix_to_reference
!End of the abilint section

  implicit none

  TYPE(matrix_scalapack),INTENT(in)        :: matrix
  REAL(dp),DIMENSION(:,:),INTENT(inout)     :: reference
  INTEGER,INTENT(in)                        :: istwf_k

  INTEGER  :: i,j,iglob,jglob,ind
  REAL(dp) :: err
  INTEGER  :: cptr

!    err = 0._DP
!    cptr = 0

  DO i=1,matrix%sizeb_local(1)
     DO j=1,matrix%sizeb_local(2)
        CALL idx_glob(matrix,i,j,iglob,jglob)

        ind=(iglob-1)*2+1

        if (istwf_k/=2) then
           reference(ind,jglob)   = REAL(matrix_get_local_cplx(matrix,i,j))
           reference(ind+1,jglob) = IMAG(matrix_get_local_cplx(matrix,i,j))
        else
           reference(ind,jglob)   = matrix_get_local_real(matrix,i,j)
           reference(ind+1,jglob) = 0._dp
        endif

!          cptr = cptr + 1
     END DO
  END DO

!    IF (cptr /= 0) THEN
!       PRINT *,matrix%processor%myproc,"error Linf matrix scalapack", &
!            &  err,"on",cptr,"terms"
!    END IF

END SUBROUTINE matrix_to_reference


!-------------------------------------------------------
! Extended matrix*matrix product
! C := alpha*A*B - beta*C
!
! For a simple matrix vector product, one can simply pass 
! alpha = (1.,0.) and beta (0.,0.)
!-------------------------------------------------------
SUBROUTINE matrix_pzgemm(matrix1,alpha,matrix2,beta,results)

  use defs_scalapack
  use defs_basis

  implicit none

  TYPE(matrix_scalapack),INTENT(in)        :: matrix1,matrix2
  TYPE(matrix_scalapack),INTENT(inout)     :: results
  COMPLEX(dp), intent(in)                   :: alpha, beta

  CALL PZGEMM('N','N',matrix1%sizeb_global(1),matrix2%sizeb_global(2),&
       &      matrix1%sizeb_global(2),alpha,matrix1%buffer_cplx,1,1, &
       &      matrix1%descript%tab,matrix2%buffer_cplx,1,1, &
       &      matrix2%descript%tab,beta,results%buffer_cplx,1,1, &
       &      results%descript%tab)

END SUBROUTINE matrix_pzgemm


!-------------------------------------------------------
!  Calculation of eigenvalues and eigenvectors
!  Complex and real case
!-------------------------------------------------------
SUBROUTINE compute_eigen_values_vectors(processor,matrix,results,eigen,communicator,istwf_k)

  use defs_scalapack
  use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none
#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

  TYPE(processor_scalapack),INTENT(in)       :: processor
  TYPE(matrix_scalapack),INTENT(in)          :: matrix
  TYPE(matrix_scalapack),INTENT(inout)       :: results
  DOUBLE PRECISION,DIMENSION(:),INTENT(inout) :: eigen
  INTEGER,INTENT(in)  :: communicator,istwf_k

  INTEGER            :: LRWORK,LIWORK,LCWORK,INFO
 
  INTEGER         , dimension(1) :: IWORK_tmp
  DOUBLE PRECISION, dimension(1) :: RWORK_tmp
  COMPLEX(dp)     , dimension(1) :: CWORK_tmp

  INTEGER         , allocatable  :: IWORK(:)
  DOUBLE PRECISION, allocatable  :: RWORK(:)
  COMPLEX(dp)     , allocatable  :: CWORK(:)

  INTEGER,          allocatable :: ICLUSTR(:)
  INTEGER,          allocatable :: IFAIL(:)
  DOUBLE PRECISION, allocatable :: GAP(:)

  DOUBLE PRECISION            :: ABSTOL,ORFAC
  INTEGER,          PARAMETER :: IZERO=0

  INTEGER ::  M,NZ,IA,JA,IZ,JZ,ierr,TWORK_tmp(3),TWORK(3)
  
  DOUBLE PRECISION :: PDLAMCH
  EXTERNAL PDLAMCH

  ! Initialisation
  INFO   = 0 
  IWORK(:) = 0
  RWORK(:) = 0._dp
  CWORK(:) = (0._dp,0._dp)
 
  ABSTOL = PDLAMCH(processor%grid%ictxt,'U')
  ORFAC  = -1.D+0

  ! Allocation of the variables for the results of the calculations
  allocate(IFAIL(matrix%sizeb_global(2)))
  allocate(ICLUSTR(2*processor%grid%dims(1)*processor%grid%dims(2)))
  allocate(GAP(processor%grid%dims(1)*processor%grid%dims(2)))
  
  ! Get the size of the work arrays
  if (istwf_k/=2) then
     CALL PZHEEVX('V','A','U',&
          &      matrix%sizeb_global(2),&
          &      matrix%buffer_cplx,1,1,matrix%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_cplx,1,1,results%descript%tab, &
          &      CWORK_tmp,-1,RWORK_tmp,-1,IWORK_tmp,-1,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  else 
     CALL PDSYEVX('V','A','U',&
          &      matrix%sizeb_global(2),&
          &      matrix%buffer_real,1,1,matrix%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_real,1,1,results%descript%tab, &
          &      RWORK_tmp,-1,IWORK_tmp,-1,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  end if

  if (INFO/=0) then
     write(6,'(A,I)') "Problem to compute workspace to use ScaLAPACK, INFO=",INFO
     !call leave_new('PERS')
  endif

  TWORK_tmp(1) = IWORK_tmp(1)
  TWORK_tmp(2) = INT(RWORK_tmp(1))
  TWORK_tmp(3) = INT(REAL(CWORK_tmp(1)))

 !! Get the maximum of the size of the work arrays processor%comm
  CALL MPI_ALLREDUCE(TWORK_tmp,TWORK,3,MPI_INTEGER,MPI_MAX,communicator,ierr)

  LIWORK = TWORK(1)
  LRWORK = TWORK(2) + matrix%sizeb_global(2) *(matrix%sizeb_global(2)-1)
  LCWORK = TWORK(3)
     
  ! Allocation of the work arrays
  if (LIWORK>0) allocate(IWORK(LIWORK))
  if (LRWORK>0) allocate(RWORK(LRWORK))
  if (LCWORK>0) allocate(CWORK(LCWORK))
 
  ! Call the calculation routine
  if (istwf_k/=2) then
     !write(6,*) 'I am using PZHEEVX'
     CALL PZHEEVX('V','A','U',&
          &      matrix%sizeb_global(2),&
          &      matrix%buffer_cplx,1,1,matrix%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_cplx,1,1,results%descript%tab, &
          &      CWORK,LCWORK,RWORK,LRWORK,IWORK,LIWORK,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  else
     !write(6,*) ' I am using PDSYEVX'
     CALL PDSYEVX('V','A','U',&
          &      matrix%sizeb_global(2),&
          &      matrix%buffer_real,1,1,matrix%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_real,1,1,results%descript%tab, &
          &      RWORK,LRWORK,IWORK,LIWORK,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  endif

  if (INFO/=0) then
     write(6,'(A,I)') "Problem to compute eigenvalues and eigenvectors with ScaLAPACK, INFO=",INFO
     !call leave_new('PERS')
  endif

  deallocate(IFAIl,ICLUSTR,GAP)
  if (allocated(IWORK)) deallocate(IWORK)
  if (allocated(RWORK)) deallocate(RWORK)
  if (allocated(CWORK)) deallocate(CWORK)

END SUBROUTINE compute_eigen_values_vectors

!-------------------------------------------------------
!  Calculation of eigenvalues and eigenvectors
!  A * X = lambda * B * X 
!  CAS COMPLEX et REEL
!-------------------------------------------------------
SUBROUTINE compute_eigen_problem(processor,matrix1,matrix2,results,eigen,communicator,istwf_k)

  use defs_scalapack
  use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none
#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

  TYPE(processor_scalapack),INTENT(in)       :: processor
  TYPE(matrix_scalapack),INTENT(in)          :: matrix1,matrix2
  TYPE(matrix_scalapack),INTENT(inout)       :: results
  DOUBLE PRECISION,DIMENSION(:),INTENT(inout) :: eigen

  INTEGER,INTENT(in)  :: communicator,istwf_k

  INTEGER            :: LRWORK,LIWORK,LCWORK,INFO
 
  INTEGER         , dimension(1) :: IWORK_tmp
  DOUBLE PRECISION, dimension(1) :: RWORK_tmp
  COMPLEX(dp)     , dimension(1) :: CWORK_tmp

  INTEGER         , allocatable  :: IWORK(:)
  DOUBLE PRECISION, allocatable  :: RWORK(:)
  COMPLEX(dp)     , allocatable  :: CWORK(:)


  INTEGER,          allocatable :: ICLUSTR(:)
  INTEGER,          allocatable :: IFAIL(:)
  DOUBLE PRECISION, allocatable :: GAP(:)

  DOUBLE PRECISION            :: ABSTOL,ORFAC
  INTEGER         , PARAMETER :: IZERO=0

  INTEGER ::  M,NZ,IA,JA,IZ,JZ,ierr,TWORK_tmp(3),TWORK(3)

  DOUBLE PRECISION :: PDLAMCH
  EXTERNAL PDLAMCH

  ! Initialisation
  INFO   = 0   
  IWORK(:) = 0
  RWORK(:) = 0._dp
  CWORK(:) = (0._dp,0._dp)

  ABSTOL = PDLAMCH(processor%grid%ictxt,'U')
  ORFAC  = -1.D+0

  ! Allocate the arrays for the results of the calculation
  allocate(IFAIL  (matrix1%sizeb_global(2)))
  allocate(ICLUSTR(2*processor%grid%dims(1)*processor%grid%dims(2)))
  allocate(GAP    (  processor%grid%dims(1)*processor%grid%dims(2)))

  ! Get the size of the work arrays
  if (istwf_k/=2) then
     CALL PZHEGVX(1,'V','A','U',&
          &      matrix1%sizeb_global(2),&
          &      matrix1%buffer_cplx,1,1,matrix1%descript%tab, &
          &      matrix2%buffer_cplx,1,1,matrix2%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_cplx,1,1,results%descript%tab, &
          &      CWORK_tmp,-1,RWORK_tmp,-1,IWORK_tmp,-1,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  else
     CALL PDSYGVX(1,'V','A','U',&
          &      matrix1%sizeb_global(2),&
          &      matrix1%buffer_real,1,1,matrix1%descript%tab, &
          &      matrix2%buffer_real,1,1,matrix2%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_real,1,1,results%descript%tab, &
          &      RWORK_tmp,-1,IWORK_tmp,-1,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  endif

  if (INFO/=0) then
     write(6,'(A,I)') "Problem to compute workspace to use ScaLAPACK, INFO=",INFO
     !call leave_new('PERS')
  endif

  TWORK_tmp(1) = IWORK_tmp(1)
  TWORK_tmp(2) = INT(RWORK_tmp(1)) + matrix1%sizeb_global(2) *(matrix1%sizeb_global(2)-1)
  TWORK_tmp(3) = INT(REAL(CWORK_tmp(1)))
 
 ! Get the maximum of sizes of the work arrays processor%comm 
  CALL MPI_ALLREDUCE(TWORK_tmp,TWORK,3,MPI_INTEGER,MPI_MAX,communicator,ierr)

  LIWORK = TWORK(1)
  LRWORK = TWORK(2)
  LCWORK = TWORK(3)

 ! Allocate the work arrays
  if (LIWORK>0) allocate(IWORK(LIWORK))
  if (LRWORK>0) allocate(RWORK(LRWORK))
  if (LCWORK>0) allocate(CWORK(LCWORK))

  ! Call the calculation routine 
  if (istwf_k/=2) then
     !write(6,*) 'I am using PZHEGVX'
     CALL PZHEGVX(1,'V','A','U',&
          &      matrix1%sizeb_global(2),&
          &      matrix1%buffer_cplx,1,1,matrix1%descript%tab, &
          &      matrix2%buffer_cplx,1,1,matrix2%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_cplx,1,1,results%descript%tab, &
          &      CWORK,LCWORK,RWORK,LRWORK,IWORK,LIWORK,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  else
     !write(6,*) 'I am using PDSYGVX'
     CALL PDSYGVX(1,'V','A','U',&
          &      matrix1%sizeb_global(2),&
          &      matrix1%buffer_real,1,1,matrix1%descript%tab, &
          &      matrix2%buffer_real,1,1,matrix2%descript%tab, &
          &      ZERO,ZERO,IZERO,IZERO,ABSTOL,&
          &      m,nz,eigen,ORFAC, &
          &      results%buffer_real,1,1,results%descript%tab, &
          &      RWORK,LRWORK,IWORK,LIWORK,&
          &      IFAIL,ICLUSTR,GAP,INFO)
  endif
  
  if (INFO/=0) then
     write(6,'(A,I)') "Problem to compute eigen problem with ScaLAPACK, INFO=",INFO
     !call leave_new('PERS')
  endif

  deallocate(IFAIl,ICLUSTR,GAP)
  if (allocated(IWORK)) deallocate(IWORK)
  if (allocated(RWORK)) deallocate(RWORK)
  if (allocated(CWORK)) deallocate(CWORK)

END SUBROUTINE compute_eigen_problem

#else
   SUBROUTINE NO_SCALAPACK


    implicit none
   END SUBROUTINE NO_SCALAPACK
#endif
!!***
