# -*- Autoconf -*-
#
# Copyright (C) 2005-2009 ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-env on 2009/05/27 19:04:13 +0000

#
# Environment variables relevant to ABINIT
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-env
# script. Any change will systematically be overwritten.
#



# ABI_ENV_AC_UPDATE(LANG)
# -----------------------
#
# Updates Autoconf build environment.
#
AC_DEFUN([ABI_ENV_AC_UPDATE],
[dnl Please note that the existing environment will always be overwritten.
 dnl Thus you should save sensistive data before calling this macro.

 dnl Check arguments
 m4_if([$1], [tmp_lang="$1"], [tmp_lang="Fortran"])dnl

 dnl Update linker flags
 case "$1" in
  C)
   LDFLAGS="${CC_LDFLAGS}"
   ;;
  C++)
   LDFLAGS="${CXX_LDFLAGS}"
   ;;
  Fortran)
   LDFLAGS="${FC_LDFLAGS}"
   ;;
 esac

 dnl Update linker additional libs
 LIBS="${CC_LIBS}"
 CXXLIBS="${CXX_LIBS}"
 FCLIBS="${FC_LIBS}"

 unset tmp_lang
]) # ABI_ENV_AC_UPDATE



# ABI_ENV_DEFINE()
# ----------------
#
# Declares ABINIT environment variables and resets the internal
# variables. This is necessary if we want to have external variables
# overriding the contents of the config files.
#
AC_DEFUN([ABI_ENV_DEFINE],
[

 dnl Library archiver flags for 64-bit objects
 ARFLAGS_64BITS=""
 AC_SUBST(ARFLAGS_64BITS)

 dnl Library archiver flags for debugging
 ARFLAGS_DEBUG=""
 AC_SUBST(ARFLAGS_DEBUG)

 dnl Additional library archiver flags
 ARFLAGS_EXTRA=""
 AC_SUBST(ARFLAGS_EXTRA)

 dnl Library archiver flags for optimization
 ARFLAGS_OPT=""
 AC_SUBST(ARFLAGS_OPT)

 dnl C linker flags for 64-bit objects
 CC_LDFLAGS_64BITS=""
 AC_SUBST(CC_LDFLAGS_64BITS)

 dnl C linker flags for debugging
 CC_LDFLAGS_DEBUG=""
 AC_SUBST(CC_LDFLAGS_DEBUG)

 dnl Additional C linker flags
 CC_LDFLAGS_EXTRA=""
 AC_SUBST(CC_LDFLAGS_EXTRA)

 dnl C linker flags for optimization
 CC_LDFLAGS_OPT=""
 AC_SUBST(CC_LDFLAGS_OPT)

 dnl C linker additional libraries for 64-bit objects
 CC_LIBS_64BITS=""
 AC_SUBST(CC_LIBS_64BITS)

 dnl C linker additional libraries for debugging
 CC_LIBS_DEBUG=""
 AC_SUBST(CC_LIBS_DEBUG)

 dnl C linker additional libraries for tricks
 CC_LIBS_EXTRA=""
 AC_SUBST(CC_LIBS_EXTRA)

 dnl C linker additional libraries for optimization
 CC_LIBS_OPT=""
 AC_SUBST(CC_LIBS_OPT)

 dnl C flags for 64-bit objects
 CFLAGS_64BITS=""
 AC_SUBST(CFLAGS_64BITS)

 dnl C compiler flags for debugging
 CFLAGS_DEBUG=""
 AC_SUBST(CFLAGS_DEBUG)

 dnl Additional C compiler flags
 CFLAGS_EXTRA=""
 AC_SUBST(CFLAGS_EXTRA)

 dnl C compiler flags for optimization
 CFLAGS_OPT=""
 AC_SUBST(CFLAGS_OPT)

 dnl C preprocessor flags for 64-bit objects
 CPPFLAGS_64BITS=""
 AC_SUBST(CPPFLAGS_64BITS)

 dnl C preprocessor flags for debugging
 CPPFLAGS_DEBUG=""
 AC_SUBST(CPPFLAGS_DEBUG)

 dnl Additional C preprocessor flags
 CPPFLAGS_EXTRA=""
 AC_SUBST(CPPFLAGS_EXTRA)

 dnl C preprocessor flags for optimization
 CPPFLAGS_OPT=""
 AC_SUBST(CPPFLAGS_OPT)

 dnl C++ linker flags for 64-bit objects
 CXX_LDFLAGS_64BITS=""
 AC_SUBST(CXX_LDFLAGS_64BITS)

 dnl C++ linker flags for debugging
 CXX_LDFLAGS_DEBUG=""
 AC_SUBST(CXX_LDFLAGS_DEBUG)

 dnl Additional C++ linker flags
 CXX_LDFLAGS_EXTRA=""
 AC_SUBST(CXX_LDFLAGS_EXTRA)

 dnl C++ linker flags for optimization
 CXX_LDFLAGS_OPT=""
 AC_SUBST(CXX_LDFLAGS_OPT)

 dnl C++ linker additional libraries for debugging
 CXX_LIBS_DEBUG=""
 AC_SUBST(CXX_LIBS_DEBUG)

 dnl C++ linker additional libraries for 64-bit objects
 CXX_LIBS_64BITS=""
 AC_SUBST(CXX_LIBS_64BITS)

 dnl C++ linker additional libraries for optimization
 CXX_LIBS_OPT=""
 AC_SUBST(CXX_LIBS_OPT)

 dnl C++ linker additional libraries for tricks
 CXX_LIBS_EXTRA=""
 AC_SUBST(CXX_LIBS_EXTRA)

 dnl C++ flags for 64-bit objects
 CXXFLAGS_64BITS=""
 AC_SUBST(CXXFLAGS_64BITS)

 dnl C++ compiler flags for debugging
 CXXFLAGS_DEBUG=""
 AC_SUBST(CXXFLAGS_DEBUG)

 dnl Additional C++ compiler flags
 CXXFLAGS_EXTRA=""
 AC_SUBST(CXXFLAGS_EXTRA)

 dnl C++ compiler flags for optimization
 CXXFLAGS_OPT=""
 AC_SUBST(CXXFLAGS_OPT)

 dnl Fortran linker flags for 64-bit objects
 FC_LDFLAGS_64BITS=""
 AC_SUBST(FC_LDFLAGS_64BITS)

 dnl Fortran linker flags for debugging
 FC_LDFLAGS_DEBUG=""
 AC_SUBST(FC_LDFLAGS_DEBUG)

 dnl Additional Fortran linker flags
 FC_LDFLAGS_EXTRA=""
 AC_SUBST(FC_LDFLAGS_EXTRA)

 dnl Fortran linker flags for optimization
 FC_LDFLAGS_OPT=""
 AC_SUBST(FC_LDFLAGS_OPT)

 dnl Fortran linker additional libraries for 64-bit objects
 FC_LIBS_64BITS=""
 AC_SUBST(FC_LIBS_64BITS)

 dnl Fortran linker additional libraries for debugging
 FC_LIBS_DEBUG=""
 AC_SUBST(FC_LIBS_DEBUG)

 dnl Fortran linker additional libraries for tricks
 FC_LIBS_EXTRA=""
 AC_SUBST(FC_LIBS_EXTRA)

 dnl Fortran linker additional libraries for optimization
 FC_LIBS_OPT=""
 AC_SUBST(FC_LIBS_OPT)

 dnl Fortran flags for 64-bit objects
 FCFLAGS_64BITS=""
 AC_SUBST(FCFLAGS_64BITS)

 dnl Fortran compiler flags for debugging
 FCFLAGS_DEBUG=""
 AC_SUBST(FCFLAGS_DEBUG)

 dnl Additional Fortran compiler flags
 FCFLAGS_EXTRA=""
 AC_SUBST(FCFLAGS_EXTRA)

 dnl Fortran flags for fixed-form source files
 FCFLAGS_FIXEDFORM=""
 AC_SUBST(FCFLAGS_FIXEDFORM)

 dnl Fortran flags for free-form source files
 FCFLAGS_FREEFORM=""
 AC_SUBST(FCFLAGS_FREEFORM)

 dnl Fortran compiler flags for optimization
 FCFLAGS_OPT=""
 AC_SUBST(FCFLAGS_OPT)

 dnl LaTeX flags
 LTXFLAGS=""
 AC_SUBST(LTXFLAGS)

 dnl Markdown text-to-HTML processor flags
 MDFLAGS=""
 AC_SUBST(MDFLAGS)

 dnl MPI C linker flags
 MPI_CC_LDFLAGS=""
 AC_SUBST(MPI_CC_LDFLAGS)

 dnl MPI C linker additional libraries
 MPI_CC_LIBS=""
 AC_SUBST(MPI_CC_LIBS)

 dnl MPI C++ linker additional libraries
 MPI_CXX_LIBS=""
 AC_SUBST(MPI_CXX_LIBS)

 dnl MPI Fortran linker additional libraries
 MPI_FC_LIBS=""
 AC_SUBST(MPI_FC_LIBS)

 dnl MPI C compiler flags
 MPI_CFLAGS=""
 AC_SUBST(MPI_CFLAGS)

 dnl MPI C preprocessor flags
 MPI_CPPFLAGS=""
 AC_SUBST(MPI_CPPFLAGS)

 dnl MPI C++ linker flags
 MPI_CXX_LDFLAGS=""
 AC_SUBST(MPI_CXX_LDFLAGS)

 dnl MPI C++ compiler flags
 MPI_CXXFLAGS=""
 AC_SUBST(MPI_CXXFLAGS)

 dnl MPI Fortran linker flags
 MPI_FC_LDFLAGS=""
 AC_SUBST(MPI_FC_LDFLAGS)

 dnl MPI Fortran compiler flags
 MPI_FCFLAGS=""
 AC_SUBST(MPI_FCFLAGS)

 dnl MPI runner command
 MPI_RUNNER=""
 AC_SUBST(MPI_RUNNER)

 dnl DVI->PDF converter flags
 PDFFLAGS=""
 AC_SUBST(PDFFLAGS)

]) # ABI_ENV_DEFINE



# ABI_ENV_INIT()
# --------------
#
# Sets ABINIT environment variables to their default values.
#
AC_DEFUN([ABI_ENV_INIT],
[

 dnl Library archiver flags for 64-bit objects
 ARFLAGS_64BITS=""

 dnl Library archiver flags for debugging
 ARFLAGS_DEBUG="${with_ar_dbgflags}"

 dnl Additional library archiver flags
 ARFLAGS_EXTRA=""

 dnl Library archiver flags for optimization
 ARFLAGS_OPT="${with_ar_optflags}"

 dnl C linker flags for 64-bit objects
 CC_LDFLAGS_64BITS=""

 dnl C linker flags for debugging
 CC_LDFLAGS_DEBUG="${with_cc_ld_dbgflags}"

 dnl Additional C linker flags
 CC_LDFLAGS_EXTRA=""

 dnl C linker flags for optimization
 CC_LDFLAGS_OPT="${with_cc_ld_optflags}"

 dnl C linker additional libraries for 64-bit objects
 CC_LIBS_64BITS=""

 dnl C linker additional libraries for debugging
 CC_LIBS_DEBUG="${with_cc_ld_dbglibs}"

 dnl C linker additional libraries for tricks
 CC_LIBS_EXTRA=""

 dnl C linker additional libraries for optimization
 CC_LIBS_OPT="${with_cc_ld_optlibs}"

 dnl C flags for 64-bit objects
 CFLAGS_64BITS=""

 dnl C compiler flags for debugging
 CFLAGS_DEBUG="${with_cc_dbgflags}"

 dnl Additional C compiler flags
 CFLAGS_EXTRA=""

 dnl C compiler flags for optimization
 CFLAGS_OPT="${with_cc_optflags}"

 dnl C preprocessor flags for 64-bit objects
 CPPFLAGS_64BITS=""

 dnl C preprocessor flags for debugging
 CPPFLAGS_DEBUG="${with_cpp_dbgflags}"

 dnl Additional C preprocessor flags
 CPPFLAGS_EXTRA=""

 dnl C preprocessor flags for optimization
 CPPFLAGS_OPT="${with_cpp_optflags}"

 dnl C++ linker flags for 64-bit objects
 CXX_LDFLAGS_64BITS=""

 dnl C++ linker flags for debugging
 CXX_LDFLAGS_DEBUG="${with_cxx_ld_dbgflags}"

 dnl Additional C++ linker flags
 CXX_LDFLAGS_EXTRA=""

 dnl C++ linker flags for optimization
 CXX_LDFLAGS_OPT="${with_cxx_ld_optflags}"

 dnl C++ linker additional libraries for debugging
 CXX_LIBS_DEBUG="${with_cxx_ld_dbglibs}"

 dnl C++ linker additional libraries for 64-bit objects
 CXX_LIBS_64BITS=""

 dnl C++ linker additional libraries for optimization
 CXX_LIBS_OPT="${with_cxx_ld_optlibs}"

 dnl C++ linker additional libraries for tricks
 CXX_LIBS_EXTRA=""

 dnl C++ flags for 64-bit objects
 CXXFLAGS_64BITS=""

 dnl C++ compiler flags for debugging
 CXXFLAGS_DEBUG="${with_cxx_dbgflags}"

 dnl Additional C++ compiler flags
 CXXFLAGS_EXTRA=""

 dnl C++ compiler flags for optimization
 CXXFLAGS_OPT="${with_cxx_optflags}"

 dnl Fortran linker flags for 64-bit objects
 FC_LDFLAGS_64BITS=""

 dnl Fortran linker flags for debugging
 FC_LDFLAGS_DEBUG="${with_fc_ld_dbgflags}"

 dnl Additional Fortran linker flags
 FC_LDFLAGS_EXTRA=""

 dnl Fortran linker flags for optimization
 FC_LDFLAGS_OPT="${with_fc_ld_optflags}"

 dnl Fortran linker additional libraries for 64-bit objects
 FC_LIBS_64BITS=""

 dnl Fortran linker additional libraries for debugging
 FC_LIBS_DEBUG="${with_fc_ld_dbglibs}"

 dnl Fortran linker additional libraries for tricks
 FC_LIBS_EXTRA=""

 dnl Fortran linker additional libraries for optimization
 FC_LIBS_OPT="${with_fc_ld_optlibs}"

 dnl Fortran flags for 64-bit objects
 FCFLAGS_64BITS=""

 dnl Fortran compiler flags for debugging
 FCFLAGS_DEBUG="${with_fc_dbgflags}"

 dnl Additional Fortran compiler flags
 FCFLAGS_EXTRA=""

 dnl Fortran flags for fixed-form source files
 FCFLAGS_FIXEDFORM=""

 dnl Fortran flags for free-form source files
 FCFLAGS_FREEFORM=""

 dnl Fortran compiler flags for optimization
 FCFLAGS_OPT="${with_fc_optflags}"

 dnl LaTeX flags
 LTXFLAGS=""

 dnl Markdown text-to-HTML processor flags
 MDFLAGS=""

 dnl MPI C linker flags
 MPI_CC_LDFLAGS="${with_mpi_cc_ldflags}"

 dnl MPI C linker additional libraries
 MPI_CC_LIBS="${with_mpi_cc_libs}"

 dnl MPI C++ linker additional libraries
 MPI_CXX_LIBS="${with_mpi_cxx_libs}"

 dnl MPI Fortran linker additional libraries
 MPI_FC_LIBS="${with_mpi_fc_libs}"

 dnl MPI C compiler flags
 MPI_CFLAGS="${with_mpi_cflags}"

 dnl MPI C preprocessor flags
 MPI_CPPFLAGS="${with_mpi_cppflags}"

 dnl MPI C++ linker flags
 MPI_CXX_LDFLAGS="${with_mpi_cc_ldflags}"

 dnl MPI C++ compiler flags
 MPI_CXXFLAGS="${with_mpi_cxxflags}"

 dnl MPI Fortran linker flags
 MPI_FC_LDFLAGS="${with_mpi_fc_ldflags}"

 dnl MPI Fortran compiler flags
 MPI_FCFLAGS="${with_mpi_fcflags}"

 dnl MPI runner command
 MPI_RUNNER="${with_mpi_runner}"

 dnl DVI->PDF converter flags
 PDFFLAGS=""

]) # ABI_ENV_INIT



# ABI_ENV_BACKUP()
# ----------------
#
# Saves all ABINIT environment variables.
#
AC_DEFUN([ABI_ENV_BACKUP],
[dnl All variables will be saved, yet please note that they may be
 dnl conditionally restored (see ABI_ENV_RECALL for details).

 dnl Save Library archiver
 abi_env_AR="${AR}"

 dnl Save Library archiver flags
 abi_env_ARFLAGS="${ARFLAGS}"

 dnl Save Library archiver flags for 64-bit objects
 abi_env_ARFLAGS_64BITS="${ARFLAGS_64BITS}"

 dnl Save Library archiver flags for debugging
 abi_env_ARFLAGS_DEBUG="${ARFLAGS_DEBUG}"

 dnl Save Additional library archiver flags
 abi_env_ARFLAGS_EXTRA="${ARFLAGS_EXTRA}"

 dnl Save Library archiver flags for optimization
 abi_env_ARFLAGS_OPT="${ARFLAGS_OPT}"

 dnl Save C compiler
 abi_env_CC="${CC}"

 dnl Save C linker flags
 abi_env_CC_LDFLAGS="${CC_LDFLAGS}"

 dnl Save C linker flags for 64-bit objects
 abi_env_CC_LDFLAGS_64BITS="${CC_LDFLAGS_64BITS}"

 dnl Save C linker flags for debugging
 abi_env_CC_LDFLAGS_DEBUG="${CC_LDFLAGS_DEBUG}"

 dnl Save Additional C linker flags
 abi_env_CC_LDFLAGS_EXTRA="${CC_LDFLAGS_EXTRA}"

 dnl Save C linker flags for optimization
 abi_env_CC_LDFLAGS_OPT="${CC_LDFLAGS_OPT}"

 dnl Save C linker additional libraries
 abi_env_CC_LIBS="${CC_LIBS}"

 dnl Save C linker additional libraries for 64-bit objects
 abi_env_CC_LIBS_64BITS="${CC_LIBS_64BITS}"

 dnl Save C linker additional libraries for debugging
 abi_env_CC_LIBS_DEBUG="${CC_LIBS_DEBUG}"

 dnl Save C linker additional libraries for tricks
 abi_env_CC_LIBS_EXTRA="${CC_LIBS_EXTRA}"

 dnl Save C linker additional libraries for optimization
 abi_env_CC_LIBS_OPT="${CC_LIBS_OPT}"

 dnl Save C compiler flags
 abi_env_CFLAGS="${CFLAGS}"

 dnl Save C flags for 64-bit objects
 abi_env_CFLAGS_64BITS="${CFLAGS_64BITS}"

 dnl Save C compiler flags for debugging
 abi_env_CFLAGS_DEBUG="${CFLAGS_DEBUG}"

 dnl Save Additional C compiler flags
 abi_env_CFLAGS_EXTRA="${CFLAGS_EXTRA}"

 dnl Save C compiler flags for optimization
 abi_env_CFLAGS_OPT="${CFLAGS_OPT}"

 dnl Save C preprocessor
 abi_env_CPP="${CPP}"

 dnl Save C preprocessor flags
 abi_env_CPPFLAGS="${CPPFLAGS}"

 dnl Save C preprocessor flags for 64-bit objects
 abi_env_CPPFLAGS_64BITS="${CPPFLAGS_64BITS}"

 dnl Save C preprocessor flags for debugging
 abi_env_CPPFLAGS_DEBUG="${CPPFLAGS_DEBUG}"

 dnl Save Additional C preprocessor flags
 abi_env_CPPFLAGS_EXTRA="${CPPFLAGS_EXTRA}"

 dnl Save C preprocessor flags for optimization
 abi_env_CPPFLAGS_OPT="${CPPFLAGS_OPT}"

 dnl Save C++ compiler
 abi_env_CXX="${CXX}"

 dnl Save C++ linker flags
 abi_env_CXX_LDFLAGS="${CXX_LDFLAGS}"

 dnl Save C++ linker flags for 64-bit objects
 abi_env_CXX_LDFLAGS_64BITS="${CXX_LDFLAGS_64BITS}"

 dnl Save C++ linker flags for debugging
 abi_env_CXX_LDFLAGS_DEBUG="${CXX_LDFLAGS_DEBUG}"

 dnl Save Additional C++ linker flags
 abi_env_CXX_LDFLAGS_EXTRA="${CXX_LDFLAGS_EXTRA}"

 dnl Save C++ linker flags for optimization
 abi_env_CXX_LDFLAGS_OPT="${CXX_LDFLAGS_OPT}"

 dnl Save C++ linker additional libraries
 abi_env_CXX_LIBS="${CXX_LIBS}"

 dnl Save C++ linker additional libraries for debugging
 abi_env_CXX_LIBS_DEBUG="${CXX_LIBS_DEBUG}"

 dnl Save C++ linker additional libraries for 64-bit objects
 abi_env_CXX_LIBS_64BITS="${CXX_LIBS_64BITS}"

 dnl Save C++ linker additional libraries for optimization
 abi_env_CXX_LIBS_OPT="${CXX_LIBS_OPT}"

 dnl Save C++ linker additional libraries for tricks
 abi_env_CXX_LIBS_EXTRA="${CXX_LIBS_EXTRA}"

 dnl Save C++ compiler flags
 abi_env_CXXFLAGS="${CXXFLAGS}"

 dnl Save C++ flags for 64-bit objects
 abi_env_CXXFLAGS_64BITS="${CXXFLAGS_64BITS}"

 dnl Save C++ compiler flags for debugging
 abi_env_CXXFLAGS_DEBUG="${CXXFLAGS_DEBUG}"

 dnl Save Additional C++ compiler flags
 abi_env_CXXFLAGS_EXTRA="${CXXFLAGS_EXTRA}"

 dnl Save C++ compiler flags for optimization
 abi_env_CXXFLAGS_OPT="${CXXFLAGS_OPT}"

 dnl Save C preprocessor definitions
 abi_env_DEFS="${DEFS}"

 dnl Save Fortran compiler
 abi_env_FC="${FC}"

 dnl Save Fortran linker flags
 abi_env_FC_LDFLAGS="${FC_LDFLAGS}"

 dnl Save Fortran linker flags for 64-bit objects
 abi_env_FC_LDFLAGS_64BITS="${FC_LDFLAGS_64BITS}"

 dnl Save Fortran linker flags for debugging
 abi_env_FC_LDFLAGS_DEBUG="${FC_LDFLAGS_DEBUG}"

 dnl Save Additional Fortran linker flags
 abi_env_FC_LDFLAGS_EXTRA="${FC_LDFLAGS_EXTRA}"

 dnl Save Fortran linker flags for optimization
 abi_env_FC_LDFLAGS_OPT="${FC_LDFLAGS_OPT}"

 dnl Save Fortran linker additional libraries
 abi_env_FC_LIBS="${FC_LIBS}"

 dnl Save Fortran linker additional libraries for 64-bit objects
 abi_env_FC_LIBS_64BITS="${FC_LIBS_64BITS}"

 dnl Save Fortran linker additional libraries for debugging
 abi_env_FC_LIBS_DEBUG="${FC_LIBS_DEBUG}"

 dnl Save Fortran linker additional libraries for tricks
 abi_env_FC_LIBS_EXTRA="${FC_LIBS_EXTRA}"

 dnl Save Fortran linker additional libraries for optimization
 abi_env_FC_LIBS_OPT="${FC_LIBS_OPT}"

 dnl Save Fortran compiler flags
 abi_env_FCFLAGS="${FCFLAGS}"

 dnl Save Fortran flags for 64-bit objects
 abi_env_FCFLAGS_64BITS="${FCFLAGS_64BITS}"

 dnl Save Fortran compiler flags for debugging
 abi_env_FCFLAGS_DEBUG="${FCFLAGS_DEBUG}"

 dnl Save Additional Fortran compiler flags
 abi_env_FCFLAGS_EXTRA="${FCFLAGS_EXTRA}"

 dnl Save Fortran flags for fixed-form source files
 abi_env_FCFLAGS_FIXEDFORM="${FCFLAGS_FIXEDFORM}"

 dnl Save Fortran flags for free-form source files
 abi_env_FCFLAGS_FREEFORM="${FCFLAGS_FREEFORM}"

 dnl Save Fortran compiler flags for optimization
 abi_env_FCFLAGS_OPT="${FCFLAGS_OPT}"

 dnl Save LaTeX flags
 abi_env_LTXFLAGS="${LTXFLAGS}"

 dnl Save Markdown text-to-HTML processor flags
 abi_env_MDFLAGS="${MDFLAGS}"

 dnl Save MPI C linker flags
 abi_env_MPI_CC_LDFLAGS="${MPI_CC_LDFLAGS}"

 dnl Save MPI C linker additional libraries
 abi_env_MPI_CC_LIBS="${MPI_CC_LIBS}"

 dnl Save MPI C++ linker additional libraries
 abi_env_MPI_CXX_LIBS="${MPI_CXX_LIBS}"

 dnl Save MPI Fortran linker additional libraries
 abi_env_MPI_FC_LIBS="${MPI_FC_LIBS}"

 dnl Save MPI C compiler flags
 abi_env_MPI_CFLAGS="${MPI_CFLAGS}"

 dnl Save MPI C preprocessor flags
 abi_env_MPI_CPPFLAGS="${MPI_CPPFLAGS}"

 dnl Save MPI C++ linker flags
 abi_env_MPI_CXX_LDFLAGS="${MPI_CXX_LDFLAGS}"

 dnl Save MPI C++ compiler flags
 abi_env_MPI_CXXFLAGS="${MPI_CXXFLAGS}"

 dnl Save MPI Fortran linker flags
 abi_env_MPI_FC_LDFLAGS="${MPI_FC_LDFLAGS}"

 dnl Save MPI Fortran compiler flags
 abi_env_MPI_FCFLAGS="${MPI_FCFLAGS}"

 dnl Save MPI runner command
 abi_env_MPI_RUNNER="${MPI_RUNNER}"

 dnl Save DVI->PDF converter flags
 abi_env_PDFFLAGS="${PDFFLAGS}"

]) # ABI_ENV_BACKUP



# ABI_ENV_RECALL()
# ----------------
#
# Restores all previously-saved non-empty ABINIT environment variables.
#
AC_DEFUN([ABI_ENV_RECALL],
[dnl The following ensures that non-empty environment variables always override
 dnl what is read from the config files.

 dnl Recall Library archiver
 test "${abi_env_AR}" != "" && \
  AR="${abi_env_AR}"

 dnl Recall Library archiver flags
 test "${abi_env_ARFLAGS}" != "" && \
  ARFLAGS="${abi_env_ARFLAGS}"

 dnl Recall Library archiver flags for 64-bit objects
 test "${abi_env_ARFLAGS_64BITS}" != "" && \
  ARFLAGS_64BITS="${abi_env_ARFLAGS_64BITS}"

 dnl Recall Library archiver flags for debugging
 test "${abi_env_ARFLAGS_DEBUG}" != "" && \
  ARFLAGS_DEBUG="${abi_env_ARFLAGS_DEBUG}"

 dnl Recall Additional library archiver flags
 test "${abi_env_ARFLAGS_EXTRA}" != "" && \
  ARFLAGS_EXTRA="${abi_env_ARFLAGS_EXTRA}"

 dnl Recall Library archiver flags for optimization
 test "${abi_env_ARFLAGS_OPT}" != "" && \
  ARFLAGS_OPT="${abi_env_ARFLAGS_OPT}"

 dnl Recall C compiler
 test "${abi_env_CC}" != "" && \
  CC="${abi_env_CC}"

 dnl Recall C linker flags
 test "${abi_env_CC_LDFLAGS}" != "" && \
  CC_LDFLAGS="${abi_env_CC_LDFLAGS}"

 dnl Recall C linker flags for 64-bit objects
 test "${abi_env_CC_LDFLAGS_64BITS}" != "" && \
  CC_LDFLAGS_64BITS="${abi_env_CC_LDFLAGS_64BITS}"

 dnl Recall C linker flags for debugging
 test "${abi_env_CC_LDFLAGS_DEBUG}" != "" && \
  CC_LDFLAGS_DEBUG="${abi_env_CC_LDFLAGS_DEBUG}"

 dnl Recall Additional C linker flags
 test "${abi_env_CC_LDFLAGS_EXTRA}" != "" && \
  CC_LDFLAGS_EXTRA="${abi_env_CC_LDFLAGS_EXTRA}"

 dnl Recall C linker flags for optimization
 test "${abi_env_CC_LDFLAGS_OPT}" != "" && \
  CC_LDFLAGS_OPT="${abi_env_CC_LDFLAGS_OPT}"

 dnl Recall C linker additional libraries
 test "${abi_env_CC_LIBS}" != "" && \
  CC_LIBS="${abi_env_CC_LIBS}"

 dnl Recall C linker additional libraries for 64-bit objects
 test "${abi_env_CC_LIBS_64BITS}" != "" && \
  CC_LIBS_64BITS="${abi_env_CC_LIBS_64BITS}"

 dnl Recall C linker additional libraries for debugging
 test "${abi_env_CC_LIBS_DEBUG}" != "" && \
  CC_LIBS_DEBUG="${abi_env_CC_LIBS_DEBUG}"

 dnl Recall C linker additional libraries for tricks
 test "${abi_env_CC_LIBS_EXTRA}" != "" && \
  CC_LIBS_EXTRA="${abi_env_CC_LIBS_EXTRA}"

 dnl Recall C linker additional libraries for optimization
 test "${abi_env_CC_LIBS_OPT}" != "" && \
  CC_LIBS_OPT="${abi_env_CC_LIBS_OPT}"

 dnl Recall C compiler flags
 test "${abi_env_CFLAGS}" != "" && \
  CFLAGS="${abi_env_CFLAGS}"

 dnl Recall C flags for 64-bit objects
 test "${abi_env_CFLAGS_64BITS}" != "" && \
  CFLAGS_64BITS="${abi_env_CFLAGS_64BITS}"

 dnl Recall C compiler flags for debugging
 test "${abi_env_CFLAGS_DEBUG}" != "" && \
  CFLAGS_DEBUG="${abi_env_CFLAGS_DEBUG}"

 dnl Recall Additional C compiler flags
 test "${abi_env_CFLAGS_EXTRA}" != "" && \
  CFLAGS_EXTRA="${abi_env_CFLAGS_EXTRA}"

 dnl Recall C compiler flags for optimization
 test "${abi_env_CFLAGS_OPT}" != "" && \
  CFLAGS_OPT="${abi_env_CFLAGS_OPT}"

 dnl Recall C preprocessor
 test "${abi_env_CPP}" != "" && \
  CPP="${abi_env_CPP}"

 dnl Recall C preprocessor flags
 test "${abi_env_CPPFLAGS}" != "" && \
  CPPFLAGS="${abi_env_CPPFLAGS}"

 dnl Recall C preprocessor flags for 64-bit objects
 test "${abi_env_CPPFLAGS_64BITS}" != "" && \
  CPPFLAGS_64BITS="${abi_env_CPPFLAGS_64BITS}"

 dnl Recall C preprocessor flags for debugging
 test "${abi_env_CPPFLAGS_DEBUG}" != "" && \
  CPPFLAGS_DEBUG="${abi_env_CPPFLAGS_DEBUG}"

 dnl Recall Additional C preprocessor flags
 test "${abi_env_CPPFLAGS_EXTRA}" != "" && \
  CPPFLAGS_EXTRA="${abi_env_CPPFLAGS_EXTRA}"

 dnl Recall C preprocessor flags for optimization
 test "${abi_env_CPPFLAGS_OPT}" != "" && \
  CPPFLAGS_OPT="${abi_env_CPPFLAGS_OPT}"

 dnl Recall C++ compiler
 test "${abi_env_CXX}" != "" && \
  CXX="${abi_env_CXX}"

 dnl Recall C++ linker flags
 test "${abi_env_CXX_LDFLAGS}" != "" && \
  CXX_LDFLAGS="${abi_env_CXX_LDFLAGS}"

 dnl Recall C++ linker flags for 64-bit objects
 test "${abi_env_CXX_LDFLAGS_64BITS}" != "" && \
  CXX_LDFLAGS_64BITS="${abi_env_CXX_LDFLAGS_64BITS}"

 dnl Recall C++ linker flags for debugging
 test "${abi_env_CXX_LDFLAGS_DEBUG}" != "" && \
  CXX_LDFLAGS_DEBUG="${abi_env_CXX_LDFLAGS_DEBUG}"

 dnl Recall Additional C++ linker flags
 test "${abi_env_CXX_LDFLAGS_EXTRA}" != "" && \
  CXX_LDFLAGS_EXTRA="${abi_env_CXX_LDFLAGS_EXTRA}"

 dnl Recall C++ linker flags for optimization
 test "${abi_env_CXX_LDFLAGS_OPT}" != "" && \
  CXX_LDFLAGS_OPT="${abi_env_CXX_LDFLAGS_OPT}"

 dnl Recall C++ linker additional libraries
 test "${abi_env_CXX_LIBS}" != "" && \
  CXX_LIBS="${abi_env_CXX_LIBS}"

 dnl Recall C++ linker additional libraries for debugging
 test "${abi_env_CXX_LIBS_DEBUG}" != "" && \
  CXX_LIBS_DEBUG="${abi_env_CXX_LIBS_DEBUG}"

 dnl Recall C++ linker additional libraries for 64-bit objects
 test "${abi_env_CXX_LIBS_64BITS}" != "" && \
  CXX_LIBS_64BITS="${abi_env_CXX_LIBS_64BITS}"

 dnl Recall C++ linker additional libraries for optimization
 test "${abi_env_CXX_LIBS_OPT}" != "" && \
  CXX_LIBS_OPT="${abi_env_CXX_LIBS_OPT}"

 dnl Recall C++ linker additional libraries for tricks
 test "${abi_env_CXX_LIBS_EXTRA}" != "" && \
  CXX_LIBS_EXTRA="${abi_env_CXX_LIBS_EXTRA}"

 dnl Recall C++ compiler flags
 test "${abi_env_CXXFLAGS}" != "" && \
  CXXFLAGS="${abi_env_CXXFLAGS}"

 dnl Recall C++ flags for 64-bit objects
 test "${abi_env_CXXFLAGS_64BITS}" != "" && \
  CXXFLAGS_64BITS="${abi_env_CXXFLAGS_64BITS}"

 dnl Recall C++ compiler flags for debugging
 test "${abi_env_CXXFLAGS_DEBUG}" != "" && \
  CXXFLAGS_DEBUG="${abi_env_CXXFLAGS_DEBUG}"

 dnl Recall Additional C++ compiler flags
 test "${abi_env_CXXFLAGS_EXTRA}" != "" && \
  CXXFLAGS_EXTRA="${abi_env_CXXFLAGS_EXTRA}"

 dnl Recall C++ compiler flags for optimization
 test "${abi_env_CXXFLAGS_OPT}" != "" && \
  CXXFLAGS_OPT="${abi_env_CXXFLAGS_OPT}"

 dnl Recall C preprocessor definitions
 test "${abi_env_DEFS}" != "" && \
  DEFS="${abi_env_DEFS}"

 dnl Recall Fortran compiler
 test "${abi_env_FC}" != "" && \
  FC="${abi_env_FC}"

 dnl Recall Fortran linker flags
 test "${abi_env_FC_LDFLAGS}" != "" && \
  FC_LDFLAGS="${abi_env_FC_LDFLAGS}"

 dnl Recall Fortran linker flags for 64-bit objects
 test "${abi_env_FC_LDFLAGS_64BITS}" != "" && \
  FC_LDFLAGS_64BITS="${abi_env_FC_LDFLAGS_64BITS}"

 dnl Recall Fortran linker flags for debugging
 test "${abi_env_FC_LDFLAGS_DEBUG}" != "" && \
  FC_LDFLAGS_DEBUG="${abi_env_FC_LDFLAGS_DEBUG}"

 dnl Recall Additional Fortran linker flags
 test "${abi_env_FC_LDFLAGS_EXTRA}" != "" && \
  FC_LDFLAGS_EXTRA="${abi_env_FC_LDFLAGS_EXTRA}"

 dnl Recall Fortran linker flags for optimization
 test "${abi_env_FC_LDFLAGS_OPT}" != "" && \
  FC_LDFLAGS_OPT="${abi_env_FC_LDFLAGS_OPT}"

 dnl Recall Fortran linker additional libraries
 test "${abi_env_FC_LIBS}" != "" && \
  FC_LIBS="${abi_env_FC_LIBS}"

 dnl Recall Fortran linker additional libraries for 64-bit objects
 test "${abi_env_FC_LIBS_64BITS}" != "" && \
  FC_LIBS_64BITS="${abi_env_FC_LIBS_64BITS}"

 dnl Recall Fortran linker additional libraries for debugging
 test "${abi_env_FC_LIBS_DEBUG}" != "" && \
  FC_LIBS_DEBUG="${abi_env_FC_LIBS_DEBUG}"

 dnl Recall Fortran linker additional libraries for tricks
 test "${abi_env_FC_LIBS_EXTRA}" != "" && \
  FC_LIBS_EXTRA="${abi_env_FC_LIBS_EXTRA}"

 dnl Recall Fortran linker additional libraries for optimization
 test "${abi_env_FC_LIBS_OPT}" != "" && \
  FC_LIBS_OPT="${abi_env_FC_LIBS_OPT}"

 dnl Recall Fortran compiler flags
 test "${abi_env_FCFLAGS}" != "" && \
  FCFLAGS="${abi_env_FCFLAGS}"

 dnl Recall Fortran flags for 64-bit objects
 test "${abi_env_FCFLAGS_64BITS}" != "" && \
  FCFLAGS_64BITS="${abi_env_FCFLAGS_64BITS}"

 dnl Recall Fortran compiler flags for debugging
 test "${abi_env_FCFLAGS_DEBUG}" != "" && \
  FCFLAGS_DEBUG="${abi_env_FCFLAGS_DEBUG}"

 dnl Recall Additional Fortran compiler flags
 test "${abi_env_FCFLAGS_EXTRA}" != "" && \
  FCFLAGS_EXTRA="${abi_env_FCFLAGS_EXTRA}"

 dnl Recall Fortran flags for fixed-form source files
 test "${abi_env_FCFLAGS_FIXEDFORM}" != "" && \
  FCFLAGS_FIXEDFORM="${abi_env_FCFLAGS_FIXEDFORM}"

 dnl Recall Fortran flags for free-form source files
 test "${abi_env_FCFLAGS_FREEFORM}" != "" && \
  FCFLAGS_FREEFORM="${abi_env_FCFLAGS_FREEFORM}"

 dnl Recall Fortran compiler flags for optimization
 test "${abi_env_FCFLAGS_OPT}" != "" && \
  FCFLAGS_OPT="${abi_env_FCFLAGS_OPT}"

 dnl Recall LaTeX flags
 test "${abi_env_LTXFLAGS}" != "" && \
  LTXFLAGS="${abi_env_LTXFLAGS}"

 dnl Recall Markdown text-to-HTML processor flags
 test "${abi_env_MDFLAGS}" != "" && \
  MDFLAGS="${abi_env_MDFLAGS}"

 dnl Recall MPI C linker flags
 test "${abi_env_MPI_CC_LDFLAGS}" != "" && \
  MPI_CC_LDFLAGS="${abi_env_MPI_CC_LDFLAGS}"

 dnl Recall MPI C linker additional libraries
 test "${abi_env_MPI_CC_LIBS}" != "" && \
  MPI_CC_LIBS="${abi_env_MPI_CC_LIBS}"

 dnl Recall MPI C++ linker additional libraries
 test "${abi_env_MPI_CXX_LIBS}" != "" && \
  MPI_CXX_LIBS="${abi_env_MPI_CXX_LIBS}"

 dnl Recall MPI Fortran linker additional libraries
 test "${abi_env_MPI_FC_LIBS}" != "" && \
  MPI_FC_LIBS="${abi_env_MPI_FC_LIBS}"

 dnl Recall MPI C compiler flags
 test "${abi_env_MPI_CFLAGS}" != "" && \
  MPI_CFLAGS="${abi_env_MPI_CFLAGS}"

 dnl Recall MPI C preprocessor flags
 test "${abi_env_MPI_CPPFLAGS}" != "" && \
  MPI_CPPFLAGS="${abi_env_MPI_CPPFLAGS}"

 dnl Recall MPI C++ linker flags
 test "${abi_env_MPI_CXX_LDFLAGS}" != "" && \
  MPI_CXX_LDFLAGS="${abi_env_MPI_CXX_LDFLAGS}"

 dnl Recall MPI C++ compiler flags
 test "${abi_env_MPI_CXXFLAGS}" != "" && \
  MPI_CXXFLAGS="${abi_env_MPI_CXXFLAGS}"

 dnl Recall MPI Fortran linker flags
 test "${abi_env_MPI_FC_LDFLAGS}" != "" && \
  MPI_FC_LDFLAGS="${abi_env_MPI_FC_LDFLAGS}"

 dnl Recall MPI Fortran compiler flags
 test "${abi_env_MPI_FCFLAGS}" != "" && \
  MPI_FCFLAGS="${abi_env_MPI_FCFLAGS}"

 dnl Recall MPI runner command
 test "${abi_env_MPI_RUNNER}" != "" && \
  MPI_RUNNER="${abi_env_MPI_RUNNER}"

 dnl Recall DVI->PDF converter flags
 test "${abi_env_PDFFLAGS}" != "" && \
  PDFFLAGS="${abi_env_PDFFLAGS}"

]) # ABI_ENV_RECALL



# ABI_ENV_RESTORE()
# -----------------
#
# Restores all previously-saved ABINIT environment variables.
#
AC_DEFUN([ABI_ENV_RESTORE],
[dnl The following ensures that non-empty environment variables always override
 dnl what is read from the config files.

 dnl Restore Library archiver
 AR="${abi_env_AR}"

 dnl Restore Library archiver flags
 ARFLAGS="${abi_env_ARFLAGS}"

 dnl Restore Library archiver flags for 64-bit objects
 ARFLAGS_64BITS="${abi_env_ARFLAGS_64BITS}"

 dnl Restore Library archiver flags for debugging
 ARFLAGS_DEBUG="${abi_env_ARFLAGS_DEBUG}"

 dnl Restore Additional library archiver flags
 ARFLAGS_EXTRA="${abi_env_ARFLAGS_EXTRA}"

 dnl Restore Library archiver flags for optimization
 ARFLAGS_OPT="${abi_env_ARFLAGS_OPT}"

 dnl Restore C compiler
 CC="${abi_env_CC}"

 dnl Restore C linker flags
 CC_LDFLAGS="${abi_env_CC_LDFLAGS}"

 dnl Restore C linker flags for 64-bit objects
 CC_LDFLAGS_64BITS="${abi_env_CC_LDFLAGS_64BITS}"

 dnl Restore C linker flags for debugging
 CC_LDFLAGS_DEBUG="${abi_env_CC_LDFLAGS_DEBUG}"

 dnl Restore Additional C linker flags
 CC_LDFLAGS_EXTRA="${abi_env_CC_LDFLAGS_EXTRA}"

 dnl Restore C linker flags for optimization
 CC_LDFLAGS_OPT="${abi_env_CC_LDFLAGS_OPT}"

 dnl Restore C linker additional libraries
 CC_LIBS="${abi_env_CC_LIBS}"

 dnl Restore C linker additional libraries for 64-bit objects
 CC_LIBS_64BITS="${abi_env_CC_LIBS_64BITS}"

 dnl Restore C linker additional libraries for debugging
 CC_LIBS_DEBUG="${abi_env_CC_LIBS_DEBUG}"

 dnl Restore C linker additional libraries for tricks
 CC_LIBS_EXTRA="${abi_env_CC_LIBS_EXTRA}"

 dnl Restore C linker additional libraries for optimization
 CC_LIBS_OPT="${abi_env_CC_LIBS_OPT}"

 dnl Restore C compiler flags
 CFLAGS="${abi_env_CFLAGS}"

 dnl Restore C flags for 64-bit objects
 CFLAGS_64BITS="${abi_env_CFLAGS_64BITS}"

 dnl Restore C compiler flags for debugging
 CFLAGS_DEBUG="${abi_env_CFLAGS_DEBUG}"

 dnl Restore Additional C compiler flags
 CFLAGS_EXTRA="${abi_env_CFLAGS_EXTRA}"

 dnl Restore C compiler flags for optimization
 CFLAGS_OPT="${abi_env_CFLAGS_OPT}"

 dnl Restore C preprocessor
 CPP="${abi_env_CPP}"

 dnl Restore C preprocessor flags
 CPPFLAGS="${abi_env_CPPFLAGS}"

 dnl Restore C preprocessor flags for 64-bit objects
 CPPFLAGS_64BITS="${abi_env_CPPFLAGS_64BITS}"

 dnl Restore C preprocessor flags for debugging
 CPPFLAGS_DEBUG="${abi_env_CPPFLAGS_DEBUG}"

 dnl Restore Additional C preprocessor flags
 CPPFLAGS_EXTRA="${abi_env_CPPFLAGS_EXTRA}"

 dnl Restore C preprocessor flags for optimization
 CPPFLAGS_OPT="${abi_env_CPPFLAGS_OPT}"

 dnl Restore C++ compiler
 CXX="${abi_env_CXX}"

 dnl Restore C++ linker flags
 CXX_LDFLAGS="${abi_env_CXX_LDFLAGS}"

 dnl Restore C++ linker flags for 64-bit objects
 CXX_LDFLAGS_64BITS="${abi_env_CXX_LDFLAGS_64BITS}"

 dnl Restore C++ linker flags for debugging
 CXX_LDFLAGS_DEBUG="${abi_env_CXX_LDFLAGS_DEBUG}"

 dnl Restore Additional C++ linker flags
 CXX_LDFLAGS_EXTRA="${abi_env_CXX_LDFLAGS_EXTRA}"

 dnl Restore C++ linker flags for optimization
 CXX_LDFLAGS_OPT="${abi_env_CXX_LDFLAGS_OPT}"

 dnl Restore C++ linker additional libraries
 CXX_LIBS="${abi_env_CXX_LIBS}"

 dnl Restore C++ linker additional libraries for debugging
 CXX_LIBS_DEBUG="${abi_env_CXX_LIBS_DEBUG}"

 dnl Restore C++ linker additional libraries for 64-bit objects
 CXX_LIBS_64BITS="${abi_env_CXX_LIBS_64BITS}"

 dnl Restore C++ linker additional libraries for optimization
 CXX_LIBS_OPT="${abi_env_CXX_LIBS_OPT}"

 dnl Restore C++ linker additional libraries for tricks
 CXX_LIBS_EXTRA="${abi_env_CXX_LIBS_EXTRA}"

 dnl Restore C++ compiler flags
 CXXFLAGS="${abi_env_CXXFLAGS}"

 dnl Restore C++ flags for 64-bit objects
 CXXFLAGS_64BITS="${abi_env_CXXFLAGS_64BITS}"

 dnl Restore C++ compiler flags for debugging
 CXXFLAGS_DEBUG="${abi_env_CXXFLAGS_DEBUG}"

 dnl Restore Additional C++ compiler flags
 CXXFLAGS_EXTRA="${abi_env_CXXFLAGS_EXTRA}"

 dnl Restore C++ compiler flags for optimization
 CXXFLAGS_OPT="${abi_env_CXXFLAGS_OPT}"

 dnl Restore C preprocessor definitions
 DEFS="${abi_env_DEFS}"

 dnl Restore Fortran compiler
 FC="${abi_env_FC}"

 dnl Restore Fortran linker flags
 FC_LDFLAGS="${abi_env_FC_LDFLAGS}"

 dnl Restore Fortran linker flags for 64-bit objects
 FC_LDFLAGS_64BITS="${abi_env_FC_LDFLAGS_64BITS}"

 dnl Restore Fortran linker flags for debugging
 FC_LDFLAGS_DEBUG="${abi_env_FC_LDFLAGS_DEBUG}"

 dnl Restore Additional Fortran linker flags
 FC_LDFLAGS_EXTRA="${abi_env_FC_LDFLAGS_EXTRA}"

 dnl Restore Fortran linker flags for optimization
 FC_LDFLAGS_OPT="${abi_env_FC_LDFLAGS_OPT}"

 dnl Restore Fortran linker additional libraries
 FC_LIBS="${abi_env_FC_LIBS}"

 dnl Restore Fortran linker additional libraries for 64-bit objects
 FC_LIBS_64BITS="${abi_env_FC_LIBS_64BITS}"

 dnl Restore Fortran linker additional libraries for debugging
 FC_LIBS_DEBUG="${abi_env_FC_LIBS_DEBUG}"

 dnl Restore Fortran linker additional libraries for tricks
 FC_LIBS_EXTRA="${abi_env_FC_LIBS_EXTRA}"

 dnl Restore Fortran linker additional libraries for optimization
 FC_LIBS_OPT="${abi_env_FC_LIBS_OPT}"

 dnl Restore Fortran compiler flags
 FCFLAGS="${abi_env_FCFLAGS}"

 dnl Restore Fortran flags for 64-bit objects
 FCFLAGS_64BITS="${abi_env_FCFLAGS_64BITS}"

 dnl Restore Fortran compiler flags for debugging
 FCFLAGS_DEBUG="${abi_env_FCFLAGS_DEBUG}"

 dnl Restore Additional Fortran compiler flags
 FCFLAGS_EXTRA="${abi_env_FCFLAGS_EXTRA}"

 dnl Restore Fortran flags for fixed-form source files
 FCFLAGS_FIXEDFORM="${abi_env_FCFLAGS_FIXEDFORM}"

 dnl Restore Fortran flags for free-form source files
 FCFLAGS_FREEFORM="${abi_env_FCFLAGS_FREEFORM}"

 dnl Restore Fortran compiler flags for optimization
 FCFLAGS_OPT="${abi_env_FCFLAGS_OPT}"

 dnl Restore LaTeX flags
 LTXFLAGS="${abi_env_LTXFLAGS}"

 dnl Restore Markdown text-to-HTML processor flags
 MDFLAGS="${abi_env_MDFLAGS}"

 dnl Restore MPI C linker flags
 MPI_CC_LDFLAGS="${abi_env_MPI_CC_LDFLAGS}"

 dnl Restore MPI C linker additional libraries
 MPI_CC_LIBS="${abi_env_MPI_CC_LIBS}"

 dnl Restore MPI C++ linker additional libraries
 MPI_CXX_LIBS="${abi_env_MPI_CXX_LIBS}"

 dnl Restore MPI Fortran linker additional libraries
 MPI_FC_LIBS="${abi_env_MPI_FC_LIBS}"

 dnl Restore MPI C compiler flags
 MPI_CFLAGS="${abi_env_MPI_CFLAGS}"

 dnl Restore MPI C preprocessor flags
 MPI_CPPFLAGS="${abi_env_MPI_CPPFLAGS}"

 dnl Restore MPI C++ linker flags
 MPI_CXX_LDFLAGS="${abi_env_MPI_CXX_LDFLAGS}"

 dnl Restore MPI C++ compiler flags
 MPI_CXXFLAGS="${abi_env_MPI_CXXFLAGS}"

 dnl Restore MPI Fortran linker flags
 MPI_FC_LDFLAGS="${abi_env_MPI_FC_LDFLAGS}"

 dnl Restore MPI Fortran compiler flags
 MPI_FCFLAGS="${abi_env_MPI_FCFLAGS}"

 dnl Restore MPI runner command
 MPI_RUNNER="${abi_env_MPI_RUNNER}"

 dnl Restore DVI->PDF converter flags
 PDFFLAGS="${abi_env_PDFFLAGS}"

]) # ABI_ENV_RESTORE
