#
# Makefile for the parser bindings of ABINIT
#

VPATH = $(abinit_srcdir)/bindings/parser

include ../../config.mk

all: libabinis.a python

libabinit_tmpdir = tmp-libabinis-objects
libabinis.a: libbindings.a 
	test -e "$(libabinit_tmpdir)" || \
	$(MKDIR_P) $(libabinit_tmpdir)
	cd $(libabinit_tmpdir) && $(AR) x ../../../src/libs/libabibase.a
	cd $(libabinit_tmpdir) && $(AR) x ../libbindings.a
	$(AR) $(ARFLAGS) libabinis.a $(libabinit_tmpdir)/*
	rm -rf $(libabinit_tmpdir)

dtset_c.h dtset_c.static.h dtset_py.h dtset_f90.inc ab_dtset_f90_get.f90: dtset.pickle parse_dtset.py
	$(abinit_srcdir)/bindings/parser/parse_dtset.py

ab_dtset_c.o: ab_dtset_c.c ab_dtset_c.h dtset_c.h dtset_c.static.h
	$(CC) $(CPPFLAGS) -I. -I$(abinit_builddir) $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab_dtset_c.c

ab_dtset_f90.o: ab_dtset_f90.f90 dtset_f90.inc ab_dtset_f90_get.f90
	$(FC) $(CPPFLAGS) -I. -I$(abinit_builddir)/src/defs -I$(abinit_builddir)/src/13iovars $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/ab_dtset_f90.f90

dtsetinit.o: dtsetinit.F90
	$(FC) $(CPPFLAGS) -I. -I$(abinit_builddir)/src/defs $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/dtsetinit.F90

libbindings.a: ab_dtset_c.o ab_dtset_f90.o dtsetinit.o
	$(AR) $(ARFLAGS) libbindings.a ab_dtset_c.o ab_dtset_f90.o dtsetinit.o
	$(RANLIB) libbindings.a

ab_dtset_py.o: dtset_py.h ab_dtset_c.h ab_dtset_py.c
	$(CC) $(CPPFLAGS) $(PYTHON_CPPFLAGS) -I. $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab_dtset_py.c


python: ab_dtset_py.o
	$(FC) -shared -o abinit.so ab_dtset_py.o -L. -lbindings -L$(abinit_builddir)/src/libs -labibase



examples: example-c example-f90

example-c: example-c.c fallbacks.o libabinis.a
	$(FC) -o example-c -I. $(abinit_srcdir)/bindings/parser/example-c.c libabinis.a fallbacks.o

example-f90: example-f90.f90 fallbacks.o libabinis.a
	$(FC) -I. -I$(abinit_builddir)/src/defs $(FCFLAGS) -o example-f90 $(abinit_srcdir)/bindings/parser/example-f90.f90 fallbacks.o -L. -lbindings -L$(abinit_builddir)/src/libs -labibase

fallbacks.o: fallbacks.f90
	$(FC) -I. -I$(abinit_builddir)/src/defs $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/fallbacks.f90

clean:
	rm -f *.o *.mod libbindings.a libabinis.a
	rm -f abinit.so
	rm -f example-c example-f90
	rm -f dtset_c.h dtset_c.static.h dtset_py.h dtset_f90.inc ab_dtset_f90_get.f90

