#!/usr/bin/env python

import sys, os
import cPickle

# dtset.pickle will one time be generated by abilint...
dtset = cPickle.load(open(os.path.join(os.path.dirname(sys.argv[0]), "dtset.pickle"),"r"))

# Create the flags for the C/F90 bindings.
comment = "This file has been automatically generated, do not modify."
F90 = "! %s\n" % comment
C   = "/* %s */\n" % comment
C  += "#ifndef DTSET_C_H\n"
C  += "#define DTSET_C_H\n"
C  += "\n"
C  += "typedef enum\n"
C  += "{\n"
Cs  = "/* %s */\n" % comment
Cs += "#ifndef DTSET_C_STATIC_H\n"
Cs += "#define DTSET_C_STATIC_H\n"
Cs += "\n"
Py  = "static PyObject* DictIds = NULL;\n"
Py += "static void _init_dict_ids(void)\n"
Py += "{\n"
Py += "  DictIds = PyDict_New();\n"
Py += "\n"
Cd  = ""
Ct  = ""
n = 0
for (key, descr) in dtset.iteritems():
  attType = "_OTHER"
  if (descr[-1].find("(") < 0):
    if (descr[0] == "integer"):
      attType = "_INT_SCALAR"
    elif (descr[0] == "real(dp)"):
      attType = "_DOUBLE_SCALAR"
  else:
    if (descr[0].startswith("integer")):
      attType = "_INT_ARRAY"
    elif (descr[0].startswith("real(dp)")):
      attType = "_DOUBLE_ARRAY"
  if (attType is not None):
    Cd  += "  AB_DTSET_%-15s,  /* %-15s */\n" % (key.upper(), attType)
    Ct  += "           %-15s,  /* %-15s */\n" % (attType, key)
    F90 += "integer, parameter, public :: ab_dtset_%-15s = %5d\n" % (key, n)  
    Py  += "  PyDict_SetItemString(DictIds, \"%s\", Py_BuildValue(\"ii\", AB_DTSET_%s, %s));\n" % (key, key.upper(), attType)
    n += 1
C  += Cd
C  += "  AB_DTSET_N_IDS\n"
C  += "} AbDtsetIds;\n"
C  += "\n"
C  += "#endif\n"
Cs += "static AbDtsetTypes ab_dtsets_types[] = {\n"
Cs += Ct
Cs += "           %-15s\n" % "_OTHER"
Cs += "};\n"
Cs += "\n"
Cs += "#endif\n"
Py += "}\n"
header = open("dtset_c.h", "w")
header.write(C)
header.close()
header = open("dtset_c.static.h", "w")
header.write(Cs)
header.close()
header = open("dtset_f90.inc", "w")
header.write(F90)
header.close()
header = open("dtset_py.h", "w")
header.write(Py)
header.close()

# Create the access routines
int_sca = ""
flt_sca = ""
int_arr = ""
flt_arr = ""
shp_arr = ""
for (key, descr) in dtset.iteritems():
  if (descr[-1].find("(") < 0):
    out  = "    case (ab_dtset_%s)\n" % key
    out += "      value = token%%dtsets(idtset)%%%s\n" % key
    if (descr[0] == "integer"):
      int_sca += out
    elif (descr[0] == "real(dp)"):
      flt_sca += out
  else:
    out  = "    case (ab_dtset_%s)\n" % key
    out += "      n_dt = product(shape(token%%dtsets(idtset)%%%s))\n" % key
    out += "      if (n_dt /= n) then\n"
    out += "        errno = AB_ERROR_DTSET_SIZE\n"
    out += "      else\n"
    out += "        values = reshape(token%%dtsets(idtset)%%%s, (/ n_dt /))\n" % key
    out += "      end if\n"
    if (descr[0].startswith("integer")):
      int_arr += out
    elif (descr[0].startswith("real(dp)")):
      flt_arr += out
    shp_arr += "    case (ab_dtset_%s)\n" % key
    shp_arr += "      ndim = size(shape(token%%dtsets(idtset)%%%s))\n" % key
    shp_arr += "      dims(1:ndim) = shape(token%%dtsets(idtset)%%%s)\n" % key
    #if ("pointer" in descr[0]):
    #  print "nullify(dtset%%%s)" % key

subs = open("ab_dtset_f90_get.f90", "w")
subs.write("! %s\n" % comment)
subs.write("""
  subroutine ab_dtset_get_integer(dtsetsId, value, id, idtset, errno)
    integer, intent(in) :: dtsetsId
    integer, intent(in) :: id, idtset
    integer, intent(out) :: value
    integer, intent(out) :: errno

    type(dtsets_list), pointer :: token

    call ab_dtset_get_from_id(token, dtsetsId)
    if (.not. associated(token)) then
      errno = AB_ERROR_DTSET_OBJ
      return
    end if
    if (idtset < 0 .or. idtset > size(token%dtsets)) then
      errno = AB_ERROR_DTSET_ID
      return
    end if
    
    errno = AB_NO_ERROR
    select case (id)
""")
subs.write(int_sca)
subs.write("""
    case default
      errno = AB_ERROR_DTSET_ATT
    end select
  end subroutine ab_dtset_get_integer

  subroutine ab_dtset_get_real(dtsetsId, value, id, idtset, errno)
    integer, intent(in) :: dtsetsId
    integer, intent(in) :: id, idtset
    real(dp), intent(out) :: value
    integer, intent(out) :: errno

    type(dtsets_list), pointer :: token

    call ab_dtset_get_from_id(token, dtsetsId)
    if (.not. associated(token)) then
      errno = AB_ERROR_DTSET_OBJ
      return
    end if
    if (idtset < 0 .or. idtset > size(token%dtsets)) then
      errno = AB_ERROR_DTSET_ID
      return
    end if
    
    errno = AB_NO_ERROR
    select case (id)
""")
subs.write(flt_sca)
subs.write("""
    case default
      errno = AB_ERROR_DTSET_ATT
    end select
  end subroutine ab_dtset_get_real

  subroutine ab_dtset_get_integer_array(dtsetsId, values, n, id, idtset, errno)
    integer, intent(in) :: dtsetsId
    integer, intent(in) :: id, idtset, n
    integer, intent(out) :: values(n)
    integer, intent(out) :: errno

    type(dtsets_list), pointer :: token
    integer :: n_dt

    call ab_dtset_get_from_id(token, dtsetsId)
    if (.not. associated(token)) then
      errno = AB_ERROR_DTSET_OBJ
      return
    end if
    if (idtset < 0 .or. idtset > size(token%dtsets)) then
      errno = AB_ERROR_DTSET_ID
      return
    end if
    
    errno = AB_NO_ERROR
    select case (id)
""")
subs.write(int_arr)
subs.write("""
    case default
      errno = AB_ERROR_DTSET_ATT
    end select
  end subroutine ab_dtset_get_integer_array

  subroutine ab_dtset_get_real_array(dtsetsId, values, n, id, idtset, errno)
    integer, intent(in) :: dtsetsId
    integer, intent(in) :: id, idtset, n
    real(dp), intent(out) :: values(n)
    integer, intent(out) :: errno

    type(dtsets_list), pointer :: token
    integer :: n_dt

    call ab_dtset_get_from_id(token, dtsetsId)
    if (.not. associated(token)) then
      errno = AB_ERROR_DTSET_OBJ
      return
    end if
    if (idtset < 0 .or. idtset > size(token%dtsets)) then
      errno = AB_ERROR_DTSET_ID
      return
    end if
    
    errno = AB_NO_ERROR
    select case (id)
""")
subs.write(flt_arr)
subs.write("""
    case default
      errno = AB_ERROR_DTSET_ATT
    end select
  end subroutine ab_dtset_get_real_array

  subroutine ab_dtset_get_shape(dtsetsId, dims, ndim, id, idtset, errno)
    integer, intent(in) :: dtsetsId
    integer, intent(in) :: id, idtset
    integer, intent(out) :: dims(7), ndim
    integer, intent(out) :: errno

    type(dtsets_list), pointer :: token

    call ab_dtset_get_from_id(token, dtsetsId)
    if (.not. associated(token)) then
      errno = AB_ERROR_DTSET_OBJ
      return
    end if
    if (idtset < 0 .or. idtset > size(token%dtsets)) then
      errno = AB_ERROR_DTSET_ID
      return
    end if
    
    errno = AB_NO_ERROR
    select case (id)
""")
subs.write(shp_arr)
subs.write("""
    case default
      errno = AB_ERROR_DTSET_ATT
    end select
  end subroutine ab_dtset_get_shape
""")
subs.close()
