      DOUBLE PRECISION FUNCTION DLAMCH( CMACH )
*
*     This routine is an home-made version of the DLAMCH routine
*     of the Lapack library. The one provided at the Lapack web site does not 
*     work properly on the P6 under pghpf, with -O2 -Mserial 
*     Only three options are implemented : safe minimum, precision and epsilon
*     XG, around December 1997.
*
*     .. Scalar Arguments ..
      CHARACTER          CMACH
*     ..
*
*  Purpose
*  =======
*
*  DLAMCH determines double precision machine parameters.
*
*  Arguments
*  =========
*
*  CMACH   (input) CHARACTER*1
*          Specifies the value to be returned by DLAMCH:
*          = "E" or "e",   DLAMCH := eps
*          = "S" or "s",   DLAMCH := sfmin
*          = "B" or "b",   DLAMCH := base
*          = "P" or "p",   DLAMCH := eps*base
*          = "N" or "n",   DLAMCH := t
*          = "R" or "r",   DLAMCH := rnd
*          = "M" or "m",   DLAMCH := emin
*          = "U" or "u",   DLAMCH := rmin
*          = "L" or "l",   DLAMCH := emax
*          = "O" or "o",   DLAMCH := rmax
*
*          where
*
*          eps   = relative machine precision
*          sfmin = safe minimum, such that 1/sfmin does not overflow
*          base  = base of the machine
*          prec  = eps*base
*          t     = number of (base) digits in the mantissa
*          rnd   = 1.0 when rounding occurs in addition, 0.0 otherwise
*          emin  = minimum exponent before (gradual) underflow
*          rmin  = underflow threshold - base**(emin-1)
*          emax  = largest exponent before overflow
*          rmax  = overflow threshold  - (base**emax)*(1-eps)
*
* =====================================================================
*
*     ..
*     .. Local Scalars ..
      LOGICAL            FIRST, LRND
      INTEGER            BETA, IMAX, IMIN, IT
      DOUBLE PRECISION   BASE, EMAX, EMIN, EPS, PREC, RMACH, RMAX, RMIN,
     $                   RND, SFMIN, SMALL, T
*     ..
*     .. Save statement ..
      SAVE               FIRST, EPS, SFMIN, BASE, T, RND, EMIN, RMIN,
     $                   EMAX, RMAX, PREC
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         eps=epsilon(0.0d0)
         sfmin=tiny(0.0d0)*20.0d0
         prec=radix(0.0d0)*eps
*        write(6,*)' dlamch : machine parameters '
*        write(6,*)'   eps    (epsilon)      =',eps
*        write(6,*)'   sfmin  (safe minimum) =',sfmin
*        write(6,*)'   prec   (epsilon*base) =',prec
      END IF
*
      IF( CMACH=='E' ) THEN
         DLAMCH = eps
      ELSE IF( CMACH=='S' ) THEN
         DLAMCH = sfmin
      ELSE IF( CMACH=='P' ) THEN
         DLAMCH = prec
      ELSE 
         write(6,*)' dlmach : option not implemented => stop'
         write(6,*)'   cmach =',cmach
         stop
      END IF
*
      RETURN
*
*     End of DLAMCH
*
      END
