!{\src2tex{textfont=tt}}
!!****f* ABINIT/shapebes
!! NAME
!! shapebes
!!
!! FUNCTION
!!    Find al and ql parameters for a "Bessel" shape function:
!!    Shape(r)=al1.jl(ql1.r)+al2.jl(ql2.r)
!!      such as Shape(r) and 2 derivatives are zero at r=rc
!!              Intg_0_rc[Shape(r).r^(l+2).dr]=1
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  ll= l quantum number
!!  rc= cut-off radius
!!
!! OUTPUT
!!  al(2)= al coefficients
!!  ql(2)= ql factors
!!
!! PARENTS
!!      psp7in
!!
!! CHILDREN
!!      jbessel,solvbes
!!
!! SOURCE

 subroutine shapebes(al,ql,ll,rc)

 use defs_basis

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: ll
 real(dp),intent(in) :: rc
 real(dp),intent(out) :: al(2),ql(2)

!Local variables-------------------------------
 integer :: ii
 real(dp) :: alpha,beta,det,jbes,jbesp,jbespp,qr
 real(dp) :: amat(2,2),bb(2)

! *************************************************************************
 alpha=1.D0;beta=0.D0
 call solvbes(ql,alpha,beta,ll,2)
 ql(1:2)=ql(1:2)/rc

 do ii=1,2
  qr=ql(ii)*rc
  call jbessel(jbes,jbesp,jbespp,ll,1,qr)
  amat(1,ii)=jbesp*ql(ii)
  call jbessel(jbes,jbesp,jbespp,ll+1,0,qr)
  amat(2,ii)=jbes*rc**(ll+2)/ql(ii)  !  Intg_0_rc[jl(qr).r^(l+2).dr]
 enddo

 bb(1)=zero;bb(2)=one

 det=amat(1,1)*amat(2,2)-amat(1,2)*amat(2,1)
 al(1)=(amat(2,2)*bb(1)-amat(1,2)*bb(2))/det
 al(2)=(amat(1,1)*bb(2)-amat(2,1)*bb(1))/det

 end subroutine
!!***
