!{\src2tex{textfont=tt}}
!!****f* ABINIT/nderiv
!! NAME
!! nderiv
!!
!! FUNCTION
!! Given an input function y(x) on a regular grid,
!! compute its first derivative
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (NH, FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  h= radial step
!!  ndim= radial mesh size
!!  y(ndim)= input function
!!
!! OUTPUT
!!  ierr= error code (not used here)
!!  z(ndim)= first derivative of y
!!
!! NOTES
!!  This routine comes from nderiv.f90 (AtomPaw code from N. Holzwarth)
!!
!! PARENTS
!!      calc_kij
!!
!! CHILDREN
!!
!! SOURCE

 subroutine nderiv(h,y,z,ndim,ierr)

 use defs_basis
 
 implicit none
 
!Arguments ---------------------------------------------
 integer :: ierr,ndim
 real(dp) :: h
 real(dp) :: y(ndim),z(ndim)
 
!Local variables ---------------------------------------
 integer :: i
 real(dp) :: a,b,c,hh,yy
 
! *********************************************************************

!Prepare differentiation loop
 hh=0.08333333333333333d0/h
 yy=y(ndim-4)
 b=hh*(-25.d0*y(1)+48.d0*y(2)-36.d0*y(3)+16.d0*y(4)-3.d0*y(5))
 c=hh*(-3.d0*y(1)-10.d0*y(2)+18.d0*y(3)-6.d0*y(4)+y(5))

!Start differentiation loop
 do i=5,ndim
  a=b;b=c
  c=hh*(y(i-4)-y(i)+8.d0*(y(i-1)-y(i-3)))
  z(i-4)=a
 enddo

!Normal exit
 ierr=0                                                              
 a=hh*(-yy+6.d0*y(ndim-3)-18.d0*y(ndim-2)+10.d0*y(ndim-1)+3.d0*y(ndim))
 z(ndim)=hh*(3.d0*yy-16.d0*y(ndim-3)+36.d0*y(ndim-2) &
            -48.d0*y(ndim-1)+25.d0*y(ndim))
 z(ndim-1)=a
 z(ndim-2)=c
 z(ndim-3)=b

 end subroutine
!!***
