!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_valden
!! NAME
!! calc_valden
!!
!! FUNCTION
!! Compute pseudized valence density (n_tild) and compensation density (n_hat, following Abinit s def.)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawarray
!!    %shapefunc(wav_meshsz)= Normalized shape function
!!  pawps
!!    %coreden4pr2(core_meshsz)= Core density multiplied by 4Pi.r2
!!    %phi(wav_meshsz,basis_size)= PAW atomic wavefunctions on the radial grid
!!    %tcoreden4pr2(core_meshsz)= Pseudized core density multiplied by 4Pi.r2
!!    %tphi(wav_meshsz,basis_size)= PAW atomic pseudo-wavefunctions on the radial grid
!!    %tvaleden4pr2(core_meshsz)= Pseudized valence density multiplied by 4Pi.r2 (if read in input file)
!!  pawrad= radial grid definitions
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %occ(basis_size)= occupation for each basis function
!!    %sph_meshsz= Dimension of radial mesh corresponding to PAW spheres
!!    %vale_meshsz= Dimension of radial mesh for pseudized valence density (0 if not in input file)
!!    %wav_meshsz= Dimension of radial mesh for wave functions
!!
!! OUTPUT
!!  pawarray
!!    %hatden4pr2(sph_meshsz)= Compensation density *4pi.r2 (following Abinit s definition)
!!    %tvaleden4pr2(wav_meshsz)= Pseudized valence density *4pi.r2 (only part inside spheres)
!!
!! PARENTS
!!      atompaw2abinit
!!
!! CHILDREN
!!      csimp
!!
!! SOURCE

 subroutine calc_valden(pawarray,pawps,pawrad,pshead)

  use defs_basis
  use defs_pawps

  implicit none

!Arguments ---------------------------------------------
 type(pawarray_type) :: pawarray
 type(pawps_type)    :: pawps
 type(pawrad_type)   :: pawrad
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ib,meshsz
 real(dp) :: qq
 real(dp),allocatable :: den4pr2(:),valeden4pr2(:)

!-------------------------------------------------------

!Compute pseudized valence density (only inside PAW sphere)
 meshsz=pshead%wav_meshsz
 pawarray%tvaleden4pr2=zero
 if (pshead%vale_meshsz>0) then
  pawarray%tvaleden4pr2(1:meshsz)=pawps%tvaleden4pr2(1:meshsz)
 else
  do ib=1,pshead%basis_size
   pawarray%tvaleden4pr2(1:meshsz)=pawarray%tvaleden4pr2(1:meshsz) &
&                                 +pshead%occ(ib)*pawps%tphi(1:meshsz,ib)**2
  enddo
 end if
  
!Compute valence density (only inside PAW sphere) - temporary needed here
 meshsz=pshead%sph_meshsz
 allocate(valeden4pr2(meshsz));valeden4pr2=zero
 do ib=1,pshead%basis_size
  valeden4pr2(1:meshsz)=valeden4pr2(1:meshsz) &
&                      +pshead%occ(ib)*pawps%phi(1:meshsz,ib)**2
 enddo

!Compute compensation density
 allocate(den4pr2(meshsz));pawarray%hatden4pr2=zero
 den4pr2(1:meshsz)=valeden4pr2(1:meshsz)-pawarray%tvaleden4pr2(1:meshsz)
 call csimp(den4pr2,pawrad,meshsz,qq)
 pawarray%hatden4pr2(1:meshsz)=qq*pawrad%rad(1:meshsz)**2*pawarray%shapefunc(1:meshsz)

 deallocate(den4pr2,valeden4pr2)

 end subroutine calc_valden
