!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_shapef
!! NAME
!! calc_shapef
!!
!! FUNCTION
!! Compute normalized shape function and its moments (shpnrm)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawrad= radial grid definitions
!!  pshead
!!    %hat_meshsz= Dimension of radial mesh for hat density
!!    %lambda= Lambda in gaussian type g(r)
!!    %l_size= Max. value of l+1 leading to a non zero Gaunt coeffs
!!    %rad_step= Step corresponding to radial mesh
!!    %rc_hat= radius for hat density
!!    %shape_type= Shape function type
!!    %sigma= Sigma for gaussian type g(r)
!!
!! OUTPUT
!!  pawarray
!!    %shapefunc(wav_meshsz)= Normalized shape function
!!    %shpnrm(l_size)= Moments of shape function for each l
!!
!! PARENTS
!!      atompaw2abinit
!!
!! CHILDREN
!!      csimp,shapebes
!!
!! SOURCE

 subroutine calc_shapef(pawarray,pawrad,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ------------------------------------
 type(pawarray_type) :: pawarray
 type(pawrad_type)   :: pawrad
 type(pshead_type)   :: pshead

!Local variables-------------------------------
 integer :: il,ir
 real(dp) :: arg,dum1,dum2,jbes1,jbes2,qr,shapefunc1,shapefunc2
 real(dp) :: al(2),ql(2)
 real(dp), allocatable :: ff(:)

!Statement functions -----------------------------------
 shapefunc1(arg)= exp(-(arg/pshead%sigma)**pshead%lambda)
 shapefunc2(arg)= (sin(pi*arg/pshead%rc_hat)/(pi*arg/pshead%rc_hat))**2

!-------------------------------------------------------

!Select the suitable shape function
 pawarray%shapefunc(:)=zero
 pawarray%shapefunc(1)=1.d0
 if (pshead%shape_type==1) then
  do ir=2,pshead%hat_meshsz
   pawarray%shapefunc(ir)=shapefunc1(pawrad%rad(ir))
  enddo
 else if (pshead%shape_type==2) then
  do ir=2,pshead%hat_meshsz
   pawarray%shapefunc(ir)=shapefunc2(pawrad%rad(ir))
  enddo
 else if (pshead%shape_type==3) then
  call shapebes(al,ql,0,pshead%rc_hat)
  do ir=1,pshead%hat_meshsz
   qr=ql(1)*pawrad%rad(ir);CALL jbessel(jbes1,dum1,dum2,0,0,qr)
   qr=ql(2)*pawrad%rad(ir);CALL jbessel(jbes2,dum1,dum2,0,0,qr)
   pawarray%shapefunc(ir)=al(1)*jbes1+al(2)*jbes2
  enddo
 else if (pshead%shape_type/=-1) then
  print *,"Error in calc_shapef: invalid value of pshead%shape_type !"
  stop
 endif

!Compute moments of shape function
 allocate(ff(pshead%hat_meshsz));pawarray%shpnrm=zero;ff(1)=zero
 do il=1,pshead%l_size
  ff(2:pshead%hat_meshsz)=pawarray%shapefunc(2:pshead%hat_meshsz)*pawrad%rad(2:pshead%hat_meshsz)**(2*il)
  call csimp(ff,pawrad,pshead%hat_meshsz,pawarray%shpnrm(il))
 enddo
 deallocate(ff)

!Normalize shape function
 pawarray%shapefunc(1:pshead%hat_meshsz)=pawarray%shapefunc(1:pshead%hat_meshsz)/pawarray%shpnrm(1)

end subroutine
!!***
